/*
  Copyright (c) 2008-2015 Red Hat, Inc. <http://www.redhat.com>
  This file is part of GlusterFS.

  This file is licensed to you under your choice of the GNU Lesser
  General Public License, version 3 or any later version (LGPLv3 or
  later), or the GNU General Public License, version 2 (GPLv2), in all
  cases as published by the Free Software Foundation.
*/

/* File: clousync-autogen-fops-tmpl.h
 * This file contains the cloudsync autogenerated FOPs declarations.
 */

#ifndef _CLOUDSYNC_AUTOGEN_FOPS_H
#define _CLOUDSYNC_AUTOGEN_FOPS_H

#include <glusterfs/xlator.h>
#include "cloudsync.h"
#include "cloudsync-common.h"

/* BEGIN GENERATED CODE - DO NOT MODIFY */

int32_t
cs_fgetxattr (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	const char * name,
	dict_t * xdata);


int32_t
cs_fsetxattr (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	dict_t * dict,
	int32_t flags,
	dict_t * xdata);


int32_t
cs_setxattr (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	dict_t * dict,
	int32_t flags,
	dict_t * xdata);


int32_t
cs_statfs (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	dict_t * xdata);


int32_t
cs_fsyncdir (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	int32_t flags,
	dict_t * xdata);


int32_t
cs_opendir (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	fd_t * fd,
	dict_t * xdata);


int32_t
cs_fstat (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	dict_t * xdata);


int32_t
cs_fsync (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	int32_t flags,
	dict_t * xdata);


int32_t
cs_flush (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	dict_t * xdata);


int32_t
cs_writev (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	struct iovec * vector,
	int32_t count,
	off_t off,
	uint32_t flags,
	struct iobref * iobref,
	dict_t * xdata);


int32_t
cs_readv (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	size_t size,
	off_t offset,
	uint32_t flags,
	dict_t * xdata);


int32_t
cs_open (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	int32_t flags,
	fd_t * fd,
	dict_t * xdata);


int32_t
cs_create (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	int32_t flags,
	mode_t mode,
	mode_t umask,
	fd_t * fd,
	dict_t * xdata);


int32_t
cs_link (call_frame_t *frame, xlator_t *this,
                   loc_t * oldloc,
	loc_t * newloc,
	dict_t * xdata);


int32_t
cs_rename (call_frame_t *frame, xlator_t *this,
                   loc_t * oldloc,
	loc_t * newloc,
	dict_t * xdata);


int32_t
cs_symlink (call_frame_t *frame, xlator_t *this,
                   const char * linkpath,
	loc_t * loc,
	mode_t umask,
	dict_t * xdata);


int32_t
cs_rmdir (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	int32_t flags,
	dict_t * xdata);


int32_t
cs_unlink (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	int32_t flags,
	dict_t * xdata);


int32_t
cs_mkdir (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	mode_t mode,
	mode_t umask,
	dict_t * xdata);


int32_t
cs_mknod (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	mode_t mode,
	dev_t rdev,
	mode_t umask,
	dict_t * xdata);


int32_t
cs_readlink (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	size_t size,
	dict_t * xdata);


int32_t
cs_access (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	int32_t mask,
	dict_t * xdata);


int32_t
cs_ftruncate (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	off_t offset,
	dict_t * xdata);


int32_t
cs_getxattr (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	const char * name,
	dict_t * xdata);


int32_t
cs_xattrop (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	gf_xattrop_flags_t flags,
	dict_t * dict,
	dict_t * xdata);


int32_t
cs_fxattrop (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	gf_xattrop_flags_t flags,
	dict_t * dict,
	dict_t * xdata);


int32_t
cs_removexattr (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	const char * name,
	dict_t * xdata);


int32_t
cs_fremovexattr (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	const char * name,
	dict_t * xdata);


int32_t
cs_lk (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	int32_t cmd,
	struct gf_flock * lock,
	dict_t * xdata);


int32_t
cs_inodelk (call_frame_t *frame, xlator_t *this,
                   const char * volume,
	loc_t * loc,
	int32_t cmd,
	struct gf_flock * lock,
	dict_t * xdata);


int32_t
cs_finodelk (call_frame_t *frame, xlator_t *this,
                   const char * volume,
	fd_t * fd,
	int32_t cmd,
	struct gf_flock * lock,
	dict_t * xdata);


int32_t
cs_entrylk (call_frame_t *frame, xlator_t *this,
                   const char * volume,
	loc_t * loc,
	const char * basename,
	entrylk_cmd cmd,
	entrylk_type type,
	dict_t * xdata);


int32_t
cs_fentrylk (call_frame_t *frame, xlator_t *this,
                   const char * volume,
	fd_t * fd,
	const char * basename,
	entrylk_cmd cmd,
	entrylk_type type,
	dict_t * xdata);


int32_t
cs_rchecksum (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	off_t offset,
	int32_t len,
	dict_t * xdata);


int32_t
cs_readdir (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	size_t size,
	off_t off,
	dict_t * xdata);


int32_t
cs_readdirp (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	size_t size,
	off_t off,
	dict_t * xdata);


int32_t
cs_setattr (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	struct iatt * stbuf,
	int32_t valid,
	dict_t * xdata);


int32_t
cs_truncate (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	off_t offset,
	dict_t * xdata);


int32_t
cs_stat (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	dict_t * xdata);


int32_t
cs_lookup (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	dict_t * xdata);


int32_t
cs_fsetattr (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	struct iatt * stbuf,
	int32_t valid,
	dict_t * xdata);


int32_t
cs_fallocate (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	int32_t keep_size,
	off_t offset,
	size_t len,
	dict_t * xdata);


int32_t
cs_discard (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	off_t offset,
	size_t len,
	dict_t * xdata);


int32_t
cs_zerofill (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	off_t offset,
	off_t len,
	dict_t * xdata);


int32_t
cs_ipc (call_frame_t *frame, xlator_t *this,
                   int32_t op,
	dict_t * xdata);


int32_t
cs_seek (call_frame_t *frame, xlator_t *this,
                   fd_t * fd,
	off_t offset,
	gf_seek_what_t what,
	dict_t * xdata);


int32_t
cs_lease (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	struct gf_lease * lease,
	dict_t * xdata);


int32_t
cs_getactivelk (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	dict_t * xdata);


int32_t
cs_setactivelk (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	lock_migration_info_t * locklist,
	dict_t * xdata);


int32_t
cs_put (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	mode_t mode,
	mode_t umask,
	uint32_t flags,
	struct iovec * vector,
	int32_t count,
	off_t off,
	struct iobref * iobref,
	dict_t * dict,
	dict_t * xdata);


int32_t
cs_icreate (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	mode_t mode,
	dict_t * xdata);


int32_t
cs_namelink (call_frame_t *frame, xlator_t *this,
                   loc_t * loc,
	dict_t * xdata);


int32_t
cs_copy_file_range (call_frame_t *frame, xlator_t *this,
                   fd_t * fd_in,
	off64_t  off_in,
	fd_t * fd_out,
	off64_t  off_out,
	size_t len,
	uint32_t flags,
	dict_t * xdata);

/* END GENERATED CODE */

#endif /* _CLOUDSYNC_AUTOGEN_FOPS_H */
