/* util-gtk.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-gtk.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
typedef void (*UtilGtkMenuForeachFunc) (const gchar* label, const gchar* action_name, GVariant* target, GMenu* section, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

VALA_EXTERN gboolean util_gtk_close_button_at_end (void);
VALA_EXTERN void util_gtk_menu_foreach (GMenu* menu,
                            UtilGtkMenuForeachFunc foreach_func,
                            gpointer foreach_func_target);
static gchar* _variant_get18 (GVariant* value);
static gchar* _variant_get19 (GVariant* value);

/**
     * Given an HTML-style color spec, parses the color and sets it to
     * the source RGB of the Cairo context. (Borrowed from Shotwell.)
     */
void
util_gtk_set_source_color_from_string (cairo_t* ctx,
                                       const gchar* spec)
{
	GdkRGBA rgba = {0};
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (spec != NULL);
	memset (&rgba, 0, sizeof (GdkRGBA));
	if (!gdk_rgba_parse (&rgba, spec)) {
		g_error ("util-gtk.vala:25: Can't parse color %s", spec);
	}
	_tmp0_ = rgba;
	_tmp1_ = rgba;
	_tmp2_ = rgba;
	cairo_set_source_rgb (ctx, _tmp0_.red, _tmp1_.green, _tmp2_.blue);
}

/**
     * Returns whether the close button is at the end of the headerbar.
     */
static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gboolean
util_gtk_close_button_at_end (void)
{
	gchar* layout = NULL;
	GtkSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean at_end = FALSE;
	const gchar* _tmp3_;
	gboolean result;
	_tmp0_ = gtk_settings_get_default ();
	g_object_get (_tmp0_, "gtk-decoration-layout", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	layout = _tmp2_;
	at_end = FALSE;
	_tmp3_ = layout;
	if (_tmp3_ != NULL) {
		gint colon_ind = 0;
		const gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = layout;
		colon_ind = string_index_of (_tmp4_, ":", 0);
		if (colon_ind >= 0) {
			const gchar* _tmp6_;
			_tmp6_ = layout;
			_tmp5_ = string_index_of (_tmp6_, "close", colon_ind) >= 0;
		} else {
			_tmp5_ = FALSE;
		}
		at_end = _tmp5_;
	}
	result = at_end;
	_g_free0 (layout);
	return result;
}

/**
     * Allows iterating over a GMenu, without having to handle MenuItems
     * @param menu - The menu to iterate over
     * @param foreach_func - The function which will be called on the
     * attributes of menu's children
     */
void
util_gtk_menu_foreach (GMenu* menu,
                       UtilGtkMenuForeachFunc foreach_func,
                       gpointer foreach_func_target)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (menu, g_menu_get_type ()));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GVariant* label = NULL;
				const GVariantType* _tmp2_;
				GVariant* _tmp3_;
				GVariant* action_name = NULL;
				const GVariantType* _tmp4_;
				GVariant* _tmp5_;
				GVariant* action_target = NULL;
				const GVariantType* _tmp6_;
				GVariant* _tmp7_;
				GMenu* section = NULL;
				GMenuModel* _tmp8_;
				const gchar* _tmp9_ = NULL;
				GVariant* _tmp10_;
				const gchar* _tmp13_ = NULL;
				GVariant* _tmp14_;
				GVariant* _tmp17_;
				GMenu* _tmp18_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < g_menu_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (menu, g_menu_model_get_type (), GMenuModel)))) {
					break;
				}
				_tmp2_ = G_VARIANT_TYPE_STRING;
				_tmp3_ = g_menu_model_get_item_attribute_value (G_TYPE_CHECK_INSTANCE_CAST (menu, g_menu_model_get_type (), GMenuModel), i, G_MENU_ATTRIBUTE_LABEL, _tmp2_);
				label = _tmp3_;
				_tmp4_ = G_VARIANT_TYPE_STRING;
				_tmp5_ = g_menu_model_get_item_attribute_value (G_TYPE_CHECK_INSTANCE_CAST (menu, g_menu_model_get_type (), GMenuModel), i, G_MENU_ATTRIBUTE_ACTION, _tmp4_);
				action_name = _tmp5_;
				_tmp6_ = G_VARIANT_TYPE_STRING;
				_tmp7_ = g_menu_model_get_item_attribute_value (G_TYPE_CHECK_INSTANCE_CAST (menu, g_menu_model_get_type (), GMenuModel), i, G_MENU_ATTRIBUTE_TARGET, _tmp6_);
				action_target = _tmp7_;
				_tmp8_ = g_menu_model_get_item_link (G_TYPE_CHECK_INSTANCE_CAST (menu, g_menu_model_get_type (), GMenuModel), i, G_MENU_LINK_SECTION);
				section = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_menu_get_type (), GMenu);
				_tmp10_ = label;
				if (_tmp10_ != NULL) {
					GVariant* _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = label;
					_tmp12_ = g_variant_get_string (_tmp11_, NULL);
					_tmp9_ = _tmp12_;
				} else {
					_tmp9_ = NULL;
				}
				_tmp14_ = action_name;
				if (_tmp14_ != NULL) {
					GVariant* _tmp15_;
					const gchar* _tmp16_;
					_tmp15_ = action_name;
					_tmp16_ = g_variant_get_string (_tmp15_, NULL);
					_tmp13_ = _tmp16_;
				} else {
					_tmp13_ = NULL;
				}
				_tmp17_ = action_target;
				_tmp18_ = section;
				foreach_func (_tmp9_, _tmp13_, _tmp17_, _tmp18_, foreach_func_target);
				_g_object_unref0 (section);
				_g_variant_unref0 (action_target);
				_g_variant_unref0 (action_name);
				_g_variant_unref0 (label);
			}
		}
	}
}

/**
     * Returns the CSS border box height for a widget.
     *
     * This adjusts the GTK widget's allocated height to exclude extra
     * space added by the CSS margin property, if any.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

inline gint
util_gtk_get_border_box_height (GtkWidget* widget)
{
	GtkStyleContext* style = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStateFlags flags = 0U;
	GtkBorder margin = {0};
	GtkBorder _tmp2_ = {0};
	GtkBorder _tmp3_;
	GtkBorder _tmp4_;
	gint result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()), 0);
	_tmp0_ = gtk_widget_get_style_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style = _tmp1_;
	flags = gtk_style_context_get_state (style);
	gtk_style_context_get_margin (style, flags, &_tmp2_);
	margin = _tmp2_;
	_tmp3_ = margin;
	_tmp4_ = margin;
	result = (gtk_widget_get_allocated_height (widget) - _tmp3_.top) - _tmp4_.bottom;
	_g_object_unref0 (style);
	return result;
}

/**
     * Constructs a frozen GMenu from an existing model using a visitor.
     *
     * The visitor is applied to the given template model to each of
     * its items, or recursively for any section or submenu. If the
     * visitor returns false when passed an item, section or submenu
     * then it will be skipped, otherwise it will be added to a new
     * menu.
     *
     * The constructed menu will be returned frozen.
     *
     * @see MenuVisitor
     */
static gchar*
_variant_get18 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

GMenu*
util_gtk_construct_menu (GMenuModel* template,
                         UtilGtkMenuVisitor visitor,
                         gpointer visitor_target)
{
	GMenu* model = NULL;
	GMenu* _tmp0_;
	GMenu* _tmp34_;
	GMenu* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (template, g_menu_model_get_type ()), NULL);
	_tmp0_ = g_menu_new ();
	model = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GMenuItem* item = NULL;
				GMenuItem* _tmp3_;
				gchar* action = NULL;
				GVariant* action_value = NULL;
				GMenuItem* _tmp4_;
				const GVariantType* _tmp5_;
				GVariant* _tmp6_;
				GVariant* _tmp7_;
				GMenu* section = NULL;
				GMenuItem* _tmp10_;
				GMenuModel* _tmp11_;
				GMenu* submenu = NULL;
				GMenuItem* _tmp12_;
				GMenuModel* _tmp13_;
				gboolean append = FALSE;
				GMenu* _tmp14_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < g_menu_model_get_n_items (template))) {
					break;
				}
				_tmp3_ = g_menu_item_new_from_model (template, i);
				item = _tmp3_;
				action = NULL;
				_tmp4_ = item;
				_tmp5_ = G_VARIANT_TYPE_STRING;
				_tmp6_ = g_menu_item_get_attribute_value (_tmp4_, G_MENU_ATTRIBUTE_ACTION, _tmp5_);
				action_value = _tmp6_;
				_tmp7_ = action_value;
				if (_tmp7_ != NULL) {
					GVariant* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = action_value;
					_tmp9_ = _variant_get18 (_tmp8_);
					_g_free0 (action);
					action = _tmp9_;
				}
				_tmp10_ = item;
				_tmp11_ = g_menu_item_get_link (_tmp10_, G_MENU_LINK_SECTION);
				section = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_menu_get_type (), GMenu);
				_tmp12_ = item;
				_tmp13_ = g_menu_item_get_link (_tmp12_, G_MENU_LINK_SUBMENU);
				submenu = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_menu_get_type (), GMenu);
				append = FALSE;
				_tmp14_ = section;
				if (_tmp14_ != NULL) {
					GMenu* _tmp15_;
					const gchar* _tmp16_;
					GMenuItem* _tmp17_;
					_tmp15_ = section;
					_tmp16_ = action;
					_tmp17_ = item;
					if (visitor (template, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_menu_model_get_type (), GMenuModel), _tmp16_, _tmp17_, visitor_target)) {
						GMenu* _tmp18_;
						GMenu* _tmp19_;
						GMenuItem* _tmp20_;
						GMenu* _tmp21_;
						append = TRUE;
						_tmp18_ = section;
						_tmp19_ = util_gtk_construct_menu (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, g_menu_model_get_type (), GMenuModel), visitor, visitor_target);
						_g_object_unref0 (section);
						section = _tmp19_;
						_tmp20_ = item;
						_tmp21_ = section;
						g_menu_item_set_section (_tmp20_, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, g_menu_model_get_type (), GMenuModel));
					}
				} else {
					GMenu* _tmp22_;
					_tmp22_ = submenu;
					if (_tmp22_ != NULL) {
						GMenu* _tmp23_;
						const gchar* _tmp24_;
						GMenuItem* _tmp25_;
						_tmp23_ = submenu;
						_tmp24_ = action;
						_tmp25_ = item;
						if (visitor (template, G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, g_menu_model_get_type (), GMenuModel), _tmp24_, _tmp25_, visitor_target)) {
							GMenu* _tmp26_;
							GMenu* _tmp27_;
							GMenuItem* _tmp28_;
							GMenu* _tmp29_;
							append = TRUE;
							_tmp26_ = submenu;
							_tmp27_ = util_gtk_construct_menu (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, g_menu_model_get_type (), GMenuModel), visitor, visitor_target);
							_g_object_unref0 (submenu);
							submenu = _tmp27_;
							_tmp28_ = item;
							_tmp29_ = submenu;
							g_menu_item_set_submenu (_tmp28_, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, g_menu_model_get_type (), GMenuModel));
						}
					} else {
						const gchar* _tmp30_;
						GMenuItem* _tmp31_;
						_tmp30_ = action;
						_tmp31_ = item;
						append = visitor (template, NULL, _tmp30_, _tmp31_, visitor_target);
					}
				}
				if (append) {
					GMenu* _tmp32_;
					GMenuItem* _tmp33_;
					_tmp32_ = model;
					_tmp33_ = item;
					g_menu_append_item (_tmp32_, _tmp33_);
				}
				_g_object_unref0 (submenu);
				_g_object_unref0 (section);
				_g_variant_unref0 (action_value);
				_g_free0 (action);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp34_ = model;
	g_menu_freeze (_tmp34_);
	result = model;
	return result;
}

/** Copies a GLib menu, setting targets for the given actions. */
static gchar*
_variant_get19 (GVariant* value)
{
	return g_variant_dup_string (value, NULL);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

GMenu*
util_gtk_copy_menu_with_targets (GMenu* template,
                                 const gchar* group,
                                 GeeMap* targets)
{
	gchar* group_prefix = NULL;
	gchar* _tmp0_;
	GMenu* copy = NULL;
	GMenu* _tmp1_;
	GMenu* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (template, g_menu_get_type ()), NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (targets, GEE_TYPE_MAP), NULL);
	_tmp0_ = g_strconcat (group, ".", NULL);
	group_prefix = _tmp0_;
	_tmp1_ = g_menu_new ();
	copy = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GMenuItem* item = NULL;
				GMenuItem* _tmp4_;
				GMenu* section = NULL;
				GMenuItem* _tmp5_;
				GMenuModel* _tmp6_;
				GMenu* submenu = NULL;
				GMenuItem* _tmp7_;
				GMenuModel* _tmp8_;
				GMenu* _tmp9_;
				GMenu* _tmp41_;
				GMenuItem* _tmp42_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < g_menu_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (template, g_menu_model_get_type (), GMenuModel)))) {
					break;
				}
				_tmp4_ = g_menu_item_new_from_model (G_TYPE_CHECK_INSTANCE_CAST (template, g_menu_model_get_type (), GMenuModel), i);
				item = _tmp4_;
				_tmp5_ = item;
				_tmp6_ = g_menu_item_get_link (_tmp5_, G_MENU_LINK_SECTION);
				section = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_menu_get_type (), GMenu);
				_tmp7_ = item;
				_tmp8_ = g_menu_item_get_link (_tmp7_, G_MENU_LINK_SUBMENU);
				submenu = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_menu_get_type (), GMenu);
				_tmp9_ = section;
				if (_tmp9_ != NULL) {
					GMenuItem* _tmp10_;
					GMenu* _tmp11_;
					GMenu* _tmp12_;
					GMenu* _tmp13_;
					_tmp10_ = item;
					_tmp11_ = section;
					_tmp12_ = util_gtk_copy_menu_with_targets (_tmp11_, group, targets);
					_tmp13_ = _tmp12_;
					g_menu_item_set_section (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_menu_model_get_type (), GMenuModel));
					_g_object_unref0 (_tmp13_);
				} else {
					GMenu* _tmp14_;
					_tmp14_ = submenu;
					if (_tmp14_ != NULL) {
						GMenuItem* _tmp15_;
						GMenu* _tmp16_;
						GMenu* _tmp17_;
						GMenu* _tmp18_;
						_tmp15_ = item;
						_tmp16_ = submenu;
						_tmp17_ = util_gtk_copy_menu_with_targets (_tmp16_, group, targets);
						_tmp18_ = _tmp17_;
						g_menu_item_set_submenu (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, g_menu_model_get_type (), GMenuModel));
						_g_object_unref0 (_tmp18_);
					} else {
						gchar* action = NULL;
						GMenuItem* _tmp19_;
						const GVariantType* _tmp20_;
						GVariant* _tmp21_;
						GVariant* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						gboolean _tmp25_ = FALSE;
						const gchar* _tmp26_;
						_tmp19_ = item;
						_tmp20_ = G_VARIANT_TYPE_STRING;
						_tmp21_ = g_menu_item_get_attribute_value (_tmp19_, G_MENU_ATTRIBUTE_ACTION, _tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = _variant_get19 (_tmp22_);
						_tmp24_ = _tmp23_;
						_g_variant_unref0 (_tmp22_);
						action = _tmp24_;
						_tmp26_ = action;
						if (_tmp26_ != NULL) {
							const gchar* _tmp27_;
							const gchar* _tmp28_;
							_tmp27_ = action;
							_tmp28_ = group_prefix;
							_tmp25_ = g_str_has_prefix (_tmp27_, _tmp28_);
						} else {
							_tmp25_ = FALSE;
						}
						if (_tmp25_) {
							GVariant* target = NULL;
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							gpointer _tmp35_;
							GVariant* _tmp36_;
							GVariant* _tmp37_;
							_tmp29_ = action;
							_tmp30_ = group_prefix;
							_tmp31_ = strlen (_tmp30_);
							_tmp32_ = _tmp31_;
							_tmp33_ = string_substring (_tmp29_, (glong) _tmp32_, (glong) -1);
							_tmp34_ = _tmp33_;
							_tmp35_ = gee_map_get (targets, _tmp34_);
							_tmp36_ = (GVariant*) _tmp35_;
							_g_free0 (_tmp34_);
							target = _tmp36_;
							_tmp37_ = target;
							if (_tmp37_ != NULL) {
								GMenuItem* _tmp38_;
								const gchar* _tmp39_;
								GVariant* _tmp40_;
								_tmp38_ = item;
								_tmp39_ = action;
								_tmp40_ = target;
								g_menu_item_set_action_and_target_value (_tmp38_, _tmp39_, _tmp40_);
							}
							_g_variant_unref0 (target);
						}
						_g_free0 (action);
					}
				}
				_tmp41_ = copy;
				_tmp42_ = item;
				g_menu_append_item (_tmp41_, _tmp42_);
				_g_object_unref0 (submenu);
				_g_object_unref0 (section);
				_g_object_unref0 (item);
			}
		}
	}
	result = copy;
	_g_free0 (group_prefix);
	return result;
}

/** Returns a truncated form of a URL if it is too long for display. */
gchar*
util_gtk_shorten_url (const gchar* url)
{
	gchar* new_url = NULL;
	gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* result;
	g_return_val_if_fail (url != NULL, NULL);
	_tmp0_ = g_strdup (url);
	new_url = _tmp0_;
	_tmp1_ = strlen (url);
	_tmp2_ = _tmp1_;
	if (_tmp2_ >= 90) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp3_ = string_substring (url, (glong) 0, (glong) 40);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp4_, "…", NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = string_substring (url, (glong) -40, (glong) -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
		_g_free0 (new_url);
		new_url = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
	}
	result = new_url;
	return result;
}

void
util_gtk_rgba (gdouble red,
               gdouble green,
               gdouble blue,
               gdouble alpha,
               GdkRGBA* result)
{
	GdkRGBA _tmp0_ = {0};
	memset (&_tmp0_, 0, sizeof (GdkRGBA));
	_tmp0_.red = red;
	_tmp0_.green = green;
	_tmp0_.blue = blue;
	_tmp0_.alpha = alpha;
	*result = _tmp0_;
	return;
}

gboolean
util_gtk_query_tooltip_label (GtkWidget* widget,
                              gint x,
                              gint y,
                              gboolean keyboard,
                              GtkTooltip* tooltip)
{
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	PangoLayout* _tmp2_;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (tooltip, gtk_tooltip_get_type ()), FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_label_get_type ()) ? ((GtkLabel*) widget) : NULL);
	label = _tmp0_;
	_tmp1_ = label;
	_tmp2_ = gtk_label_get_layout (_tmp1_);
	if (pango_layout_is_ellipsized (_tmp2_)) {
		GtkLabel* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = label;
		_tmp4_ = gtk_label_get_label (_tmp3_);
		_tmp5_ = _tmp4_;
		gtk_tooltip_set_markup (tooltip, _tmp5_);
		result = TRUE;
		_g_object_unref0 (label);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (label);
	return result;
}

