/* IconGroupContainer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from IconGroupContainer.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014 Tom Beckmann
 *                         2025 elementary, Inc. <https://elementary.io>
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "gala.h"
#include <meta/workspace.h>

#define GALA_ICON_GROUP_CONTAINER_SPACING 48
#define GALA_ICON_GROUP_CONTAINER_GROUP_WIDTH 64
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_ICON_GROUP_CONTAINER (gala_icon_group_container_get_type ())
#define GALA_ICON_GROUP_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainer))
#define GALA_ICON_GROUP_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainerClass))
#define GALA_IS_ICON_GROUP_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP_CONTAINER))
#define GALA_IS_ICON_GROUP_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP_CONTAINER))
#define GALA_ICON_GROUP_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainerClass))

typedef struct _GalaIconGroupContainer GalaIconGroupContainer;
typedef struct _GalaIconGroupContainerClass GalaIconGroupContainerClass;
typedef struct _GalaIconGroupContainerPrivate GalaIconGroupContainerPrivate;
enum  {
	GALA_ICON_GROUP_CONTAINER_0_PROPERTY,
	GALA_ICON_GROUP_CONTAINER_SCALE_FACTOR_PROPERTY,
	GALA_ICON_GROUP_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* gala_icon_group_container_properties[GALA_ICON_GROUP_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_WORKSPACE_INSERT_THUMB (gala_workspace_insert_thumb_get_type ())
#define GALA_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb))
#define GALA_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))
#define GALA_IS_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_IS_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_WORKSPACE_INSERT_THUMB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))

typedef struct _GalaWorkspaceInsertThumb GalaWorkspaceInsertThumb;
typedef struct _GalaWorkspaceInsertThumbClass GalaWorkspaceInsertThumbClass;

#define GALA_TYPE_ICON_GROUP (gala_icon_group_get_type ())
#define GALA_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroup))
#define GALA_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))
#define GALA_IS_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP))
#define GALA_IS_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP))
#define GALA_ICON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))

typedef struct _GalaIconGroup GalaIconGroup;
typedef struct _GalaIconGroupClass GalaIconGroupClass;
enum  {
	GALA_ICON_GROUP_CONTAINER_REQUEST_REPOSITION_SIGNAL,
	GALA_ICON_GROUP_CONTAINER_NUM_SIGNALS
};
static guint gala_icon_group_container_signals[GALA_ICON_GROUP_CONTAINER_NUM_SIGNALS] = {0};

struct _GalaIconGroupContainer {
	ClutterActor parent_instance;
	GalaIconGroupContainerPrivate * priv;
};

struct _GalaIconGroupContainerClass {
	ClutterActorClass parent_class;
};

struct _GalaIconGroupContainerPrivate {
	gfloat _scale_factor;
};

static gint GalaIconGroupContainer_private_offset;
static gpointer gala_icon_group_container_parent_class = NULL;

VALA_EXTERN GType gala_icon_group_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroupContainer, g_object_unref)
VALA_EXTERN GalaIconGroupContainer* gala_icon_group_container_new (gfloat scale);
VALA_EXTERN GalaIconGroupContainer* gala_icon_group_container_construct (GType object_type,
                                                             gfloat scale);
static void gala_icon_group_container_reallocate (GalaIconGroupContainer* self);
VALA_EXTERN GType gala_workspace_insert_thumb_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceInsertThumb, g_object_unref)
VALA_EXTERN gfloat gala_icon_group_container_get_scale_factor (GalaIconGroupContainer* self);
VALA_EXTERN void gala_workspace_insert_thumb_set_scale_factor (GalaWorkspaceInsertThumb* self,
                                                   gfloat value);
VALA_EXTERN GType gala_icon_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroup, g_object_unref)
VALA_EXTERN void gala_icon_group_container_add_group (GalaIconGroupContainer* self,
                                          GalaIconGroup* group);
VALA_EXTERN MetaWorkspace* gala_icon_group_get_workspace (GalaIconGroup* self);
VALA_EXTERN GalaWorkspaceInsertThumb* gala_workspace_insert_thumb_new (gint workspace_index,
                                                           gfloat scale);
VALA_EXTERN GalaWorkspaceInsertThumb* gala_workspace_insert_thumb_construct (GType object_type,
                                                                 gint workspace_index,
                                                                 gfloat scale);
static void gala_icon_group_container_expanded_changed (GalaIconGroupContainer* self,
                                                 GParamSpec* param);
static void _gala_icon_group_container_expanded_changed_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
static void gala_icon_group_container_update_inserter_indices (GalaIconGroupContainer* self);
VALA_EXTERN void gala_icon_group_container_remove_group (GalaIconGroupContainer* self,
                                             GalaIconGroup* group);
VALA_EXTERN void gala_icon_group_container_remove_group_in_place (GalaIconGroupContainer* self,
                                                      GalaIconGroup* group);
VALA_EXTERN void gala_workspace_insert_thumb_set_expanded (GalaWorkspaceInsertThumb* self,
                                               gboolean value);
VALA_EXTERN void gala_icon_group_set_hovered_actor (GalaIconGroup* self,
                                        ClutterActor* actor);
VALA_EXTERN void gala_icon_group_container_reset_thumbs (GalaIconGroupContainer* self,
                                             gint delay);
VALA_EXTERN void gala_workspace_insert_thumb_set_delay (GalaWorkspaceInsertThumb* self,
                                            gint value);
VALA_EXTERN gfloat gala_icon_group_container_calculate_total_width (GalaIconGroupContainer* self);
VALA_EXTERN gboolean gala_workspace_insert_thumb_get_expanded (GalaWorkspaceInsertThumb* self);
VALA_EXTERN void gala_icon_group_container_force_reposition (GalaIconGroupContainer* self);
VALA_EXTERN void gala_workspace_insert_thumb_set_workspace_index (GalaWorkspaceInsertThumb* self,
                                                      gint value);
VALA_EXTERN void gala_icon_group_container_set_scale_factor (GalaIconGroupContainer* self,
                                                 gfloat value);
static void gala_icon_group_container_finalize (GObject * obj);
static GType gala_icon_group_container_get_type_once (void);
static void _vala_gala_icon_group_container_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_gala_icon_group_container_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
gala_icon_group_container_get_instance_private (GalaIconGroupContainer* self)
{
	return G_STRUCT_MEMBER_P (self, GalaIconGroupContainer_private_offset);
}

GalaIconGroupContainer*
gala_icon_group_container_construct (GType object_type,
                                     gfloat scale)
{
	GalaIconGroupContainer * self = NULL;
	ClutterBoxLayout* _tmp0_;
	ClutterBoxLayout* _tmp1_;
	self = (GalaIconGroupContainer*) g_object_new (object_type, "scale-factor", scale, NULL);
	_tmp0_ = (ClutterBoxLayout*) clutter_box_layout_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	clutter_actor_set_layout_manager ((ClutterActor*) self, (ClutterLayoutManager*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}

GalaIconGroupContainer*
gala_icon_group_container_new (gfloat scale)
{
	return gala_icon_group_container_construct (GALA_TYPE_ICON_GROUP_CONTAINER, scale);
}

static void
gala_icon_group_container_reallocate (GalaIconGroupContainer* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceInsertThumb* thumb = NULL;
				ClutterActor* _tmp1_;
				GalaWorkspaceInsertThumb* _tmp2_;
				_tmp1_ = child;
				thumb = GALA_IS_WORKSPACE_INSERT_THUMB (_tmp1_) ? ((GalaWorkspaceInsertThumb*) _tmp1_) : NULL;
				_tmp2_ = thumb;
				if (_tmp2_ != NULL) {
					GalaWorkspaceInsertThumb* _tmp3_;
					gfloat _tmp4_;
					gfloat _tmp5_;
					_tmp3_ = thumb;
					_tmp4_ = gala_icon_group_container_get_scale_factor (self);
					_tmp5_ = _tmp4_;
					gala_workspace_insert_thumb_set_scale_factor (_tmp3_, _tmp5_);
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static void
_gala_icon_group_container_expanded_changed_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	gala_icon_group_container_expanded_changed ((GalaIconGroupContainer*) self, pspec);
}

void
gala_icon_group_container_add_group (GalaIconGroupContainer* self,
                                     GalaIconGroup* group)
{
	gint index = 0;
	MetaWorkspace* _tmp0_;
	MetaWorkspace* _tmp1_;
	GalaWorkspaceInsertThumb* thumb = NULL;
	gfloat _tmp2_;
	gfloat _tmp3_;
	GalaWorkspaceInsertThumb* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = gala_icon_group_get_workspace (group);
	_tmp1_ = _tmp0_;
	index = meta_workspace_index (_tmp1_);
	clutter_actor_insert_child_at_index ((ClutterActor*) self, (ClutterActor*) group, index * 2);
	_tmp2_ = gala_icon_group_container_get_scale_factor (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gala_workspace_insert_thumb_new (index, _tmp3_);
	g_object_ref_sink (_tmp4_);
	thumb = _tmp4_;
	g_signal_connect_object ((GObject*) thumb, "notify::expanded", (GCallback) _gala_icon_group_container_expanded_changed_g_object_notify, self, G_CONNECT_AFTER);
	clutter_actor_insert_child_at_index ((ClutterActor*) self, (ClutterActor*) thumb, index * 2);
	gala_icon_group_container_update_inserter_indices (self);
	_g_object_unref0 (thumb);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gala_icon_group_container_remove_group (GalaIconGroupContainer* self,
                                        GalaIconGroup* group)
{
	GalaWorkspaceInsertThumb* thumb = NULL;
	ClutterActor* _tmp0_;
	GalaWorkspaceInsertThumb* _tmp1_;
	guint _tmp2_;
	GQuark _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = clutter_actor_get_previous_sibling ((ClutterActor*) group);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb));
	thumb = _tmp1_;
	g_signal_parse_name ("notify::expanded", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) thumb, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _gala_icon_group_container_expanded_changed_g_object_notify, self);
	clutter_actor_remove_child ((ClutterActor*) self, (ClutterActor*) thumb);
	clutter_actor_remove_child ((ClutterActor*) self, (ClutterActor*) group);
	gala_icon_group_container_update_inserter_indices (self);
	_g_object_unref0 (thumb);
}

/**
     * Removes an icon group "in place".
     * When initially dragging an icon group we remove
     * it and it's previous WorkspaceInsertThumb. This would make
     * the container immediately reallocate and fill the empty space
     * with right-most IconGroups.
     *
     * We don't want that until the IconGroup
     * leaves the expanded WorkspaceInsertThumb.
     */
void
gala_icon_group_container_remove_group_in_place (GalaIconGroupContainer* self,
                                                 GalaIconGroup* group)
{
	GalaWorkspaceInsertThumb* deleted_thumb = NULL;
	ClutterActor* _tmp0_;
	GalaWorkspaceInsertThumb* _tmp1_;
	GalaWorkspaceInsertThumb* deleted_placeholder_thumb = NULL;
	ClutterActor* _tmp2_;
	GalaWorkspaceInsertThumb* _tmp3_;
	GalaWorkspaceInsertThumb* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = clutter_actor_get_previous_sibling ((ClutterActor*) group);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb));
	deleted_thumb = _tmp1_;
	_tmp2_ = clutter_actor_get_next_sibling ((ClutterActor*) group);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb));
	deleted_placeholder_thumb = _tmp3_;
	gala_icon_group_container_remove_group (self, group);
	_tmp4_ = deleted_placeholder_thumb;
	if (_tmp4_ != NULL) {
		gfloat deleted_width = 0.0F;
		GalaWorkspaceInsertThumb* _tmp5_;
		GalaWorkspaceInsertThumb* _tmp6_;
		GalaWorkspaceInsertThumb* _tmp7_;
		GalaWorkspaceInsertThumb* _tmp8_;
		gfloat _tmp9_;
		gfloat _tmp10_;
		GalaWorkspaceInsertThumb* _tmp11_;
		_tmp5_ = deleted_thumb;
		deleted_width = clutter_actor_get_width ((ClutterActor*) _tmp5_) + clutter_actor_get_width ((ClutterActor*) group);
		_tmp6_ = deleted_placeholder_thumb;
		gala_workspace_insert_thumb_set_expanded (_tmp6_, TRUE);
		_tmp7_ = deleted_placeholder_thumb;
		_tmp8_ = deleted_placeholder_thumb;
		_tmp9_ = clutter_actor_get_width ((ClutterActor*) _tmp8_);
		_tmp10_ = _tmp9_;
		clutter_actor_set_width ((ClutterActor*) _tmp8_, _tmp10_ + deleted_width);
		_tmp11_ = deleted_placeholder_thumb;
		gala_icon_group_set_hovered_actor (group, (ClutterActor*) _tmp11_);
	}
	_g_object_unref0 (deleted_placeholder_thumb);
	_g_object_unref0 (deleted_thumb);
}

void
gala_icon_group_container_reset_thumbs (GalaIconGroupContainer* self,
                                        gint delay)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceInsertThumb* thumb = NULL;
				ClutterActor* _tmp1_;
				GalaWorkspaceInsertThumb* _tmp2_;
				_tmp1_ = child;
				thumb = GALA_IS_WORKSPACE_INSERT_THUMB (_tmp1_) ? ((GalaWorkspaceInsertThumb*) _tmp1_) : NULL;
				_tmp2_ = thumb;
				if (_tmp2_ != NULL) {
					GalaWorkspaceInsertThumb* _tmp3_;
					GalaWorkspaceInsertThumb* _tmp4_;
					_tmp3_ = thumb;
					gala_workspace_insert_thumb_set_delay (_tmp3_, delay);
					_tmp4_ = thumb;
					clutter_actor_destroy_all_children ((ClutterActor*) _tmp4_);
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static void
gala_icon_group_container_expanded_changed (GalaIconGroupContainer* self,
                                            GParamSpec* param)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	g_signal_emit (self, gala_icon_group_container_signals[GALA_ICON_GROUP_CONTAINER_REQUEST_REPOSITION_SIGNAL], 0, TRUE);
}

/**
     * Calculates the width that will be occupied taking currently running animations
     * end states into account
     */
gfloat
gala_icon_group_container_calculate_total_width (GalaIconGroupContainer* self)
{
	gint spacing = 0;
	gfloat _tmp0_;
	gfloat _tmp1_;
	gint group_width = 0;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gfloat width = 0.0F;
	GList* _tmp4_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = gala_icon_group_container_get_scale_factor (self);
	_tmp1_ = _tmp0_;
	spacing = gala_utils_scale_to_int (GALA_ICON_GROUP_CONTAINER_SPACING, _tmp1_);
	_tmp2_ = gala_icon_group_container_get_scale_factor (self);
	_tmp3_ = _tmp2_;
	group_width = gala_utils_scale_to_int (GALA_ICON_GROUP_CONTAINER_GROUP_WIDTH, _tmp3_);
	width = 0.0f;
	_tmp4_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp4_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp5_;
				_tmp5_ = child;
				if (GALA_IS_WORKSPACE_INSERT_THUMB (_tmp5_)) {
					ClutterActor* _tmp6_;
					gboolean _tmp7_;
					gboolean _tmp8_;
					_tmp6_ = child;
					_tmp7_ = gala_workspace_insert_thumb_get_expanded (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb));
					_tmp8_ = _tmp7_;
					if (_tmp8_) {
						width += (gfloat) (group_width + (spacing * 2));
					} else {
						width += (gfloat) spacing;
					}
				} else {
					width += (gfloat) group_width;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	width += (gfloat) spacing;
	result = width;
	return result;
}

void
gala_icon_group_container_force_reposition (GalaIconGroupContainer* self)
{
	GList* children = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	children = _tmp0_;
	_tmp1_ = children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp2_;
				_tmp2_ = child;
				if (GALA_IS_ICON_GROUP (_tmp2_)) {
					ClutterActor* _tmp3_;
					_tmp3_ = child;
					gala_icon_group_container_remove_group (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GALA_TYPE_ICON_GROUP, GalaIconGroup));
				}
			}
		}
	}
	_tmp4_ = children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp4_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp5_;
				_tmp5_ = child;
				if (GALA_IS_ICON_GROUP (_tmp5_)) {
					ClutterActor* _tmp6_;
					_tmp6_ = child;
					gala_icon_group_container_add_group (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GALA_TYPE_ICON_GROUP, GalaIconGroup));
				}
			}
		}
	}
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
}

static void
gala_icon_group_container_update_inserter_indices (GalaIconGroupContainer* self)
{
	gint current_index = 0;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	current_index = 0;
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceInsertThumb* thumb = NULL;
				ClutterActor* _tmp1_;
				GalaWorkspaceInsertThumb* _tmp2_;
				_tmp1_ = child;
				thumb = GALA_IS_WORKSPACE_INSERT_THUMB (_tmp1_) ? ((GalaWorkspaceInsertThumb*) _tmp1_) : NULL;
				_tmp2_ = thumb;
				if (_tmp2_ != NULL) {
					GalaWorkspaceInsertThumb* _tmp3_;
					gint _tmp4_;
					_tmp3_ = thumb;
					_tmp4_ = current_index;
					current_index = _tmp4_ + 1;
					gala_workspace_insert_thumb_set_workspace_index (_tmp3_, _tmp4_);
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

gfloat
gala_icon_group_container_get_scale_factor (GalaIconGroupContainer* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_scale_factor;
	return result;
}

void
gala_icon_group_container_set_scale_factor (GalaIconGroupContainer* self,
                                            gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value != self->priv->_scale_factor) {
		self->priv->_scale_factor = value;
		gala_icon_group_container_reallocate (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gala_icon_group_container_properties[GALA_ICON_GROUP_CONTAINER_SCALE_FACTOR_PROPERTY]);
}

static void
gala_icon_group_container_class_init (GalaIconGroupContainerClass * klass,
                                      gpointer klass_data)
{
	gala_icon_group_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaIconGroupContainer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_icon_group_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_icon_group_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_icon_group_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ICON_GROUP_CONTAINER_SCALE_FACTOR_PROPERTY, gala_icon_group_container_properties[GALA_ICON_GROUP_CONTAINER_SCALE_FACTOR_PROPERTY] = g_param_spec_float ("scale-factor", "scale-factor", "scale-factor", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gala_icon_group_container_signals[GALA_ICON_GROUP_CONTAINER_REQUEST_REPOSITION_SIGNAL] = g_signal_new ("request-reposition", GALA_TYPE_ICON_GROUP_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
gala_icon_group_container_instance_init (GalaIconGroupContainer * self,
                                         gpointer klass)
{
	self->priv = gala_icon_group_container_get_instance_private (self);
	self->priv->_scale_factor = 1.0f;
}

static void
gala_icon_group_container_finalize (GObject * obj)
{
	GalaIconGroupContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainer);
	G_OBJECT_CLASS (gala_icon_group_container_parent_class)->finalize (obj);
}

/**
 * This class contains the icon groups at the bottom and will take
 * care of displaying actors for inserting windows between the groups
 * once implemented
 */
 G_GNUC_NO_INLINE static GType
gala_icon_group_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaIconGroupContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_icon_group_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaIconGroupContainer), 0, (GInstanceInitFunc) gala_icon_group_container_instance_init, NULL };
	GType gala_icon_group_container_type_id;
	gala_icon_group_container_type_id = g_type_register_static (clutter_actor_get_type (), "GalaIconGroupContainer", &g_define_type_info, 0);
	GalaIconGroupContainer_private_offset = g_type_add_instance_private (gala_icon_group_container_type_id, sizeof (GalaIconGroupContainerPrivate));
	return gala_icon_group_container_type_id;
}

GType
gala_icon_group_container_get_type (void)
{
	static gsize gala_icon_group_container_type_id__once = 0;
	if (g_once_init_enter (&gala_icon_group_container_type_id__once)) {
		GType gala_icon_group_container_type_id;
		gala_icon_group_container_type_id = gala_icon_group_container_get_type_once ();
		g_once_init_leave (&gala_icon_group_container_type_id__once, gala_icon_group_container_type_id);
	}
	return gala_icon_group_container_type_id__once;
}

static void
_vala_gala_icon_group_container_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GalaIconGroupContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainer);
	switch (property_id) {
		case GALA_ICON_GROUP_CONTAINER_SCALE_FACTOR_PROPERTY:
		g_value_set_float (value, gala_icon_group_container_get_scale_factor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_icon_group_container_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	GalaIconGroupContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainer);
	switch (property_id) {
		case GALA_ICON_GROUP_CONTAINER_SCALE_FACTOR_PROPERTY:
		gala_icon_group_container_set_scale_factor (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

