/* GestureSettings.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from GestureSettings.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc (https://elementary.io)
 *           2021 José Expósito <jose.exposito89@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <clutter/clutter.h>
#include <glib.h>
#include <meta/common.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include "gala.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_GESTURE_SETTINGS (gala_gesture_settings_get_type ())
#define GALA_GESTURE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettings))
#define GALA_GESTURE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettingsClass))
#define GALA_IS_GESTURE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_SETTINGS))
#define GALA_IS_GESTURE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_SETTINGS))
#define GALA_GESTURE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettingsClass))

typedef struct _GalaGestureSettings GalaGestureSettings;
typedef struct _GalaGestureSettingsClass GalaGestureSettingsClass;
typedef struct _GalaGestureSettingsPrivate GalaGestureSettingsPrivate;
enum  {
	GALA_GESTURE_SETTINGS_0_PROPERTY,
	GALA_GESTURE_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* gala_gesture_settings_properties[GALA_GESTURE_SETTINGS_NUM_PROPERTIES];

#define GALA_TYPE_GESTURE (gala_gesture_get_type ())
#define GALA_GESTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE, GalaGesture))
#define GALA_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE, GalaGestureClass))
#define GALA_IS_GESTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE))
#define GALA_IS_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE))
#define GALA_GESTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE, GalaGestureClass))

typedef struct _GalaGesture GalaGesture;
typedef struct _GalaGestureClass GalaGestureClass;
typedef struct _GalaGesturePrivate GalaGesturePrivate;
typedef enum  {
	GALA_GESTURE_DIRECTION_UNKNOWN = 0,
	GALA_GESTURE_DIRECTION_UP = 1,
	GALA_GESTURE_DIRECTION_DOWN = 2,
	GALA_GESTURE_DIRECTION_LEFT = 3,
	GALA_GESTURE_DIRECTION_RIGHT = 4,
	GALA_GESTURE_DIRECTION_IN = 5,
	GALA_GESTURE_DIRECTION_OUT = 6
} GalaGestureDirection;

#define GALA_TYPE_GESTURE_DIRECTION (gala_gesture_direction_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GalaGestureSettings {
	GObject parent_instance;
	GalaGestureSettingsPrivate * priv;
};

struct _GalaGestureSettingsClass {
	GObjectClass parent_class;
};

struct _GalaGesture {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaGesturePrivate * priv;
	ClutterEventType type;
	GalaGestureDirection direction;
	gint fingers;
	ClutterInputDeviceType performed_on_device_type;
	gfloat origin_x;
	gfloat origin_y;
};

struct _GalaGestureClass {
	GTypeClass parent_class;
	void (*finalize) (GalaGesture *self);
};

static gpointer gala_gesture_settings_parent_class = NULL;
static GSettings* gala_gesture_settings_gala_settings;
static GSettings* gala_gesture_settings_gala_settings = NULL;
static GSettings* gala_gesture_settings_touchpad_settings;
static GSettings* gala_gesture_settings_touchpad_settings = NULL;

VALA_EXTERN GType gala_gesture_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureSettings, g_object_unref)
VALA_EXTERN gboolean gala_gesture_settings_is_natural_scroll_enabled (GalaGestureSettings* self,
                                                          ClutterInputDeviceType device_type);
VALA_EXTERN gpointer gala_gesture_ref (gpointer instance);
VALA_EXTERN void gala_gesture_unref (gpointer instance);
VALA_EXTERN GParamSpec* gala_param_spec_gesture (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void gala_value_set_gesture (GValue* value,
                             gpointer v_object);
VALA_EXTERN void gala_value_take_gesture (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer gala_value_get_gesture (const GValue* value);
VALA_EXTERN GType gala_gesture_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGesture, gala_gesture_unref)
VALA_EXTERN MetaMotionDirection* gala_gesture_settings_get_direction (GalaGestureSettings* self,
                                                          GalaGesture* gesture);
VALA_EXTERN GType gala_gesture_direction_get_type (void) G_GNUC_CONST ;
static MetaMotionDirection* _meta_motion_direction_dup (MetaMotionDirection* self);
VALA_EXTERN MetaMotionDirection* gala_gesture_settings_get_natural_scroll_direction (GalaGestureSettings* self,
                                                                         GalaGesture* gesture);
VALA_EXTERN gchar* gala_gesture_settings_get_string (const gchar* setting_id);
VALA_EXTERN GalaGestureAction gala_gesture_settings_get_action (GalaGesture* gesture,
                                                    GVariant** action_info);
static GVariant* _variant_new6 (gboolean value);
VALA_EXTERN GalaGestureSettings* gala_gesture_settings_new (void);
VALA_EXTERN GalaGestureSettings* gala_gesture_settings_construct (GType object_type);
static void gala_gesture_settings_finalize (GObject * obj);
static GType gala_gesture_settings_get_type_once (void);

gboolean
gala_gesture_settings_is_natural_scroll_enabled (GalaGestureSettings* self,
                                                 ClutterInputDeviceType device_type)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (device_type == CLUTTER_TOUCHSCREEN_DEVICE) {
		_tmp0_ = TRUE;
	} else {
		GSettings* _tmp1_;
		_tmp1_ = gala_gesture_settings_touchpad_settings;
		_tmp0_ = g_settings_get_boolean (_tmp1_, "natural-scroll");
	}
	result = _tmp0_;
	return result;
}

static MetaMotionDirection*
_meta_motion_direction_dup (MetaMotionDirection* self)
{
	MetaMotionDirection* dup;
	dup = g_new0 (MetaMotionDirection, 1);
	memcpy (dup, self, sizeof (MetaMotionDirection));
	return dup;
}

static gpointer
__meta_motion_direction_dup0 (gpointer self)
{
	return self ? _meta_motion_direction_dup (self) : NULL;
}

MetaMotionDirection*
gala_gesture_settings_get_direction (GalaGestureSettings* self,
                                     GalaGesture* gesture)
{
	MetaMotionDirection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gesture != NULL, NULL);
	switch (gesture->direction) {
		case GALA_GESTURE_DIRECTION_UP:
		{
			MetaMotionDirection _tmp0_;
			MetaMotionDirection* _tmp1_;
			_tmp0_ = META_MOTION_UP;
			_tmp1_ = __meta_motion_direction_dup0 (&_tmp0_);
			result = _tmp1_;
			return result;
		}
		case GALA_GESTURE_DIRECTION_DOWN:
		{
			MetaMotionDirection _tmp2_;
			MetaMotionDirection* _tmp3_;
			_tmp2_ = META_MOTION_DOWN;
			_tmp3_ = __meta_motion_direction_dup0 (&_tmp2_);
			result = _tmp3_;
			return result;
		}
		case GALA_GESTURE_DIRECTION_LEFT:
		{
			MetaMotionDirection _tmp4_;
			MetaMotionDirection* _tmp5_;
			_tmp4_ = META_MOTION_LEFT;
			_tmp5_ = __meta_motion_direction_dup0 (&_tmp4_);
			result = _tmp5_;
			return result;
		}
		case GALA_GESTURE_DIRECTION_RIGHT:
		{
			MetaMotionDirection _tmp6_;
			MetaMotionDirection* _tmp7_;
			_tmp6_ = META_MOTION_RIGHT;
			_tmp7_ = __meta_motion_direction_dup0 (&_tmp6_);
			result = _tmp7_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

MetaMotionDirection*
gala_gesture_settings_get_natural_scroll_direction (GalaGestureSettings* self,
                                                    GalaGesture* gesture)
{
	gboolean natural_scroll = FALSE;
	MetaMotionDirection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gesture != NULL, NULL);
	natural_scroll = gala_gesture_settings_is_natural_scroll_enabled (self, gesture->performed_on_device_type);
	switch (gesture->direction) {
		case GALA_GESTURE_DIRECTION_UP:
		{
			MetaMotionDirection _tmp0_ = 0;
			MetaMotionDirection* _tmp1_;
			if (natural_scroll) {
				_tmp0_ = META_MOTION_DOWN;
			} else {
				_tmp0_ = META_MOTION_UP;
			}
			_tmp1_ = __meta_motion_direction_dup0 (&_tmp0_);
			result = _tmp1_;
			return result;
		}
		case GALA_GESTURE_DIRECTION_DOWN:
		{
			MetaMotionDirection _tmp2_ = 0;
			MetaMotionDirection* _tmp3_;
			if (natural_scroll) {
				_tmp2_ = META_MOTION_UP;
			} else {
				_tmp2_ = META_MOTION_DOWN;
			}
			_tmp3_ = __meta_motion_direction_dup0 (&_tmp2_);
			result = _tmp3_;
			return result;
		}
		case GALA_GESTURE_DIRECTION_LEFT:
		{
			MetaMotionDirection _tmp4_ = 0;
			MetaMotionDirection* _tmp5_;
			if (natural_scroll) {
				_tmp4_ = META_MOTION_RIGHT;
			} else {
				_tmp4_ = META_MOTION_LEFT;
			}
			_tmp5_ = __meta_motion_direction_dup0 (&_tmp4_);
			result = _tmp5_;
			return result;
		}
		case GALA_GESTURE_DIRECTION_RIGHT:
		{
			MetaMotionDirection _tmp6_ = 0;
			MetaMotionDirection* _tmp7_;
			if (natural_scroll) {
				_tmp6_ = META_MOTION_LEFT;
			} else {
				_tmp6_ = META_MOTION_RIGHT;
			}
			_tmp7_ = __meta_motion_direction_dup0 (&_tmp6_);
			result = _tmp7_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

gchar*
gala_gesture_settings_get_string (const gchar* setting_id)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (setting_id != NULL, NULL);
	_tmp0_ = gala_gesture_settings_gala_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, setting_id);
	result = _tmp1_;
	return result;
}

static GVariant*
_variant_new6 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

GalaGestureAction
gala_gesture_settings_get_action (GalaGesture* gesture,
                                  GVariant** action_info)
{
	GVariant* _vala_action_info = NULL;
	gint fingers = 0;
	GalaGestureAction result;
	g_return_val_if_fail (gesture != NULL, 0);
	_g_variant_unref0 (_vala_action_info);
	_vala_action_info = NULL;
	fingers = gesture->fingers;
	switch (gesture->type) {
		case CLUTTER_TOUCHPAD_SWIPE:
		{
			gboolean _tmp0_ = FALSE;
			if (gesture->direction == GALA_GESTURE_DIRECTION_LEFT) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = gesture->direction == GALA_GESTURE_DIRECTION_RIGHT;
			}
			if (_tmp0_) {
				gchar* three_finger_swipe_horizontal = NULL;
				gchar* _tmp1_;
				gchar* four_finger_swipe_horizontal = NULL;
				gchar* _tmp2_;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				_tmp1_ = gala_gesture_settings_get_string ("three-finger-swipe-horizontal");
				three_finger_swipe_horizontal = _tmp1_;
				_tmp2_ = gala_gesture_settings_get_string ("four-finger-swipe-horizontal");
				four_finger_swipe_horizontal = _tmp2_;
				if (fingers == 3) {
					const gchar* _tmp5_;
					_tmp5_ = three_finger_swipe_horizontal;
					_tmp4_ = g_strcmp0 (_tmp5_, "switch-to-workspace") == 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					_tmp3_ = TRUE;
				} else {
					gboolean _tmp6_ = FALSE;
					if (fingers == 4) {
						const gchar* _tmp7_;
						_tmp7_ = four_finger_swipe_horizontal;
						_tmp6_ = g_strcmp0 (_tmp7_, "switch-to-workspace") == 0;
					} else {
						_tmp6_ = FALSE;
					}
					_tmp3_ = _tmp6_;
				}
				if (_tmp3_) {
					result = GALA_GESTURE_ACTION_SWITCH_WORKSPACE;
					_g_free0 (four_finger_swipe_horizontal);
					_g_free0 (three_finger_swipe_horizontal);
					if (action_info) {
						*action_info = _vala_action_info;
					} else {
						_g_variant_unref0 (_vala_action_info);
					}
					return result;
				}
				if (fingers == 3) {
					const gchar* _tmp10_;
					_tmp10_ = three_finger_swipe_horizontal;
					_tmp9_ = g_strcmp0 (_tmp10_, "move-to-workspace") == 0;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					_tmp8_ = TRUE;
				} else {
					gboolean _tmp11_ = FALSE;
					if (fingers == 4) {
						const gchar* _tmp12_;
						_tmp12_ = four_finger_swipe_horizontal;
						_tmp11_ = g_strcmp0 (_tmp12_, "move-to-workspace") == 0;
					} else {
						_tmp11_ = FALSE;
					}
					_tmp8_ = _tmp11_;
				}
				if (_tmp8_) {
					GVariant* _tmp13_;
					_tmp13_ = _variant_new6 (TRUE);
					_g_variant_unref0 (_vala_action_info);
					_vala_action_info = _tmp13_;
					result = GALA_GESTURE_ACTION_SWITCH_WORKSPACE;
					_g_free0 (four_finger_swipe_horizontal);
					_g_free0 (three_finger_swipe_horizontal);
					if (action_info) {
						*action_info = _vala_action_info;
					} else {
						_g_variant_unref0 (_vala_action_info);
					}
					return result;
				}
				if (fingers == 3) {
					const gchar* _tmp16_;
					_tmp16_ = three_finger_swipe_horizontal;
					_tmp15_ = g_strcmp0 (_tmp16_, "switch-windows") == 0;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					_tmp14_ = TRUE;
				} else {
					gboolean _tmp17_ = FALSE;
					if (fingers == 4) {
						const gchar* _tmp18_;
						_tmp18_ = four_finger_swipe_horizontal;
						_tmp17_ = g_strcmp0 (_tmp18_, "switch-windows") == 0;
					} else {
						_tmp17_ = FALSE;
					}
					_tmp14_ = _tmp17_;
				}
				if (_tmp14_) {
					result = GALA_GESTURE_ACTION_SWITCH_WINDOWS;
					_g_free0 (four_finger_swipe_horizontal);
					_g_free0 (three_finger_swipe_horizontal);
					if (action_info) {
						*action_info = _vala_action_info;
					} else {
						_g_variant_unref0 (_vala_action_info);
					}
					return result;
				}
				_g_free0 (four_finger_swipe_horizontal);
				_g_free0 (three_finger_swipe_horizontal);
			} else {
				gboolean _tmp19_ = FALSE;
				if (gesture->direction == GALA_GESTURE_DIRECTION_UP) {
					_tmp19_ = TRUE;
				} else {
					_tmp19_ = gesture->direction == GALA_GESTURE_DIRECTION_DOWN;
				}
				if (_tmp19_) {
					gchar* three_finger_swipe_up = NULL;
					gchar* _tmp20_;
					gchar* four_finger_swipe_up = NULL;
					gchar* _tmp21_;
					gboolean _tmp22_ = FALSE;
					gboolean _tmp23_ = FALSE;
					_tmp20_ = gala_gesture_settings_get_string ("three-finger-swipe-up");
					three_finger_swipe_up = _tmp20_;
					_tmp21_ = gala_gesture_settings_get_string ("four-finger-swipe-up");
					four_finger_swipe_up = _tmp21_;
					if (fingers == 3) {
						const gchar* _tmp24_;
						_tmp24_ = three_finger_swipe_up;
						_tmp23_ = g_strcmp0 (_tmp24_, "multitasking-view") == 0;
					} else {
						_tmp23_ = FALSE;
					}
					if (_tmp23_) {
						_tmp22_ = TRUE;
					} else {
						gboolean _tmp25_ = FALSE;
						if (fingers == 4) {
							const gchar* _tmp26_;
							_tmp26_ = four_finger_swipe_up;
							_tmp25_ = g_strcmp0 (_tmp26_, "multitasking-view") == 0;
						} else {
							_tmp25_ = FALSE;
						}
						_tmp22_ = _tmp25_;
					}
					if (_tmp22_) {
						result = GALA_GESTURE_ACTION_MULTITASKING_VIEW;
						_g_free0 (four_finger_swipe_up);
						_g_free0 (three_finger_swipe_up);
						if (action_info) {
							*action_info = _vala_action_info;
						} else {
							_g_variant_unref0 (_vala_action_info);
						}
						return result;
					}
					_g_free0 (four_finger_swipe_up);
					_g_free0 (three_finger_swipe_up);
				}
			}
			break;
		}
		case CLUTTER_TOUCHPAD_PINCH:
		{
			gchar* three_finger_pinch = NULL;
			gchar* _tmp27_;
			gchar* four_finger_pinch = NULL;
			gchar* _tmp28_;
			gboolean _tmp29_ = FALSE;
			gboolean _tmp30_ = FALSE;
			_tmp27_ = gala_gesture_settings_get_string ("three-finger-pinch");
			three_finger_pinch = _tmp27_;
			_tmp28_ = gala_gesture_settings_get_string ("four-finger-pinch");
			four_finger_pinch = _tmp28_;
			if (fingers == 3) {
				const gchar* _tmp31_;
				_tmp31_ = three_finger_pinch;
				_tmp30_ = g_strcmp0 (_tmp31_, "zoom") == 0;
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				_tmp29_ = TRUE;
			} else {
				gboolean _tmp32_ = FALSE;
				if (fingers == 4) {
					const gchar* _tmp33_;
					_tmp33_ = four_finger_pinch;
					_tmp32_ = g_strcmp0 (_tmp33_, "zoom") == 0;
				} else {
					_tmp32_ = FALSE;
				}
				_tmp29_ = _tmp32_;
			}
			if (_tmp29_) {
				result = GALA_GESTURE_ACTION_ZOOM;
				_g_free0 (four_finger_pinch);
				_g_free0 (three_finger_pinch);
				if (action_info) {
					*action_info = _vala_action_info;
				} else {
					_g_variant_unref0 (_vala_action_info);
				}
				return result;
			}
			_g_free0 (four_finger_pinch);
			_g_free0 (three_finger_pinch);
			break;
		}
		default:
		{
			break;
		}
	}
	result = GALA_GESTURE_ACTION_NONE;
	if (action_info) {
		*action_info = _vala_action_info;
	} else {
		_g_variant_unref0 (_vala_action_info);
	}
	return result;
}

GalaGestureSettings*
gala_gesture_settings_construct (GType object_type)
{
	GalaGestureSettings * self = NULL;
	self = (GalaGestureSettings*) g_object_new (object_type, NULL);
	return self;
}

GalaGestureSettings*
gala_gesture_settings_new (void)
{
	return gala_gesture_settings_construct (GALA_TYPE_GESTURE_SETTINGS);
}

static void
gala_gesture_settings_class_init (GalaGestureSettingsClass * klass,
                                  gpointer klass_data)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gala_gesture_settings_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = gala_gesture_settings_finalize;
	_tmp0_ = g_settings_new ("io.elementary.desktop.wm.gestures");
	_g_object_unref0 (gala_gesture_settings_gala_settings);
	gala_gesture_settings_gala_settings = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.desktop.peripherals.touchpad");
	_g_object_unref0 (gala_gesture_settings_touchpad_settings);
	gala_gesture_settings_touchpad_settings = _tmp1_;
}

static void
gala_gesture_settings_instance_init (GalaGestureSettings * self,
                                     gpointer klass)
{
}

static void
gala_gesture_settings_finalize (GObject * obj)
{
	GalaGestureSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettings);
	G_OBJECT_CLASS (gala_gesture_settings_parent_class)->finalize (obj);
}

/**
 * Utility class to access the gesture settings. Easily accessible through GestureTracker.settings.
 */
 G_GNUC_NO_INLINE static GType
gala_gesture_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaGestureSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_gesture_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaGestureSettings), 0, (GInstanceInitFunc) gala_gesture_settings_instance_init, NULL };
	GType gala_gesture_settings_type_id;
	gala_gesture_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaGestureSettings", &g_define_type_info, 0);
	return gala_gesture_settings_type_id;
}

GType
gala_gesture_settings_get_type (void)
{
	static gsize gala_gesture_settings_type_id__once = 0;
	if (g_once_init_enter (&gala_gesture_settings_type_id__once)) {
		GType gala_gesture_settings_type_id;
		gala_gesture_settings_type_id = gala_gesture_settings_get_type_once ();
		g_once_init_leave (&gala_gesture_settings_type_id__once, gala_gesture_settings_type_id);
	}
	return gala_gesture_settings_type_id__once;
}

