/* theme.c generated by valac 0.56.18, the Vala compiler
 * generated from theme.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Four-in-a-row.

   Copyright © 2018 Jacob Humphrey

   GNOME Four-in-a-row is free software: you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Four-in-a-row is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with GNOME Four-in-a-row.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_THEME_MANAGER (theme_manager_get_type ())
#define THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME_MANAGER, ThemeManager))
#define THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME_MANAGER, ThemeManagerClass))
#define IS_THEME_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME_MANAGER))
#define IS_THEME_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME_MANAGER))
#define THEME_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME_MANAGER, ThemeManagerClass))

typedef struct _ThemeManager ThemeManager;
typedef struct _ThemeManagerClass ThemeManagerClass;
typedef struct _ThemeManagerPrivate ThemeManagerPrivate;
enum  {
	THEME_MANAGER_0_PROPERTY,
	THEME_MANAGER_THEME_ID_PROPERTY,
	THEME_MANAGER_BOARD_SIZE_PROPERTY,
	THEME_MANAGER_PB_TILESET_RAW_PROPERTY,
	THEME_MANAGER_PB_BGROUND_RAW_PROPERTY,
	THEME_MANAGER_NUM_PROPERTIES
};
static GParamSpec* theme_manager_properties[THEME_MANAGER_NUM_PROPERTIES];

#define THEME_MANAGER_TYPE_THEME (theme_manager_theme_get_type ())
typedef struct _ThemeManagerTheme ThemeManagerTheme;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	PLAYER_NOBODY,
	PLAYER_HUMAN,
	PLAYER_OPPONENT
} Player;

#define TYPE_PLAYER (player_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	THEME_MANAGER_THEME_CHANGED_SIGNAL,
	THEME_MANAGER_NUM_SIGNALS
};
static guint theme_manager_signals[THEME_MANAGER_NUM_SIGNALS] = {0};

struct _ThemeManager {
	GObject parent_instance;
	ThemeManagerPrivate * priv;
};

struct _ThemeManagerClass {
	GObjectClass parent_class;
};

struct _ThemeManagerPrivate {
	gboolean theme_set;
	gint _theme_id;
	guint8 _board_size;
	gboolean pixmaps_loaded;
	GdkPixbuf* _pb_tileset_raw;
	GdkPixbuf* _pb_bground_raw;
};

struct _ThemeManagerTheme {
	gchar* title;
	gchar* fname_tileset;
	gchar* fname_bground;
	gchar* grid_color;
	gchar* player1;
	gchar* player2;
	gchar* player1_with_colon;
	gchar* player2_with_colon;
	gchar* player1_win;
	gchar* player2_win;
	gchar* player1_turn;
	gchar* player2_turn;
};

static gint ThemeManager_private_offset;
static gpointer theme_manager_parent_class = NULL;

VALA_EXTERN GType theme_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThemeManager, g_object_unref)
static GType theme_manager_theme_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ThemeManagerTheme* theme_manager_theme_dup (const ThemeManagerTheme* self);
static void theme_manager_theme_free (ThemeManagerTheme* self);
static void theme_manager_theme_copy (const ThemeManagerTheme* self,
                               ThemeManagerTheme* dest);
static void theme_manager_theme_destroy (ThemeManagerTheme* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (ThemeManagerTheme, theme_manager_theme_destroy)
VALA_EXTERN ThemeManager* theme_manager_new (guint8 size);
VALA_EXTERN ThemeManager* theme_manager_construct (GType object_type,
                                       guint8 size);
VALA_EXTERN GType player_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* theme_manager_get_player_turn (ThemeManager* self,
                                      Player who);
static gint theme_manager_get_theme_id (ThemeManager* self);
VALA_EXTERN gchar* theme_manager_get_player_win (ThemeManager* self,
                                     Player who);
VALA_EXTERN gchar* theme_manager_get_player (ThemeManager* self,
                                 Player who,
                                 gboolean with_colon);
VALA_EXTERN gchar* theme_manager_get_grid_color (ThemeManager* self);
static void theme_manager_load_pixmaps (ThemeManager* self);
static void theme_manager_load_image (const gchar* image_name,
                               GdkPixbuf** pixbuf);
static inline void theme_manager_create_background (ThemeManager* self);
static guint8 theme_manager_get_board_size (ThemeManager* self);
VALA_EXTERN gchar** theme_manager_get_themes (ThemeManager* self,
                                  gint* result_length1);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN void theme_manager_set_theme_id (ThemeManager* self,
                                 gint value);
static void theme_manager_set_board_size (ThemeManager* self,
                                   guint8 value);
VALA_EXTERN GdkPixbuf* theme_manager_get_pb_tileset_raw (ThemeManager* self);
VALA_EXTERN GdkPixbuf* theme_manager_get_pb_bground_raw (ThemeManager* self);
static void theme_manager_finalize (GObject * obj);
static GType theme_manager_get_type_once (void);
static void _vala_theme_manager_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_theme_manager_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static const ThemeManagerTheme THEME_MANAGER_theme[5] = {{N_ ("High Contrast"), "tileset_50x50_hcontrast.svg", NULL, "#000000", N_ ("Circle"), N_ ("Cross"), N_ ("Circle:"), N_ ("Cross:"), N_ ("Circle wins!"), N_ ("Cross wins!"), N_ ("Circle’s turn"), N_ ("Cross’s turn")}, {N_ ("High Contrast Inverse"), "tileset_50x50_hcinverse.svg", NULL, "#FFFFFF", N_ ("Circle"), N_ ("Cross"), N_ ("Circle:"), N_ ("Cross:"), N_ ("Circle wins!"), N_ ("Cross wins!"), N_ ("Circle’s turn"), N_ ("Cross’s turn")}, {N_ ("Red and Green Marbles"), "tileset_50x50_faenza-glines-icon1.svg", "bg_toplight.png", "#727F8C", N_ ("Red"), N_ ("Green"), N_ ("Red:"), N_ ("Green:"), N_ ("Red wins!"), N_ ("Green wins!"), N_ ("Red’s turn"), N_ ("Green’s turn")}, {N_ ("Blue and Red Marbles"), "tileset_50x50_faenza-glines-icon2.svg", "bg_toplight.png", "#727F8C", N_ ("Blue"), N_ ("Red"), N_ ("Blue:"), N_ ("Red:"), N_ ("Blue wins!"), N_ ("Red wins!"), N_ ("Blue’s turn"), N_ ("Red’s turn")}, {N_ ("Stars and Rings"), "tileset_50x50_faenza-gnect-icon.svg", "bg_toplight.png", "#727F8C", N_ ("Red"), N_ ("Green"), N_ ("Red:"), N_ ("Green:"), N_ ("Red wins!"), N_ ("Green wins!"), N_ ("Red’s turn"), N_ ("Green’s turn")}};

static inline gpointer
theme_manager_get_instance_private (ThemeManager* self)
{
	return G_STRUCT_MEMBER_P (self, ThemeManager_private_offset);
}

ThemeManager*
theme_manager_construct (GType object_type,
                         guint8 size)
{
	ThemeManager * self = NULL;
	self = (ThemeManager*) g_object_new (object_type, "board-size", size, NULL);
	return self;
}

ThemeManager*
theme_manager_new (guint8 size)
{
	return theme_manager_construct (TYPE_THEME_MANAGER, size);
}

gchar*
theme_manager_get_player_turn (ThemeManager* self,
                               Player who)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (who == PLAYER_HUMAN) {
		gint _tmp0_;
		gint _tmp1_;
		ThemeManagerTheme _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = theme_manager_get_theme_id (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = THEME_MANAGER_theme[_tmp1_];
		_tmp3_ = _tmp2_.player1_turn;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	} else {
		gint _tmp5_;
		gint _tmp6_;
		ThemeManagerTheme _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = theme_manager_get_theme_id (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = THEME_MANAGER_theme[_tmp6_];
		_tmp8_ = _tmp7_.player2_turn;
		_tmp9_ = g_strdup (_tmp8_);
		result = _tmp9_;
		return result;
	}
}

gchar*
theme_manager_get_player_win (ThemeManager* self,
                              Player who)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (who == PLAYER_HUMAN) {
		gint _tmp0_;
		gint _tmp1_;
		ThemeManagerTheme _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = theme_manager_get_theme_id (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = THEME_MANAGER_theme[_tmp1_];
		_tmp3_ = _tmp2_.player1_win;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	} else {
		gint _tmp5_;
		gint _tmp6_;
		ThemeManagerTheme _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = theme_manager_get_theme_id (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = THEME_MANAGER_theme[_tmp6_];
		_tmp8_ = _tmp7_.player2_win;
		_tmp9_ = g_strdup (_tmp8_);
		result = _tmp9_;
		return result;
	}
}

gchar*
theme_manager_get_player (ThemeManager* self,
                          Player who,
                          gboolean with_colon)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (with_colon) {
		if (who == PLAYER_HUMAN) {
			gint _tmp0_;
			gint _tmp1_;
			ThemeManagerTheme _tmp2_;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp0_ = theme_manager_get_theme_id (self);
			_tmp1_ = _tmp0_;
			_tmp2_ = THEME_MANAGER_theme[_tmp1_];
			_tmp3_ = _tmp2_.player1_with_colon;
			_tmp4_ = g_strdup (_ (_tmp3_));
			result = _tmp4_;
			return result;
		} else {
			gint _tmp5_;
			gint _tmp6_;
			ThemeManagerTheme _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp5_ = theme_manager_get_theme_id (self);
			_tmp6_ = _tmp5_;
			_tmp7_ = THEME_MANAGER_theme[_tmp6_];
			_tmp8_ = _tmp7_.player2_with_colon;
			_tmp9_ = g_strdup (_ (_tmp8_));
			result = _tmp9_;
			return result;
		}
	} else {
		if (who == PLAYER_HUMAN) {
			gint _tmp10_;
			gint _tmp11_;
			ThemeManagerTheme _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp10_ = theme_manager_get_theme_id (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = THEME_MANAGER_theme[_tmp11_];
			_tmp13_ = _tmp12_.player1;
			_tmp14_ = g_strdup (_ (_tmp13_));
			result = _tmp14_;
			return result;
		} else {
			gint _tmp15_;
			gint _tmp16_;
			ThemeManagerTheme _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp15_ = theme_manager_get_theme_id (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = THEME_MANAGER_theme[_tmp16_];
			_tmp18_ = _tmp17_.player2;
			_tmp19_ = g_strdup (_ (_tmp18_));
			result = _tmp19_;
			return result;
		}
	}
}

gchar*
theme_manager_get_grid_color (ThemeManager* self)
{
	gint _tmp0_;
	gint _tmp1_;
	ThemeManagerTheme _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = theme_manager_get_theme_id (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = THEME_MANAGER_theme[_tmp1_];
	_tmp3_ = _tmp2_.grid_color;
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}

static void
theme_manager_load_pixmaps (ThemeManager* self)
{
	gint _tmp0_;
	gint _tmp1_;
	ThemeManagerTheme _tmp2_;
	const gchar* _tmp3_;
	GdkPixbuf* _tmp4_ = NULL;
	gint _tmp5_;
	gint _tmp6_;
	ThemeManagerTheme _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = theme_manager_get_theme_id (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = THEME_MANAGER_theme[_tmp1_];
	_tmp3_ = _tmp2_.fname_tileset;
	theme_manager_load_image (_tmp3_, &_tmp4_);
	_g_object_unref0 (self->priv->_pb_tileset_raw);
	self->priv->_pb_tileset_raw = _tmp4_;
	_tmp5_ = theme_manager_get_theme_id (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = THEME_MANAGER_theme[_tmp6_];
	_tmp8_ = _tmp7_.fname_bground;
	if (_tmp8_ != NULL) {
		gint _tmp9_;
		gint _tmp10_;
		ThemeManagerTheme _tmp11_;
		const gchar* _tmp12_;
		GdkPixbuf* _tmp13_ = NULL;
		_tmp9_ = theme_manager_get_theme_id (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = THEME_MANAGER_theme[_tmp10_];
		_tmp12_ = _tmp11_.fname_bground;
		theme_manager_load_image ((const gchar*) _tmp12_, &_tmp13_);
		_g_object_unref0 (self->priv->_pb_bground_raw);
		self->priv->_pb_bground_raw = _tmp13_;
	} else {
		theme_manager_create_background (self);
	}
	self->priv->pixmaps_loaded = TRUE;
}

static void
theme_manager_load_image (const gchar* image_name,
                          GdkPixbuf** pixbuf)
{
	GdkPixbuf* _vala_pixbuf = NULL;
	gchar* image_resource = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (image_name != NULL);
	_tmp0_ = g_strconcat ("/org/gnome/Four-in-a-row/images/", image_name, NULL);
	image_resource = _tmp0_;
	{
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp2_ = gdk_pixbuf_new_from_resource (image_resource, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (_vala_pixbuf);
		_vala_pixbuf = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e->message;
		g_critical ("theme.vala:114: %s", _tmp4_);
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (image_resource);
		_g_object_unref0 (_vala_pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (image_resource);
	if (pixbuf) {
		*pixbuf = _vala_pixbuf;
	} else {
		_g_object_unref0 (_vala_pixbuf);
	}
}

static inline void
theme_manager_create_background (ThemeManager* self)
{
	gint raw_tile_size = 0;
	GdkPixbuf* _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	GdkPixbuf* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_pb_tileset_raw;
	raw_tile_size = gdk_pixbuf_get_height (_tmp0_);
	_tmp1_ = self->priv->_board_size;
	_tmp2_ = self->priv->_board_size;
	_tmp3_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, raw_tile_size * _tmp1_, raw_tile_size * _tmp2_);
	_g_object_unref0 (self->priv->_pb_bground_raw);
	self->priv->_pb_bground_raw = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				guint8 _tmp6_;
				GdkPixbuf* _tmp7_;
				GdkPixbuf* _tmp8_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = self->priv->_board_size;
				if (!(i < ((gint) _tmp6_))) {
					break;
				}
				_tmp7_ = self->priv->_pb_tileset_raw;
				_tmp8_ = self->priv->_pb_bground_raw;
				gdk_pixbuf_copy_area (_tmp7_, raw_tile_size * 3, 0, raw_tile_size, raw_tile_size, _tmp8_, i * raw_tile_size, 0);
				{
					gint j = 0;
					j = 1;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							guint8 _tmp11_;
							GdkPixbuf* _tmp12_;
							GdkPixbuf* _tmp13_;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = j;
								j = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = self->priv->_board_size;
							if (!(j < ((gint) _tmp11_))) {
								break;
							}
							_tmp12_ = self->priv->_pb_tileset_raw;
							_tmp13_ = self->priv->_pb_bground_raw;
							gdk_pixbuf_copy_area (_tmp12_, raw_tile_size * 2, 0, raw_tile_size, raw_tile_size, _tmp13_, i * raw_tile_size, j * raw_tile_size);
						}
					}
				}
			}
		}
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
theme_manager_get_themes (ThemeManager* self,
                          gint* result_length1)
{
	gchar** themes = NULL;
	gchar** _tmp0_;
	gint themes_length1;
	gint _themes_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	themes = _tmp0_;
	themes_length1 = 0;
	_themes_size_ = themes_length1;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ThemeManagerTheme _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((gint) i) < G_N_ELEMENTS (THEME_MANAGER_theme))) {
					break;
				}
				_tmp3_ = THEME_MANAGER_theme[i];
				_tmp4_ = _tmp3_.title;
				_tmp5_ = g_strdup (_ (_tmp4_));
				_vala_array_add1 (&themes, &themes_length1, &_themes_size_, _tmp5_);
			}
		}
	}
	_tmp6_ = themes;
	_tmp6__length1 = themes_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gint
theme_manager_get_theme_id (ThemeManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (!self->priv->theme_set) {
		g_assert_not_reached ();
	}
	result = self->priv->_theme_id;
	return result;
}

void
theme_manager_set_theme_id (ThemeManager* self,
                            gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_theme_id = value;
	self->priv->theme_set = TRUE;
	theme_manager_load_pixmaps (self);
	g_signal_emit (self, theme_manager_signals[THEME_MANAGER_THEME_CHANGED_SIGNAL], 0);
}

static guint8
theme_manager_get_board_size (ThemeManager* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_board_size;
	return result;
}

static void
theme_manager_set_board_size (ThemeManager* self,
                              guint8 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_board_size = value;
}

GdkPixbuf*
theme_manager_get_pb_tileset_raw (ThemeManager* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->pixmaps_loaded) {
		g_assert_not_reached ();
	}
	_tmp0_ = self->priv->_pb_tileset_raw;
	result = _tmp0_;
	return result;
}

GdkPixbuf*
theme_manager_get_pb_bground_raw (ThemeManager* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->pixmaps_loaded) {
		g_assert_not_reached ();
	}
	_tmp0_ = self->priv->_pb_bground_raw;
	result = _tmp0_;
	return result;
}

static void
theme_manager_theme_copy (const ThemeManagerTheme* self,
                          ThemeManagerTheme* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	_tmp0_ = (*self).title;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).title);
	(*dest).title = _tmp1_;
	_tmp2_ = (*self).fname_tileset;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).fname_tileset);
	(*dest).fname_tileset = _tmp3_;
	_tmp4_ = (*self).fname_bground;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).fname_bground);
	(*dest).fname_bground = _tmp5_;
	_tmp6_ = (*self).grid_color;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).grid_color);
	(*dest).grid_color = _tmp7_;
	_tmp8_ = (*self).player1;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 ((*dest).player1);
	(*dest).player1 = _tmp9_;
	_tmp10_ = (*self).player2;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 ((*dest).player2);
	(*dest).player2 = _tmp11_;
	_tmp12_ = (*self).player1_with_colon;
	_tmp13_ = g_strdup (_tmp12_);
	_g_free0 ((*dest).player1_with_colon);
	(*dest).player1_with_colon = _tmp13_;
	_tmp14_ = (*self).player2_with_colon;
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 ((*dest).player2_with_colon);
	(*dest).player2_with_colon = _tmp15_;
	_tmp16_ = (*self).player1_win;
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 ((*dest).player1_win);
	(*dest).player1_win = _tmp17_;
	_tmp18_ = (*self).player2_win;
	_tmp19_ = g_strdup (_tmp18_);
	_g_free0 ((*dest).player2_win);
	(*dest).player2_win = _tmp19_;
	_tmp20_ = (*self).player1_turn;
	_tmp21_ = g_strdup (_tmp20_);
	_g_free0 ((*dest).player1_turn);
	(*dest).player1_turn = _tmp21_;
	_tmp22_ = (*self).player2_turn;
	_tmp23_ = g_strdup (_tmp22_);
	_g_free0 ((*dest).player2_turn);
	(*dest).player2_turn = _tmp23_;
}

static void
theme_manager_theme_destroy (ThemeManagerTheme* self)
{
	_g_free0 ((*self).title);
	_g_free0 ((*self).fname_tileset);
	_g_free0 ((*self).fname_bground);
	_g_free0 ((*self).grid_color);
	_g_free0 ((*self).player1);
	_g_free0 ((*self).player2);
	_g_free0 ((*self).player1_with_colon);
	_g_free0 ((*self).player2_with_colon);
	_g_free0 ((*self).player1_win);
	_g_free0 ((*self).player2_win);
	_g_free0 ((*self).player1_turn);
	_g_free0 ((*self).player2_turn);
}

static ThemeManagerTheme*
theme_manager_theme_dup (const ThemeManagerTheme* self)
{
	ThemeManagerTheme* dup;
	dup = g_new0 (ThemeManagerTheme, 1);
	theme_manager_theme_copy (self, dup);
	return dup;
}

static void
theme_manager_theme_free (ThemeManagerTheme* self)
{
	theme_manager_theme_destroy (self);
	g_free (self);
}

static GType
theme_manager_theme_get_type_once (void)
{
	GType theme_manager_theme_type_id;
	theme_manager_theme_type_id = g_boxed_type_register_static ("ThemeManagerTheme", (GBoxedCopyFunc) theme_manager_theme_dup, (GBoxedFreeFunc) theme_manager_theme_free);
	return theme_manager_theme_type_id;
}

static GType
theme_manager_theme_get_type (void)
{
	static volatile gsize theme_manager_theme_type_id__once = 0;
	if (g_once_init_enter (&theme_manager_theme_type_id__once)) {
		GType theme_manager_theme_type_id;
		theme_manager_theme_type_id = theme_manager_theme_get_type_once ();
		g_once_init_leave (&theme_manager_theme_type_id__once, theme_manager_theme_type_id);
	}
	return theme_manager_theme_type_id__once;
}

static void
theme_manager_class_init (ThemeManagerClass * klass,
                          gpointer klass_data)
{
	theme_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ThemeManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_theme_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_theme_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = theme_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_THEME_ID_PROPERTY, theme_manager_properties[THEME_MANAGER_THEME_ID_PROPERTY] = g_param_spec_int ("theme-id", "theme-id", "theme-id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_BOARD_SIZE_PROPERTY, theme_manager_properties[THEME_MANAGER_BOARD_SIZE_PROPERTY] = g_param_spec_uchar ("board-size", "board-size", "board-size", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_PB_TILESET_RAW_PROPERTY, theme_manager_properties[THEME_MANAGER_PB_TILESET_RAW_PROPERTY] = g_param_spec_object ("pb-tileset-raw", "pb-tileset-raw", "pb-tileset-raw", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), THEME_MANAGER_PB_BGROUND_RAW_PROPERTY, theme_manager_properties[THEME_MANAGER_PB_BGROUND_RAW_PROPERTY] = g_param_spec_object ("pb-bground-raw", "pb-bground-raw", "pb-bground-raw", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	theme_manager_signals[THEME_MANAGER_THEME_CHANGED_SIGNAL] = g_signal_new ("theme-changed", TYPE_THEME_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
theme_manager_instance_init (ThemeManager * self,
                             gpointer klass)
{
	self->priv = theme_manager_get_instance_private (self);
	self->priv->theme_set = FALSE;
	self->priv->pixmaps_loaded = FALSE;
}

static void
theme_manager_finalize (GObject * obj)
{
	ThemeManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME_MANAGER, ThemeManager);
	_g_object_unref0 (self->priv->_pb_tileset_raw);
	_g_object_unref0 (self->priv->_pb_bground_raw);
	G_OBJECT_CLASS (theme_manager_parent_class)->finalize (obj);
}

static GType
theme_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThemeManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThemeManager), 0, (GInstanceInitFunc) theme_manager_instance_init, NULL };
	GType theme_manager_type_id;
	theme_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ThemeManager", &g_define_type_info, 0);
	ThemeManager_private_offset = g_type_add_instance_private (theme_manager_type_id, sizeof (ThemeManagerPrivate));
	return theme_manager_type_id;
}

GType
theme_manager_get_type (void)
{
	static volatile gsize theme_manager_type_id__once = 0;
	if (g_once_init_enter (&theme_manager_type_id__once)) {
		GType theme_manager_type_id;
		theme_manager_type_id = theme_manager_get_type_once ();
		g_once_init_leave (&theme_manager_type_id__once, theme_manager_type_id);
	}
	return theme_manager_type_id__once;
}

static void
_vala_theme_manager_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	ThemeManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THEME_MANAGER, ThemeManager);
	switch (property_id) {
		case THEME_MANAGER_THEME_ID_PROPERTY:
		g_value_set_int (value, theme_manager_get_theme_id (self));
		break;
		case THEME_MANAGER_BOARD_SIZE_PROPERTY:
		g_value_set_uchar (value, theme_manager_get_board_size (self));
		break;
		case THEME_MANAGER_PB_TILESET_RAW_PROPERTY:
		g_value_set_object (value, theme_manager_get_pb_tileset_raw (self));
		break;
		case THEME_MANAGER_PB_BGROUND_RAW_PROPERTY:
		g_value_set_object (value, theme_manager_get_pb_bground_raw (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_theme_manager_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	ThemeManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THEME_MANAGER, ThemeManager);
	switch (property_id) {
		case THEME_MANAGER_THEME_ID_PROPERTY:
		theme_manager_set_theme_id (self, g_value_get_int (value));
		break;
		case THEME_MANAGER_BOARD_SIZE_PROPERTY:
		theme_manager_set_board_size (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

