/* util.c generated by valac 0.56.18, the Vala compiler
 * generated from util.vala, do not modify */

#include "xmpp-vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
  * Parse a number from a hexadecimal representation.
  *
  * Skips any whitespace at the start of the string, parses as many valid
  * characters as hexadecimal digits as possible (possibly zero) and returns
  * them as an integer value.
  *
  * ```
  * // 0xa
  * print("0x%lx\n", from_hex("A quick brown fox jumps over the lazy dog."));
  * ```
  */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

glong
xmpp_util_from_hex (const gchar* numeral)
{
	glong _result_ = 0L;
	gboolean skipping_whitespace = FALSE;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_ = 0;
	guint8* _tmp2_;
	gint _tmp2__length1;
	glong result;
	g_return_val_if_fail (numeral != NULL, 0L);
	_result_ = (glong) 0;
	skipping_whitespace = TRUE;
	_tmp0_ = string_get_data (numeral, &_tmp1_);
	_tmp0__length1 = _tmp1_;
	_tmp2_ = _tmp0_;
	_tmp2__length1 = _tmp0__length1;
	{
		guint8* byte_collection = NULL;
		gint byte_collection_length1 = 0;
		gint _byte_collection_size_ = 0;
		gint byte_it = 0;
		byte_collection = _tmp2_;
		byte_collection_length1 = _tmp2__length1;
		for (byte_it = 0; byte_it < byte_collection_length1; byte_it = byte_it + 1) {
			guint8 byte = 0U;
			byte = byte_collection[byte_it];
			{
				gchar c = '\0';
				gboolean _tmp3_ = FALSE;
				gint digit = 0;
				gboolean _tmp4_ = FALSE;
				c = (gchar) byte;
				if (skipping_whitespace) {
					_tmp3_ = g_ascii_isspace (c);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					continue;
				}
				skipping_whitespace = FALSE;
				if ('0' <= c) {
					_tmp4_ = c <= '9';
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					digit = (gint) (c - '0');
				} else {
					gboolean _tmp5_ = FALSE;
					if ('A' <= c) {
						_tmp5_ = c <= 'F';
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						digit = (c - 'A') + 10;
					} else {
						gboolean _tmp6_ = FALSE;
						if ('a' <= c) {
							_tmp6_ = c <= 'f';
						} else {
							_tmp6_ = FALSE;
						}
						if (_tmp6_) {
							digit = (c - 'a') + 10;
						} else {
							break;
						}
					}
				}
				_result_ = (_result_ << 4) | digit;
			}
		}
	}
	result = _result_;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

