/* video_widget.c generated by valac 0.56.18, the Vala compiler
 * generated from video_widget.vala, do not modify */

#include <gst/video/video.h>
#include <glib.h>
#include "rtp.h"
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include "libdino.h"
#include <gst/gst.h>
#include <gst/base/base.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "xmpp-vala.h"

#define DINO_PLUGINS_RTP_VIDEO_WIDGET_RECAPS_AFTER_CHANGE 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DINO_PLUGINS_RTP_PAINTABLE_0_PROPERTY,
	DINO_PLUGINS_RTP_PAINTABLE_NUM_PROPERTIES
};
static GParamSpec* dino_plugins_rtp_paintable_properties[DINO_PLUGINS_RTP_PAINTABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
enum  {
	DINO_PLUGINS_RTP_SINK_0_PROPERTY,
	DINO_PLUGINS_RTP_SINK_NUM_PROPERTIES
};
static GParamSpec* dino_plugins_rtp_sink_properties[DINO_PLUGINS_RTP_SINK_NUM_PROPERTIES];
#define __vala_GstVideoInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstVideoInfo_free (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
enum  {
	DINO_PLUGINS_RTP_VIDEO_WIDGET_0_PROPERTY,
	DINO_PLUGINS_RTP_VIDEO_WIDGET_ID_PROPERTY,
	DINO_PLUGINS_RTP_VIDEO_WIDGET_PLUGIN_PROPERTY,
	DINO_PLUGINS_RTP_VIDEO_WIDGET_PIPE_PROPERTY,
	DINO_PLUGINS_RTP_VIDEO_WIDGET_NUM_PROPERTIES
};
static GParamSpec* dino_plugins_rtp_video_widget_properties[DINO_PLUGINS_RTP_VIDEO_WIDGET_NUM_PROPERTIES];
typedef struct _Block12Data Block12Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DinoPluginsRtpPaintablePrivate {
	GdkPaintable* image;
	gdouble pixel_aspect_ratio;
};

struct _Block11Data {
	int _ref_count_;
	DinoPluginsRtpPaintable* self;
	GdkTexture* texture;
	gdouble pixel_aspect_ratio;
};

struct _DinoPluginsRtpSinkPrivate {
	GstVideoInfo* info;
};

struct _DinoPluginsRtpVideoWidgetPrivate {
	guint _id;
	DinoPluginsRtpPlugin* _plugin;
	gboolean attached;
	DinoPluginsRtpDevice* connected_device;
	GstElement* connected_device_element;
	DinoPluginsRtpStream* connected_stream;
	GstElement* prepare;
	GstCaps* last_input_caps;
	GstCaps* last_caps;
	gint recaps_since_change;
	DinoPluginsRtpSink* sink;
	GtkPicture* widget;
};

struct _Block12Data {
	int _ref_count_;
	DinoPluginsRtpVideoWidget* self;
	gint width;
	gint height;
};

static gint DinoPluginsRtpPaintable_private_offset;
static gpointer dino_plugins_rtp_paintable_parent_class = NULL;
static GdkPaintableInterface * dino_plugins_rtp_paintable_gdk_paintable_parent_iface = NULL;
static gint DinoPluginsRtpSink_private_offset;
static gpointer dino_plugins_rtp_sink_parent_class = NULL;
static gint DinoPluginsRtpVideoWidget_private_offset;
static gpointer dino_plugins_rtp_video_widget_parent_class = NULL;
static guint dino_plugins_rtp_video_widget_last_id;
static guint dino_plugins_rtp_video_widget_last_id = (guint) 0;
static guint dino_plugins_rtp_video_widget_active_widgets;
static guint dino_plugins_rtp_video_widget_active_widgets = (guint) 0;
static DinoPluginsVideoCallWidgetIface * dino_plugins_rtp_video_widget_dino_plugins_video_call_widget_parent_iface = NULL;

GstVideoInfo* gst_video_frame_get_video_info (GstVideoFrame* frame);
void* gst_video_frame_get_data (GstVideoFrame* frame,
                                size_t* result_length1);
static GdkPaintableFlags dino_plugins_rtp_paintable_real_get_flags (GdkPaintable* base);
static void dino_plugins_rtp_paintable_real_snapshot (GdkPaintable* base,
                                               GdkSnapshot* snapshot,
                                               gdouble width,
                                               gdouble height);
static GdkPaintable* dino_plugins_rtp_paintable_real_get_current_image (GdkPaintable* base);
static gint dino_plugins_rtp_paintable_real_get_intrinsic_width (GdkPaintable* base);
static gint dino_plugins_rtp_paintable_real_get_intrinsic_height (GdkPaintable* base);
static gdouble dino_plugins_rtp_paintable_real_get_intrinsic_aspect_ratio (GdkPaintable* base);
static void dino_plugins_rtp_paintable_real_dispose (GObject* base);
static void dino_plugins_rtp_paintable_set_paintable (DinoPluginsRtpPaintable* self,
                                               GdkPaintable* paintable,
                                               gdouble pixel_aspect_ratio);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gboolean __lambda25_ (Block11Data* _data11_);
static gboolean ___lambda25__gsource_func (gpointer self);
static void dino_plugins_rtp_paintable_finalize (GObject * obj);
static GType dino_plugins_rtp_paintable_get_type_once (void);
static void _vala_GstVideoInfo_free (GstVideoInfo* self);
static gboolean dino_plugins_rtp_sink_real_set_info (GstVideoSink* base,
                                              GstCaps* caps,
                                              GstVideoInfo* info);
static GstVideoInfo* _vala_GstVideoInfo_copy (GstVideoInfo* self);
static void dino_plugins_rtp_sink_real_get_times (GstBaseSink* base,
                                           GstBuffer* buffer,
                                           GstClockTime* start,
                                           GstClockTime* end);
static GstCaps* dino_plugins_rtp_sink_real_get_caps (GstBaseSink* base,
                                              GstCaps* filter);
static GdkMemoryFormat dino_plugins_rtp_sink_memory_format_from_video (DinoPluginsRtpSink* self,
                                                                GstVideoFormat format);
static GdkTexture* dino_plugins_rtp_sink_texture_from_buffer (DinoPluginsRtpSink* self,
                                                       GstBuffer* buffer,
                                                       gdouble* pixel_aspect_ratio);
static guint8* _vala_array_dup4 (guint8* self,
                          gssize length);
static void dino_plugins_rtp_sink_queue_buffer (DinoPluginsRtpSink* self,
                                         GstBuffer* buf);
static GstFlowReturn dino_plugins_rtp_sink_real_show_frame (GstVideoSink* base,
                                                     GstBuffer* buf);
static GObject * dino_plugins_rtp_sink_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void dino_plugins_rtp_sink_finalize (GObject * obj);
static GType dino_plugins_rtp_sink_get_type_once (void);
static void dino_plugins_rtp_video_widget_notify_weak (GObject* widget_object);
static void dino_plugins_rtp_video_widget_set_plugin (DinoPluginsRtpVideoWidget* self,
                                               DinoPluginsRtpPlugin* value);
static void dino_plugins_rtp_video_widget_set_id (DinoPluginsRtpVideoWidget* self,
                                           guint value);
static void _dino_plugins_rtp_video_widget_notify_weak_gweak_notify (gpointer self,
                                                              GObject* object);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gboolean __lambda26_ (Block12Data* _data12_);
static gboolean ___lambda26__gsource_func (gpointer self);
static void dino_plugins_rtp_video_widget_real_display_stream (DinoPluginsVideoCallWidget* base,
                                                        XmppXepJingleRtpStream* stream,
                                                        XmppJid* jid);
static void _dino_plugins_rtp_video_widget_input_caps_changed_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
static void dino_plugins_rtp_video_widget_real_display_device (DinoPluginsVideoCallWidget* base,
                                                        DinoPluginsMediaDevice* media_device);
static void dino_plugins_rtp_video_widget_real_detach (DinoPluginsVideoCallWidget* base);
static void dino_plugins_rtp_video_widget_real_dispose (GObject* base);
static void dino_plugins_rtp_video_widget_finalize (GObject * obj);
static GType dino_plugins_rtp_video_widget_get_type_once (void);
static void _vala_dino_plugins_rtp_video_widget_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_dino_plugins_rtp_video_widget_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
dino_plugins_rtp_paintable_get_instance_private (DinoPluginsRtpPaintable* self)
{
	return G_STRUCT_MEMBER_P (self, DinoPluginsRtpPaintable_private_offset);
}

static GdkPaintableFlags
dino_plugins_rtp_paintable_real_get_flags (GdkPaintable* base)
{
	DinoPluginsRtpPaintable * self;
	GdkPaintableFlags result;
	self = (DinoPluginsRtpPaintable*) base;
	result = 0;
	return result;
}

static void
dino_plugins_rtp_paintable_real_snapshot (GdkPaintable* base,
                                          GdkSnapshot* snapshot,
                                          gdouble width,
                                          gdouble height)
{
	DinoPluginsRtpPaintable * self;
	GdkPaintable* _tmp0_;
	self = (DinoPluginsRtpPaintable*) base;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = self->priv->image;
	if (_tmp0_ != NULL) {
		GdkPaintable* _tmp1_;
		_tmp1_ = self->priv->image;
		gdk_paintable_snapshot (_tmp1_, snapshot, width, height);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GdkPaintable*
dino_plugins_rtp_paintable_real_get_current_image (GdkPaintable* base)
{
	DinoPluginsRtpPaintable * self;
	GdkPaintable* _tmp0_;
	GdkPaintable* _tmp3_;
	GdkPaintable* result;
	self = (DinoPluginsRtpPaintable*) base;
	_tmp0_ = self->priv->image;
	if (_tmp0_ != NULL) {
		GdkPaintable* _tmp1_;
		GdkPaintable* _tmp2_;
		_tmp1_ = self->priv->image;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = gdk_paintable_new_empty (0, 0);
	result = _tmp3_;
	return result;
}

static gint
dino_plugins_rtp_paintable_real_get_intrinsic_width (GdkPaintable* base)
{
	DinoPluginsRtpPaintable * self;
	GdkPaintable* _tmp0_;
	gint result;
	self = (DinoPluginsRtpPaintable*) base;
	_tmp0_ = self->priv->image;
	if (_tmp0_ != NULL) {
		GdkPaintable* _tmp1_;
		_tmp1_ = self->priv->image;
		result = (gint) (self->priv->pixel_aspect_ratio * gdk_paintable_get_intrinsic_width (_tmp1_));
		return result;
	}
	result = 0;
	return result;
}

static gint
dino_plugins_rtp_paintable_real_get_intrinsic_height (GdkPaintable* base)
{
	DinoPluginsRtpPaintable * self;
	GdkPaintable* _tmp0_;
	gint result;
	self = (DinoPluginsRtpPaintable*) base;
	_tmp0_ = self->priv->image;
	if (_tmp0_ != NULL) {
		GdkPaintable* _tmp1_;
		_tmp1_ = self->priv->image;
		result = (gint) (self->priv->pixel_aspect_ratio * gdk_paintable_get_intrinsic_height (_tmp1_));
		return result;
	}
	result = 0;
	return result;
}

static gdouble
dino_plugins_rtp_paintable_real_get_intrinsic_aspect_ratio (GdkPaintable* base)
{
	DinoPluginsRtpPaintable * self;
	GdkPaintable* _tmp0_;
	gdouble result;
	self = (DinoPluginsRtpPaintable*) base;
	_tmp0_ = self->priv->image;
	if (_tmp0_ != NULL) {
		GdkPaintable* _tmp1_;
		_tmp1_ = self->priv->image;
		result = self->priv->pixel_aspect_ratio * gdk_paintable_get_intrinsic_aspect_ratio (_tmp1_);
		return result;
	}
	result = 0.0;
	return result;
}

static void
dino_plugins_rtp_paintable_real_dispose (GObject* base)
{
	DinoPluginsRtpPaintable * self;
	self = (DinoPluginsRtpPaintable*) base;
	_g_object_unref0 (self->priv->image);
	self->priv->image = NULL;
	G_OBJECT_CLASS (dino_plugins_rtp_paintable_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
}

static void
dino_plugins_rtp_paintable_set_paintable (DinoPluginsRtpPaintable* self,
                                          GdkPaintable* paintable,
                                          gdouble pixel_aspect_ratio)
{
	GdkPaintable* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GdkPaintable* _tmp4_;
	gboolean size_changed = FALSE;
	GdkPaintable* _tmp8_;
	GdkPaintable* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (paintable != NULL);
	_tmp0_ = self->priv->image;
	if (paintable == _tmp0_) {
		return;
	}
	_tmp4_ = self->priv->image;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GdkPaintable* _tmp5_;
		_tmp5_ = self->priv->image;
		_tmp3_ = (self->priv->pixel_aspect_ratio * gdk_paintable_get_intrinsic_width (_tmp5_)) != (pixel_aspect_ratio * gdk_paintable_get_intrinsic_width (paintable));
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		GdkPaintable* _tmp6_;
		_tmp6_ = self->priv->image;
		_tmp2_ = gdk_paintable_get_intrinsic_height (_tmp6_) != gdk_paintable_get_intrinsic_height (paintable);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GdkPaintable* _tmp7_;
		_tmp7_ = self->priv->image;
		_tmp1_ = gdk_paintable_get_intrinsic_aspect_ratio (_tmp7_) != gdk_paintable_get_intrinsic_aspect_ratio (paintable);
	}
	size_changed = _tmp1_;
	_tmp8_ = self->priv->image;
	if (_tmp8_ != NULL) {
		GdkPaintable* _tmp9_;
		_tmp9_ = self->priv->image;
		g_object_run_dispose ((GObject*) _tmp9_);
	}
	_tmp10_ = _g_object_ref0 (paintable);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp10_;
	self->priv->pixel_aspect_ratio = pixel_aspect_ratio;
	if (size_changed) {
		gdk_paintable_invalidate_size ((GdkPaintable*) self);
	}
	gdk_paintable_invalidate_contents ((GdkPaintable*) self);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		DinoPluginsRtpPaintable* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->texture);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static gboolean
__lambda25_ (Block11Data* _data11_)
{
	DinoPluginsRtpPaintable* self;
	gboolean result;
	self = _data11_->self;
	dino_plugins_rtp_paintable_set_paintable (self, (GdkPaintable*) _data11_->texture, _data11_->pixel_aspect_ratio);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda25__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda25_ (self);
	return result;
}

void
dino_plugins_rtp_paintable_queue_set_texture (DinoPluginsRtpPaintable* self,
                                              GdkTexture* texture,
                                              gdouble pixel_aspect_ratio)
{
	Block11Data* _data11_;
	GdkTexture* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (texture != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (texture);
	_g_object_unref0 (_data11_->texture);
	_data11_->texture = _tmp0_;
	_data11_->pixel_aspect_ratio = pixel_aspect_ratio;
	g_idle_add_full ((gint) DINO_PLUGINS_PRIORITY_DEFAULT, ___lambda25__gsource_func, block11_data_ref (_data11_), block11_data_unref);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

DinoPluginsRtpPaintable*
dino_plugins_rtp_paintable_construct (GType object_type)
{
	DinoPluginsRtpPaintable * self = NULL;
	self = (DinoPluginsRtpPaintable*) g_object_new (object_type, NULL);
	return self;
}

DinoPluginsRtpPaintable*
dino_plugins_rtp_paintable_new (void)
{
	return dino_plugins_rtp_paintable_construct (DINO_PLUGINS_RTP_TYPE_PAINTABLE);
}

static void
dino_plugins_rtp_paintable_class_init (DinoPluginsRtpPaintableClass * klass,
                                       gpointer klass_data)
{
	dino_plugins_rtp_paintable_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DinoPluginsRtpPaintable_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) dino_plugins_rtp_paintable_real_dispose;
	G_OBJECT_CLASS (klass)->finalize = dino_plugins_rtp_paintable_finalize;
}

static void
dino_plugins_rtp_paintable_gdk_paintable_interface_init (GdkPaintableInterface * iface,
                                                         gpointer iface_data)
{
	dino_plugins_rtp_paintable_gdk_paintable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_flags = (GdkPaintableFlags (*) (GdkPaintable*)) dino_plugins_rtp_paintable_real_get_flags;
	iface->snapshot = (void (*) (GdkPaintable*, GdkSnapshot*, gdouble, gdouble)) dino_plugins_rtp_paintable_real_snapshot;
	iface->get_current_image = (GdkPaintable* (*) (GdkPaintable*)) dino_plugins_rtp_paintable_real_get_current_image;
	iface->get_intrinsic_width = (gint (*) (GdkPaintable*)) dino_plugins_rtp_paintable_real_get_intrinsic_width;
	iface->get_intrinsic_height = (gint (*) (GdkPaintable*)) dino_plugins_rtp_paintable_real_get_intrinsic_height;
	iface->get_intrinsic_aspect_ratio = (gdouble (*) (GdkPaintable*)) dino_plugins_rtp_paintable_real_get_intrinsic_aspect_ratio;
}

static void
dino_plugins_rtp_paintable_instance_init (DinoPluginsRtpPaintable * self,
                                          gpointer klass)
{
	self->priv = dino_plugins_rtp_paintable_get_instance_private (self);
}

static void
dino_plugins_rtp_paintable_finalize (GObject * obj)
{
	DinoPluginsRtpPaintable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_PLUGINS_RTP_TYPE_PAINTABLE, DinoPluginsRtpPaintable);
	_g_object_unref0 (self->priv->image);
	G_OBJECT_CLASS (dino_plugins_rtp_paintable_parent_class)->finalize (obj);
}

static GType
dino_plugins_rtp_paintable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DinoPluginsRtpPaintableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_plugins_rtp_paintable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DinoPluginsRtpPaintable), 0, (GInstanceInitFunc) dino_plugins_rtp_paintable_instance_init, NULL };
	static const GInterfaceInfo gdk_paintable_info = { (GInterfaceInitFunc) dino_plugins_rtp_paintable_gdk_paintable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType dino_plugins_rtp_paintable_type_id;
	dino_plugins_rtp_paintable_type_id = g_type_register_static (G_TYPE_OBJECT, "DinoPluginsRtpPaintable", &g_define_type_info, 0);
	g_type_add_interface_static (dino_plugins_rtp_paintable_type_id, gdk_paintable_get_type (), &gdk_paintable_info);
	DinoPluginsRtpPaintable_private_offset = g_type_add_instance_private (dino_plugins_rtp_paintable_type_id, sizeof (DinoPluginsRtpPaintablePrivate));
	return dino_plugins_rtp_paintable_type_id;
}

GType
dino_plugins_rtp_paintable_get_type (void)
{
	static volatile gsize dino_plugins_rtp_paintable_type_id__once = 0;
	if (g_once_init_enter (&dino_plugins_rtp_paintable_type_id__once)) {
		GType dino_plugins_rtp_paintable_type_id;
		dino_plugins_rtp_paintable_type_id = dino_plugins_rtp_paintable_get_type_once ();
		g_once_init_leave (&dino_plugins_rtp_paintable_type_id__once, dino_plugins_rtp_paintable_type_id);
	}
	return dino_plugins_rtp_paintable_type_id__once;
}

static inline gpointer
dino_plugins_rtp_sink_get_instance_private (DinoPluginsRtpSink* self)
{
	return G_STRUCT_MEMBER_P (self, DinoPluginsRtpSink_private_offset);
}

static void
_vala_GstVideoInfo_free (GstVideoInfo* self)
{
	g_boxed_free (gst_video_info_get_type (), self);
}

static GstVideoInfo*
_vala_GstVideoInfo_copy (GstVideoInfo* self)
{
	return g_boxed_copy (gst_video_info_get_type (), self);
}

static gpointer
__vala_GstVideoInfo_copy0 (gpointer self)
{
	return self ? _vala_GstVideoInfo_copy (self) : NULL;
}

static gboolean
dino_plugins_rtp_sink_real_set_info (GstVideoSink* base,
                                     GstCaps* caps,
                                     GstVideoInfo* info)
{
	DinoPluginsRtpSink * self;
	GstVideoInfo* _tmp0_;
	gboolean result;
	self = (DinoPluginsRtpSink*) base;
	g_return_val_if_fail (caps != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp0_ = __vala_GstVideoInfo_copy0 (info);
	__vala_GstVideoInfo_free0 (self->priv->info);
	self->priv->info = _tmp0_;
	result = TRUE;
	return result;
}

static void
dino_plugins_rtp_sink_real_get_times (GstBaseSink* base,
                                      GstBuffer* buffer,
                                      GstClockTime* start,
                                      GstClockTime* end)
{
	DinoPluginsRtpSink * self;
	GstClockTime _vala_start = 0ULL;
	GstClockTime _vala_end = 0ULL;
	self = (DinoPluginsRtpSink*) base;
	g_return_if_fail (buffer != NULL);
	if (buffer->pts != ((GstClockTime) -1)) {
		_vala_start = buffer->pts;
		if (buffer->duration != ((GstClockTime) -1)) {
			_vala_end = _vala_start + buffer->duration;
		} else {
			GstVideoInfo* _tmp0_;
			_tmp0_ = self->priv->info;
			if (_tmp0_->fps_n > 0) {
				GstVideoInfo* _tmp1_;
				GstVideoInfo* _tmp2_;
				_tmp1_ = self->priv->info;
				_tmp2_ = self->priv->info;
				_vala_end = _vala_start + gst_util_uint64_scale_int ((guint64) GST_SECOND, _tmp1_->fps_d, _tmp2_->fps_n);
			}
		}
	}
	if (start) {
		*start = _vala_start;
	}
	if (end) {
		*end = _vala_end;
	}
}

static GstCaps*
dino_plugins_rtp_sink_real_get_caps (GstBaseSink* base,
                                     GstCaps* filter)
{
	DinoPluginsRtpSink * self;
	GstCaps* caps = NULL;
	GstCaps* _tmp0_;
	GstCaps* result;
	self = (DinoPluginsRtpSink*) base;
	_tmp0_ = gst_caps_from_string ("video/x-raw, format={ BGRA, ARGB, RGBA, ABGR, RGB, BGR }");
	caps = _tmp0_;
	if (filter != NULL) {
		GstCaps* _tmp1_;
		GstCaps* _tmp2_;
		_tmp1_ = caps;
		_tmp2_ = gst_caps_intersect_full (filter, _tmp1_, GST_CAPS_INTERSECT_FIRST);
		result = _tmp2_;
		_gst_caps_unref0 (caps);
		return result;
	} else {
		result = caps;
		return result;
	}
}

static GdkMemoryFormat
dino_plugins_rtp_sink_memory_format_from_video (DinoPluginsRtpSink* self,
                                                GstVideoFormat format)
{
	GdkMemoryFormat result;
	g_return_val_if_fail (self != NULL, 0);
	switch (format) {
		case GST_VIDEO_FORMAT_BGRA:
		{
			result = GDK_MEMORY_B8G8R8A8;
			return result;
		}
		case GST_VIDEO_FORMAT_ARGB:
		{
			result = GDK_MEMORY_A8R8G8B8;
			return result;
		}
		case GST_VIDEO_FORMAT_RGBA:
		{
			result = GDK_MEMORY_R8G8B8A8;
			return result;
		}
		case GST_VIDEO_FORMAT_ABGR:
		{
			result = GDK_MEMORY_A8B8G8R8;
			return result;
		}
		case GST_VIDEO_FORMAT_RGB:
		{
			result = GDK_MEMORY_R8G8B8;
			return result;
		}
		case GST_VIDEO_FORMAT_BGR:
		{
			result = GDK_MEMORY_B8G8R8;
			return result;
		}
		default:
		{
			const gchar* _tmp0_;
			_tmp0_ = gst_video_format_to_string (format);
			g_warning ("video_widget.vala:120: Unsupported video format: %s", _tmp0_);
			result = GDK_MEMORY_A8R8G8B8;
			return result;
		}
	}
}

static guint8*
_vala_array_dup4 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static GdkTexture*
dino_plugins_rtp_sink_texture_from_buffer (DinoPluginsRtpSink* self,
                                           GstBuffer* buffer,
                                           gdouble* pixel_aspect_ratio)
{
	gdouble _vala_pixel_aspect_ratio = 0.0;
	GstVideoFrame frame = {0};
	GdkTexture* texture = NULL;
	GstVideoInfo* _tmp0_;
	GdkTexture* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (buffer != NULL, NULL);
	memset (&frame, 0, sizeof (GstVideoFrame));
	_tmp0_ = self->priv->info;
	if (gst_video_frame_map (&frame, _tmp0_, buffer, GST_MAP_READ)) {
		GstVideoInfo* info = NULL;
		GstVideoFrame _tmp1_;
		GstVideoInfo* _tmp2_;
		GBytes* bytes = NULL;
		GstVideoFrame _tmp3_;
		size_t _tmp4_ = 0;
		guint8* _tmp5_;
		guint8* _tmp6_;
		gint _tmp6__length1;
		GBytes* _tmp7_;
		GstVideoInfo* _tmp8_;
		GstVideoInfo* _tmp9_;
		GstVideoInfo* _tmp10_;
		GstVideoFormatInfo* _tmp11_;
		GBytes* _tmp12_;
		GstVideoInfo* _tmp13_;
		gint _tmp14_;
		GdkMemoryTexture* _tmp15_;
		GstVideoInfo* _tmp16_;
		GstVideoInfo* _tmp17_;
		_tmp1_ = frame;
		_tmp2_ = gst_video_frame_get_video_info (&_tmp1_);
		info = _tmp2_;
		_tmp3_ = frame;
		_tmp5_ = (guint8*) gst_video_frame_get_data (&_tmp3_, &_tmp4_);
		_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup4 (_tmp5_, _tmp4_) : _tmp5_;
		_tmp6__length1 = _tmp4_;
		_tmp7_ = g_bytes_new_take (_tmp6_, _tmp6__length1);
		bytes = _tmp7_;
		_tmp8_ = info;
		_tmp9_ = info;
		_tmp10_ = info;
		_tmp11_ = _tmp10_->finfo;
		_tmp12_ = bytes;
		_tmp13_ = info;
		_tmp14_ = _tmp13_->stride[0];
		_tmp15_ = (GdkMemoryTexture*) gdk_memory_texture_new (_tmp8_->width, _tmp9_->height, dino_plugins_rtp_sink_memory_format_from_video (self, (*_tmp11_).format), _tmp12_, (gsize) _tmp14_);
		_g_object_unref0 (texture);
		texture = (GdkTexture*) _tmp15_;
		_tmp16_ = info;
		_tmp17_ = info;
		_vala_pixel_aspect_ratio = ((gdouble) _tmp16_->par_n) / ((gdouble) _tmp17_->par_d);
		gst_video_frame_unmap (&frame);
		_g_bytes_unref0 (bytes);
	} else {
		_g_object_unref0 (texture);
		texture = NULL;
	}
	result = texture;
	if (pixel_aspect_ratio) {
		*pixel_aspect_ratio = _vala_pixel_aspect_ratio;
	}
	return result;
}

static void
dino_plugins_rtp_sink_queue_buffer (DinoPluginsRtpSink* self,
                                    GstBuffer* buf)
{
	gdouble pixel_aspect_ratio = 0.0;
	GdkTexture* texture = NULL;
	gdouble _tmp0_ = 0.0;
	GdkTexture* _tmp1_;
	GdkTexture* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buf != NULL);
	_tmp1_ = dino_plugins_rtp_sink_texture_from_buffer (self, buf, &_tmp0_);
	pixel_aspect_ratio = _tmp0_;
	texture = _tmp1_;
	_tmp2_ = texture;
	if (_tmp2_ != NULL) {
		DinoPluginsRtpPaintable* _tmp3_;
		GdkTexture* _tmp4_;
		_tmp3_ = self->paintable;
		_tmp4_ = texture;
		dino_plugins_rtp_paintable_queue_set_texture (_tmp3_, _tmp4_, pixel_aspect_ratio);
	}
	_g_object_unref0 (texture);
}

static GstFlowReturn
dino_plugins_rtp_sink_real_show_frame (GstVideoSink* base,
                                       GstBuffer* buf)
{
	DinoPluginsRtpSink * self;
	GstFlowReturn result;
	self = (DinoPluginsRtpSink*) base;
	g_return_val_if_fail (buf != NULL, 0);
	g_mutex_lock (&((GstObject*) self)->lock);
	dino_plugins_rtp_sink_queue_buffer (self, buf);
	g_mutex_unlock (&((GstObject*) self)->lock);
	result = GST_FLOW_OK;
	return result;
}

DinoPluginsRtpSink*
dino_plugins_rtp_sink_construct (GType object_type)
{
	DinoPluginsRtpSink * self = NULL;
	self = (DinoPluginsRtpSink*) g_object_new (object_type, NULL);
	return self;
}

DinoPluginsRtpSink*
dino_plugins_rtp_sink_new (void)
{
	return dino_plugins_rtp_sink_construct (DINO_PLUGINS_RTP_TYPE_SINK);
}

static GObject *
dino_plugins_rtp_sink_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DinoPluginsRtpSink * self;
	parent_class = G_OBJECT_CLASS (dino_plugins_rtp_sink_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_PLUGINS_RTP_TYPE_SINK, DinoPluginsRtpSink);
	gst_base_sink_set_drop_out_of_segment ((GstBaseSink*) self, FALSE);
	return obj;
}

static void
dino_plugins_rtp_sink_base_init (DinoPluginsRtpSinkClass * klass)
{
	GstCaps* _tmp0_;
	GstCaps* _tmp1_;
	GstPadTemplate* _tmp2_;
	GstPadTemplate* _tmp3_;
	gst_element_class_set_metadata (GST_ELEMENT_CLASS (klass), "Dino Gtk Video Sink", "Sink/Video", "The video sink used by Dino", "Dino Team <team@dino.im>");
	_tmp0_ = gst_caps_from_string ("video/x-raw, format={ BGRA, ARGB, RGBA, ABGR, RGB, BGR }");
	_tmp1_ = _tmp0_;
	_tmp2_ = gst_pad_template_new ("sink", GST_PAD_SINK, GST_PAD_ALWAYS, _tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	gst_element_class_add_pad_template (GST_ELEMENT_CLASS (klass), _tmp3_);
	_g_object_unref0 (_tmp3_);
	_gst_caps_unref0 (_tmp1_);
}

static void
dino_plugins_rtp_sink_class_init (DinoPluginsRtpSinkClass * klass,
                                  gpointer klass_data)
{
	dino_plugins_rtp_sink_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DinoPluginsRtpSink_private_offset);
	((GstVideoSinkClass *) klass)->set_info = (gboolean (*) (GstVideoSink*, GstCaps*, GstVideoInfo*)) dino_plugins_rtp_sink_real_set_info;
	((GstBaseSinkClass *) klass)->get_times = (void (*) (GstBaseSink*, GstBuffer*, GstClockTime*, GstClockTime*)) dino_plugins_rtp_sink_real_get_times;
	((GstBaseSinkClass *) klass)->get_caps = (GstCaps* (*) (GstBaseSink*, GstCaps*)) dino_plugins_rtp_sink_real_get_caps;
	((GstVideoSinkClass *) klass)->show_frame = (GstFlowReturn (*) (GstVideoSink*, GstBuffer*)) dino_plugins_rtp_sink_real_show_frame;
	G_OBJECT_CLASS (klass)->constructor = dino_plugins_rtp_sink_constructor;
	G_OBJECT_CLASS (klass)->finalize = dino_plugins_rtp_sink_finalize;
}

static void
dino_plugins_rtp_sink_instance_init (DinoPluginsRtpSink * self,
                                     gpointer klass)
{
	DinoPluginsRtpPaintable* _tmp0_;
	GstVideoInfo* _tmp1_;
	self->priv = dino_plugins_rtp_sink_get_instance_private (self);
	_tmp0_ = dino_plugins_rtp_paintable_new ();
	self->paintable = _tmp0_;
	_tmp1_ = gst_video_info_new ();
	self->priv->info = _tmp1_;
}

static void
dino_plugins_rtp_sink_finalize (GObject * obj)
{
	DinoPluginsRtpSink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_PLUGINS_RTP_TYPE_SINK, DinoPluginsRtpSink);
	_g_object_unref0 (self->paintable);
	__vala_GstVideoInfo_free0 (self->priv->info);
	G_OBJECT_CLASS (dino_plugins_rtp_sink_parent_class)->finalize (obj);
}

static GType
dino_plugins_rtp_sink_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DinoPluginsRtpSinkClass), (GBaseInitFunc) dino_plugins_rtp_sink_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_plugins_rtp_sink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DinoPluginsRtpSink), 0, (GInstanceInitFunc) dino_plugins_rtp_sink_instance_init, NULL };
	GType dino_plugins_rtp_sink_type_id;
	dino_plugins_rtp_sink_type_id = g_type_register_static (gst_video_sink_get_type (), "DinoPluginsRtpSink", &g_define_type_info, 0);
	DinoPluginsRtpSink_private_offset = g_type_add_instance_private (dino_plugins_rtp_sink_type_id, sizeof (DinoPluginsRtpSinkPrivate));
	return dino_plugins_rtp_sink_type_id;
}

GType
dino_plugins_rtp_sink_get_type (void)
{
	static volatile gsize dino_plugins_rtp_sink_type_id__once = 0;
	if (g_once_init_enter (&dino_plugins_rtp_sink_type_id__once)) {
		GType dino_plugins_rtp_sink_type_id;
		dino_plugins_rtp_sink_type_id = dino_plugins_rtp_sink_get_type_once ();
		g_once_init_leave (&dino_plugins_rtp_sink_type_id__once, dino_plugins_rtp_sink_type_id);
	}
	return dino_plugins_rtp_sink_type_id__once;
}

static inline gpointer
dino_plugins_rtp_video_widget_get_instance_private (DinoPluginsRtpVideoWidget* self)
{
	return G_STRUCT_MEMBER_P (self, DinoPluginsRtpVideoWidget_private_offset);
}

gboolean
dino_plugins_rtp_video_widget_has_instances (void)
{
	gboolean result;
	result = dino_plugins_rtp_video_widget_active_widgets > ((guint) 0);
	return result;
}

static void
dino_plugins_rtp_video_widget_notify_weak (GObject* widget_object)
{
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (widget_object != NULL);
	if (dino_plugins_rtp_video_widget_active_widgets > ((guint) 0)) {
		guint _tmp0_;
		g_debug ("video_widget.vala:187: Video widget %p destroyed. left=%u", widget_object, dino_plugins_rtp_video_widget_active_widgets);
		_tmp0_ = dino_plugins_rtp_video_widget_active_widgets;
		dino_plugins_rtp_video_widget_active_widgets = _tmp0_ - 1;
	}
	if (dino_plugins_rtp_video_widget_active_widgets == ((guint) 0)) {
		_tmp1_ = DINO_PLUGINS_RTP_IS_VIDEO_WIDGET (widget_object);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		DinoPluginsRtpPlugin* _tmp2_;
		_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (widget_object, DINO_PLUGINS_RTP_TYPE_VIDEO_WIDGET, DinoPluginsRtpVideoWidget)->priv->_plugin;
		dino_plugins_rtp_plugin_destroy_call_pipe_if_unused (_tmp2_);
	}
}

static void
_dino_plugins_rtp_video_widget_notify_weak_gweak_notify (gpointer self,
                                                         GObject* object)
{
	dino_plugins_rtp_video_widget_notify_weak (object);
}

DinoPluginsRtpVideoWidget*
dino_plugins_rtp_video_widget_construct (GType object_type,
                                         DinoPluginsRtpPlugin* plugin)
{
	DinoPluginsRtpVideoWidget * self = NULL;
	GtkBinLayout* _tmp0_;
	guint _tmp1_;
	DinoPluginsRtpSink* _tmp2_ = NULL;
	DinoPluginsRtpSink* _tmp3_;
	DinoPluginsRtpPaintable* _tmp4_;
	GtkPicture* _tmp5_;
	GtkPicture* _tmp6_;
	guint _tmp7_;
	g_return_val_if_fail (plugin != NULL, NULL);
	self = (DinoPluginsRtpVideoWidget*) g_object_new (object_type, NULL);
	dino_plugins_rtp_video_widget_set_plugin (self, plugin);
	_tmp0_ = (GtkBinLayout*) gtk_bin_layout_new ();
	gtk_widget_set_layout_manager ((GtkWidget*) self, (GtkLayoutManager*) _tmp0_);
	_tmp1_ = dino_plugins_rtp_video_widget_last_id;
	dino_plugins_rtp_video_widget_last_id = _tmp1_ + 1;
	dino_plugins_rtp_video_widget_set_id (self, _tmp1_);
	_tmp2_ = dino_plugins_rtp_sink_new ();
	g_object_set ((GstBaseSink*) _tmp2_, "async", FALSE, NULL);
	gst_base_sink_set_sync ((GstBaseSink*) _tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->sink);
	self->priv->sink = _tmp2_;
	_tmp3_ = self->priv->sink;
	_tmp4_ = _tmp3_->paintable;
	_tmp5_ = (GtkPicture*) gtk_picture_new_for_paintable ((GdkPaintable*) _tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp5_;
	_tmp6_ = self->priv->widget;
	gtk_widget_insert_after ((GtkWidget*) _tmp6_, (GtkWidget*) self, NULL);
	_tmp7_ = dino_plugins_rtp_video_widget_active_widgets;
	dino_plugins_rtp_video_widget_active_widgets = _tmp7_ + 1;
	g_debug ("video_widget.vala:204: Video widget %p created. total=%u", self, dino_plugins_rtp_video_widget_active_widgets);
	g_object_weak_ref ((GObject*) self, _dino_plugins_rtp_video_widget_notify_weak_gweak_notify, NULL);
	return self;
}

DinoPluginsRtpVideoWidget*
dino_plugins_rtp_video_widget_new (DinoPluginsRtpPlugin* plugin)
{
	return dino_plugins_rtp_video_widget_construct (DINO_PLUGINS_RTP_TYPE_VIDEO_WIDGET, plugin);
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		DinoPluginsRtpVideoWidget* self;
		self = _data12_->self;
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gboolean
__lambda26_ (Block12Data* _data12_)
{
	DinoPluginsRtpVideoWidget* self;
	gboolean result;
	self = _data12_->self;
	g_signal_emit_by_name ((DinoPluginsVideoCallWidget*) self, "resolution-changed", (guint) _data12_->width, (guint) _data12_->height);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda26__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda26_ (self);
	return result;
}

static gpointer
_gst_caps_ref0 (gpointer self)
{
	return self ? gst_caps_ref (self) : NULL;
}

void
dino_plugins_rtp_video_widget_input_caps_changed (DinoPluginsRtpVideoWidget* self,
                                                  GObject* pad,
                                                  GParamSpec* spec)
{
	Block12Data* _data12_;
	GstCaps* caps = NULL;
	GstCaps* _tmp0_;
	GstCaps* _tmp1_;
	GstCaps* _tmp2_;
	GstCaps* _tmp3_;
	GstStructure* _tmp4_;
	gint _tmp5_ = 0;
	GstCaps* _tmp6_;
	GstStructure* _tmp7_;
	gint _tmp8_ = 0;
	GstCaps* _tmp9_;
	GstCaps* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pad != NULL);
	g_return_if_fail (spec != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (pad, gst_pad_get_type (), GstPad), "caps", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	caps = _tmp1_;
	_tmp2_ = caps;
	if (_tmp2_ == NULL) {
		g_debug ("video_widget.vala:211: Input: No caps");
		_gst_caps_unref0 (caps);
		block12_data_unref (_data12_);
		_data12_ = NULL;
		return;
	}
	_tmp3_ = caps;
	_tmp4_ = gst_caps_get_structure (_tmp3_, (guint) 0);
	gst_structure_get_int (_tmp4_, "width", &_tmp5_);
	_data12_->width = _tmp5_;
	_tmp6_ = caps;
	_tmp7_ = gst_caps_get_structure (_tmp6_, (guint) 0);
	gst_structure_get_int (_tmp7_, "height", &_tmp8_);
	_data12_->height = _tmp8_;
	g_debug ("video_widget.vala:218: Input resolution changed: %ix%i", _data12_->width, _data12_->height);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda26__gsource_func, block12_data_ref (_data12_), block12_data_unref);
	_tmp9_ = caps;
	_tmp10_ = _gst_caps_ref0 (_tmp9_);
	_gst_caps_unref0 (self->priv->last_input_caps);
	self->priv->last_input_caps = _tmp10_;
	_gst_caps_unref0 (caps);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

static void
_dino_plugins_rtp_video_widget_input_caps_changed_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	dino_plugins_rtp_video_widget_input_caps_changed ((DinoPluginsRtpVideoWidget*) self, _sender, pspec);
}

static void
dino_plugins_rtp_video_widget_real_display_stream (DinoPluginsVideoCallWidget* base,
                                                   XmppXepJingleRtpStream* stream,
                                                   XmppJid* jid)
{
	DinoPluginsRtpVideoWidget * self;
	DinoPluginsRtpSink* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	DinoPluginsRtpStream* _tmp3_;
	DinoPluginsRtpStream* _tmp4_;
	DinoPluginsRtpPlugin* _tmp5_;
	GstPipeline* _tmp6_;
	GstPipeline* _tmp7_;
	DinoPluginsRtpSink* _tmp8_;
	GstElement* _tmp9_ = NULL;
	guint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GstElement* _tmp15_;
	GstElement* _tmp16_;
	GstElement* _tmp17_;
	GstElement* _tmp18_;
	guint _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GstElement* _tmp24_;
	GstPad* _tmp25_;
	GstPad* _tmp26_;
	GstPipeline* _tmp27_;
	GstPipeline* _tmp28_;
	GstElement* _tmp29_;
	DinoPluginsRtpStream* _tmp30_;
	GstElement* _tmp31_;
	GstElement* _tmp32_;
	DinoPluginsRtpSink* _tmp33_;
	DinoPluginsRtpSink* _tmp34_;
	DinoPluginsRtpPlugin* _tmp35_;
	GError* _inner_error0_ = NULL;
	self = (DinoPluginsRtpVideoWidget*) base;
	g_return_if_fail (jid != NULL);
	_tmp0_ = self->priv->sink;
	if (_tmp0_ == NULL) {
		return;
	}
	dino_plugins_video_call_widget_detach ((DinoPluginsVideoCallWidget*) self);
	_tmp1_ = xmpp_xep_jingle_rtp_stream_get_media (stream);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "video") != 0) {
		return;
	}
	_tmp3_ = _g_object_ref0 (DINO_PLUGINS_RTP_IS_STREAM (stream) ? ((DinoPluginsRtpStream*) stream) : NULL);
	_g_object_unref0 (self->priv->connected_stream);
	self->priv->connected_stream = _tmp3_;
	_tmp4_ = self->priv->connected_stream;
	if (_tmp4_ == NULL) {
		return;
	}
	_tmp5_ = self->priv->_plugin;
	dino_plugins_rtp_plugin_pause (_tmp5_);
	_tmp6_ = dino_plugins_rtp_video_widget_get_pipe (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->sink;
	gst_bin_add ((GstBin*) _tmp7_, (GstElement*) _tmp8_);
	_tmp10_ = self->priv->_id;
	_tmp11_ = g_strdup_printf ("%u", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("videoconvert name=video_widget_", _tmp12_, "_convert", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = gst_parse_bin_from_description_full (_tmp14_, TRUE, NULL, GST_PARSE_FLAG_NONE, &_inner_error0_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp9_ = _tmp16_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp17_ = _tmp9_;
	_tmp9_ = NULL;
	if (_tmp17_ != NULL) {
		g_object_ref_sink (_tmp17_);
	}
	_g_object_unref0 (self->priv->prepare);
	self->priv->prepare = _tmp17_;
	_tmp18_ = self->priv->prepare;
	_tmp19_ = self->priv->_id;
	_tmp20_ = g_strdup_printf ("%u", _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat ("video_widget_", _tmp21_, "_prepare", NULL);
	_tmp23_ = _tmp22_;
	gst_object_set_name ((GstObject*) _tmp18_, _tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_tmp24_ = self->priv->prepare;
	_tmp25_ = gst_element_get_static_pad (_tmp24_, "sink");
	_tmp26_ = _tmp25_;
	g_signal_connect_object ((GObject*) _tmp26_, "notify::caps", (GCallback) _dino_plugins_rtp_video_widget_input_caps_changed_g_object_notify, self, 0);
	_g_object_unref0 (_tmp26_);
	_tmp27_ = dino_plugins_rtp_video_widget_get_pipe (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = self->priv->prepare;
	gst_bin_add ((GstBin*) _tmp28_, _tmp29_);
	_tmp30_ = self->priv->connected_stream;
	_tmp31_ = self->priv->prepare;
	dino_plugins_rtp_stream_add_output (_tmp30_, _tmp31_, NULL);
	_tmp32_ = self->priv->prepare;
	_tmp33_ = self->priv->sink;
	gst_element_link (_tmp32_, (GstElement*) _tmp33_);
	_tmp34_ = self->priv->sink;
	gst_element_set_locked_state ((GstElement*) _tmp34_, FALSE);
	_tmp35_ = self->priv->_plugin;
	dino_plugins_rtp_plugin_unpause (_tmp35_);
	self->priv->attached = TRUE;
	_g_object_unref0 (_tmp9_);
}

static void
dino_plugins_rtp_video_widget_real_display_device (DinoPluginsVideoCallWidget* base,
                                                   DinoPluginsMediaDevice* media_device)
{
	DinoPluginsRtpVideoWidget * self;
	DinoPluginsRtpSink* _tmp0_;
	DinoPluginsRtpDevice* _tmp1_;
	DinoPluginsRtpDevice* _tmp2_;
	DinoPluginsRtpPlugin* _tmp3_;
	GstPipeline* _tmp4_;
	GstPipeline* _tmp5_;
	DinoPluginsRtpSink* _tmp6_;
	GstElement* _tmp7_ = NULL;
	guint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	guint _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	guint _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GstElement* _tmp19_;
	GstElement* _tmp20_;
	GstElement* _tmp21_;
	GstElement* _tmp22_;
	guint _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GstElement* _tmp28_;
	GstPipeline* _tmp42_;
	GstPipeline* _tmp43_;
	GstElement* _tmp44_;
	DinoPluginsRtpDevice* _tmp45_;
	GstElement* _tmp46_;
	GstElement* _tmp47_;
	GstElement* _tmp48_;
	GstElement* _tmp49_;
	DinoPluginsRtpSink* _tmp50_;
	DinoPluginsRtpSink* _tmp51_;
	DinoPluginsRtpPlugin* _tmp52_;
	GError* _inner_error0_ = NULL;
	self = (DinoPluginsRtpVideoWidget*) base;
	g_return_if_fail (media_device != NULL);
	_tmp0_ = self->priv->sink;
	if (_tmp0_ == NULL) {
		return;
	}
	dino_plugins_video_call_widget_detach ((DinoPluginsVideoCallWidget*) self);
	_tmp1_ = _g_object_ref0 (DINO_PLUGINS_RTP_IS_DEVICE (media_device) ? ((DinoPluginsRtpDevice*) media_device) : NULL);
	_g_object_unref0 (self->priv->connected_device);
	self->priv->connected_device = _tmp1_;
	_tmp2_ = self->priv->connected_device;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = self->priv->_plugin;
	dino_plugins_rtp_plugin_pause (_tmp3_);
	_tmp4_ = dino_plugins_rtp_video_widget_get_pipe (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->sink;
	gst_bin_add ((GstBin*) _tmp5_, (GstElement*) _tmp6_);
	_tmp8_ = self->priv->_id;
	_tmp9_ = g_strdup_printf ("%u", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->_id;
	_tmp12_ = g_strdup_printf ("%u", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->_id;
	_tmp15_ = g_strdup_printf ("%u", _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat ("videoflip video-direction=auto name=video_widget_", _tmp10_, "_orientation ! videoflip method=horizontal-flip name=video_widget_", _tmp13_, "_flip ! videoconvert name=video_widget_", _tmp16_, "_convert", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = gst_parse_bin_from_description_full (_tmp18_, TRUE, NULL, GST_PARSE_FLAG_NONE, &_inner_error0_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
	_tmp7_ = _tmp20_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp21_ = _tmp7_;
	_tmp7_ = NULL;
	if (_tmp21_ != NULL) {
		g_object_ref_sink (_tmp21_);
	}
	_g_object_unref0 (self->priv->prepare);
	self->priv->prepare = _tmp21_;
	_tmp22_ = self->priv->prepare;
	_tmp23_ = self->priv->_id;
	_tmp24_ = g_strdup_printf ("%u", _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat ("video_widget_", _tmp25_, "_prepare", NULL);
	_tmp27_ = _tmp26_;
	gst_object_set_name ((GstObject*) _tmp22_, _tmp27_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_tmp28_ = self->priv->prepare;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, gst_bin_get_type ())) {
		GstElement* _tmp29_;
		guint _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		GstElement* _tmp35_;
		GstElement* _tmp36_;
		GstPad* _tmp37_;
		GstPad* _tmp38_;
		_tmp29_ = self->priv->prepare;
		_tmp30_ = self->priv->_id;
		_tmp31_ = g_strdup_printf ("%u", _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat ("video_widget_", _tmp32_, "_flip", NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = gst_bin_get_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gst_bin_get_type (), GstBin), _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = gst_element_get_static_pad (_tmp36_, "sink");
		_tmp38_ = _tmp37_;
		g_signal_connect_object ((GObject*) _tmp38_, "notify::caps", (GCallback) _dino_plugins_rtp_video_widget_input_caps_changed_g_object_notify, self, 0);
		_g_object_unref0 (_tmp38_);
		_g_object_unref0 (_tmp36_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
	} else {
		GstElement* _tmp39_;
		GstPad* _tmp40_;
		GstPad* _tmp41_;
		_tmp39_ = self->priv->prepare;
		_tmp40_ = gst_element_get_static_pad (_tmp39_, "sink");
		_tmp41_ = _tmp40_;
		g_signal_connect_object ((GObject*) _tmp41_, "notify::caps", (GCallback) _dino_plugins_rtp_video_widget_input_caps_changed_g_object_notify, self, 0);
		_g_object_unref0 (_tmp41_);
	}
	_tmp42_ = dino_plugins_rtp_video_widget_get_pipe (self);
	_tmp43_ = _tmp42_;
	_tmp44_ = self->priv->prepare;
	gst_bin_add ((GstBin*) _tmp43_, _tmp44_);
	_tmp45_ = self->priv->connected_device;
	_tmp46_ = dino_plugins_rtp_device_link_source (_tmp45_, NULL, (guint) 0, -1, (guint32) 0);
	_g_object_unref0 (self->priv->connected_device_element);
	self->priv->connected_device_element = _tmp46_;
	_tmp47_ = self->priv->connected_device_element;
	_tmp48_ = self->priv->prepare;
	gst_element_link (_tmp47_, _tmp48_);
	_tmp49_ = self->priv->prepare;
	_tmp50_ = self->priv->sink;
	gst_element_link (_tmp49_, (GstElement*) _tmp50_);
	_tmp51_ = self->priv->sink;
	gst_element_set_locked_state ((GstElement*) _tmp51_, FALSE);
	_tmp52_ = self->priv->_plugin;
	dino_plugins_rtp_plugin_unpause (_tmp52_);
	self->priv->attached = TRUE;
	_g_object_unref0 (_tmp7_);
}

static void
dino_plugins_rtp_video_widget_real_detach (DinoPluginsVideoCallWidget* base)
{
	DinoPluginsRtpVideoWidget * self;
	DinoPluginsRtpSink* _tmp0_;
	self = (DinoPluginsRtpVideoWidget*) base;
	_tmp0_ = self->priv->sink;
	if (_tmp0_ == NULL) {
		return;
	}
	if (self->priv->attached) {
		DinoPluginsRtpStream* _tmp1_;
		DinoPluginsRtpDevice* _tmp4_;
		GstElement* _tmp8_;
		GstElement* _tmp9_;
		GstPipeline* _tmp10_;
		GstPipeline* _tmp11_;
		GstElement* _tmp12_;
		DinoPluginsRtpSink* _tmp13_;
		DinoPluginsRtpSink* _tmp14_;
		GstPipeline* _tmp15_;
		GstPipeline* _tmp16_;
		DinoPluginsRtpSink* _tmp17_;
		g_debug ("video_widget.vala:280: Detaching");
		_tmp1_ = self->priv->connected_stream;
		if (_tmp1_ != NULL) {
			DinoPluginsRtpStream* _tmp2_;
			GstElement* _tmp3_;
			_tmp2_ = self->priv->connected_stream;
			_tmp3_ = self->priv->prepare;
			dino_plugins_rtp_stream_remove_output (_tmp2_, _tmp3_);
			_g_object_unref0 (self->priv->connected_stream);
			self->priv->connected_stream = NULL;
		}
		_tmp4_ = self->priv->connected_device;
		if (_tmp4_ != NULL) {
			GstElement* _tmp5_;
			DinoPluginsRtpSink* _tmp6_;
			DinoPluginsRtpDevice* _tmp7_;
			_tmp5_ = self->priv->connected_device_element;
			_tmp6_ = self->priv->sink;
			gst_element_unlink (_tmp5_, (GstElement*) _tmp6_);
			_g_object_unref0 (self->priv->connected_device_element);
			self->priv->connected_device_element = NULL;
			_tmp7_ = self->priv->connected_device;
			dino_plugins_rtp_device_unlink (_tmp7_, NULL);
			_g_object_unref0 (self->priv->connected_device);
			self->priv->connected_device = NULL;
		}
		_tmp8_ = self->priv->prepare;
		gst_element_set_locked_state (_tmp8_, TRUE);
		_tmp9_ = self->priv->prepare;
		gst_element_set_state (_tmp9_, GST_STATE_NULL);
		_tmp10_ = dino_plugins_rtp_video_widget_get_pipe (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->prepare;
		gst_bin_remove ((GstBin*) _tmp11_, _tmp12_);
		_g_object_unref0 (self->priv->prepare);
		self->priv->prepare = NULL;
		_tmp13_ = self->priv->sink;
		gst_element_set_locked_state ((GstElement*) _tmp13_, TRUE);
		_tmp14_ = self->priv->sink;
		gst_element_set_state ((GstElement*) _tmp14_, GST_STATE_NULL);
		_tmp15_ = dino_plugins_rtp_video_widget_get_pipe (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->sink;
		gst_bin_remove ((GstBin*) _tmp16_, (GstElement*) _tmp17_);
		self->priv->attached = FALSE;
	}
}

static void
dino_plugins_rtp_video_widget_real_dispose (GObject* base)
{
	DinoPluginsRtpVideoWidget * self;
	GtkPicture* _tmp0_;
	self = (DinoPluginsRtpVideoWidget*) base;
	dino_plugins_video_call_widget_detach ((DinoPluginsVideoCallWidget*) self);
	_tmp0_ = self->priv->widget;
	if (_tmp0_ != NULL) {
		GtkPicture* _tmp1_;
		_tmp1_ = self->priv->widget;
		gtk_widget_unparent ((GtkWidget*) _tmp1_);
	}
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = NULL;
	_g_object_unref0 (self->priv->sink);
	self->priv->sink = NULL;
}

guint
dino_plugins_rtp_video_widget_get_id (DinoPluginsRtpVideoWidget* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_id;
	return result;
}

static void
dino_plugins_rtp_video_widget_set_id (DinoPluginsRtpVideoWidget* self,
                                      guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = dino_plugins_rtp_video_widget_get_id (self);
	if (old_value != value) {
		self->priv->_id = value;
		g_object_notify_by_pspec ((GObject *) self, dino_plugins_rtp_video_widget_properties[DINO_PLUGINS_RTP_VIDEO_WIDGET_ID_PROPERTY]);
	}
}

DinoPluginsRtpPlugin*
dino_plugins_rtp_video_widget_get_plugin (DinoPluginsRtpVideoWidget* self)
{
	DinoPluginsRtpPlugin* result;
	DinoPluginsRtpPlugin* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plugin;
	result = _tmp0_;
	return result;
}

static void
dino_plugins_rtp_video_widget_set_plugin (DinoPluginsRtpVideoWidget* self,
                                          DinoPluginsRtpPlugin* value)
{
	DinoPluginsRtpPlugin* old_value;
	g_return_if_fail (self != NULL);
	old_value = dino_plugins_rtp_video_widget_get_plugin (self);
	if (old_value != value) {
		DinoPluginsRtpPlugin* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_plugin);
		self->priv->_plugin = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, dino_plugins_rtp_video_widget_properties[DINO_PLUGINS_RTP_VIDEO_WIDGET_PLUGIN_PROPERTY]);
	}
}

GstPipeline*
dino_plugins_rtp_video_widget_get_pipe (DinoPluginsRtpVideoWidget* self)
{
	GstPipeline* result;
	DinoPluginsRtpPlugin* _tmp0_;
	GstPipeline* _tmp1_;
	GstPipeline* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plugin;
	_tmp1_ = dino_plugins_rtp_plugin_get_pipe (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
dino_plugins_rtp_video_widget_class_init (DinoPluginsRtpVideoWidgetClass * klass,
                                          gpointer klass_data)
{
	dino_plugins_rtp_video_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DinoPluginsRtpVideoWidget_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) dino_plugins_rtp_video_widget_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_dino_plugins_rtp_video_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dino_plugins_rtp_video_widget_set_property;
	G_OBJECT_CLASS (klass)->finalize = dino_plugins_rtp_video_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_PLUGINS_RTP_VIDEO_WIDGET_ID_PROPERTY, dino_plugins_rtp_video_widget_properties[DINO_PLUGINS_RTP_VIDEO_WIDGET_ID_PROPERTY] = g_param_spec_uint ("id", "id", "id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_PLUGINS_RTP_VIDEO_WIDGET_PLUGIN_PROPERTY, dino_plugins_rtp_video_widget_properties[DINO_PLUGINS_RTP_VIDEO_WIDGET_PLUGIN_PROPERTY] = g_param_spec_object ("plugin", "plugin", "plugin", DINO_PLUGINS_RTP_TYPE_PLUGIN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_PLUGINS_RTP_VIDEO_WIDGET_PIPE_PROPERTY, dino_plugins_rtp_video_widget_properties[DINO_PLUGINS_RTP_VIDEO_WIDGET_PIPE_PROPERTY] = g_param_spec_object ("pipe", "pipe", "pipe", gst_pipeline_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
dino_plugins_rtp_video_widget_dino_plugins_video_call_widget_interface_init (DinoPluginsVideoCallWidgetIface * iface,
                                                                             gpointer iface_data)
{
	dino_plugins_rtp_video_widget_dino_plugins_video_call_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->display_stream = (void (*) (DinoPluginsVideoCallWidget*, XmppXepJingleRtpStream*, XmppJid*)) dino_plugins_rtp_video_widget_real_display_stream;
	iface->display_device = (void (*) (DinoPluginsVideoCallWidget*, DinoPluginsMediaDevice*)) dino_plugins_rtp_video_widget_real_display_device;
	iface->detach = (void (*) (DinoPluginsVideoCallWidget*)) dino_plugins_rtp_video_widget_real_detach;
}

static void
dino_plugins_rtp_video_widget_instance_init (DinoPluginsRtpVideoWidget * self,
                                             gpointer klass)
{
	self->priv = dino_plugins_rtp_video_widget_get_instance_private (self);
}

static void
dino_plugins_rtp_video_widget_finalize (GObject * obj)
{
	DinoPluginsRtpVideoWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_PLUGINS_RTP_TYPE_VIDEO_WIDGET, DinoPluginsRtpVideoWidget);
	_g_object_unref0 (self->priv->_plugin);
	_g_object_unref0 (self->priv->connected_device);
	_g_object_unref0 (self->priv->connected_device_element);
	_g_object_unref0 (self->priv->connected_stream);
	_g_object_unref0 (self->priv->prepare);
	_gst_caps_unref0 (self->priv->last_input_caps);
	_gst_caps_unref0 (self->priv->last_caps);
	_g_object_unref0 (self->priv->sink);
	_g_object_unref0 (self->priv->widget);
	G_OBJECT_CLASS (dino_plugins_rtp_video_widget_parent_class)->finalize (obj);
}

static GType
dino_plugins_rtp_video_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DinoPluginsRtpVideoWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_plugins_rtp_video_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DinoPluginsRtpVideoWidget), 0, (GInstanceInitFunc) dino_plugins_rtp_video_widget_instance_init, NULL };
	static const GInterfaceInfo dino_plugins_video_call_widget_info = { (GInterfaceInitFunc) dino_plugins_rtp_video_widget_dino_plugins_video_call_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType dino_plugins_rtp_video_widget_type_id;
	dino_plugins_rtp_video_widget_type_id = g_type_register_static (gtk_widget_get_type (), "DinoPluginsRtpVideoWidget", &g_define_type_info, 0);
	g_type_add_interface_static (dino_plugins_rtp_video_widget_type_id, DINO_PLUGINS_TYPE_VIDEO_CALL_WIDGET, &dino_plugins_video_call_widget_info);
	DinoPluginsRtpVideoWidget_private_offset = g_type_add_instance_private (dino_plugins_rtp_video_widget_type_id, sizeof (DinoPluginsRtpVideoWidgetPrivate));
	return dino_plugins_rtp_video_widget_type_id;
}

GType
dino_plugins_rtp_video_widget_get_type (void)
{
	static volatile gsize dino_plugins_rtp_video_widget_type_id__once = 0;
	if (g_once_init_enter (&dino_plugins_rtp_video_widget_type_id__once)) {
		GType dino_plugins_rtp_video_widget_type_id;
		dino_plugins_rtp_video_widget_type_id = dino_plugins_rtp_video_widget_get_type_once ();
		g_once_init_leave (&dino_plugins_rtp_video_widget_type_id__once, dino_plugins_rtp_video_widget_type_id);
	}
	return dino_plugins_rtp_video_widget_type_id__once;
}

static void
_vala_dino_plugins_rtp_video_widget_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	DinoPluginsRtpVideoWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DINO_PLUGINS_RTP_TYPE_VIDEO_WIDGET, DinoPluginsRtpVideoWidget);
	switch (property_id) {
		case DINO_PLUGINS_RTP_VIDEO_WIDGET_ID_PROPERTY:
		g_value_set_uint (value, dino_plugins_rtp_video_widget_get_id (self));
		break;
		case DINO_PLUGINS_RTP_VIDEO_WIDGET_PLUGIN_PROPERTY:
		g_value_set_object (value, dino_plugins_rtp_video_widget_get_plugin (self));
		break;
		case DINO_PLUGINS_RTP_VIDEO_WIDGET_PIPE_PROPERTY:
		g_value_set_object (value, dino_plugins_rtp_video_widget_get_pipe (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_dino_plugins_rtp_video_widget_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	DinoPluginsRtpVideoWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DINO_PLUGINS_RTP_TYPE_VIDEO_WIDGET, DinoPluginsRtpVideoWidget);
	switch (property_id) {
		case DINO_PLUGINS_RTP_VIDEO_WIDGET_ID_PROPERTY:
		dino_plugins_rtp_video_widget_set_id (self, g_value_get_uint (value));
		break;
		case DINO_PLUGINS_RTP_VIDEO_WIDGET_PLUGIN_PROPERTY:
		dino_plugins_rtp_video_widget_set_plugin (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

