/* srtp.c generated by valac 0.56.18, the Vala compiler
 * generated from srtp.vala, do not modify */

#include "crypto-vala.h"
#include <glib.h>
#include <srtp2/srtp.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _srtp_dealloc0(var) ((var == NULL) ? NULL : (var = (srtp_dealloc (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _CryptoSrtpParamSpecSession CryptoSrtpParamSpecSession;

struct _CryptoSrtpSessionPrivate {
	gboolean _has_encrypt;
	gboolean _has_decrypt;
	srtp_ctx_t* encrypt_context;
	srtp_ctx_t* decrypt_context;
};

struct _CryptoSrtpParamSpecSession {
	GParamSpec parent_instance;
};

static gint CryptoSrtpSession_private_offset;
static gpointer crypto_srtp_session_parent_class = NULL;

static void crypto_srtp_session_log (srtp_log_level_t level,
                              const gchar* msg);
static const char* _srtp_log_level_to_string (srtp_log_level_t value);
static const char* _srtp_error_status_to_string (srtp_err_status_t value);
static void crypto_srtp_session_create_policy (CryptoSrtpSession* self,
                                        const gchar* profile,
                                        srtp_policy_t* result);
static void crypto_srtp_session_set_has_encrypt (CryptoSrtpSession* self,
                                          gboolean value);
static void crypto_srtp_session_set_has_decrypt (CryptoSrtpSession* self,
                                          gboolean value);
static void _crypto_srtp_session_log_srtp_log_handler_func_t (srtp_log_level_t level,
                                                       const gchar* msg,
                                                       gpointer self);
static void crypto_srtp_session_finalize (CryptoSrtpSession * obj);
static GType crypto_srtp_session_get_type_once (void);

static inline gpointer
crypto_srtp_session_get_instance_private (CryptoSrtpSession* self)
{
	return G_STRUCT_MEMBER_P (self, CryptoSrtpSession_private_offset);
}

static const char*
_srtp_log_level_to_string (srtp_log_level_t value)
{
	switch (value) {
		case srtp_log_level_error:
		return "srtp_log_level_error";
		case srtp_log_level_warning:
		return "srtp_log_level_warning";
		case srtp_log_level_info:
		return "srtp_log_level_info";
		case srtp_log_level_debug:
		return "srtp_log_level_debug";
	}
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
crypto_srtp_session_log (srtp_log_level_t level,
                         const gchar* msg)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = _srtp_log_level_to_string (level);
	_tmp1_ = string_to_string (msg);
	_tmp2_ = g_strconcat ("SRTP[", _tmp0_, "]: ", _tmp1_, "\n", NULL);
	_tmp3_ = _tmp2_;
	g_print ("%s", _tmp3_);
	_g_free0 (_tmp3_);
}

CryptoSrtpSession*
crypto_srtp_session_construct (GType object_type)
{
	CryptoSrtpSession* self = NULL;
	srtp_ctx_t* _tmp0_ = NULL;
	srtp_ctx_t* _tmp1_ = NULL;
	self = (CryptoSrtpSession*) g_type_create_instance (object_type);
	srtp_create (&_tmp0_, NULL);
	_srtp_dealloc0 (self->priv->encrypt_context);
	self->priv->encrypt_context = _tmp0_;
	srtp_create (&_tmp1_, NULL);
	_srtp_dealloc0 (self->priv->decrypt_context);
	self->priv->decrypt_context = _tmp1_;
	return self;
}

CryptoSrtpSession*
crypto_srtp_session_new (void)
{
	return crypto_srtp_session_construct (CRYPTO_SRTP_TYPE_SESSION);
}

static const char*
_srtp_error_status_to_string (srtp_err_status_t value)
{
	switch (value) {
		case srtp_err_status_ok:
		return "srtp_err_status_ok";
		case srtp_err_status_fail:
		return "srtp_err_status_fail";
		case srtp_err_status_bad_param:
		return "srtp_err_status_bad_param";
		case srtp_err_status_alloc_fail:
		return "srtp_err_status_alloc_fail";
		case srtp_err_status_dealloc_fail:
		return "srtp_err_status_dealloc_fail";
		case srtp_err_status_init_fail:
		return "srtp_err_status_init_fail";
		case srtp_err_status_terminus:
		return "srtp_err_status_terminus";
		case srtp_err_status_auth_fail:
		return "srtp_err_status_auth_fail";
		case srtp_err_status_cipher_fail:
		return "srtp_err_status_cipher_fail";
		case srtp_err_status_replay_fail:
		return "srtp_err_status_replay_fail";
		case srtp_err_status_replay_old:
		return "srtp_err_status_replay_old";
		case srtp_err_status_algo_fail:
		return "srtp_err_status_algo_fail";
		case srtp_err_status_no_such_op:
		return "srtp_err_status_no_such_op";
		case srtp_err_status_no_ctx:
		return "srtp_err_status_no_ctx";
		case srtp_err_status_cant_check:
		return "srtp_err_status_cant_check";
		case srtp_err_status_key_expired:
		return "srtp_err_status_key_expired";
		case srtp_err_status_socket_err:
		return "srtp_err_status_socket_err";
		case srtp_err_status_signal_err:
		return "srtp_err_status_signal_err";
		case srtp_err_status_nonce_bad:
		return "srtp_err_status_nonce_bad";
		case srtp_err_status_read_fail:
		return "srtp_err_status_read_fail";
		case srtp_err_status_write_fail:
		return "srtp_err_status_write_fail";
		case srtp_err_status_parse_err:
		return "srtp_err_status_parse_err";
		case srtp_err_status_encode_err:
		return "srtp_err_status_encode_err";
		case srtp_err_status_semaphore_err:
		return "srtp_err_status_semaphore_err";
		case srtp_err_status_pfkey_err:
		return "srtp_err_status_pfkey_err";
		case srtp_err_status_bad_mki:
		return "srtp_err_status_bad_mki";
		case srtp_err_status_pkt_idx_old:
		return "srtp_err_status_pkt_idx_old";
		case srtp_err_status_pkt_idx_adv:
		return "srtp_err_status_pkt_idx_adv";
	}
	return NULL;
}

guint8*
crypto_srtp_session_encrypt_rtp (CryptoSrtpSession* self,
                                 guint8* data,
                                 gint data_length1,
                                 gint* result_length1,
                                 GError** error)
{
	guint8* buf = NULL;
	guint8* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint buf_use = 0;
	srtp_err_status_t res = 0;
	srtp_ctx_t* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	srtp_err_status_t _tmp4_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (guint8, data_length1 + SRTP_MAX_TRAILER_LEN);
	buf = _tmp0_;
	buf_length1 = data_length1 + SRTP_MAX_TRAILER_LEN;
	_buf_size_ = buf_length1;
	_tmp1_ = buf;
	_tmp1__length1 = buf_length1;
	memcpy (_tmp1_, data, (gsize) data_length1);
	buf_use = data_length1;
	_tmp2_ = self->priv->encrypt_context;
	_tmp3_ = buf;
	_tmp3__length1 = buf_length1;
	_tmp4_ = srtp_protect (_tmp2_, (void*) _tmp3_, &buf_use);
	res = _tmp4_;
	if (res != srtp_err_status_ok) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp5_ = _srtp_error_status_to_string (res);
		_tmp6_ = g_strconcat ("SRTP encrypt failed: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_UNKNOWN, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error0_ = _tmp9_;
		if (_inner_error0_->domain == CRYPTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			buf = (g_free (buf), NULL);
			return NULL;
		} else {
			buf = (g_free (buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	buf_length1 = buf_use;
	_tmp10_ = buf;
	_tmp10__length1 = buf_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

guint8*
crypto_srtp_session_decrypt_rtp (CryptoSrtpSession* self,
                                 guint8* data,
                                 gint data_length1,
                                 gint* result_length1,
                                 GError** error)
{
	guint8* buf = NULL;
	guint8* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint buf_use = 0;
	srtp_err_status_t res = 0;
	srtp_ctx_t* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	srtp_err_status_t _tmp4_;
	guint8* ret = NULL;
	guint8* _tmp11_;
	gint ret_length1;
	gint _ret_size_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	guint8* _tmp13_;
	gint _tmp13__length1;
	guint8* _tmp14_;
	gint _tmp14__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (guint8, data_length1);
	buf = _tmp0_;
	buf_length1 = data_length1;
	_buf_size_ = buf_length1;
	_tmp1_ = buf;
	_tmp1__length1 = buf_length1;
	memcpy (_tmp1_, data, (gsize) data_length1);
	buf_use = data_length1;
	_tmp2_ = self->priv->decrypt_context;
	_tmp3_ = buf;
	_tmp3__length1 = buf_length1;
	_tmp4_ = srtp_unprotect (_tmp2_, (void*) _tmp3_, &buf_use);
	res = _tmp4_;
	switch (res) {
		case srtp_err_status_auth_fail:
		{
			GError* _tmp5_;
			_tmp5_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_AUTHENTICATION_FAILED, "SRTP packet failed the message authentication check");
			_inner_error0_ = _tmp5_;
			if (_inner_error0_->domain == CRYPTO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				buf = (g_free (buf), NULL);
				return NULL;
			} else {
				buf = (g_free (buf), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		case srtp_err_status_ok:
		{
			break;
		}
		default:
		{
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			GError* _tmp9_;
			GError* _tmp10_;
			_tmp6_ = _srtp_error_status_to_string (res);
			_tmp7_ = g_strconcat ("SRTP decrypt failed: ", _tmp6_, NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_UNKNOWN, _tmp8_);
			_tmp10_ = _tmp9_;
			_g_free0 (_tmp8_);
			_inner_error0_ = _tmp10_;
			if (_inner_error0_->domain == CRYPTO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				buf = (g_free (buf), NULL);
				return NULL;
			} else {
				buf = (g_free (buf), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp11_ = g_new0 (guint8, buf_use);
	ret = _tmp11_;
	ret_length1 = buf_use;
	_ret_size_ = ret_length1;
	_tmp12_ = ret;
	_tmp12__length1 = ret_length1;
	_tmp13_ = buf;
	_tmp13__length1 = buf_length1;
	memcpy (_tmp12_, _tmp13_, (gsize) buf_use);
	_tmp14_ = ret;
	_tmp14__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	buf = (g_free (buf), NULL);
	return result;
}

guint8*
crypto_srtp_session_encrypt_rtcp (CryptoSrtpSession* self,
                                  guint8* data,
                                  gint data_length1,
                                  gint* result_length1,
                                  GError** error)
{
	guint8* buf = NULL;
	guint8* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint buf_use = 0;
	srtp_err_status_t res = 0;
	srtp_ctx_t* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	srtp_err_status_t _tmp4_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (guint8, (data_length1 + SRTP_MAX_TRAILER_LEN) + 4);
	buf = _tmp0_;
	buf_length1 = (data_length1 + SRTP_MAX_TRAILER_LEN) + 4;
	_buf_size_ = buf_length1;
	_tmp1_ = buf;
	_tmp1__length1 = buf_length1;
	memcpy (_tmp1_, data, (gsize) data_length1);
	buf_use = data_length1;
	_tmp2_ = self->priv->encrypt_context;
	_tmp3_ = buf;
	_tmp3__length1 = buf_length1;
	_tmp4_ = srtp_protect_rtcp (_tmp2_, (void*) _tmp3_, &buf_use);
	res = _tmp4_;
	if (res != srtp_err_status_ok) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp5_ = _srtp_error_status_to_string (res);
		_tmp6_ = g_strconcat ("SRTCP encrypt failed: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_UNKNOWN, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_inner_error0_ = _tmp9_;
		if (_inner_error0_->domain == CRYPTO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			buf = (g_free (buf), NULL);
			return NULL;
		} else {
			buf = (g_free (buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	buf_length1 = buf_use;
	_tmp10_ = buf;
	_tmp10__length1 = buf_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

guint8*
crypto_srtp_session_decrypt_rtcp (CryptoSrtpSession* self,
                                  guint8* data,
                                  gint data_length1,
                                  gint* result_length1,
                                  GError** error)
{
	guint8* buf = NULL;
	guint8* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint buf_use = 0;
	srtp_err_status_t res = 0;
	srtp_ctx_t* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	srtp_err_status_t _tmp4_;
	guint8* ret = NULL;
	guint8* _tmp11_;
	gint ret_length1;
	gint _ret_size_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	guint8* _tmp13_;
	gint _tmp13__length1;
	guint8* _tmp14_;
	gint _tmp14__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (guint8, data_length1);
	buf = _tmp0_;
	buf_length1 = data_length1;
	_buf_size_ = buf_length1;
	_tmp1_ = buf;
	_tmp1__length1 = buf_length1;
	memcpy (_tmp1_, data, (gsize) data_length1);
	buf_use = data_length1;
	_tmp2_ = self->priv->decrypt_context;
	_tmp3_ = buf;
	_tmp3__length1 = buf_length1;
	_tmp4_ = srtp_unprotect_rtcp (_tmp2_, (void*) _tmp3_, &buf_use);
	res = _tmp4_;
	switch (res) {
		case srtp_err_status_auth_fail:
		{
			GError* _tmp5_;
			_tmp5_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_AUTHENTICATION_FAILED, "SRTCP packet failed the message authentication check");
			_inner_error0_ = _tmp5_;
			if (_inner_error0_->domain == CRYPTO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				buf = (g_free (buf), NULL);
				return NULL;
			} else {
				buf = (g_free (buf), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		case srtp_err_status_ok:
		{
			break;
		}
		default:
		{
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			GError* _tmp9_;
			GError* _tmp10_;
			_tmp6_ = _srtp_error_status_to_string (res);
			_tmp7_ = g_strconcat ("SRTCP decrypt failed: ", _tmp6_, NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_UNKNOWN, _tmp8_);
			_tmp10_ = _tmp9_;
			_g_free0 (_tmp8_);
			_inner_error0_ = _tmp10_;
			if (_inner_error0_->domain == CRYPTO_ERROR) {
				g_propagate_error (error, _inner_error0_);
				buf = (g_free (buf), NULL);
				return NULL;
			} else {
				buf = (g_free (buf), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp11_ = g_new0 (guint8, buf_use);
	ret = _tmp11_;
	ret_length1 = buf_use;
	_ret_size_ = ret_length1;
	_tmp12_ = ret;
	_tmp12__length1 = ret_length1;
	_tmp13_ = buf;
	_tmp13__length1 = buf_length1;
	memcpy (_tmp12_, _tmp13_, (gsize) buf_use);
	_tmp14_ = ret;
	_tmp14__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	buf = (g_free (buf), NULL);
	return result;
}

static void
crypto_srtp_session_create_policy (CryptoSrtpSession* self,
                                   const gchar* profile,
                                   srtp_policy_t* result)
{
	srtp_policy_t policy = {0};
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile != NULL);
	memset (&policy, 0, sizeof (srtp_policy_t));
	_tmp0_ = profile;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (CRYPTO_SRTP_AES_CM_128_HMAC_SHA1_80)))) {
		switch (0) {
			default:
			{
				srtp_crypto_policy_set_aes_cm_128_hmac_sha1_80 (&policy.rtp);
				srtp_crypto_policy_set_aes_cm_128_hmac_sha1_80 (&policy.rtcp);
				break;
			}
		}
	}
	*result = policy;
	return;
}

void
crypto_srtp_session_set_encryption_key (CryptoSrtpSession* self,
                                        const gchar* profile,
                                        guint8* key,
                                        gint key_length1,
                                        guint8* salt,
                                        gint salt_length1)
{
	srtp_policy_t policy = {0};
	srtp_policy_t _tmp0_ = {0};
	guint8* _tmp1_;
	srtp_policy_t _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	srtp_policy_t _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	srtp_ctx_t* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile != NULL);
	crypto_srtp_session_create_policy (self, profile, &_tmp0_);
	policy = _tmp0_;
	policy.ssrc.type = ssrc_any_outbound;
	_tmp1_ = g_new0 (guint8, key_length1 + salt_length1);
	policy.key = (g_free (policy.key), NULL);
	policy.key = _tmp1_;
	_tmp2_ = policy;
	_tmp3_ = _tmp2_.key;
	_tmp3__length1 = -1;
	memcpy (_tmp3_, key, (gsize) key_length1);
	_tmp4_ = policy;
	_tmp5_ = _tmp4_.key;
	_tmp5__length1 = -1;
	memcpy (((guint8*) _tmp5_) + key_length1, salt, (gsize) salt_length1);
	policy.next = NULL;
	_tmp6_ = self->priv->encrypt_context;
	srtp_add_stream (_tmp6_, &policy);
	crypto_srtp_session_set_has_encrypt (self, TRUE);
	 (&policy);
}

void
crypto_srtp_session_set_decryption_key (CryptoSrtpSession* self,
                                        const gchar* profile,
                                        guint8* key,
                                        gint key_length1,
                                        guint8* salt,
                                        gint salt_length1)
{
	srtp_policy_t policy = {0};
	srtp_policy_t _tmp0_ = {0};
	guint8* _tmp1_;
	srtp_policy_t _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	srtp_policy_t _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	srtp_ctx_t* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (profile != NULL);
	crypto_srtp_session_create_policy (self, profile, &_tmp0_);
	policy = _tmp0_;
	policy.ssrc.type = ssrc_any_inbound;
	_tmp1_ = g_new0 (guint8, key_length1 + salt_length1);
	policy.key = (g_free (policy.key), NULL);
	policy.key = _tmp1_;
	_tmp2_ = policy;
	_tmp3_ = _tmp2_.key;
	_tmp3__length1 = -1;
	memcpy (_tmp3_, key, (gsize) key_length1);
	_tmp4_ = policy;
	_tmp5_ = _tmp4_.key;
	_tmp5__length1 = -1;
	memcpy (((guint8*) _tmp5_) + key_length1, salt, (gsize) salt_length1);
	policy.next = NULL;
	_tmp6_ = self->priv->decrypt_context;
	srtp_add_stream (_tmp6_, &policy);
	crypto_srtp_session_set_has_decrypt (self, TRUE);
	 (&policy);
}

gboolean
crypto_srtp_session_get_has_encrypt (CryptoSrtpSession* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_encrypt;
	return result;
}

static void
crypto_srtp_session_set_has_encrypt (CryptoSrtpSession* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_encrypt = value;
}

gboolean
crypto_srtp_session_get_has_decrypt (CryptoSrtpSession* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_decrypt;
	return result;
}

static void
crypto_srtp_session_set_has_decrypt (CryptoSrtpSession* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_decrypt = value;
}

static void
_crypto_srtp_session_log_srtp_log_handler_func_t (srtp_log_level_t level,
                                                  const gchar* msg,
                                                  gpointer self)
{
	crypto_srtp_session_log (level, msg);
}

static void
crypto_srtp_value_session_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
crypto_srtp_value_session_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		crypto_srtp_session_unref (value->data[0].v_pointer);
	}
}

static void
crypto_srtp_value_session_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = crypto_srtp_session_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
crypto_srtp_value_session_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
crypto_srtp_value_session_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CryptoSrtpSession * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = crypto_srtp_session_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
crypto_srtp_value_session_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	CryptoSrtpSession ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = crypto_srtp_session_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
crypto_srtp_param_spec_session (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	CryptoSrtpParamSpecSession* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CRYPTO_SRTP_TYPE_SESSION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
crypto_srtp_value_get_session (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CRYPTO_SRTP_TYPE_SESSION), NULL);
	return value->data[0].v_pointer;
}

void
crypto_srtp_value_set_session (GValue* value,
                               gpointer v_object)
{
	CryptoSrtpSession * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CRYPTO_SRTP_TYPE_SESSION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CRYPTO_SRTP_TYPE_SESSION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		crypto_srtp_session_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		crypto_srtp_session_unref (old);
	}
}

void
crypto_srtp_value_take_session (GValue* value,
                                gpointer v_object)
{
	CryptoSrtpSession * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CRYPTO_SRTP_TYPE_SESSION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CRYPTO_SRTP_TYPE_SESSION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		crypto_srtp_session_unref (old);
	}
}

static void
crypto_srtp_session_class_init (CryptoSrtpSessionClass * klass,
                                gpointer klass_data)
{
	crypto_srtp_session_parent_class = g_type_class_peek_parent (klass);
	((CryptoSrtpSessionClass *) klass)->finalize = crypto_srtp_session_finalize;
	g_type_class_adjust_private_offset (klass, &CryptoSrtpSession_private_offset);
	srtp_init ();
	srtp_install_log_handler (_crypto_srtp_session_log_srtp_log_handler_func_t, NULL);
}

static void
crypto_srtp_session_instance_init (CryptoSrtpSession * self,
                                   gpointer klass)
{
	self->priv = crypto_srtp_session_get_instance_private (self);
	self->priv->_has_encrypt = FALSE;
	self->priv->_has_decrypt = FALSE;
	self->ref_count = 1;
}

static void
crypto_srtp_session_finalize (CryptoSrtpSession * obj)
{
	CryptoSrtpSession * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CRYPTO_SRTP_TYPE_SESSION, CryptoSrtpSession);
	g_signal_handlers_destroy (self);
	_srtp_dealloc0 (self->priv->encrypt_context);
	_srtp_dealloc0 (self->priv->decrypt_context);
}

static GType
crypto_srtp_session_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { crypto_srtp_value_session_init, crypto_srtp_value_session_free_value, crypto_srtp_value_session_copy_value, crypto_srtp_value_session_peek_pointer, "p", crypto_srtp_value_session_collect_value, "p", crypto_srtp_value_session_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CryptoSrtpSessionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crypto_srtp_session_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CryptoSrtpSession), 0, (GInstanceInitFunc) crypto_srtp_session_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType crypto_srtp_session_type_id;
	crypto_srtp_session_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CryptoSrtpSession", &g_define_type_info, &g_define_type_fundamental_info, 0);
	CryptoSrtpSession_private_offset = g_type_add_instance_private (crypto_srtp_session_type_id, sizeof (CryptoSrtpSessionPrivate));
	return crypto_srtp_session_type_id;
}

GType
crypto_srtp_session_get_type (void)
{
	static volatile gsize crypto_srtp_session_type_id__once = 0;
	if (g_once_init_enter (&crypto_srtp_session_type_id__once)) {
		GType crypto_srtp_session_type_id;
		crypto_srtp_session_type_id = crypto_srtp_session_get_type_once ();
		g_once_init_leave (&crypto_srtp_session_type_id__once, crypto_srtp_session_type_id);
	}
	return crypto_srtp_session_type_id__once;
}

gpointer
crypto_srtp_session_ref (gpointer instance)
{
	CryptoSrtpSession * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
crypto_srtp_session_unref (gpointer instance)
{
	CryptoSrtpSession * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CRYPTO_SRTP_SESSION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

