/* text_button.c generated by valac 0.56.17, the Vala compiler
 * generated from text_button.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_CLICK_EVENT_BOX (widgets_click_event_box_get_type ())
#define WIDGETS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBox))
#define WIDGETS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))
#define WIDGETS_IS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_IS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_CLICK_EVENT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))

typedef struct _WidgetsClickEventBox WidgetsClickEventBox;
typedef struct _WidgetsClickEventBoxClass WidgetsClickEventBoxClass;
typedef struct _WidgetsClickEventBoxPrivate WidgetsClickEventBoxPrivate;

#define WIDGETS_TYPE_TEXT_BUTTON (widgets_text_button_get_type ())
#define WIDGETS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TEXT_BUTTON, WidgetsTextButton))
#define WIDGETS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TEXT_BUTTON, WidgetsTextButtonClass))
#define WIDGETS_IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TEXT_BUTTON))
#define WIDGETS_IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TEXT_BUTTON))
#define WIDGETS_TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TEXT_BUTTON, WidgetsTextButtonClass))

typedef struct _WidgetsTextButton WidgetsTextButton;
typedef struct _WidgetsTextButtonClass WidgetsTextButtonClass;
typedef struct _WidgetsTextButtonPrivate WidgetsTextButtonPrivate;
enum  {
	WIDGETS_TEXT_BUTTON_0_PROPERTY,
	WIDGETS_TEXT_BUTTON_NUM_PROPERTIES
};
static GParamSpec* widgets_text_button_properties[WIDGETS_TEXT_BUTTON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _WidgetsClickEventBox {
	GtkEventBox parent_instance;
	WidgetsClickEventBoxPrivate * priv;
	gboolean is_press;
};

struct _WidgetsClickEventBoxClass {
	GtkEventBoxClass parent_class;
};

struct _WidgetsTextButton {
	WidgetsClickEventBox parent_instance;
	WidgetsTextButtonPrivate * priv;
	gboolean is_hover;
	GdkRGBA text_hover_color;
	GdkRGBA text_normal_color;
	GdkRGBA text_press_color;
	gint button_text_size;
	gint height;
	gchar* button_text;
};

struct _WidgetsTextButtonClass {
	WidgetsClickEventBoxClass parent_class;
};

static gpointer widgets_text_button_parent_class = NULL;

VALA_EXTERN GType widgets_click_event_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsClickEventBox, g_object_unref)
VALA_EXTERN GType widgets_text_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTextButton, g_object_unref)
VALA_EXTERN WidgetsTextButton* widgets_text_button_new (const gchar* text,
                                            const gchar* normal_color_string,
                                            const gchar* hover_color_string,
                                            const gchar* press_color_string);
VALA_EXTERN WidgetsTextButton* widgets_text_button_construct (GType object_type,
                                                  const gchar* text,
                                                  const gchar* normal_color_string,
                                                  const gchar* hover_color_string,
                                                  const gchar* press_color_string);
VALA_EXTERN WidgetsClickEventBox* widgets_click_event_box_new (void);
VALA_EXTERN WidgetsClickEventBox* widgets_click_event_box_construct (GType object_type);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
static gboolean __lambda51_ (WidgetsTextButton* self,
                      GtkWidget* w,
                      GdkEventCrossing* e);
static gboolean ___lambda51__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda52_ (WidgetsTextButton* self,
                      GtkWidget* w,
                      GdkEventCrossing* e);
static gboolean ___lambda52__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                     GdkEventCrossing* event,
                                                     gpointer self);
static gboolean __lambda53_ (WidgetsTextButton* self,
                      GtkWidget* w,
                      GdkEventButton* e);
static gboolean ___lambda53__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static gboolean __lambda54_ (WidgetsTextButton* self,
                      GtkWidget* w,
                      GdkEventButton* e);
static gboolean ___lambda54__gtk_widget_button_release_event (GtkWidget* _sender,
                                                       GdkEventButton* event,
                                                       gpointer self);
static void __lambda55_ (WidgetsTextButton* self,
                  WidgetsClickEventBox* w,
                  GdkEventButton* e);
static void ___lambda55__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                                   GdkEventButton* event,
                                                   gpointer self);
VALA_EXTERN gboolean widgets_text_button_on_draw (WidgetsTextButton* self,
                                      GtkWidget* widget,
                                      cairo_t* cr);
static gboolean _widgets_text_button_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                       cairo_t* cr,
                                                       gpointer self);
VALA_EXTERN void utils_set_context_color (cairo_t* cr,
                              GdkRGBA* color);
VALA_EXTERN void draw_draw_text (cairo_t* cr,
                     const gchar* text,
                     gint x,
                     gint y,
                     gint width,
                     gint height,
                     gint size,
                     PangoAlignment horizontal_alignment,
                     const gchar* vertical_align,
                     gint* wrap_width);
static void widgets_text_button_finalize (GObject * obj);
static GType widgets_text_button_get_type_once (void);
VALA_EXTERN WidgetsTextButton* widgets_create_link_button (const gchar* text);
VALA_EXTERN WidgetsTextButton* widgets_create_delete_button (const gchar* text);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda51_ (WidgetsTextButton* self,
             GtkWidget* w,
             GdkEventCrossing* e)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkWindow* _tmp2_;
	GdkCursor* _tmp3_;
	GdkCursor* _tmp4_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp3_ = gdk_cursor_new_for_display (display, GDK_HAND1);
	_tmp4_ = _tmp3_;
	gdk_window_set_cursor (_tmp2_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	self->is_hover = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	_g_object_unref0 (display);
	return result;
}

static gboolean
___lambda51__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda51_ ((WidgetsTextButton*) self, _sender, event);
	return result;
}

static gboolean
__lambda52_ (WidgetsTextButton* self,
             GtkWidget* w,
             GdkEventCrossing* e)
{
	GdkWindow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_cursor (_tmp0_, NULL);
	self->is_hover = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda52__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                            GdkEventCrossing* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda52_ ((WidgetsTextButton*) self, _sender, event);
	return result;
}

static gboolean
__lambda53_ (WidgetsTextButton* self,
             GtkWidget* w,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda53__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda53_ ((WidgetsTextButton*) self, _sender, event);
	return result;
}

static gboolean
__lambda54_ (WidgetsTextButton* self,
             GtkWidget* w,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	self->is_hover = FALSE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda54__gtk_widget_button_release_event (GtkWidget* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda54_ ((WidgetsTextButton*) self, _sender, event);
	return result;
}

static void
__lambda55_ (WidgetsTextButton* self,
             WidgetsClickEventBox* w,
             GdkEventButton* e)
{
	GdkWindow* _tmp0_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (e != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_cursor (_tmp0_, NULL);
}

static void
___lambda55__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	__lambda55_ ((WidgetsTextButton*) self, _sender, event);
}

static gboolean
_widgets_text_button_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                              cairo_t* cr,
                                              gpointer self)
{
	gboolean result;
	result = widgets_text_button_on_draw ((WidgetsTextButton*) self, _sender, cr);
	return result;
}

WidgetsTextButton*
widgets_text_button_construct (GType object_type,
                               const gchar* text,
                               const gchar* normal_color_string,
                               const gchar* hover_color_string,
                               const gchar* press_color_string)
{
	WidgetsTextButton * self = NULL;
	gchar* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_ = {0};
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (normal_color_string != NULL, NULL);
	g_return_val_if_fail (hover_color_string != NULL, NULL);
	g_return_val_if_fail (press_color_string != NULL, NULL);
	self = (WidgetsTextButton*) widgets_click_event_box_construct (object_type);
	gtk_widget_set_size_request ((GtkWidget*) self, -1, self->height);
	_tmp0_ = g_strdup (text);
	_g_free0 (self->button_text);
	self->button_text = _tmp0_;
	utils_hex_to_rgba (normal_color_string, 1.0, &_tmp1_);
	self->text_normal_color = _tmp1_;
	utils_hex_to_rgba (hover_color_string, 1.0, &_tmp2_);
	self->text_hover_color = _tmp2_;
	utils_hex_to_rgba (press_color_string, 1.0, &_tmp3_);
	self->text_press_color = _tmp3_;
	gtk_widget_add_events ((GtkWidget*) self, (gint) (((GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK) | GDK_POINTER_MOTION_MASK) | GDK_LEAVE_NOTIFY_MASK));
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) ___lambda51__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) ___lambda52__gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda53__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) ___lambda54__gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((WidgetsClickEventBox*) self, "clicked", (GCallback) ___lambda55__widgets_click_event_box_clicked, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_text_button_on_draw_gtk_widget_draw, self, 0);
	return self;
}

WidgetsTextButton*
widgets_text_button_new (const gchar* text,
                         const gchar* normal_color_string,
                         const gchar* hover_color_string,
                         const gchar* press_color_string)
{
	return widgets_text_button_construct (WIDGETS_TYPE_TEXT_BUTTON, text, normal_color_string, hover_color_string, press_color_string);
}

gboolean
widgets_text_button_on_draw (WidgetsTextButton* self,
                             GtkWidget* widget,
                             cairo_t* cr)
{
	GtkAllocation rect = {0};
	GtkAllocation _tmp0_ = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation (widget, &_tmp0_);
	rect = _tmp0_;
	if (self->is_hover) {
		if (((WidgetsClickEventBox*) self)->is_press) {
			GdkRGBA _tmp1_;
			const gchar* _tmp2_;
			GtkAllocation _tmp3_;
			GtkAllocation _tmp4_;
			_tmp1_ = self->text_press_color;
			utils_set_context_color (cr, &_tmp1_);
			_tmp2_ = self->button_text;
			_tmp3_ = rect;
			_tmp4_ = rect;
			draw_draw_text (cr, _tmp2_, 0, 0, _tmp3_.width, _tmp4_.height, self->button_text_size, PANGO_ALIGN_CENTER, "middle", NULL);
		} else {
			GdkRGBA _tmp5_;
			const gchar* _tmp6_;
			GtkAllocation _tmp7_;
			GtkAllocation _tmp8_;
			_tmp5_ = self->text_hover_color;
			utils_set_context_color (cr, &_tmp5_);
			_tmp6_ = self->button_text;
			_tmp7_ = rect;
			_tmp8_ = rect;
			draw_draw_text (cr, _tmp6_, 0, 0, _tmp7_.width, _tmp8_.height, self->button_text_size, PANGO_ALIGN_CENTER, "middle", NULL);
		}
	} else {
		GdkRGBA _tmp9_;
		const gchar* _tmp10_;
		GtkAllocation _tmp11_;
		GtkAllocation _tmp12_;
		_tmp9_ = self->text_normal_color;
		utils_set_context_color (cr, &_tmp9_);
		_tmp10_ = self->button_text;
		_tmp11_ = rect;
		_tmp12_ = rect;
		draw_draw_text (cr, _tmp10_, 0, 0, _tmp11_.width, _tmp12_.height, self->button_text_size, PANGO_ALIGN_CENTER, "middle", NULL);
	}
	result = TRUE;
	return result;
}

static void
widgets_text_button_class_init (WidgetsTextButtonClass * klass,
                                gpointer klass_data)
{
	widgets_text_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_text_button_finalize;
}

static void
widgets_text_button_instance_init (WidgetsTextButton * self,
                                   gpointer klass)
{
	self->is_hover = FALSE;
	self->button_text_size = 10;
	self->height = 30;
}

static void
widgets_text_button_finalize (GObject * obj)
{
	WidgetsTextButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_TEXT_BUTTON, WidgetsTextButton);
	_g_free0 (self->button_text);
	G_OBJECT_CLASS (widgets_text_button_parent_class)->finalize (obj);
}

static GType
widgets_text_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsTextButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_text_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsTextButton), 0, (GInstanceInitFunc) widgets_text_button_instance_init, NULL };
	GType widgets_text_button_type_id;
	widgets_text_button_type_id = g_type_register_static (WIDGETS_TYPE_CLICK_EVENT_BOX, "WidgetsTextButton", &g_define_type_info, 0);
	return widgets_text_button_type_id;
}

GType
widgets_text_button_get_type (void)
{
	static volatile gsize widgets_text_button_type_id__once = 0;
	if (g_once_init_enter (&widgets_text_button_type_id__once)) {
		GType widgets_text_button_type_id;
		widgets_text_button_type_id = widgets_text_button_get_type_once ();
		g_once_init_leave (&widgets_text_button_type_id__once, widgets_text_button_type_id);
	}
	return widgets_text_button_type_id__once;
}

WidgetsTextButton*
widgets_create_link_button (const gchar* text)
{
	WidgetsTextButton* _tmp0_;
	WidgetsTextButton* result;
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = widgets_text_button_new (text, "#0082FA", "#16B8FF", "#0060B9");
	g_object_ref_sink (_tmp0_);
	result = _tmp0_;
	return result;
}

WidgetsTextButton*
widgets_create_delete_button (const gchar* text)
{
	WidgetsTextButton* _tmp0_;
	WidgetsTextButton* result;
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = widgets_text_button_new (text, "#FF5A5A", "#FF142D", "#AF0000");
	g_object_ref_sink (_tmp0_);
	result = _tmp0_;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

