/* base_panel.c generated by valac 0.56.17, the Vala compiler
 * generated from base_panel.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_BASE_PANEL (widgets_base_panel_get_type ())
#define WIDGETS_BASE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_BASE_PANEL, WidgetsBasePanel))
#define WIDGETS_BASE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_BASE_PANEL, WidgetsBasePanelClass))
#define WIDGETS_IS_BASE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_BASE_PANEL))
#define WIDGETS_IS_BASE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_BASE_PANEL))
#define WIDGETS_BASE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_BASE_PANEL, WidgetsBasePanelClass))

typedef struct _WidgetsBasePanel WidgetsBasePanel;
typedef struct _WidgetsBasePanelClass WidgetsBasePanelClass;
typedef struct _WidgetsBasePanelPrivate WidgetsBasePanelPrivate;

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;

#define WIDGETS_TYPE_SWITCHER (widgets_switcher_get_type ())
#define WIDGETS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_SWITCHER, WidgetsSwitcher))
#define WIDGETS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_SWITCHER, WidgetsSwitcherClass))
#define WIDGETS_IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_SWITCHER))
#define WIDGETS_IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_SWITCHER))
#define WIDGETS_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_SWITCHER, WidgetsSwitcherClass))

typedef struct _WidgetsSwitcher WidgetsSwitcher;
typedef struct _WidgetsSwitcherClass WidgetsSwitcherClass;

#define WIDGETS_TYPE_WORKSPACE (widgets_workspace_get_type ())
#define WIDGETS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspace))
#define WIDGETS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))
#define WIDGETS_IS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_IS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_WORKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))

typedef struct _WidgetsWorkspace WidgetsWorkspace;
typedef struct _WidgetsWorkspaceClass WidgetsWorkspaceClass;
enum  {
	WIDGETS_BASE_PANEL_0_PROPERTY,
	WIDGETS_BASE_PANEL_NUM_PROPERTIES
};
static GParamSpec* widgets_base_panel_properties[WIDGETS_BASE_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _WidgetsBasePanel {
	GtkHBox parent_instance;
	WidgetsBasePanelPrivate * priv;
	WidgetsConfigWindow* parent_window;
	WidgetsWorkspaceManager* workspace_manager;
	GdkRGBA background_color;
	GdkRGBA line_dark_color;
	GdkRGBA line_light_color;
	GtkBox* home_page_box;
	GtkBox* search_page_box;
	GtkScrolledWindow* home_page_scrolledwindow;
	GtkScrolledWindow* search_page_scrolledwindow;
	GtkWidget* focus_widget;
	WidgetsSwitcher* switcher;
	WidgetsWorkspace* workspace;
	gint back_button_margin_left;
	gint back_button_margin_top;
};

struct _WidgetsBasePanelClass {
	GtkHBoxClass parent_class;
	void (*create_search_page) (WidgetsBasePanel* self, const gchar* search_text, const gchar* group_name);
	void (*create_home_page) (WidgetsBasePanel* self);
};

static gpointer widgets_base_panel_parent_class = NULL;

VALA_EXTERN GType widgets_base_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsBasePanel, g_object_unref)
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
VALA_EXTERN GType widgets_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsSwitcher, g_object_unref)
VALA_EXTERN GType widgets_workspace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspace, g_object_unref)
VALA_EXTERN void widgets_base_panel_create_search_page (WidgetsBasePanel* self,
                                            const gchar* search_text,
                                            const gchar* group_name);
VALA_EXTERN void widgets_base_panel_create_home_page (WidgetsBasePanel* self);
VALA_EXTERN WidgetsBasePanel* widgets_base_panel_new (void);
VALA_EXTERN WidgetsBasePanel* widgets_base_panel_construct (GType object_type);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN GtkScrolledWindow* widgets_base_panel_create_scrolled_window (WidgetsBasePanel* self);
VALA_EXTERN void widgets_base_panel_update_search_page (WidgetsBasePanel* self,
                                            const gchar* search_text,
                                            const gchar* group_name);
VALA_EXTERN void widgets_switcher_add_to_left_box (WidgetsSwitcher* self,
                                       GtkWidget* start_widget);
VALA_EXTERN void widgets_base_panel_show_home_page (WidgetsBasePanel* self,
                                        GtkWidget* start_widget);
VALA_EXTERN void widgets_switcher_scroll_to_left (WidgetsSwitcher* self,
                                      GtkWidget* start_widget,
                                      GtkWidget* end_widget);
VALA_EXTERN void widgets_base_panel_show_search_page (WidgetsBasePanel* self,
                                          const gchar* search_text,
                                          const gchar* group_name,
                                          GtkWidget* start_widget);
VALA_EXTERN void widgets_switcher_scroll_to_right (WidgetsSwitcher* self,
                                       GtkWidget* start_widget,
                                       GtkWidget* end_widget);
VALA_EXTERN void widgets_base_panel_update_home_page (WidgetsBasePanel* self);
VALA_EXTERN gboolean widgets_base_panel_on_draw (WidgetsBasePanel* self,
                                     GtkWidget* widget,
                                     cairo_t* cr);
VALA_EXTERN gboolean widgets_config_window_is_light_theme (WidgetsConfigWindow* self);
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
VALA_EXTERN void utils_set_context_color (cairo_t* cr,
                              GdkRGBA* color);
static void widgets_base_panel_real_create_search_page (WidgetsBasePanel* self,
                                                 const gchar* search_text,
                                                 const gchar* group_name);
static void widgets_base_panel_real_create_home_page (WidgetsBasePanel* self);
static void widgets_base_panel_finalize (GObject * obj);
static GType widgets_base_panel_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

WidgetsBasePanel*
widgets_base_panel_construct (GType object_type)
{
	WidgetsBasePanel * self = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_ = {0};
	self = (WidgetsBasePanel*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->home_page_box);
	self->home_page_box = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->search_page_box);
	self->search_page_box = _tmp1_;
	utils_hex_to_rgba ("#ffffff", 0.1, &_tmp2_);
	self->line_dark_color = _tmp2_;
	utils_hex_to_rgba ("#000000", 0.1, &_tmp3_);
	self->line_light_color = _tmp3_;
	return self;
}

WidgetsBasePanel*
widgets_base_panel_new (void)
{
	return widgets_base_panel_construct (WIDGETS_TYPE_BASE_PANEL);
}

GtkScrolledWindow*
widgets_base_panel_create_scrolled_window (WidgetsBasePanel* self)
{
	GtkScrolledWindow* scrolledwindow = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkWidget* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkScrolledWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	scrolledwindow = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) scrolledwindow);
	gtk_style_context_add_class (_tmp1_, "scrolledwindow");
	gtk_scrolled_window_set_policy (scrolledwindow, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type (scrolledwindow, GTK_SHADOW_NONE);
	_tmp2_ = gtk_scrolled_window_get_vscrollbar (scrolledwindow);
	_tmp3_ = gtk_widget_get_style_context (_tmp2_);
	gtk_style_context_add_class (_tmp3_, "light_scrollbar");
	result = scrolledwindow;
	return result;
}

void
widgets_base_panel_update_search_page (WidgetsBasePanel* self,
                                       const gchar* search_text,
                                       const gchar* group_name)
{
	gdouble scroll_value = 0.0;
	GtkScrolledWindow* _tmp0_;
	WidgetsSwitcher* _tmp3_;
	GtkBox* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search_text != NULL);
	g_return_if_fail (group_name != NULL);
	scroll_value = (gdouble) 0;
	_tmp0_ = self->search_page_scrolledwindow;
	if (_tmp0_ != NULL) {
		GtkScrolledWindow* _tmp1_;
		GtkAdjustment* _tmp2_;
		_tmp1_ = self->search_page_scrolledwindow;
		_tmp2_ = gtk_scrolled_window_get_vadjustment (_tmp1_);
		scroll_value = gtk_adjustment_get_value (_tmp2_);
	}
	widgets_base_panel_create_search_page (self, search_text, group_name);
	_tmp3_ = self->switcher;
	_tmp4_ = self->search_page_box;
	widgets_switcher_add_to_left_box (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->search_page_scrolledwindow;
	if (_tmp5_ != NULL) {
		GtkScrolledWindow* _tmp6_;
		GtkAdjustment* _tmp7_;
		_tmp6_ = self->search_page_scrolledwindow;
		_tmp7_ = gtk_scrolled_window_get_vadjustment (_tmp6_);
		gtk_adjustment_set_value (_tmp7_, scroll_value);
	}
	gtk_widget_show_all ((GtkWidget*) self);
}

void
widgets_base_panel_show_home_page (WidgetsBasePanel* self,
                                   GtkWidget* start_widget)
{
	g_return_if_fail (self != NULL);
	widgets_base_panel_create_home_page (self);
	if (start_widget == NULL) {
		WidgetsSwitcher* _tmp0_;
		GtkBox* _tmp1_;
		_tmp0_ = self->switcher;
		_tmp1_ = self->home_page_box;
		widgets_switcher_add_to_left_box (_tmp0_, (GtkWidget*) _tmp1_);
	} else {
		WidgetsSwitcher* _tmp2_;
		GtkBox* _tmp3_;
		_tmp2_ = self->switcher;
		_tmp3_ = self->home_page_box;
		widgets_switcher_scroll_to_left (_tmp2_, start_widget, (GtkWidget*) _tmp3_);
	}
	gtk_widget_show_all ((GtkWidget*) self);
}

void
widgets_base_panel_show_search_page (WidgetsBasePanel* self,
                                     const gchar* search_text,
                                     const gchar* group_name,
                                     GtkWidget* start_widget)
{
	WidgetsSwitcher* _tmp0_;
	GtkBox* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search_text != NULL);
	g_return_if_fail (group_name != NULL);
	g_return_if_fail (start_widget != NULL);
	widgets_base_panel_create_search_page (self, search_text, group_name);
	_tmp0_ = self->switcher;
	_tmp1_ = self->search_page_box;
	widgets_switcher_scroll_to_right (_tmp0_, start_widget, (GtkWidget*) _tmp1_);
	gtk_widget_show_all ((GtkWidget*) self);
}

void
widgets_base_panel_update_home_page (WidgetsBasePanel* self)
{
	gdouble scroll_value = 0.0;
	GtkScrolledWindow* _tmp0_;
	WidgetsSwitcher* _tmp3_;
	GtkBox* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	g_return_if_fail (self != NULL);
	scroll_value = (gdouble) 0;
	_tmp0_ = self->home_page_scrolledwindow;
	if (_tmp0_ != NULL) {
		GtkScrolledWindow* _tmp1_;
		GtkAdjustment* _tmp2_;
		_tmp1_ = self->home_page_scrolledwindow;
		_tmp2_ = gtk_scrolled_window_get_vadjustment (_tmp1_);
		scroll_value = gtk_adjustment_get_value (_tmp2_);
	}
	widgets_base_panel_create_home_page (self);
	_tmp3_ = self->switcher;
	_tmp4_ = self->home_page_box;
	widgets_switcher_add_to_left_box (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->home_page_scrolledwindow;
	if (_tmp5_ != NULL) {
		GtkScrolledWindow* _tmp6_;
		GtkAdjustment* _tmp7_;
		_tmp6_ = self->home_page_scrolledwindow;
		_tmp7_ = gtk_scrolled_window_get_vadjustment (_tmp6_);
		gtk_adjustment_set_value (_tmp7_, scroll_value);
	}
	gtk_widget_show_all ((GtkWidget*) self);
}

gboolean
widgets_base_panel_on_draw (WidgetsBasePanel* self,
                            GtkWidget* widget,
                            cairo_t* cr)
{
	gboolean is_light_theme = FALSE;
	GtkWidget* _tmp0_;
	GtkAllocation rect = {0};
	GtkAllocation _tmp1_ = {0};
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	GtkAllocation _tmp5_;
	GtkAllocation _tmp6_;
	GtkAllocation _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	is_light_theme = widgets_config_window_is_light_theme (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	gtk_widget_get_allocation (widget, &_tmp1_);
	rect = _tmp1_;
	_tmp2_ = self->background_color;
	_tmp3_ = self->background_color;
	_tmp4_ = self->background_color;
	cairo_set_source_rgba (cr, _tmp2_.red, _tmp3_.green, _tmp4_.blue, 0.8);
	_tmp5_ = rect;
	_tmp6_ = rect;
	draw_draw_rectangle (cr, 1, 0, _tmp5_.width - 1, _tmp6_.height, TRUE);
	if (is_light_theme) {
		GdkRGBA _tmp7_;
		_tmp7_ = self->line_light_color;
		utils_set_context_color (cr, &_tmp7_);
	} else {
		GdkRGBA _tmp8_;
		_tmp8_ = self->line_dark_color;
		utils_set_context_color (cr, &_tmp8_);
	}
	_tmp9_ = rect;
	draw_draw_rectangle (cr, 0, 0, 1, _tmp9_.height, TRUE);
	result = FALSE;
	return result;
}

static void
widgets_base_panel_real_create_search_page (WidgetsBasePanel* self,
                                            const gchar* search_text,
                                            const gchar* group_name)
{
	g_return_if_fail (search_text != NULL);
	g_return_if_fail (group_name != NULL);
}

void
widgets_base_panel_create_search_page (WidgetsBasePanel* self,
                                       const gchar* search_text,
                                       const gchar* group_name)
{
	WidgetsBasePanelClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = WIDGETS_BASE_PANEL_GET_CLASS (self);
	if (_klass_->create_search_page) {
		_klass_->create_search_page (self, search_text, group_name);
	}
}

static void
widgets_base_panel_real_create_home_page (WidgetsBasePanel* self)
{
}

void
widgets_base_panel_create_home_page (WidgetsBasePanel* self)
{
	WidgetsBasePanelClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = WIDGETS_BASE_PANEL_GET_CLASS (self);
	if (_klass_->create_home_page) {
		_klass_->create_home_page (self);
	}
}

static void
widgets_base_panel_class_init (WidgetsBasePanelClass * klass,
                               gpointer klass_data)
{
	widgets_base_panel_parent_class = g_type_class_peek_parent (klass);
	((WidgetsBasePanelClass *) klass)->create_search_page = (void (*) (WidgetsBasePanel*, const gchar*, const gchar*)) widgets_base_panel_real_create_search_page;
	((WidgetsBasePanelClass *) klass)->create_home_page = (void (*) (WidgetsBasePanel*)) widgets_base_panel_real_create_home_page;
	G_OBJECT_CLASS (klass)->finalize = widgets_base_panel_finalize;
}

static void
widgets_base_panel_instance_init (WidgetsBasePanel * self,
                                  gpointer klass)
{
	self->back_button_margin_left = 8;
	self->back_button_margin_top = 6;
}

static void
widgets_base_panel_finalize (GObject * obj)
{
	WidgetsBasePanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_BASE_PANEL, WidgetsBasePanel);
	_g_object_unref0 (self->parent_window);
	_g_object_unref0 (self->workspace_manager);
	_g_object_unref0 (self->home_page_box);
	_g_object_unref0 (self->search_page_box);
	_g_object_unref0 (self->home_page_scrolledwindow);
	_g_object_unref0 (self->search_page_scrolledwindow);
	_g_object_unref0 (self->focus_widget);
	_g_object_unref0 (self->switcher);
	_g_object_unref0 (self->workspace);
	G_OBJECT_CLASS (widgets_base_panel_parent_class)->finalize (obj);
}

static GType
widgets_base_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsBasePanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_base_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsBasePanel), 0, (GInstanceInitFunc) widgets_base_panel_instance_init, NULL };
	GType widgets_base_panel_type_id;
	widgets_base_panel_type_id = g_type_register_static (gtk_hbox_get_type (), "WidgetsBasePanel", &g_define_type_info, 0);
	return widgets_base_panel_type_id;
}

GType
widgets_base_panel_get_type (void)
{
	static volatile gsize widgets_base_panel_type_id__once = 0;
	if (g_once_init_enter (&widgets_base_panel_type_id__once)) {
		GType widgets_base_panel_type_id;
		widgets_base_panel_type_id = widgets_base_panel_get_type_once ();
		g_once_init_leave (&widgets_base_panel_type_id__once, widgets_base_panel_type_id);
	}
	return widgets_base_panel_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

