/* data-parser.c generated by valac 0.56.18, the Vala compiler
 * generated from data-parser.vala, do not modify */

/* data-parser.vala
 *
 * Copyright 2022 Vojtěch Perník
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define WG_DATA_PARSER_TYPE_WORD (wg_data_parser_word_get_type ())
#define WG_DATA_PARSER_WORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WG_DATA_PARSER_TYPE_WORD, WGDataParserWord))
#define WG_DATA_PARSER_WORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WG_DATA_PARSER_TYPE_WORD, WGDataParserWordClass))
#define WG_DATA_PARSER_IS_WORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WG_DATA_PARSER_TYPE_WORD))
#define WG_DATA_PARSER_IS_WORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WG_DATA_PARSER_TYPE_WORD))
#define WG_DATA_PARSER_WORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WG_DATA_PARSER_TYPE_WORD, WGDataParserWordClass))

typedef struct _WGDataParserWord WGDataParserWord;
typedef struct _WGDataParserWordClass WGDataParserWordClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _WGDataParserWordPrivate WGDataParserWordPrivate;
enum  {
	WG_DATA_PARSER_WORD_0_PROPERTY,
	WG_DATA_PARSER_WORD_VAL_PROPERTY,
	WG_DATA_PARSER_WORD_WORD_PROPERTY,
	WG_DATA_PARSER_WORD_REPLACED_PROPERTY,
	WG_DATA_PARSER_WORD_CHARACTERS_PROPERTY,
	WG_DATA_PARSER_WORD_NUM_PROPERTIES
};
static GParamSpec* wg_data_parser_word_properties[WG_DATA_PARSER_WORD_NUM_PROPERTIES];

struct _WGDataParserWord {
	GObject parent_instance;
	WGDataParserWordPrivate * priv;
};

struct _WGDataParserWordClass {
	GObjectClass parent_class;
};

struct _WGDataParserWordPrivate {
	gchar* _val;
	gchar* _word;
	gchar* _replaced;
	gchar** _characters;
	gint _characters_length1;
	gint __characters_size_;
};

VALA_EXTERN GHashTable* wg_data_parser_replacements;
GHashTable* wg_data_parser_replacements = NULL;
VALA_EXTERN gchar** wg_data_parser__available_letters;
VALA_EXTERN gint wg_data_parser__available_letters_length1;
gchar** wg_data_parser__available_letters = NULL;
gint wg_data_parser__available_letters_length1 = 0;
static gint _wg_data_parser__available_letters_size_ = 0;
VALA_EXTERN WGDataParserWord** wg_data_parser__dictionary;
VALA_EXTERN gint wg_data_parser__dictionary_length1;
WGDataParserWord** wg_data_parser__dictionary = NULL;
gint wg_data_parser__dictionary_length1 = 0;
static gint _wg_data_parser__dictionary_size_ = 0;
static gint WGDataParserWord_private_offset;
static gpointer wg_data_parser_word_parent_class = NULL;

VALA_EXTERN void wg_data_parser_load_replacements (void);
static void _g_free0_ (gpointer var);
VALA_EXTERN gchar* wg_data_get_replacements (void);
VALA_EXTERN gchar* wg_data_parser_replace (const gchar* original);
VALA_EXTERN gchar** wg_data_parser_get_available_letters (gint* result_length1);
VALA_EXTERN gchar* wg_data_get_available_letters (void);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
VALA_EXTERN GType wg_data_parser_word_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WGDataParserWord, g_object_unref)
VALA_EXTERN WGDataParserWord** wg_data_parser_get_dictionary (gint* result_length1);
VALA_EXTERN gchar* wg_data_get_dictionary (void);
VALA_EXTERN WGDataParserWord* wg_data_parser_word_new (const gchar* val);
VALA_EXTERN WGDataParserWord* wg_data_parser_word_construct (GType object_type,
                                                 const gchar* val);
static void _vala_array_add4 (WGDataParserWord** * array,
                       gint* length,
                       gint* size,
                       WGDataParserWord* value);
static WGDataParserWord** _vala_array_dup4 (WGDataParserWord** self,
                                     gssize length);
VALA_EXTERN gboolean wg_data_parser_check_if_word_exists (gchar** characters,
                                              gint characters_length1);
VALA_EXTERN gchar** wg_data_parser_word_get_characters (WGDataParserWord* self,
                                            gint* result_length1);
VALA_EXTERN const gchar* wg_data_parser_word_get_val (WGDataParserWord* self);
static void wg_data_parser_word_set_val (WGDataParserWord* self,
                                  const gchar* value);
VALA_EXTERN const gchar* wg_data_parser_word_get_word (WGDataParserWord* self);
VALA_EXTERN const gchar* wg_data_parser_word_get_replaced (WGDataParserWord* self);
static void wg_data_parser_word_finalize (GObject * obj);
static GType wg_data_parser_word_get_type_once (void);
static void _vala_wg_data_parser_word_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_wg_data_parser_word_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
wg_data_parser_load_replacements (void)
{
	GHashTable* _tmp0_;
	_tmp0_ = wg_data_parser_replacements;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_free0_);
		_g_hash_table_unref0 (wg_data_parser_replacements);
		wg_data_parser_replacements = _tmp3_;
		_tmp4_ = wg_data_get_replacements ();
		_tmp5_ = _tmp4_;
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _vala_array_length (_tmp6_);
		_g_free0 (_tmp5_);
		{
			gchar** replacement_collection = NULL;
			gint replacement_collection_length1 = 0;
			gint _replacement_collection_size_ = 0;
			gint replacement_it = 0;
			replacement_collection = _tmp8_;
			replacement_collection_length1 = _tmp8__length1;
			for (replacement_it = 0; replacement_it < replacement_collection_length1; replacement_it = replacement_it + 1) {
				gchar* _tmp9_;
				gchar* replacement = NULL;
				_tmp9_ = g_strdup (replacement_collection[replacement_it]);
				replacement = _tmp9_;
				{
					gchar** _splitted = NULL;
					const gchar* _tmp10_;
					gchar** _tmp11_;
					gchar** _tmp12_;
					gint _splitted_length1;
					gint __splitted_size_;
					GHashTable* _tmp13_;
					gchar** _tmp14_;
					gint _tmp14__length1;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp10_ = replacement;
					_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "/", 0);
					_splitted = _tmp12_;
					_splitted_length1 = _vala_array_length (_tmp11_);
					__splitted_size_ = _splitted_length1;
					_tmp13_ = wg_data_parser_replacements;
					_tmp14_ = _splitted;
					_tmp14__length1 = _splitted_length1;
					_tmp15_ = _tmp14_[0];
					_tmp16_ = string_strip (_tmp15_);
					_tmp17_ = _splitted;
					_tmp17__length1 = _splitted_length1;
					_tmp18_ = _tmp17_[1];
					_tmp19_ = string_strip (_tmp18_);
					g_hash_table_insert (_tmp13_, _tmp16_, _tmp19_);
					_splitted = (_vala_array_free (_splitted, _splitted_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
				}
			}
			replacement_collection = (_vala_array_free (replacement_collection, replacement_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
}

/**
     * Replaces characters in the given string according to the rules.
     */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
wg_data_parser_replace (const gchar* original)
{
	gchar* replaced = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	GList* _tmp2_;
	gchar* result;
	g_return_val_if_fail (original != NULL, NULL);
	wg_data_parser_load_replacements ();
	_tmp0_ = g_strdup (original);
	replaced = _tmp0_;
	_tmp1_ = wg_data_parser_replacements;
	_tmp2_ = g_hash_table_get_keys (_tmp1_);
	{
		GList* needle_collection = NULL;
		GList* needle_it = NULL;
		needle_collection = _tmp2_;
		for (needle_it = needle_collection; needle_it != NULL; needle_it = needle_it->next) {
			gchar* _tmp3_;
			gchar* needle = NULL;
			_tmp3_ = g_strdup ((const gchar*) needle_it->data);
			needle = _tmp3_;
			{
				gchar* to_replace = NULL;
				GHashTable* _tmp4_;
				const gchar* _tmp5_;
				gconstpointer _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp4_ = wg_data_parser_replacements;
				_tmp5_ = needle;
				_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
				_tmp7_ = g_strdup ((const gchar*) _tmp6_);
				to_replace = _tmp7_;
				_tmp8_ = replaced;
				_tmp9_ = needle;
				_tmp10_ = to_replace;
				_tmp11_ = string_replace (_tmp8_, _tmp9_, _tmp10_);
				_g_free0 (replaced);
				replaced = _tmp11_;
				_tmp12_ = replaced;
				_tmp13_ = needle;
				_tmp14_ = g_utf8_strup (_tmp13_, (gssize) -1);
				_tmp15_ = _tmp14_;
				_tmp16_ = to_replace;
				_tmp17_ = g_utf8_strup (_tmp16_, (gssize) -1);
				_tmp18_ = _tmp17_;
				_tmp19_ = string_replace (_tmp12_, _tmp15_, _tmp18_);
				_g_free0 (replaced);
				replaced = _tmp19_;
				_g_free0 (_tmp18_);
				_g_free0 (_tmp15_);
				_g_free0 (to_replace);
				_g_free0 (needle);
			}
		}
		(needle_collection == NULL) ? NULL : (needle_collection = (g_list_free (needle_collection), NULL));
	}
	result = replaced;
	return result;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
wg_data_parser_get_available_letters (gint* result_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** result;
	_tmp0_ = wg_data_parser__available_letters;
	_tmp0__length1 = wg_data_parser__available_letters_length1;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		_tmp1_ = wg_data_get_available_letters ();
		_tmp2_ = _tmp1_;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "/", 0);
		wg_data_parser__available_letters = (_vala_array_free (wg_data_parser__available_letters, wg_data_parser__available_letters_length1, (GDestroyNotify) g_free), NULL);
		wg_data_parser__available_letters = _tmp4_;
		wg_data_parser__available_letters_length1 = _vala_array_length (_tmp3_);
		_wg_data_parser__available_letters_size_ = wg_data_parser__available_letters_length1;
		_g_free0 (_tmp2_);
	}
	_tmp5_ = wg_data_parser__available_letters;
	_tmp5__length1 = wg_data_parser__available_letters_length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup3 (_tmp5_, _tmp5__length1) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

/**
     * Returns List of Word instances from the dictionary.
     */
static void
_vala_array_add4 (WGDataParserWord** * array,
                  gint* length,
                  gint* size,
                  WGDataParserWord* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WGDataParserWord*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static WGDataParserWord**
_vala_array_dup4 (WGDataParserWord** self,
                  gssize length)
{
	if (length >= 0) {
		WGDataParserWord** result;
		gssize i;
		result = g_new0 (WGDataParserWord*, length + 1);
		for (i = 0; i < length; i++) {
			WGDataParserWord* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

WGDataParserWord**
wg_data_parser_get_dictionary (gint* result_length1)
{
	WGDataParserWord** _tmp0_;
	gint _tmp0__length1;
	WGDataParserWord** _tmp13_;
	gint _tmp13__length1;
	WGDataParserWord** _tmp14_;
	gint _tmp14__length1;
	WGDataParserWord** _tmp15_;
	gint _tmp15__length1;
	WGDataParserWord** result;
	_tmp0_ = wg_data_parser__dictionary;
	_tmp0__length1 = wg_data_parser__dictionary_length1;
	if (_tmp0_ == NULL) {
		WGDataParserWord** _tmp1_;
		gchar** words = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gint words_length1;
		gint _words_size_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp1_ = g_new0 (WGDataParserWord*, 0 + 1);
		wg_data_parser__dictionary = (_vala_array_free (wg_data_parser__dictionary, wg_data_parser__dictionary_length1, (GDestroyNotify) g_object_unref), NULL);
		wg_data_parser__dictionary = _tmp1_;
		wg_data_parser__dictionary_length1 = 0;
		_wg_data_parser__dictionary_size_ = wg_data_parser__dictionary_length1;
		_tmp2_ = wg_data_get_dictionary ();
		_tmp3_ = _tmp2_;
		_tmp4_ = string_strip (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _vala_array_length (_tmp6_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		words = _tmp8_;
		words_length1 = _tmp8__length1;
		_words_size_ = words_length1;
		_tmp9_ = words;
		_tmp9__length1 = words_length1;
		{
			gchar** word_collection = NULL;
			gint word_collection_length1 = 0;
			gint _word_collection_size_ = 0;
			gint word_it = 0;
			word_collection = _tmp9_;
			word_collection_length1 = _tmp9__length1;
			for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
				gchar* _tmp10_;
				gchar* word = NULL;
				_tmp10_ = g_strdup (word_collection[word_it]);
				word = _tmp10_;
				{
					const gchar* _tmp11_;
					WGDataParserWord* _tmp12_;
					_tmp11_ = word;
					_tmp12_ = wg_data_parser_word_new (_tmp11_);
					_vala_array_add4 (&wg_data_parser__dictionary, &wg_data_parser__dictionary_length1, &_wg_data_parser__dictionary_size_, _tmp12_);
					_g_free0 (word);
				}
			}
		}
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp13_ = wg_data_parser__dictionary;
	_tmp13__length1 = wg_data_parser__dictionary_length1;
	_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup4 (_tmp13_, _tmp13__length1) : _tmp13_;
	_tmp14__length1 = _tmp13__length1;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp14__length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gboolean
wg_data_parser_check_if_word_exists (gchar** characters,
                                     gint characters_length1)
{
	gchar* needle = NULL;
	gchar* _tmp0_;
	WGDataParserWord** dict = NULL;
	gint _tmp1_ = 0;
	WGDataParserWord** _tmp2_;
	gint dict_length1;
	gint _dict_size_;
	WGDataParserWord** _tmp3_;
	gint _tmp3__length1;
	gboolean result;
	_tmp0_ = _vala_g_strjoinv ("/", characters, (gint) characters_length1);
	needle = _tmp0_;
	_tmp2_ = wg_data_parser_get_dictionary (&_tmp1_);
	dict = _tmp2_;
	dict_length1 = _tmp1_;
	_dict_size_ = dict_length1;
	_tmp3_ = dict;
	_tmp3__length1 = dict_length1;
	{
		WGDataParserWord** word_collection = NULL;
		gint word_collection_length1 = 0;
		gint _word_collection_size_ = 0;
		gint word_it = 0;
		word_collection = _tmp3_;
		word_collection_length1 = _tmp3__length1;
		for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
			WGDataParserWord* _tmp4_;
			WGDataParserWord* word = NULL;
			_tmp4_ = _g_object_ref0 (word_collection[word_it]);
			word = _tmp4_;
			{
				gchar* current = NULL;
				WGDataParserWord* _tmp5_;
				gchar** _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_ = 0;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				_tmp5_ = word;
				_tmp6_ = wg_data_parser_word_get_characters (_tmp5_, &_tmp7_);
				_tmp6__length1 = _tmp7_;
				_tmp8_ = _tmp6_;
				_tmp8__length1 = _tmp6__length1;
				_tmp9_ = _vala_g_strjoinv ("/", _tmp8_, (gint) _tmp8__length1);
				current = _tmp9_;
				_tmp10_ = needle;
				_tmp11_ = current;
				if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
					result = TRUE;
					_g_free0 (current);
					_g_object_unref0 (word);
					dict = (_vala_array_free (dict, dict_length1, (GDestroyNotify) g_object_unref), NULL);
					_g_free0 (needle);
					return result;
				}
				_g_free0 (current);
				_g_object_unref0 (word);
			}
		}
	}
	result = FALSE;
	dict = (_vala_array_free (dict, dict_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (needle);
	return result;
}

static inline gpointer
wg_data_parser_word_get_instance_private (WGDataParserWord* self)
{
	return G_STRUCT_MEMBER_P (self, WGDataParserWord_private_offset);
}

/**
         * Takes the exact value of the word from the dictionary (with slashes).
         *
         * For example: h/o/u/s/e
         */
WGDataParserWord*
wg_data_parser_word_construct (GType object_type,
                               const gchar* val)
{
	WGDataParserWord * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (val != NULL, NULL);
	_tmp0_ = string_strip (val);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	self = (WGDataParserWord*) g_object_new (object_type, "val", _tmp3_, NULL);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}

WGDataParserWord*
wg_data_parser_word_new (const gchar* val)
{
	return wg_data_parser_word_construct (WG_DATA_PARSER_TYPE_WORD, val);
}

const gchar*
wg_data_parser_word_get_val (WGDataParserWord* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_val;
	result = _tmp0_;
	return result;
}

static void
wg_data_parser_word_set_val (WGDataParserWord* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = wg_data_parser_word_get_val (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_val);
		self->priv->_val = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, wg_data_parser_word_properties[WG_DATA_PARSER_WORD_VAL_PROPERTY]);
	}
}

const gchar*
wg_data_parser_word_get_word (WGDataParserWord* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_word;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->_val;
		_tmp2_ = string_replace (_tmp1_, "/", "");
		_g_free0 (self->priv->_word);
		self->priv->_word = _tmp2_;
	}
	_tmp3_ = self->priv->_word;
	result = _tmp3_;
	return result;
}

const gchar*
wg_data_parser_word_get_replaced (WGDataParserWord* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_replaced;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = wg_data_parser_word_get_word (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = wg_data_parser_replace (_tmp2_);
		_g_free0 (self->priv->_replaced);
		self->priv->_replaced = _tmp3_;
	}
	_tmp4_ = self->priv->_replaced;
	result = _tmp4_;
	return result;
}

gchar**
wg_data_parser_word_get_characters (WGDataParserWord* self,
                                    gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_characters;
	_tmp0__length1 = self->priv->_characters_length1;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		_tmp1_ = self->priv->_val;
		_tmp2_ = wg_data_parser_replace (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "/", 0);
		self->priv->_characters = (_vala_array_free (self->priv->_characters, self->priv->_characters_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_characters = _tmp5_;
		self->priv->_characters_length1 = _vala_array_length (_tmp4_);
		self->priv->__characters_size_ = self->priv->_characters_length1;
		_g_free0 (_tmp3_);
	}
	_tmp6_ = self->priv->_characters;
	_tmp6__length1 = self->priv->_characters_length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

static void
wg_data_parser_word_class_init (WGDataParserWordClass * klass,
                                gpointer klass_data)
{
	wg_data_parser_word_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WGDataParserWord_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_wg_data_parser_word_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_wg_data_parser_word_set_property;
	G_OBJECT_CLASS (klass)->finalize = wg_data_parser_word_finalize;
	/**
	         * The exact value of the word from the dictionary (with slashes).
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), WG_DATA_PARSER_WORD_VAL_PROPERTY, wg_data_parser_word_properties[WG_DATA_PARSER_WORD_VAL_PROPERTY] = g_param_spec_string ("val", "val", "val", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	         * The normal form of the word.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), WG_DATA_PARSER_WORD_WORD_PROPERTY, wg_data_parser_word_properties[WG_DATA_PARSER_WORD_WORD_PROPERTY] = g_param_spec_string ("word", "word", "word", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * The replaced form of the word.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), WG_DATA_PARSER_WORD_REPLACED_PROPERTY, wg_data_parser_word_properties[WG_DATA_PARSER_WORD_REPLACED_PROPERTY] = g_param_spec_string ("replaced", "replaced", "replaced", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Characters of the word with already replaced characters.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), WG_DATA_PARSER_WORD_CHARACTERS_PROPERTY, wg_data_parser_word_properties[WG_DATA_PARSER_WORD_CHARACTERS_PROPERTY] = g_param_spec_boxed ("characters", "characters", "characters", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
wg_data_parser_word_instance_init (WGDataParserWord * self,
                                   gpointer klass)
{
	self->priv = wg_data_parser_word_get_instance_private (self);
}

static void
wg_data_parser_word_finalize (GObject * obj)
{
	WGDataParserWord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WG_DATA_PARSER_TYPE_WORD, WGDataParserWord);
	_g_free0 (self->priv->_val);
	_g_free0 (self->priv->_word);
	_g_free0 (self->priv->_replaced);
	self->priv->_characters = (_vala_array_free (self->priv->_characters, self->priv->_characters_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (wg_data_parser_word_parent_class)->finalize (obj);
}

/**
     * Class representing a word from the dictionary.
     */
static GType
wg_data_parser_word_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WGDataParserWordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wg_data_parser_word_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WGDataParserWord), 0, (GInstanceInitFunc) wg_data_parser_word_instance_init, NULL };
	GType wg_data_parser_word_type_id;
	wg_data_parser_word_type_id = g_type_register_static (G_TYPE_OBJECT, "WGDataParserWord", &g_define_type_info, 0);
	WGDataParserWord_private_offset = g_type_add_instance_private (wg_data_parser_word_type_id, sizeof (WGDataParserWordPrivate));
	return wg_data_parser_word_type_id;
}

GType
wg_data_parser_word_get_type (void)
{
	static volatile gsize wg_data_parser_word_type_id__once = 0;
	if (g_once_init_enter (&wg_data_parser_word_type_id__once)) {
		GType wg_data_parser_word_type_id;
		wg_data_parser_word_type_id = wg_data_parser_word_get_type_once ();
		g_once_init_leave (&wg_data_parser_word_type_id__once, wg_data_parser_word_type_id);
	}
	return wg_data_parser_word_type_id__once;
}

static void
_vala_wg_data_parser_word_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	WGDataParserWord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WG_DATA_PARSER_TYPE_WORD, WGDataParserWord);
	switch (property_id) {
		case WG_DATA_PARSER_WORD_VAL_PROPERTY:
		g_value_set_string (value, wg_data_parser_word_get_val (self));
		break;
		case WG_DATA_PARSER_WORD_WORD_PROPERTY:
		g_value_set_string (value, wg_data_parser_word_get_word (self));
		break;
		case WG_DATA_PARSER_WORD_REPLACED_PROPERTY:
		g_value_set_string (value, wg_data_parser_word_get_replaced (self));
		break;
		case WG_DATA_PARSER_WORD_CHARACTERS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, wg_data_parser_word_get_characters (self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_wg_data_parser_word_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	WGDataParserWord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WG_DATA_PARSER_TYPE_WORD, WGDataParserWord);
	switch (property_id) {
		case WG_DATA_PARSER_WORD_VAL_PROPERTY:
		wg_data_parser_word_set_val (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

