/* Theme.c generated by valac 0.56.17, the Vala compiler
 * generated from Theme.vala, do not modify */

/*
Copyright (C) 2015 2016 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <xmlbird.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_THEME_0_PROPERTY,
	BIRD_FONT_THEME_NUM_PROPERTIES
};
static GParamSpec* bird_font_theme_properties[BIRD_FONT_THEME_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bird_font_color_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_color_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define BIRD_FONT_TYPE_SETTINGS_DISPLAY (bird_font_settings_display_get_type ())
#define BIRD_FONT_SETTINGS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_SETTINGS_DISPLAY, BirdFontSettingsDisplay))
#define BIRD_FONT_SETTINGS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_SETTINGS_DISPLAY, BirdFontSettingsDisplayClass))
#define BIRD_FONT_IS_SETTINGS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_SETTINGS_DISPLAY))
#define BIRD_FONT_IS_SETTINGS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_SETTINGS_DISPLAY))
#define BIRD_FONT_SETTINGS_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_SETTINGS_DISPLAY, BirdFontSettingsDisplayClass))

typedef struct _BirdFontSettingsDisplay BirdFontSettingsDisplay;
typedef struct _BirdFontSettingsDisplayClass BirdFontSettingsDisplayClass;
typedef struct _Block68Data Block68Data;

struct _Block68Data {
	int _ref_count_;
	BirdFontSettingsDisplay* d;
};

static gpointer bird_font_theme_parent_class = NULL;
static GeeHashMap* bird_font_theme_colors;
static GeeHashMap* bird_font_theme_colors = NULL;
GeeArrayList* bird_font_theme_color_list = NULL;
GeeArrayList* bird_font_theme_themes = NULL;
gchar* bird_font_theme_current_theme = NULL;

static void bird_font_theme_add_theme_files (void);
VALA_EXTERN GFile* bird_font_bird_font_get_settings_directory (void);
static void bird_font_theme_parse_theme (GFile* f);
static void bird_font_theme_parse_colors (BTag* tag);
static void bird_font_theme_parse_color (BAttributes* attributes);
VALA_EXTERN GType bird_font_settings_display_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void bird_font_theme_add_new_theme (BirdFontSettingsDisplay* d);
static Block68Data* block68_data_ref (Block68Data* _data68_);
static void block68_data_unref (void * _userdata_);
static void __lambda595_ (const gchar* text);
static void ___lambda595__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda596_ (Block68Data* _data68_);
VALA_EXTERN void bird_font_settings_display_create_setting_items (BirdFontSettingsDisplay* self);
static void ___lambda596__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static void bird_font_theme_finalize (GObject * obj);
static GType bird_font_theme_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
bird_font_theme_text_color (BirdFontText* text,
                            const gchar* name)
{
	BirdFontColor* c = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	BirdFontColor* _tmp6_;
	BirdFontColor* _tmp7_;
	BirdFontColor* _tmp8_;
	BirdFontColor* _tmp9_;
	g_return_if_fail (text != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_theme_colors;
	if (G_UNLIKELY (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name))) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = string_to_string (name);
		_tmp2_ = g_strconcat ("Theme does not have a color for ", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		g_warning ("Theme.vala:31: %s", _tmp3_);
		_g_free0 (_tmp3_);
		_bird_font_color_unref0 (c);
		return;
	}
	_tmp4_ = bird_font_theme_colors;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, name);
	_bird_font_color_unref0 (c);
	c = (BirdFontColor*) _tmp5_;
	_tmp6_ = c;
	_tmp7_ = c;
	_tmp8_ = c;
	_tmp9_ = c;
	bird_font_text_set_source_rgba (text, _tmp6_->r, _tmp7_->g, _tmp8_->b, _tmp9_->a);
	_bird_font_color_unref0 (c);
}

void
bird_font_theme_color (cairo_t* cr,
                       const gchar* name)
{
	BirdFontColor* c = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	BirdFontColor* _tmp6_;
	BirdFontColor* _tmp7_;
	BirdFontColor* _tmp8_;
	BirdFontColor* _tmp9_;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_theme_colors;
	if (G_UNLIKELY (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name))) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = string_to_string (name);
		_tmp2_ = g_strconcat ("Theme does not have a color for ", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		g_warning ("Theme.vala:43: %s", _tmp3_);
		_g_free0 (_tmp3_);
		_bird_font_color_unref0 (c);
		return;
	}
	_tmp4_ = bird_font_theme_colors;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, name);
	_bird_font_color_unref0 (c);
	c = (BirdFontColor*) _tmp5_;
	_tmp6_ = c;
	_tmp7_ = c;
	_tmp8_ = c;
	_tmp9_ = c;
	cairo_set_source_rgba (cr, _tmp6_->r, _tmp7_->g, _tmp8_->b, _tmp9_->a);
	_bird_font_color_unref0 (c);
}

void
bird_font_theme_color_opacity (cairo_t* cr,
                               const gchar* name,
                               gdouble opacity)
{
	BirdFontColor* c = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	BirdFontColor* _tmp6_;
	BirdFontColor* _tmp7_;
	BirdFontColor* _tmp8_;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_theme_colors;
	if (G_UNLIKELY (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name))) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = string_to_string (name);
		_tmp2_ = g_strconcat ("Theme does not have a color for ", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		g_warning ("Theme.vala:55: %s", _tmp3_);
		_g_free0 (_tmp3_);
		_bird_font_color_unref0 (c);
		return;
	}
	_tmp4_ = bird_font_theme_colors;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, name);
	_bird_font_color_unref0 (c);
	c = (BirdFontColor*) _tmp5_;
	_tmp6_ = c;
	_tmp7_ = c;
	_tmp8_ = c;
	cairo_set_source_rgba (cr, _tmp6_->r, _tmp7_->g, _tmp8_->b, opacity);
	_bird_font_color_unref0 (c);
}

void
bird_font_theme_gradient (cairo_pattern_t* p,
                          const gchar* name1,
                          const gchar* name2)
{
	BirdFontColor* c1 = NULL;
	BirdFontColor* _tmp0_;
	BirdFontColor* c2 = NULL;
	BirdFontColor* _tmp1_;
	g_return_if_fail (p != NULL);
	g_return_if_fail (name1 != NULL);
	g_return_if_fail (name2 != NULL);
	_tmp0_ = bird_font_theme_get_color (name1);
	c1 = _tmp0_;
	_tmp1_ = bird_font_theme_get_color (name2);
	c2 = _tmp1_;
	cairo_pattern_add_color_stop_rgba (p, (gdouble) 1, c1->r, c1->g, c1->b, c1->a);
	cairo_pattern_add_color_stop_rgba (p, (gdouble) 0, c2->r, c2->g, c2->b, c2->a);
	_bird_font_color_unref0 (c2);
	_bird_font_color_unref0 (c1);
}

void
bird_font_theme_text_color_opacity (BirdFontText* text,
                                    const gchar* name,
                                    gdouble opacity)
{
	BirdFontColor* c = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	BirdFontColor* _tmp6_;
	BirdFontColor* _tmp7_;
	BirdFontColor* _tmp8_;
	g_return_if_fail (text != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_theme_colors;
	if (G_UNLIKELY (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name))) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = string_to_string (name);
		_tmp2_ = g_strconcat ("Theme does not have a color for ", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		g_warning ("Theme.vala:75: %s", _tmp3_);
		_g_free0 (_tmp3_);
		_bird_font_color_unref0 (c);
		return;
	}
	_tmp4_ = bird_font_theme_colors;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, name);
	_bird_font_color_unref0 (c);
	c = (BirdFontColor*) _tmp5_;
	_tmp6_ = c;
	_tmp7_ = c;
	_tmp8_ = c;
	bird_font_text_set_source_rgba (text, _tmp6_->r, _tmp7_->g, _tmp8_->b, opacity);
	_bird_font_color_unref0 (c);
}

BirdFontColor*
bird_font_theme_get_color (const gchar* name)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp5_;
	gpointer _tmp6_;
	BirdFontColor* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = bird_font_theme_colors;
	if (G_UNLIKELY (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name))) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		BirdFontColor* _tmp4_;
		_tmp1_ = string_to_string (name);
		_tmp2_ = g_strconcat ("Theme does not have a color for ", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		g_warning ("Theme.vala:85: %s", _tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = bird_font_color_new ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = bird_font_theme_colors;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, name);
	result = (BirdFontColor*) _tmp6_;
	return result;
}

void
bird_font_theme_set_default_colors (void)
{
	gchar* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeArrayList* _tmp3_;
	_tmp0_ = g_strdup ("dark.theme");
	_g_free0 (bird_font_theme_current_theme);
	bird_font_theme_current_theme = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (bird_font_theme_color_list);
	bird_font_theme_color_list = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, BIRD_FONT_TYPE_COLOR, (GBoxedCopyFunc) bird_font_color_ref, (GDestroyNotify) bird_font_color_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (bird_font_theme_colors);
	bird_font_theme_colors = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (bird_font_theme_themes);
	bird_font_theme_themes = _tmp3_;
	bird_font_theme_add_theme_files ();
	bird_font_theme_set_default_color ("Canvas Background", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Filled Stroke", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Stroke Color", 141 / 255.0, 141 / 255.0, 141 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Handle Color", 141 / 255.0, 141 / 255.0, 141 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Fill Color", 0.5, 0.5, 0.5, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Objects", 35 / 255.0, 131 / 255.0, 194 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Background 1", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Dialog Background", 238 / 255.0, 239 / 255.0, 243 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Menu Background", 222 / 255.0, 221 / 255.0, 226 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Default Background", 238 / 255.0, 239 / 255.0, 243 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Headline Background", 110 / 255.0, 113 / 255.0, 130 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Checkbox Background", 255 / 255.0, 255 / 255.0, 255 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Foreground 1", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Text Foreground", 3 / 255.0, 16 / 255.0, 24 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Text Tool Box", 3 / 255.0, 16 / 255.0, 24 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Text Tab Bar", 3 / 255.0, 16 / 255.0, 24 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Tab Foreground", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Menu Foreground", 3 / 255.0, 16 / 255.0, 24 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Table Border", 26 / 255.0, 30 / 255.0, 32 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selection Border", 40 / 255.0, 57 / 255.0, 65 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Glyph", 219 / 255.0, 221 / 255.0, 233 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Table Background 1", 238 / 255.0, 239 / 255.0, 243 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Table Background 2", 225 / 255.0, 227 / 255.0, 233 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Tab Separator", 207 / 255.0, 210 / 255.0, 215 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Foreground Inverted", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Highlighted 1", 159 / 255.0, 165 / 255.0, 192 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Highlighted Guide", (gdouble) 0, (gdouble) 0, 0.3, (gdouble) 1);
	bird_font_theme_set_default_color ("Guide 1", 0.7, 0.7, 0.8, (gdouble) 1);
	bird_font_theme_set_default_color ("Guide 2", 0.7, (gdouble) 0, (gdouble) 0, 0.5);
	bird_font_theme_set_default_color ("Guide 3", 120 / 255.0, 68 / 255.0, 120 / 255.0, 120 / 255.0);
	bird_font_theme_set_default_color ("Grid", 0.2, 0.6, 0.2, 0.2);
	bird_font_theme_set_default_color ("Background Glyph", 0.2, 0.2, 0.2, 0.5);
	bird_font_theme_set_default_color ("Button Border 1", 173 / 255.0, 176 / 255.0, 188 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Background 1", 211 / 255.0, 212 / 255.0, 216 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Border 2", 173 / 255.0, 176 / 255.0, 188 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Background 2", 211 / 255.0, 212 / 255.0, 216 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Border 3", 173 / 255.0, 176 / 255.0, 188 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Background 3", 242 / 255.0, 246 / 255.0, 246 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Border 4", 173 / 255.0, 176 / 255.0, 188 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Background 4", 233 / 255.0, 233 / 255.0, 233 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Foreground", 3 / 255.0, 16 / 255.0, 24 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Button Foreground", 3 / 255.0, 16 / 255.0, 24 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Tool Foreground", 3 / 255.0, 16 / 255.0, 24 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Tool Foreground", 3 / 255.0, 16 / 255.0, 24 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Text Area Background", 255 / 255.0, 255 / 255.0, 255 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Item Border", 207 / 255.0, 210 / 255.0, 215 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Overview Item", 211 / 255.0, 212 / 255.0, 216 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Item 1", 236 / 255.0, 236 / 255.0, 236 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Item 2", 246 / 255.0, 246 / 255.0, 246 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Selected Foreground", 45 / 255.0, 45 / 255.0, 45 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Foreground", 45 / 255.0, 45 / 255.0, 45 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Glyph Count Background 1", 255 / 255.0, 255 / 255.0, 255 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Glyph Count Background 2", 255 / 255.0, 255 / 255.0, 255 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Dialog Shadow", (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.3);
	bird_font_theme_set_default_color ("Selected Active Cubic Control Point", 0 / 255.0, 112 / 255.0, 244 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Cubic Control Point", 0 / 255.0, 112 / 255.0, 244 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Active Cubic Control Point", 70 / 255.0, 70 / 255.0, 70 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Cubic Control Point", 116 / 255.0, 116 / 255.0, 116 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Active Quadratic Control Point", 0 / 255.0, 112 / 255.0, 244 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Quadratic Control Point", 0 / 255.0, 112 / 255.0, 244 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Active Quadratic Control Point", 85 / 255.0, 115 / 255.0, 149 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Quadratic Control Point", 123 / 255.0, 151 / 255.0, 184 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Control Point Handle", 0 / 255.0, 112 / 255.0, 244 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Active Handle", 21 / 255.0, 44 / 255.0, 25 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Control Point Handle", 81 / 255.0, 147 / 255.0, 90 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Merge", 167 / 255.0, 170 / 255.0, 178 / 255.0, 0.3);
	bird_font_theme_set_default_color ("Spin Button", 164 / 255.0, 167 / 255.0, 175 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Active Spin Button", 104 / 255.0, 108 / 255.0, 119 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Zoom Bar Border", 122 / 255.0, 131 / 255.0, 145 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Font Name", 0 / 255.0, 0 / 255.0, 0 / 255.0, (gdouble) 1);
	if (bird_font_bird_font_has_argument ("--test")) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("generated_theme.theme");
		_g_free0 (bird_font_theme_current_theme);
		bird_font_theme_current_theme = _tmp4_;
		bird_font_theme_write_theme ();
	}
	bird_font_theme_set_default_color ("Canvas Background", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Filled Stroke", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Stroke Color", 141 / 255.0, 141 / 255.0, 141 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Handle Color", 141 / 255.0, 141 / 255.0, 141 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Fill Color", 0.5, 0.5, 0.5, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Objects", 35 / 255.0, 131 / 255.0, 194 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Background 1", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Dialog Background", 55 / 255.0, 56 / 255.0, 62 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Menu Background", 43 / 255.0, 42 / 255.0, 47 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Default Background", 55 / 255.0, 56 / 255.0, 62 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Headline Background", 101 / 255.0, 108 / 255.0, 116 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Checkbox Background", 101 / 255.0, 108 / 255.0, 116 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Foreground 1", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Text Foreground", 0 / 255.0, 0 / 255.0, 0 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Text Tool Box", 128 / 255.0, 130 / 255.0, 136 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Text Tab Bar", 128 / 255.0, 130 / 255.0, 136 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Tab Foreground", 38 / 255.0, 36 / 255.0, 39 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Menu Foreground", 128 / 255.0, 130 / 255.0, 136 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Table Border", 26 / 255.0, 30 / 255.0, 32 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selection Border", 40 / 255.0, 57 / 255.0, 65 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Glyph", 219 / 255.0, 221 / 255.0, 233 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Table Background 1", 238 / 255.0, 239 / 255.0, 243 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Table Background 2", 225 / 255.0, 227 / 255.0, 233 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Tab Separator", 123 / 255.0, 127 / 255.0, 132 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Foreground Inverted", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Highlighted 1", 234 / 255.0, 77 / 255.0, 26 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Highlighted Guide", (gdouble) 0, (gdouble) 0, 0.3, (gdouble) 1);
	bird_font_theme_set_default_color ("Guide 1", 0.7, 0.7, 0.8, (gdouble) 1);
	bird_font_theme_set_default_color ("Guide 2", 0.7, (gdouble) 0, (gdouble) 0, 0.5);
	bird_font_theme_set_default_color ("Guide 3", 120 / 255.0, 68 / 255.0, 120 / 255.0, 120 / 255.0);
	bird_font_theme_set_default_color ("Grid", 0.2, 0.6, 0.2, 0.2);
	bird_font_theme_set_default_color ("Background Glyph", 0.2, 0.2, 0.2, 0.5);
	bird_font_theme_set_default_color ("Button Border 1", 39 / 255.0, 40 / 255.0, 44 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Background 1", 25 / 255.0, 28 / 255.0, 30 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Border 2", 39 / 255.0, 40 / 255.0, 44 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Background 2", 25 / 255.0, 28 / 255.0, 30 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Border 3", 39 / 255.0, 40 / 255.0, 44 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Background 3", 44 / 255.0, 47 / 255.0, 51 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Border 4", 39 / 255.0, 40 / 255.0, 44 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Background 4", 38 / 255.0, 41 / 255.0, 44 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Foreground", 255 / 255.0, 255 / 255.0, 255 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Button Foreground", 107 / 255.0, 112 / 255.0, 122 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Tool Foreground", 123 / 255.0, 127 / 255.0, 132 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Tool Foreground", 123 / 255.0, 127 / 255.0, 132 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Text Area Background", 101 / 255.0, 108 / 255.0, 116 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Item Border", 207 / 255.0, 210 / 255.0, 215 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Overview Item", 211 / 255.0, 212 / 255.0, 216 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Item 1", 236 / 255.0, 236 / 255.0, 236 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Item 2", 246 / 255.0, 246 / 255.0, 246 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Selected Foreground", 45 / 255.0, 45 / 255.0, 45 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Foreground", 45 / 255.0, 45 / 255.0, 45 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Glyph Count Background 1", 92 / 255.0, 106 / 255.0, 117 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Glyph Count Background 2", 92 / 255.0, 106 / 255.0, 117 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Dialog Shadow", (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.3);
	bird_font_theme_set_default_color ("Selected Active Cubic Control Point", 234 / 255.0, 77 / 255.0, 26 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Cubic Control Point", 234 / 255.0, 77 / 255.0, 26 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Active Cubic Control Point", 70 / 255.0, 70 / 255.0, 70 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Cubic Control Point", 116 / 255.0, 116 / 255.0, 116 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Active Quadratic Control Point", 234 / 255.0, 77 / 255.0, 26 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Quadratic Control Point", 234 / 255.0, 77 / 255.0, 26 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Active Quadratic Control Point", 85 / 255.0, 115 / 255.0, 149 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Quadratic Control Point", 123 / 255.0, 151 / 255.0, 184 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Control Point Handle", 234 / 255.0, 77 / 255.0, 26 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Active Handle", 21 / 255.0, 44 / 255.0, 25 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Merge", 167 / 255.0, 170 / 255.0, 178 / 255.0, 0.3);
	bird_font_theme_set_default_color ("Spin Button", 107 / 255.0, 112 / 255.0, 122 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Active Spin Button", 107 / 255.0, 112 / 255.0, 122 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Zoom Bar Border", 38 / 255.0, 39 / 255.0, 43 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Font Name", 234 / 255.0, 77 / 255.0, 26 / 255.0, (gdouble) 1);
	if (bird_font_bird_font_has_argument ("--test")) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("generated_dark_theme.theme");
		_g_free0 (bird_font_theme_current_theme);
		bird_font_theme_current_theme = _tmp5_;
		bird_font_theme_write_theme ();
	}
	bird_font_theme_set_default_color ("Canvas Background", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Filled Stroke", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Stroke Color", 141 / 255.0, 141 / 255.0, 141 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Handle Color", 141 / 255.0, 141 / 255.0, 141 / 255.0, (gdouble) 1);
	bird_font_theme_set_default_color ("Fill Color", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Objects", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Background 1", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Dialog Background", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Menu Background", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Default Background", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Headline Background", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Checkbox Background", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Foreground 1", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Text Foreground", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Text Tool Box", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Text Tab Bar", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Tab Foreground", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Menu Foreground", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Table Border", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selection Border", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Glyph", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Table Background 1", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Table Background 2", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Tab Separator", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Foreground Inverted", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Highlighted 1", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Highlighted Guide", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Guide 1", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Guide 2", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Guide 3", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Grid", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Background Glyph", 0.2, 0.2, 0.2, 0.5);
	bird_font_theme_set_default_color ("Button Border 1", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Background 1", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Border 2", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Background 2", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Border 3", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Background 3", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Border 4", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Background 4", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Button Foreground", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Button Foreground", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Tool Foreground", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Tool Foreground", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Text Area Background", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Item Border", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Overview Item", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Item 1", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Item 2", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Selected Foreground", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Overview Foreground", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Glyph Count Background 1", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Glyph Count Background 2", (gdouble) 1, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	bird_font_theme_set_default_color ("Dialog Shadow", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Active Cubic Control Point", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Cubic Control Point", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Active Cubic Control Point", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Cubic Control Point", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Active Quadratic Control Point", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Quadratic Control Point", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Active Quadratic Control Point", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Quadratic Control Point", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Selected Control Point Handle", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Active Handle", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Control Point Handle", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Merge", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Spin Button", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Active Spin Button", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Zoom Bar Border", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	bird_font_theme_set_default_color ("Font Name", (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	if (bird_font_bird_font_has_argument ("--test")) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("generated_high_contrast.theme");
		_g_free0 (bird_font_theme_current_theme);
		bird_font_theme_current_theme = _tmp6_;
		bird_font_theme_write_theme ();
	}
	bird_font_theme_load_theme ("dark.theme");
	if (bird_font_bird_font_has_argument ("--test")) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		gchar* _tmp100_;
		gchar* _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		gchar* _tmp105_;
		gchar* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		gchar* _tmp112_;
		gchar* _tmp113_;
		gchar* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
		gchar* _tmp118_;
		gchar* _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		gchar* _tmp124_;
		gchar* _tmp125_;
		gchar* _tmp126_;
		gchar* _tmp127_;
		gchar* _tmp128_;
		gchar* _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		gchar* _tmp132_;
		gchar* _tmp133_;
		gchar* _tmp134_;
		_tmp7_ = bird_font_t_ ("Canvas Background");
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp8_);
		_tmp9_ = bird_font_t_ ("Filled Stroke");
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp10_);
		_tmp11_ = bird_font_t_ ("Stroke Color");
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp12_);
		_tmp13_ = bird_font_t_ ("Handle Color");
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp14_);
		_tmp15_ = bird_font_t_ ("Fill Color");
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp16_);
		_tmp17_ = bird_font_t_ ("Selected Objects");
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp18_);
		_tmp19_ = bird_font_t_ ("Background 1");
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp20_);
		_tmp21_ = bird_font_t_ ("Dialog Background");
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp22_);
		_tmp23_ = bird_font_t_ ("Menu Background");
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp24_);
		_tmp25_ = bird_font_t_ ("Default Background");
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp26_);
		_tmp27_ = bird_font_t_ ("Checkbox Background");
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp28_);
		_tmp29_ = bird_font_t_ ("Foreground 1");
		_tmp30_ = _tmp29_;
		_g_free0 (_tmp30_);
		_tmp31_ = bird_font_t_ ("Text Foreground");
		_tmp32_ = _tmp31_;
		_g_free0 (_tmp32_);
		_tmp33_ = bird_font_t_ ("Table Border");
		_tmp34_ = _tmp33_;
		_g_free0 (_tmp34_);
		_tmp35_ = bird_font_t_ ("Selection Border");
		_tmp36_ = _tmp35_;
		_g_free0 (_tmp36_);
		_tmp37_ = bird_font_t_ ("Overview Glyph");
		_tmp38_ = _tmp37_;
		_g_free0 (_tmp38_);
		_tmp39_ = bird_font_t_ ("Foreground Inverted");
		_tmp40_ = _tmp39_;
		_g_free0 (_tmp40_);
		_tmp41_ = bird_font_t_ ("Menu Foreground");
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp42_);
		_tmp43_ = bird_font_t_ ("Selected Tab Foreground");
		_tmp44_ = _tmp43_;
		_g_free0 (_tmp44_);
		_tmp45_ = bird_font_t_ ("Tab Separator");
		_tmp46_ = _tmp45_;
		_g_free0 (_tmp46_);
		_tmp47_ = bird_font_t_ ("Highlighted 1");
		_tmp48_ = _tmp47_;
		_g_free0 (_tmp48_);
		_tmp49_ = bird_font_t_ ("Highlighted Guide");
		_tmp50_ = _tmp49_;
		_g_free0 (_tmp50_);
		_tmp51_ = bird_font_t_ ("Grid");
		_tmp52_ = _tmp51_;
		_g_free0 (_tmp52_);
		_tmp53_ = bird_font_t_ ("Guide 1");
		_tmp54_ = _tmp53_;
		_g_free0 (_tmp54_);
		_tmp55_ = bird_font_t_ ("Guide 2");
		_tmp56_ = _tmp55_;
		_g_free0 (_tmp56_);
		_tmp57_ = bird_font_t_ ("Guide 3");
		_tmp58_ = _tmp57_;
		_g_free0 (_tmp58_);
		_tmp59_ = bird_font_t_ ("Button Border 1");
		_tmp60_ = _tmp59_;
		_g_free0 (_tmp60_);
		_tmp61_ = bird_font_t_ ("Button Background 1");
		_tmp62_ = _tmp61_;
		_g_free0 (_tmp62_);
		_tmp63_ = bird_font_t_ ("Button Border 2");
		_tmp64_ = _tmp63_;
		_g_free0 (_tmp64_);
		_tmp65_ = bird_font_t_ ("Button Background 2");
		_tmp66_ = _tmp65_;
		_g_free0 (_tmp66_);
		_tmp67_ = bird_font_t_ ("Button Border 3");
		_tmp68_ = _tmp67_;
		_g_free0 (_tmp68_);
		_tmp69_ = bird_font_t_ ("Button Background 3");
		_tmp70_ = _tmp69_;
		_g_free0 (_tmp70_);
		_tmp71_ = bird_font_t_ ("Button Border 4");
		_tmp72_ = _tmp71_;
		_g_free0 (_tmp72_);
		_tmp73_ = bird_font_t_ ("Button Background 4");
		_tmp74_ = _tmp73_;
		_g_free0 (_tmp74_);
		_tmp75_ = bird_font_t_ ("Button Foreground");
		_tmp76_ = _tmp75_;
		_g_free0 (_tmp76_);
		_tmp77_ = bird_font_t_ ("Selected Button Foreground");
		_tmp78_ = _tmp77_;
		_g_free0 (_tmp78_);
		_tmp79_ = bird_font_t_ ("Tool Foreground");
		_tmp80_ = _tmp79_;
		_g_free0 (_tmp80_);
		_tmp81_ = bird_font_t_ ("Selected Tool Foreground");
		_tmp82_ = _tmp81_;
		_g_free0 (_tmp82_);
		_tmp83_ = bird_font_t_ ("Text Area Background");
		_tmp84_ = _tmp83_;
		_g_free0 (_tmp84_);
		_tmp85_ = bird_font_t_ ("Overview Item Border");
		_tmp86_ = _tmp85_;
		_g_free0 (_tmp86_);
		_tmp87_ = bird_font_t_ ("Selected Overview Item");
		_tmp88_ = _tmp87_;
		_g_free0 (_tmp88_);
		_tmp89_ = bird_font_t_ ("Overview Item 1");
		_tmp90_ = _tmp89_;
		_g_free0 (_tmp90_);
		_tmp91_ = bird_font_t_ ("Overview Item 2");
		_tmp92_ = _tmp91_;
		_g_free0 (_tmp92_);
		_tmp93_ = bird_font_t_ ("Overview Selected Foreground");
		_tmp94_ = _tmp93_;
		_g_free0 (_tmp94_);
		_tmp95_ = bird_font_t_ ("Overview Foreground");
		_tmp96_ = _tmp95_;
		_g_free0 (_tmp96_);
		_tmp97_ = bird_font_t_ ("Glyph Count Background 1");
		_tmp98_ = _tmp97_;
		_g_free0 (_tmp98_);
		_tmp99_ = bird_font_t_ ("Glyph Count Background 2");
		_tmp100_ = _tmp99_;
		_g_free0 (_tmp100_);
		_tmp101_ = bird_font_t_ ("Dialog Shadow");
		_tmp102_ = _tmp101_;
		_g_free0 (_tmp102_);
		_tmp103_ = bird_font_t_ ("Selected Active Cubic Control Point");
		_tmp104_ = _tmp103_;
		_g_free0 (_tmp104_);
		_tmp105_ = bird_font_t_ ("Selected Cubic Control Point");
		_tmp106_ = _tmp105_;
		_g_free0 (_tmp106_);
		_tmp107_ = bird_font_t_ ("Active Cubic Control Point");
		_tmp108_ = _tmp107_;
		_g_free0 (_tmp108_);
		_tmp109_ = bird_font_t_ ("Cubic Control Point");
		_tmp110_ = _tmp109_;
		_g_free0 (_tmp110_);
		_tmp111_ = bird_font_t_ ("Selected Active Quadratic Control Point");
		_tmp112_ = _tmp111_;
		_g_free0 (_tmp112_);
		_tmp113_ = bird_font_t_ ("Selected Quadratic Control Point");
		_tmp114_ = _tmp113_;
		_g_free0 (_tmp114_);
		_tmp115_ = bird_font_t_ ("Active Quadratic Control Point");
		_tmp116_ = _tmp115_;
		_g_free0 (_tmp116_);
		_tmp117_ = bird_font_t_ ("Cubic Quadratic Point");
		_tmp118_ = _tmp117_;
		_g_free0 (_tmp118_);
		_tmp119_ = bird_font_t_ ("Selected Control Point Handle");
		_tmp120_ = _tmp119_;
		_g_free0 (_tmp120_);
		_tmp121_ = bird_font_t_ ("Active Handle");
		_tmp122_ = _tmp121_;
		_g_free0 (_tmp122_);
		_tmp123_ = bird_font_t_ ("Control Point Handle");
		_tmp124_ = _tmp123_;
		_g_free0 (_tmp124_);
		_tmp125_ = bird_font_t_ ("Merge");
		_tmp126_ = _tmp125_;
		_g_free0 (_tmp126_);
		_tmp127_ = bird_font_t_ ("Spin Button");
		_tmp128_ = _tmp127_;
		_g_free0 (_tmp128_);
		_tmp129_ = bird_font_t_ ("Active Spin Button");
		_tmp130_ = _tmp129_;
		_g_free0 (_tmp130_);
		_tmp131_ = bird_font_t_ ("Zoom Bar Border");
		_tmp132_ = _tmp131_;
		_g_free0 (_tmp132_);
		_tmp133_ = bird_font_t_ ("Font Name");
		_tmp134_ = _tmp133_;
		_g_free0 (_tmp134_);
	}
}

static void
bird_font_theme_add_theme_files (void)
{
	GFileEnumerator* enumerator = NULL;
	GFileInfo* file_info = NULL;
	gchar* file_name = NULL;
	GFile* dir = NULL;
	GFile* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = bird_font_bird_font_get_settings_directory ();
	_g_object_unref0 (dir);
	dir = _tmp0_;
	_tmp1_ = bird_font_theme_themes;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	_tmp2_ = bird_font_theme_themes;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, "dark.theme");
	_tmp3_ = bird_font_theme_themes;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, "bright.theme");
	_tmp4_ = bird_font_theme_themes;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, "high_contrast.theme");
	{
		GFileEnumerator* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileEnumerator* _tmp7_;
		GFileEnumerator* _tmp8_;
		_tmp6_ = dir;
		_tmp7_ = g_file_enumerate_children (_tmp6_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (enumerator);
		enumerator = _tmp8_;
		while (TRUE) {
			GFileInfo* _tmp9_ = NULL;
			GFileEnumerator* _tmp10_;
			GFileInfo* _tmp11_;
			GFileInfo* _tmp12_;
			GFileInfo* _tmp13_;
			GFileInfo* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp10_ = enumerator;
			_tmp11_ = g_file_enumerator_next_file (_tmp10_, NULL, &_inner_error0_);
			_tmp9_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp5_);
				goto __catch0_g_error;
			}
			_tmp12_ = _tmp9_;
			_tmp9_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp12_;
			_tmp13_ = file_info;
			if (!(_tmp13_ != NULL)) {
				_g_object_unref0 (_tmp9_);
				break;
			}
			_tmp14_ = file_info;
			_tmp15_ = g_file_info_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_file_info_get_type (), GFileInfo));
			_tmp16_ = g_strdup (_tmp15_);
			_g_free0 (file_name);
			file_name = _tmp16_;
			_tmp17_ = file_name;
			if (g_str_has_suffix (_tmp17_, ".theme")) {
				GeeArrayList* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = bird_font_theme_themes;
				_tmp19_ = file_name;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
			}
			_g_object_unref0 (_tmp9_);
		}
		_g_object_unref0 (_tmp5_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("Theme.vala:528: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dir);
		_g_free0 (file_name);
		_g_object_unref0 (file_info);
		_g_object_unref0 (enumerator);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (dir);
	_g_free0 (file_name);
	_g_object_unref0 (file_info);
	_g_object_unref0 (enumerator);
}

void
bird_font_theme_set_default_color (const gchar* name,
                                   gdouble r,
                                   gdouble g,
                                   gdouble b,
                                   gdouble a)
{
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	BirdFontColor* _tmp2_;
	BirdFontColor* _tmp3_;
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_theme_color_list;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, name);
	_tmp1_ = bird_font_theme_colors;
	_tmp2_ = bird_font_color_new (r, g, b, a);
	_tmp3_ = _tmp2_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, name, _tmp3_);
	_bird_font_color_unref0 (_tmp3_);
}

void
bird_font_theme_save_color (const gchar* name,
                            gdouble r,
                            gdouble g,
                            gdouble b,
                            gdouble a)
{
	GeeHashMap* _tmp0_;
	BirdFontColor* _tmp1_;
	BirdFontColor* _tmp2_;
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_theme_colors;
	_tmp1_ = bird_font_color_new (r, g, b, a);
	_tmp2_ = _tmp1_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, name, _tmp2_);
	_bird_font_color_unref0 (_tmp2_);
	bird_font_theme_write_theme ();
}

void
bird_font_theme_load_theme (const gchar* theme_file)
{
	GFile* default_theme = NULL;
	GFile* user_theme = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_if_fail (theme_file != NULL);
	_tmp0_ = bird_font_bird_font_get_settings_directory ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_get_child (_tmp1_, theme_file);
	_g_object_unref0 (user_theme);
	user_theme = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_tmp3_ = user_theme;
	if (g_file_query_exists (_tmp3_, NULL)) {
		gchar* _tmp4_;
		GFile* _tmp5_;
		_tmp4_ = g_strdup (theme_file);
		_g_free0 (bird_font_theme_current_theme);
		bird_font_theme_current_theme = _tmp4_;
		_tmp5_ = user_theme;
		bird_font_theme_parse_theme (_tmp5_);
		_g_object_unref0 (user_theme);
		_g_object_unref0 (default_theme);
		return;
	}
	_tmp6_ = bird_font_search_paths_find_file (NULL, theme_file);
	_g_object_unref0 (default_theme);
	default_theme = _tmp6_;
	_tmp7_ = default_theme;
	if (g_file_query_exists (_tmp7_, NULL)) {
		gchar* _tmp8_;
		GFile* _tmp9_;
		_tmp8_ = g_strdup (theme_file);
		_g_free0 (bird_font_theme_current_theme);
		bird_font_theme_current_theme = _tmp8_;
		_tmp9_ = default_theme;
		bird_font_theme_parse_theme (_tmp9_);
		_g_object_unref0 (user_theme);
		_g_object_unref0 (default_theme);
		return;
	}
	_tmp10_ = string_to_string (theme_file);
	_tmp11_ = g_strconcat ("Theme not found: ", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	g_warning ("Theme.vala:560: %s", _tmp12_);
	_g_free0 (_tmp12_);
	_g_object_unref0 (user_theme);
	_g_object_unref0 (default_theme);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

void
bird_font_theme_write_theme (void)
{
	GDataOutputStream* os = NULL;
	GFile* file = NULL;
	gint i = 0;
	gchar* base_name = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	const gchar* _tmp25_;
	GFile* _tmp26_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = bird_font_theme_current_theme;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		g_warning ("Theme.vala:570: No name for theme.");
		_g_free0 (base_name);
		_g_object_unref0 (file);
		_g_object_unref0 (os);
		return;
	}
	_tmp3_ = bird_font_theme_current_theme;
	if (g_strcmp0 (_tmp3_, "dark.theme") == 0) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = bird_font_theme_current_theme;
		_tmp2_ = g_strcmp0 (_tmp4_, "bright.theme") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = bird_font_theme_current_theme;
		_tmp1_ = g_strcmp0 (_tmp5_, "high_contrast.theme") == 0;
	}
	if (_tmp1_) {
		gchar* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		const gchar* _tmp9_;
		GFile* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = g_strdup ("custom.theme");
		_g_free0 (bird_font_theme_current_theme);
		bird_font_theme_current_theme = _tmp6_;
		_tmp7_ = bird_font_bird_font_get_settings_directory ();
		_tmp8_ = _tmp7_;
		_tmp9_ = bird_font_theme_current_theme;
		_tmp10_ = bird_font_get_child (_tmp8_, _tmp9_);
		_g_object_unref0 (file);
		file = _tmp10_;
		_g_object_unref0 (_tmp8_);
		i = 2;
		_tmp11_ = g_strdup ("custom");
		_g_free0 (base_name);
		base_name = _tmp11_;
		while (TRUE) {
			GFile* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			GFile* _tmp18_;
			GFile* _tmp19_;
			const gchar* _tmp20_;
			GFile* _tmp21_;
			gint _tmp22_;
			_tmp12_ = file;
			if (!g_file_query_exists (_tmp12_, NULL)) {
				break;
			}
			_tmp13_ = base_name;
			_tmp14_ = string_to_string (_tmp13_);
			_tmp15_ = g_strdup_printf ("%i", i);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (_tmp14_, "_", _tmp16_, ".theme", NULL);
			_g_free0 (bird_font_theme_current_theme);
			bird_font_theme_current_theme = _tmp17_;
			_g_free0 (_tmp16_);
			_tmp18_ = bird_font_bird_font_get_settings_directory ();
			_tmp19_ = _tmp18_;
			_tmp20_ = bird_font_theme_current_theme;
			_tmp21_ = bird_font_get_child (_tmp19_, _tmp20_);
			_g_object_unref0 (file);
			file = _tmp21_;
			_g_object_unref0 (_tmp19_);
			_tmp22_ = i;
			i = _tmp22_ + 1;
		}
	}
	_tmp23_ = bird_font_bird_font_get_settings_directory ();
	_tmp24_ = _tmp23_;
	_tmp25_ = bird_font_theme_current_theme;
	_tmp26_ = bird_font_get_child (_tmp24_, _tmp25_);
	_g_object_unref0 (file);
	file = _tmp26_;
	_g_object_unref0 (_tmp24_);
	{
		GFile* _tmp27_;
		_tmp27_ = file;
		if (g_file_query_exists (_tmp27_, NULL)) {
			GFile* _tmp28_;
			_tmp28_ = file;
			g_file_delete (_tmp28_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("Theme.vala:597: %s", _tmp30_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (base_name);
		_g_object_unref0 (file);
		_g_object_unref0 (os);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GFileOutputStream* _tmp31_ = NULL;
		GFile* _tmp32_;
		GFileOutputStream* _tmp33_;
		GDataOutputStream* _tmp34_;
		GDataOutputStream* _tmp35_;
		GDataOutputStream* _tmp36_;
		GDataOutputStream* _tmp37_;
		GDataOutputStream* _tmp83_;
		GDataOutputStream* _tmp84_;
		_tmp32_ = file;
		_tmp33_ = g_file_create (_tmp32_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp31_ = _tmp33_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp34_ = g_data_output_stream_new ((GOutputStream*) _tmp31_);
		_g_object_unref0 (os);
		os = _tmp34_;
		_tmp35_ = os;
		g_data_output_stream_put_string (_tmp35_, "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp31_);
			goto __catch1_g_error;
		}
		_tmp36_ = os;
		g_data_output_stream_put_string (_tmp36_, "\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp31_);
			goto __catch1_g_error;
		}
		_tmp37_ = os;
		g_data_output_stream_put_string (_tmp37_, "<theme>\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp31_);
			goto __catch1_g_error;
		}
		{
			GeeIterator* _name_it = NULL;
			GeeHashMap* _tmp38_;
			GeeSet* _tmp39_;
			GeeSet* _tmp40_;
			GeeSet* _tmp41_;
			GeeIterator* _tmp42_;
			GeeIterator* _tmp43_;
			_tmp38_ = bird_font_theme_colors;
			_tmp39_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = _tmp40_;
			_tmp42_ = gee_iterable_iterator ((GeeIterable*) _tmp41_);
			_tmp43_ = _tmp42_;
			_g_object_unref0 (_tmp41_);
			_name_it = _tmp43_;
			while (TRUE) {
				GeeIterator* _tmp44_;
				gchar* name = NULL;
				GeeIterator* _tmp45_;
				gpointer _tmp46_;
				BirdFontColor* color = NULL;
				GeeHashMap* _tmp47_;
				const gchar* _tmp48_;
				gpointer _tmp49_;
				GDataOutputStream* _tmp50_;
				GDataOutputStream* _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				GDataOutputStream* _tmp58_;
				BirdFontColor* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				GDataOutputStream* _tmp64_;
				BirdFontColor* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				GDataOutputStream* _tmp70_;
				BirdFontColor* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				GDataOutputStream* _tmp76_;
				BirdFontColor* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				GDataOutputStream* _tmp82_;
				_tmp44_ = _name_it;
				if (!gee_iterator_next (_tmp44_)) {
					break;
				}
				_tmp45_ = _name_it;
				_tmp46_ = gee_iterator_get (_tmp45_);
				name = (gchar*) _tmp46_;
				_tmp47_ = bird_font_theme_colors;
				_tmp48_ = name;
				_tmp49_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp47_, _tmp48_);
				color = (BirdFontColor*) _tmp49_;
				_tmp50_ = os;
				g_data_output_stream_put_string (_tmp50_, "\t<color ", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_bird_font_color_unref0 (color);
					_g_free0 (name);
					_g_object_unref0 (_name_it);
					_g_object_unref0 (_tmp31_);
					goto __catch1_g_error;
				}
				_tmp51_ = os;
				_tmp52_ = name;
				_tmp53_ = g_markup_escape_text (_tmp52_, (gssize) -1);
				_tmp54_ = _tmp53_;
				_tmp55_ = string_to_string (_tmp54_);
				_tmp56_ = g_strconcat ("name=\"", _tmp55_, "\" ", NULL);
				_tmp57_ = _tmp56_;
				g_data_output_stream_put_string (_tmp51_, _tmp57_, NULL, &_inner_error0_);
				_g_free0 (_tmp57_);
				_g_free0 (_tmp54_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_bird_font_color_unref0 (color);
					_g_free0 (name);
					_g_object_unref0 (_name_it);
					_g_object_unref0 (_tmp31_);
					goto __catch1_g_error;
				}
				_tmp58_ = os;
				_tmp59_ = color;
				_tmp60_ = double_to_string (_tmp59_->r);
				_tmp61_ = _tmp60_;
				_tmp62_ = g_strconcat ("red=\"", _tmp61_, "\" ", NULL);
				_tmp63_ = _tmp62_;
				g_data_output_stream_put_string (_tmp58_, _tmp63_, NULL, &_inner_error0_);
				_g_free0 (_tmp63_);
				_g_free0 (_tmp61_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_bird_font_color_unref0 (color);
					_g_free0 (name);
					_g_object_unref0 (_name_it);
					_g_object_unref0 (_tmp31_);
					goto __catch1_g_error;
				}
				_tmp64_ = os;
				_tmp65_ = color;
				_tmp66_ = double_to_string (_tmp65_->g);
				_tmp67_ = _tmp66_;
				_tmp68_ = g_strconcat ("green=\"", _tmp67_, "\" ", NULL);
				_tmp69_ = _tmp68_;
				g_data_output_stream_put_string (_tmp64_, _tmp69_, NULL, &_inner_error0_);
				_g_free0 (_tmp69_);
				_g_free0 (_tmp67_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_bird_font_color_unref0 (color);
					_g_free0 (name);
					_g_object_unref0 (_name_it);
					_g_object_unref0 (_tmp31_);
					goto __catch1_g_error;
				}
				_tmp70_ = os;
				_tmp71_ = color;
				_tmp72_ = double_to_string (_tmp71_->b);
				_tmp73_ = _tmp72_;
				_tmp74_ = g_strconcat ("blue=\"", _tmp73_, "\" ", NULL);
				_tmp75_ = _tmp74_;
				g_data_output_stream_put_string (_tmp70_, _tmp75_, NULL, &_inner_error0_);
				_g_free0 (_tmp75_);
				_g_free0 (_tmp73_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_bird_font_color_unref0 (color);
					_g_free0 (name);
					_g_object_unref0 (_name_it);
					_g_object_unref0 (_tmp31_);
					goto __catch1_g_error;
				}
				_tmp76_ = os;
				_tmp77_ = color;
				_tmp78_ = double_to_string (_tmp77_->a);
				_tmp79_ = _tmp78_;
				_tmp80_ = g_strconcat ("alpha=\"", _tmp79_, "\"", NULL);
				_tmp81_ = _tmp80_;
				g_data_output_stream_put_string (_tmp76_, _tmp81_, NULL, &_inner_error0_);
				_g_free0 (_tmp81_);
				_g_free0 (_tmp79_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_bird_font_color_unref0 (color);
					_g_free0 (name);
					_g_object_unref0 (_name_it);
					_g_object_unref0 (_tmp31_);
					goto __catch1_g_error;
				}
				_tmp82_ = os;
				g_data_output_stream_put_string (_tmp82_, "/>\n", NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_bird_font_color_unref0 (color);
					_g_free0 (name);
					_g_object_unref0 (_name_it);
					_g_object_unref0 (_tmp31_);
					goto __catch1_g_error;
				}
				_bird_font_color_unref0 (color);
				_g_free0 (name);
			}
			_g_object_unref0 (_name_it);
		}
		_tmp83_ = os;
		g_data_output_stream_put_string (_tmp83_, "</theme>\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp31_);
			goto __catch1_g_error;
		}
		_tmp84_ = os;
		g_output_stream_close ((GOutputStream*) _tmp84_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp31_);
			goto __catch1_g_error;
		}
		_g_object_unref0 (_tmp31_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp85_;
		const gchar* _tmp86_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp85_ = e;
		_tmp86_ = _tmp85_->message;
		g_warning ("Theme.vala:623: %s", _tmp86_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (base_name);
		_g_object_unref0 (file);
		_g_object_unref0 (os);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	bird_font_theme_add_theme_files ();
	_g_free0 (base_name);
	_g_object_unref0 (file);
	_g_object_unref0 (os);
}

static void
bird_font_theme_parse_theme (GFile* f)
{
	gchar* xml_data = NULL;
	BXmlParser* parser = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (f != NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		BXmlParser* _tmp3_;
		BXmlParser* _tmp4_;
		BTag* _tmp5_;
		BTag* _tmp6_;
		_tmp0_ = g_file_get_path (f);
		_tmp1_ = (gchar*) _tmp0_;
		g_file_get_contents (_tmp1_, &_tmp2_, NULL, &_inner_error0_);
		_g_free0 (xml_data);
		xml_data = _tmp2_;
		_g_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = b_xml_parser_new (xml_data);
		_g_object_unref0 (parser);
		parser = _tmp3_;
		_tmp4_ = parser;
		_tmp5_ = b_xml_parser_get_root_tag (_tmp4_);
		_tmp6_ = _tmp5_;
		bird_font_theme_parse_colors (_tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("Theme.vala:638: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		_g_free0 (xml_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (parser);
	_g_free0 (xml_data);
}

static void
bird_font_theme_parse_colors (BTag* tag)
{
	g_return_if_fail (tag != NULL);
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp0_;
		_tmp0_ = b_tag_iterator (tag);
		_t_it = _tmp0_;
		while (TRUE) {
			BTagIterator* _tmp1_;
			BTag* t = NULL;
			BTagIterator* _tmp2_;
			BTag* _tmp3_;
			BTag* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gboolean _tmp7_;
			_tmp1_ = _t_it;
			if (!b_tag_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _t_it;
			_tmp3_ = b_tag_iterator_get (_tmp2_);
			t = _tmp3_;
			_tmp4_ = t;
			_tmp5_ = b_tag_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strcmp0 (_tmp6_, "color") == 0;
			_g_free0 (_tmp6_);
			if (_tmp7_) {
				BTag* _tmp8_;
				BAttributes* _tmp9_;
				BAttributes* _tmp10_;
				_tmp8_ = t;
				_tmp9_ = b_tag_get_attributes (_tmp8_);
				_tmp10_ = _tmp9_;
				bird_font_theme_parse_color (_tmp10_);
				_g_object_unref0 (_tmp10_);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
bird_font_theme_parse_color (BAttributes* attributes)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	gdouble r = 0.0;
	gdouble g = 0.0;
	gdouble b = 0.0;
	gdouble a = 0.0;
	GeeHashMap* _tmp39_;
	const gchar* _tmp40_;
	BirdFontColor* _tmp41_;
	BirdFontColor* _tmp42_;
	g_return_if_fail (attributes != NULL);
	_tmp0_ = g_strdup ("");
	name = _tmp0_;
	r = (gdouble) 0;
	g = (gdouble) 0;
	b = (gdouble) 0;
	a = (gdouble) 1;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributesIterator* _tmp1_;
		_tmp1_ = b_attributes_iterator (attributes);
		_attr_it = _tmp1_;
		while (TRUE) {
			BAttributesIterator* _tmp2_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp3_;
			BAttribute* _tmp4_;
			BAttribute* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			BAttribute* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			BAttribute* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gboolean _tmp21_;
			BAttribute* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_;
			BAttribute* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gboolean _tmp35_;
			_tmp2_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _attr_it;
			_tmp4_ = b_attributes_iterator_get (_tmp3_);
			attr = _tmp4_;
			_tmp5_ = attr;
			_tmp6_ = b_attribute_get_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp7_, "name") == 0;
			_g_free0 (_tmp7_);
			if (_tmp8_) {
				BAttribute* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = attr;
				_tmp10_ = b_attribute_get_content (_tmp9_);
				_g_free0 (name);
				name = _tmp10_;
			}
			_tmp11_ = attr;
			_tmp12_ = b_attribute_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strcmp0 (_tmp13_, "red") == 0;
			_g_free0 (_tmp13_);
			if (_tmp14_) {
				BAttribute* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp15_ = attr;
				_tmp16_ = b_attribute_get_content (_tmp15_);
				_tmp17_ = _tmp16_;
				r = double_parse (_tmp17_);
				_g_free0 (_tmp17_);
			}
			_tmp18_ = attr;
			_tmp19_ = b_attribute_get_name (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strcmp0 (_tmp20_, "green") == 0;
			_g_free0 (_tmp20_);
			if (_tmp21_) {
				BAttribute* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp22_ = attr;
				_tmp23_ = b_attribute_get_content (_tmp22_);
				_tmp24_ = _tmp23_;
				g = double_parse (_tmp24_);
				_g_free0 (_tmp24_);
			}
			_tmp25_ = attr;
			_tmp26_ = b_attribute_get_name (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strcmp0 (_tmp27_, "blue") == 0;
			_g_free0 (_tmp27_);
			if (_tmp28_) {
				BAttribute* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp29_ = attr;
				_tmp30_ = b_attribute_get_content (_tmp29_);
				_tmp31_ = _tmp30_;
				b = double_parse (_tmp31_);
				_g_free0 (_tmp31_);
			}
			_tmp32_ = attr;
			_tmp33_ = b_attribute_get_name (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strcmp0 (_tmp34_, "alpha") == 0;
			_g_free0 (_tmp34_);
			if (_tmp35_) {
				BAttribute* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp36_ = attr;
				_tmp37_ = b_attribute_get_content (_tmp36_);
				_tmp38_ = _tmp37_;
				a = double_parse (_tmp38_);
				_g_free0 (_tmp38_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp39_ = bird_font_theme_colors;
	_tmp40_ = name;
	_tmp41_ = bird_font_color_new (r, g, b, a);
	_tmp42_ = _tmp41_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp39_, _tmp40_, _tmp42_);
	_bird_font_color_unref0 (_tmp42_);
	_g_free0 (name);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block68Data*
block68_data_ref (Block68Data* _data68_)
{
	g_atomic_int_inc (&_data68_->_ref_count_);
	return _data68_;
}

static void
block68_data_unref (void * _userdata_)
{
	Block68Data* _data68_;
	_data68_ = (Block68Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data68_->_ref_count_)) {
		_g_object_unref0 (_data68_->d);
		g_slice_free (Block68Data, _data68_);
	}
}

static void
__lambda595_ (const gchar* text)
{
	g_return_if_fail (text != NULL);
	if (g_strcmp0 (text, "") != 0) {
		gchar* _tmp0_;
		GeeArrayList* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = g_strconcat (text, ".theme", NULL);
		_g_free0 (bird_font_theme_current_theme);
		bird_font_theme_current_theme = _tmp0_;
		_tmp1_ = bird_font_theme_themes;
		_tmp2_ = bird_font_theme_current_theme;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp2_);
	}
}

static void
___lambda595__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda595_ (text);
}

static void
__lambda596_ (Block68Data* _data68_)
{
	bird_font_tab_content_hide_text_input ();
	bird_font_theme_write_theme ();
	bird_font_settings_display_create_setting_items (_data68_->d);
}

static void
___lambda596__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda596_ (self);
}

void
bird_font_theme_add_new_theme (BirdFontSettingsDisplay* d)
{
	Block68Data* _data68_;
	BirdFontSettingsDisplay* _tmp0_;
	BirdFontTextListener* listener = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	BirdFontTextListener* _tmp5_;
	g_return_if_fail (d != NULL);
	_data68_ = g_slice_new0 (Block68Data);
	_data68_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (d);
	_g_object_unref0 (_data68_->d);
	_data68_->d = _tmp0_;
	_tmp1_ = bird_font_t_ ("New theme");
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_t_ ("Set");
	_tmp4_ = _tmp3_;
	_tmp5_ = bird_font_text_listener_new (_tmp2_, "", _tmp4_);
	_g_object_unref0 (listener);
	listener = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	g_signal_connect (listener, "signal-text-input", (GCallback) ___lambda595__bird_font_text_listener_signal_text_input, NULL);
	g_signal_connect_data (listener, "signal-submit", (GCallback) ___lambda596__bird_font_text_listener_signal_submit, block68_data_ref (_data68_), (GClosureNotify) block68_data_unref, 0);
	bird_font_tab_content_show_text_input (listener);
	_g_object_unref0 (listener);
	block68_data_unref (_data68_);
	_data68_ = NULL;
}

gchar*
bird_font_theme_get_icon_file (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("icons.birdfont");
	result = _tmp0_;
	return result;
}

BirdFontTheme*
bird_font_theme_construct (GType object_type)
{
	BirdFontTheme * self = NULL;
	self = (BirdFontTheme*) g_object_new (object_type, NULL);
	return self;
}

BirdFontTheme*
bird_font_theme_new (void)
{
	return bird_font_theme_construct (BIRD_FONT_TYPE_THEME);
}

static void
bird_font_theme_class_init (BirdFontThemeClass * klass,
                            gpointer klass_data)
{
	bird_font_theme_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_theme_finalize;
}

static void
bird_font_theme_instance_init (BirdFontTheme * self,
                               gpointer klass)
{
}

static void
bird_font_theme_finalize (GObject * obj)
{
	BirdFontTheme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_THEME, BirdFontTheme);
	G_OBJECT_CLASS (bird_font_theme_parent_class)->finalize (obj);
}

static GType
bird_font_theme_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontTheme), 0, (GInstanceInitFunc) bird_font_theme_instance_init, NULL };
	GType bird_font_theme_type_id;
	bird_font_theme_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontTheme", &g_define_type_info, 0);
	return bird_font_theme_type_id;
}

GType
bird_font_theme_get_type (void)
{
	static volatile gsize bird_font_theme_type_id__once = 0;
	if (g_once_init_enter (&bird_font_theme_type_id__once)) {
		GType bird_font_theme_type_id;
		bird_font_theme_type_id = bird_font_theme_get_type_once ();
		g_once_init_leave (&bird_font_theme_type_id__once, bird_font_theme_type_id);
	}
	return bird_font_theme_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

