/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output.bookshelf;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.bookshelf.Bookshelf;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutput;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutputWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

public class BookshelfOutputWeights
extends BookshelfOutputWriter {
    private static final Bookshelf.BookshelfFiles fileType = Bookshelf.BookshelfFiles.wts;
    private Cell cell;

    public BookshelfOutputWeights(String genericFileName, Cell cell) {
        super(genericFileName, fileType);
        this.cell = cell;
    }

    @Override
    public void write() throws IOException {
        Job.getUserInterface().setProgressNote("Weights File" + this.fileName);
        PrintWriter writer = new PrintWriter(this.fileName);
        writer.println(BookshelfOutput.createBookshelfHeader(fileType));
        Iterator<NodeInst> ini = this.cell.getNodes();
        while (ini.hasNext()) {
            NodeInst ni = ini.next();
            String name = ni.getName();
            int weight = 1;
            Variable var = ni.getVar("weight");
            if (var == null) continue;
            weight = (Integer)var.getObject();
            writer.println("   " + name + "   " + weight);
        }
        writer.flush();
        writer.close();
    }
}

