/*
 * execute Ghostscript loader. Only for W32TeX.
 * This should not be used in TeX Live.
 */

#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>

#ifdef _WIN64
#define EXEPROG "gswin64c.exe"
#define EXEPROGX "gswin32c.exe"
#else
#define EXEPROG "gswin32c.exe"
#define EXEPROGX "gswin64c.exe"
#endif

static int is_in_path(char *name)
{
  FILE *f;
  char cmd[256];
  char buffer[512];
  char *p;
  int ret = 0;
  int i;

  for(i = 0; i < 512; i++)
    buffer[i] = '\0';

  strcpy(cmd, "where ");
  strcat(cmd, name);
  strcat(cmd, " 2>nul");
  f = _popen(cmd, "r");

  if (!f)
    return 0;

  p = fgets(buffer, 511, f);
  _pclose(f);

  if(p != NULL) {
    for(p = buffer; *p; p++)
      *p = tolower(*p);
    p = strstr(buffer, name);
    if(p != NULL)
      ret = 1;
  }

  return ret;
}

static int is_include_space(char *s)
{
  char *p;
  p = strchr(s, ' ');
  if(p) return 1;
  p = strchr(s, '\t');
  if(p) return 1;
  return 0;
}

int main(int argc, char **argv)
{
  int i;
  char *p;

/*  MSC seems to require quotation for arguments with spaces.*/
  for(i = 0; i < argc; i++) {
    if(is_include_space(argv[i])) {
      p = malloc(strlen(argv[i])+3);
      strcpy(p, "\"");
      strcat(p, argv[i]);
      strcat(p, "\"");
      argv[i] = p;
    }
  }
  argv[argc] = NULL;

  if(is_in_path(EXEPROG))
    return _spawnvp(_P_WAIT, EXEPROG, (char **)argv);
  else if(is_in_path(EXEPROGX))
    return _spawnvp(_P_WAIT, EXEPROGX, (char **)argv);
  else
    return _spawnvp(_P_WAIT, EXEPROG, (char **)argv);
}
