/*
 * virtual font
 */

#include	"defs.h"
#include	"dconv.h"
#include	"set.h"
#include	"global.h"
#include	"virfont.h"

void vf_mc(struct font_entry *fe, struct vfchar_entry *ce, int c);

#ifdef KPATHSEA
#include	<kpathsea/tex-file.h>
#endif

int vftype_access();
int jvftype_access();
void init_vf_fontinfo();
void init_jvf_fontinfo();
struct fontop vfop = {
    "vf",
    pathtype_init,
    vftype_access,
    init_vf_fontinfo,
};
struct fontop jvfop = {
    "jvf",
    pathtype_init,
    jvftype_access,
    init_jvf_fontinfo,
};

vftype_access(proto, fe, acca)
char *proto;
struct font_entry *fe;
struct accarg *acca;
{
    return vfty_acc(proto, fe, acca, "vf", NULL);
}

jvftype_access(proto, fe, acca)
char *proto;
struct font_entry *fe;
struct accarg *acca;
{
    /*return vfty_acc(proto, fe, acca, "jvf", ".jvf");*/
    return vfty_acc(proto, fe, acca, "jvf", NULL);
}

vfty_acc(proto, fe, acca, type, suffix)
char *proto;
struct font_entry *fe;
struct accarg *acca;
char *type, *suffix;
{
    char *filename;
    __BOOLEAN__ ok;

#ifdef KPATHSEA
    filename = kpsearch_make(proto, fe->n, kpse_vf_format, suffix, acca,
			     fe->name);
    if (ok = (filename != NULL))
	strcpy(fe->name, filename);
#else
    pave(fe->name, proto, acca);
    ok = access(fe->name, R_OK) == 0;
#endif
#ifdef DEBUG
    if (Debuguser)
	(void)fprintf(stderr, "trying to access(%s) %s\n", type, fe->name);
#endif
    return ok;
}

void
init_vf_fontinfo(fe)
struct font_entry *fe;
{
    int vf_markchar();
    void read_vf_fontinfo();

    read_vf_dviinfo(fe);
    fe->fnt_markchar = vf_markchar;
    fe->fnt_readfontinfo = read_vf_fontinfo;
}

void
init_jvf_fontinfo(fe)
struct font_entry *fe;
{
    int jvf_markchar();
    void read_jvf_fontinfo();

    read_jvf_dviinfo(fe);
    fe->fnt_markchar = jvf_markchar;
    fe->fnt_readfontinfo = read_jvf_fontinfo;
}

#define	CODE_NORMAL	0
#define	CODE_JIS	1

#define	N94CSCHARS	(94*256)

#define	NJISCHARS	(94*94+1)
#define	JISDEFAULT	(94*94)

read_vf_dviinfo(struct font_entry *fe)
{
    read_vf_di(fe, CODE_NORMAL);
    return 0;
}

read_jvf_dviinfo(struct font_entry *fe)
{
    read_vf_di(fe, CODE_JIS);
    return 0;
}

read_vf_di(struct font_entry *fe, int coding)
{
    FILE *fntfp;
    int cmd, t;
    int ds;
    int	k, c, s, d, a, l;
    byte n[STRSIZE];
    int nvfc, nvfc1;
    struct virfntinfo *vfi;
    struct font_index *fip;
    struct vfchar_entry *ce;
    int pl, cc, idx, tfm;
    int misschar = 0;
    struct virfntinfo *alloc_virfinfo(), *realloc_virfinfo();

    openfontfile(fe);
    fntfp = fe->openfile;
    if (getuint(fntfp,1) != VF_PRE || getuint(fntfp,1) != VF_ID)
	Fatal("bad vf file %s\n", fe->name);
    (void)fseek(fntfp, (long)getuint(fntfp, 1), SEEK_CUR);	/* comment */
    if ((t = getuint(fntfp, 4)) && fe->c && t != fe->c)
	Warning("font = \"%s\",\n-->font checksum = %d,\n-->dvi checksum = %d",
		fe->name, fe->c, t);
    ds = getuint(fntfp, 4);	/* design size */
    nvfc = MAXVFCHAR+1;
    vfi = alloc_virfinfo((coding == CODE_NORMAL) ? MAXVFCHAR+1 : NJISCHARS);

    for (; (cmd = getuint(fntfp,1)) >= VF_FNT_DEF1 && cmd <= VF_FNT_DEF4; ) {
	k = getuint(fntfp, cmd-VF_FNT_DEF1+1);
	c = getuint(fntfp, 4);	/* checksum */
	s = scale(fe->s, getuint(fntfp, 4));	/* scaled size */
	d = getuint(fntfp, 4) >> 4;		/* design size (pt -> sp) */
	a = getuint(fntfp, 1);	/* area length for font name */
	l = getuint(fntfp, 1);	/* device length */
	getbytes(fntfp, n, a+l);
	n[a+l] = '\0';
	readfontdef(k, c, s, d, a, l, (char *)n, &(vfi->vf_fontidx));
    }			

    if (vfi->vf_fontidx == NULL) {
	vfi->vf_default_fent = NULL;
    } else {
	for (fip = vfi->vf_fontidx; fip->next != NULL;
	     fip = fip->next)
	    ;
	vfi->vf_default_fent = fip->fent;
    }

    for (;; cmd = getuint(fntfp, 1)) {
	if (cmd <= VF_LONG_CHAR) {
	    if (cmd == VF_LONG_CHAR) {
		pl = getuint(fntfp, 4);
		cc = getuint(fntfp, 4);
		tfm = getuint(fntfp, 4);
	    } else {
		pl = cmd;
		cc = getuint(fntfp, 1);
		tfm = getuint(fntfp, 3);
	    }
	    if (coding == CODE_NORMAL) {
		if (cc >= nvfc) {
		    nvfc1 = cc + N94CSCHARS;
		    vfi = realloc_virfinfo(vfi, nvfc, nvfc1);
		    nvfc = nvfc1;
		}
		ce = &vfi->ch[cc];
	    } else {
		if (cc == 0)
		    ce = &vfi->ch[JISDEFAULT];
		else if ((idx = jis_to_idx94(cc)) < 0) {
		    misschar++;
#ifdef DEBUG
		    if (Debug)
			(void)fprintf(stderr,
				      "cc 0x%x in (j)vf file %s (skipped)\n",
				      cc, fe->name);
#endif
		    (void)fseek(fntfp, (long)pl, SEEK_CUR);
		    continue;
		} else
		    ce = &vfi->ch[idx];
	    }
	    ce->tfmw = scale(tfm, fe->s);
	    if (pl == 0)
		ce->vfdstat = VFD_NULL;
	    else {
		ce->vfdstat = VFD_NOTLD;
		ce->vfd.dvi.dvilen = pl;
		ce->vfd.dvi.where.fileoffset = ftell(fntfp);
		(void)fseek(fntfp, (long)pl, SEEK_CUR);
	    }
	} else if (cmd == VF_POST) {
	    break;
	} else
	    Fatal("illegal vf command %d in %s\n", cmd, fe->name);
    }
    if (misschar > 0) {
	Warning("char(s) in vf file %s skipped", fe->name);
	Warning("\t\"font jvf\" may be the mistake of \"font vf\"");
    }
    virfinfo(fe) = vfi;
    return 0;
}

struct virfntinfo *
alloc_virfinfo(nchars)
int nchars;
{
    struct virfntinfo *vfi;
    struct vfchar_entry *ce;
    int i;

    vfi = (struct virfntinfo *)
	  alloc_check(malloc((unsigned)sizeof(struct virfntinfo)+
			     (nchars-1)*sizeof(struct vfchar_entry)),
		      "virfont info");
    vfi->vf_fontidx = NULL;
    for (i = 0; i < nchars; i++) {
	ce = &(vfi->ch[i]);
	ce->vfdstat = VFD_UNDEF;
	ce->tfmw = 0;
    }
    return vfi;
}

struct virfntinfo *
realloc_virfinfo(vfi0, nchars0, nchars)
struct virfntinfo *vfi0;
int nchars0, nchars;
{
    struct virfntinfo *vfi;
    struct vfchar_entry *ce;
    int i;

    vfi = (struct virfntinfo *)
	  alloc_check(realloc(vfi0,
			      (unsigned)sizeof(struct virfntinfo)+
			      (nchars-1)*sizeof(struct vfchar_entry)),
		      "virfont info");
    for (i = nchars0; i < nchars; i++) {
	ce = &(vfi->ch[i]);
	ce->vfdstat = VFD_UNDEF;
	ce->tfmw = 0;
    }
    return vfi;
}

vf_markchar(int c)
{
    vf_mc(curfontent, &virfinfo(curfontent)->ch[c], c);
    return 0;
}

jvf_markchar(int c)
{
    int idx;

    if ((idx = jis_to_idx94(c)) < 0) {
#ifdef DEBUG
	if (Debuguser)
	    (void)fprintf(stderr, "char 0x%x (font %s) invalid\n",
			  c, curfontent->n);
#endif
    } else
	vf_mc(curfontent, &virfinfo(curfontent)->ch[idx], c);
    return 0;
}

byte *
getvfdvi(fe, ce)
struct font_entry *fe;
struct vfchar_entry *ce;
{
    int dvilen;
    byte *dvip, *dp;
    FILE *fntfp;

    openfontfile(fe);
    fntfp = fe->openfile;
    (void)fseek(fntfp, (long)ce->vfd.dvi.where.fileoffset, SEEK_SET);
    dvilen = ce->vfd.dvi.dvilen;
    if ((dvip = (byte *)malloc((unsigned)dvilen)) == NULL)
	Fatal("Unable to allocate memory for vf char\n");
    (void)fread((char *)dvip, 1, dvilen, fntfp);
    return dvip;
}

void vf_mc(struct font_entry *fe, struct vfchar_entry *ce, int c)
{
    int cmd, dvilen, k;
    struct vfchar_entry *defce;
    byte *dvip, *dp;
    struct font_index *fi;
    struct dconv save_curdconv, *save_curdconvp;
    struct font_entry *save_curfontent;

    if (ce->vfdstat >= VFD_NULL)
	return;
    if (ce->vfdstat == VFD_UNDEF) {
	if ((defce = &virfinfo(fe)->ch[JISDEFAULT])->vfdstat == VFD_UNDEF)
	    Fatal("char %d in vf file %s is not defined", c, fe->n);
	if (defce->vfdstat == VFD_NOTLD) {
	    defce->vfd.dvi.where.dviptr = getvfdvi(fe, defce);
	    defce->vfdstat = VFD_NULL;
	}
	dvilen = ce->vfd.dvi.dvilen = defce->vfd.dvi.dvilen;
	if ((dvip = (byte *)malloc((unsigned)dvilen)) == NULL)
	    Fatal("Unable to allocate memory for vf char\n");
	/* Hack. depend on the fact that default char is of the form
	   ... SET2 0x2121. */
	memcpy(dvip, defce->vfd.dvi.where.dviptr, dvilen);
	*(dvip+dvilen-2) = c>>8;
	*(dvip+dvilen-1) = c&0xff;
	ce->tfmw = defce->tfmw;
    } else {
	dvip = getvfdvi(fe, ce);
	dvilen = ce->vfd.dvi.dvilen;
    }

    /* short cut for simple cases */
    ce->vfdstat = VFD_DVI;
    if (setc_com(cmd = *dvip, dvip, dvilen, ce)) {
	ce->vfdstat = VFD_SETFC;
	ce->vfd.set.f = virfinfo(fe)->vf_default_fent;
    } else if (FONT_00 <= cmd && cmd <= FNT4) {
	if (cmd <= FONT_63) {
	    --dvilen;
	    dp = dvip+1;
	} else {
	    dvilen -= cmd-FNT1+2;
	    dp = dvip+cmd-FNT1+2;
	}
	if (setc_com(*dp, dp, dvilen, ce)) {
	    ce->vfdstat = VFD_SETFC;
	    k = (cmd <= FONT_63) ? cmd-FONT_00
		: makeuint(dvip+1, cmd-FNT1+1);
	    for (fi = virfinfo(fe)->vf_fontidx;
		 fi != NULL && fi->k != k; fi = fi->next)
		;
	    ce->vfd.set.f = fi->fent;
	}
    }

    if (ce->vfdstat == VFD_SETFC) {
	save_curfontent = curfontent;
	setcurfont(ce->vfd.set.f);
	MarkChar(ce->vfd.set.c);
	setcurfont(save_curfontent);
	free((char *)dvip);
	return;
    }
    ce->vfd.dvi.where.dviptr = dvip;

    /* save */
    save_curdconvp = curdconvp;
    curdconvp->dc_bufbeg = dc_bufbeg;
    save_curdconv = *curdconvp;
    vfd_dconv_templ.dc_bufbeg = dvip;
    vfd_dconv_templ.dc_bufend = dvip+ce->vfd.dvi.dvilen;
    /*vfd_dconv_templ.dc_scale = fe->s;*/
    setcurdconv(&vfd_dconv_templ);
    save_curfontent = curfontent;
    setcurfont(virfinfo(fe)->vf_default_fent);

    scanfont(TRUE, &(virfinfo(fe)->vf_fontidx));

    /* restore */
    *save_curdconvp = save_curdconv;
    setcurdconv(save_curdconvp);
    setcurfont(save_curfontent);
}

setc_com(cmd, dvip, dvilen, ce)
byte cmd;
byte *dvip;
int dvilen;
struct vfchar_entry *ce;
{
    if (cmd <= SETC_127 && dvilen <= 1) {
	ce->vfd.set.c = cmd;
	return TRUE;
    } else if (SET1 <= cmd && cmd <= SET4 && dvilen == cmd-SET1+2) {
	ce->vfd.set.c = makeuint(dvip+1, dvilen-1);
	return TRUE;
    }
    return FALSE;
}

void
read_vf_fontinfo(fe)
struct font_entry *fe;
{
    DEV_FONT vf_fontdict();
    int vf_setchar(), vf_setstring();

    fe->rvf_setchar = virf_setchar;
    fe->rvf_setstring = virf_setstring;
    fe->dev_fontdict = vf_fontdict;
    fe->dev_setchar = vf_setchar;
    fe->dev_setstring = vf_setstring;
}

void
read_jvf_fontinfo(fe)
struct font_entry *fe;
{
    DEV_FONT vf_fontdict();
    int jvf_setchar(), jvf_setstring();

    fe->rvf_setchar = virf_setchar;
    fe->rvf_setstring = virf_setstring;
    fe->dev_fontdict = vf_fontdict;
    fe->dev_setchar = jvf_setchar;
    fe->dev_setstring = jvf_setstring;
}

/* ARGSUSED */
DEV_FONT
vf_fontdict(struct font_entry *fe, int c)
{
    Fatal("%s implementation error: vf_fontdict", G_progname);
    return 0;
}

vf_setchar(c)
int c;
{
    return vf_sc(curfontent, &virfinfo(curfontent)->ch[c], c);
}

jvf_setchar(c)
int c;
{
    int idx;

    if ((idx = jis_to_idx94(c)) < 0)
	return 0;
    else
	return vf_sc(curfontent, &virfinfo(curfontent)->ch[idx], c);
}

/* ARGSUSED */
vf_sc(fe, ce, c)
struct font_entry *fe;
struct vfchar_entry *ce;
int c;
{
    struct dconv save_curdconv, *save_curdconvp;
    struct font_entry *save_curfontent;
    int save_h, save_v, save_dir;
    __BOOLEAN__ save_chmove;

    if (ce->vfdstat == VFD_SETFC) {
	save_curfontent = curfontent;
	setcurfont(ce->vfd.set.f);
	save_chmove = chmove;
	SetChar(ce->vfd.set.c, FALSE);
	setcurfont(save_curfontent);
	chmove = save_chmove;
	return ce->tfmw;
    }

    if (ce->vfdstat == VFD_NULL)
	return ce->tfmw;

    /* save */
    save_curdconvp = curdconvp;
    curdconvp->dc_bufbeg = dc_bufbeg;
    save_curdconv = *curdconvp;
    vfd_dconv_templ.dc_bufbeg = ce->vfd.dvi.where.dviptr;
    vfd_dconv_templ.dc_bufend = ce->vfd.dvi.where.dviptr+ce->vfd.dvi.dvilen;
    vfd_dconv_templ.dc_scale = fe->s;
    setcurdconv(&vfd_dconv_templ);
    save_curfontent = curfontent;
    setcurfont(virfinfo(fe)->vf_default_fent);
    save_h = h;
    save_v = v;
    save_dir = dir;
    save_chmove = chmove;

    dviconv(virfinfo(fe)->vf_fontidx);

    /* restore */
    *save_curdconvp = save_curdconv;
    setcurdconv(save_curdconvp);
    setcurfont(save_curfontent);
    h = save_h;
    v = save_v;
    setdir(save_dir);
    chmove = save_chmove;

    return ce->tfmw;
}

vf_setstring(s, len)
unsigned char *s;
int len;
{
    unsigned char *sp;
    int w;

    /* should be optimized */
    for (sp = s; sp < s+len; sp++) {
	w = vf_setchar(*sp);
	*move += w;
    }
    return 0;
}

jvf_setstring(s, len)
unsigned char *s;
int len;
{
    unsigned char *sp;
    int w;

    /* should be optimized */
    for (sp = s; sp < s+len; sp++) {
	w = jvf_setchar(*sp);
	*move += w;
    }
    return 0;
}
