/***** Autogenerated from runpicture.in; changes will be overwritten *****/

#line 1 "runtimebase.in"
/*****
 * runtimebase.in
 * Andy Hammerlindl  2009/07/28
 *
 * Common declarations needed for all code-generating .in files.
 *
 *****/


#line 1 "runpicture.in"
/*****
 * runpicture.in
 *
 * Runtime functions for picture operations.
 *
 *****/

#line 1 "runtimebase.in"
#if defined(MIKTEX_WINDOWS)
#  define MIKTEX_UTF8_WRAP_ALL 1
#  include <miktex/utf8wrap.h>
#endif
#include "stack.h"
#include "types.h"
#include "builtin.h"
#include "entry.h"
#include "errormsg.h"
#include "array.h"
#include "triple.h"
#include "callable.h"
#include "opsymbols.h"

using vm::stack;
using vm::error;
using vm::array;
using vm::read;
using vm::callable;
using types::formal;
using types::function;
using camp::triple;

#define PRIMITIVE(name,Name,asyName) using types::prim##Name;
#include <primitives.h>
#undef PRIMITIVE

typedef double real;

void unused(void *);

namespace run {
array *copyArray(array *a);
array *copyArray2(array *a);
array *copyArray3(array *a);

double *copyTripleArray2Components(array *a, size_t &N,
                                   GCPlacement placement=NoGC);
triple *copyTripleArray2C(array *a, size_t &N,
                          GCPlacement placement=NoGC);
}

function *realRealFunction();

#define CURRENTPEN processData().currentpen

#line 28 "runpicture.in"
#include "picture.h"
#include "drawelement.h"
#include "path.h"
#include "array.h"
#include "arrayop.h"
#include "drawpath.h"
#include "drawfill.h"
#include "drawclipbegin.h"
#include "drawclipend.h"
#include "drawgsave.h"
#include "drawgrestore.h"
#include "drawgroup.h"
#include "drawverbatim.h"
#include "drawlabel.h"
#include "drawlayer.h"
#include "drawimage.h"
#include "drawpath3.h"
#include "drawsurface.h"

using namespace camp;
using namespace settings;
using namespace vm;

typedef array Intarray;
typedef array Intarray2;
typedef array realarray;
typedef array realarray2;
typedef array pairarray;
typedef array pairarray2;
typedef array triplearray;
typedef array triplearray2;
typedef array patharray;
typedef array penarray;
typedef array penarray2;

typedef callable callablePen;

using types::IntArray;
using types::IntArray2;
using types::realArray;
using types::realArray2;
using types::pairArray;
using types::pairArray2;
using types::tripleArray;
using types::tripleArray2;
using types::pathArray;
using types::penArray;
using types::penArray2;

static transform ZeroTransform=transform(0.0,0.0,0.0,0.0,0.0,0.0);

transform getTransform(xmap_t &xmap, picture::nodelist::iterator p)
{
    string s=(*p)->KEY;
    transform t;
    // Don't apply xmap without an explicit corresponding key
    size_t n=s.length();
    if(n == 0 || s.substr(n-1) != "1") return t;

    xmap_t::iterator q=xmap.find(s.substr(0,n-2));
    if(q != xmap.end()) {
      xtransform_t& v=q->second;
      if(!v.empty()) {
        t=v.front();
        v.pop_front();      
      }
    }
    return t;
}


function *transformFunction()
{
  return new function(primTransform());
}

function *penFunction()
{
  return new function(primPen(),primInt(),primInt());
}

// Ignore unclosed begingroups but not spurious endgroups.
const char *nobegin="endgroup without matching begingroup";
  
array *emptyarray=new array(0);

array *nop(array *a) 
{
  return a;
}
  
triple Zero;

string defaultformat3="prc";

// Autogenerated routines:



#ifndef NOSYM
#include "runpicture.symbols.h"

#endif
namespace run {
#line 126 "runpicture.in"
void newPicture(stack *Stack)
{
#line 127 "runpicture.in"
  {Stack->push<picture*>(new picture()); return;}
}

#line 131 "runpicture.in"
// bool empty(picture *f);
void gen_runpicture1(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 132 "runpicture.in"
  {Stack->push<bool>(f->null()); return;}
}

#line 136 "runpicture.in"
// void erase(picture *f);
void gen_runpicture2(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 137 "runpicture.in"
  f->nodes.clear();
}

#line 141 "runpicture.in"
// pair min(picture *f);
void gen_runpicture3(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 142 "runpicture.in"
  {Stack->push<pair>(f->bounds().Min()); return;}
}

#line 146 "runpicture.in"
// pair max(picture *f);
void gen_runpicture4(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 147 "runpicture.in"
  {Stack->push<pair>(f->bounds().Max()); return;}
}

#line 151 "runpicture.in"
// pair size(picture *f);
void gen_runpicture5(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 152 "runpicture.in"
  bbox b=f->bounds();
  {Stack->push<pair>(b.Max()-b.Min()); return;}
}

#line 157 "runpicture.in"
// void _draw(picture *f, path g, pen p);
void gen_runpicture6(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  path g=vm::pop<path>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 158 "runpicture.in"
  f->append(new drawPath(g,p));
}

#line 162 "runpicture.in"
// void fill(picture *f, patharray *g, pen p=CURRENTPEN, bool copy=true);
void gen_runpicture7(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 163 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray : nop;
  f->append(new drawFill(*copyarray(g),false,p));
}

#line 168 "runpicture.in"
// void latticeshade(picture *f, patharray *g, bool stroke=false,                  pen fillrule=CURRENTPEN, penarray2 *p, transform t=identity,                   bool copy=true);
void gen_runpicture8(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  transform t=vm::pop<transform>(Stack,identity);
  penarray2 * p=vm::pop<penarray2 *>(Stack);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 171 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray : nop;
  f->append(new drawLatticeShade(*copyarray(g),stroke,fillrule,*copyarray(p),
                                 t));
}

#line 177 "runpicture.in"
// void axialshade(picture *f, patharray *g, bool stroke=false, pen pena, pair a,                bool extenda=true, pen penb, pair b, bool extendb=true,                bool copy=true);
void gen_runpicture9(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  bool extendb=vm::pop<bool>(Stack,true);
  pair b=vm::pop<pair>(Stack);
  pen penb=vm::pop<pen>(Stack);
  bool extenda=vm::pop<bool>(Stack,true);
  pair a=vm::pop<pair>(Stack);
  pen pena=vm::pop<pen>(Stack);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 180 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray : nop;
  f->append(new drawAxialShade(*copyarray(g),stroke,pena,a,extenda,penb,b,
                               extendb));
}

#line 186 "runpicture.in"
// void radialshade(picture *f, patharray *g, bool stroke=false, pen pena,                 pair a, real ra, bool extenda=true, pen penb, pair b, real rb,                 bool extendb=true, bool copy=true);
void gen_runpicture10(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  bool extendb=vm::pop<bool>(Stack,true);
  real rb=vm::pop<real>(Stack);
  pair b=vm::pop<pair>(Stack);
  pen penb=vm::pop<pen>(Stack);
  bool extenda=vm::pop<bool>(Stack,true);
  real ra=vm::pop<real>(Stack);
  pair a=vm::pop<pair>(Stack);
  pen pena=vm::pop<pen>(Stack);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 189 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray : nop;
  f->append(new drawRadialShade(*copyarray(g),stroke,pena,a,ra,extenda,
                                penb,b,rb,extendb));
}

#line 195 "runpicture.in"
// void gouraudshade(picture *f, patharray *g, bool stroke=false,                  pen fillrule=CURRENTPEN, penarray *p, pairarray *z,                  Intarray *edges, bool copy=true);
void gen_runpicture11(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  Intarray * edges=vm::pop<Intarray *>(Stack);
  pairarray * z=vm::pop<pairarray *>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 198 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray : nop;
  checkArrays(p,z);
  checkArrays(z,edges);
  f->append(new drawGouraudShade(*copyarray(g),stroke,fillrule,*copyarray(p),
                                 *copyarray(z),*copyarray(edges)));
}

#line 206 "runpicture.in"
// void gouraudshade(picture *f, patharray *g, bool stroke=false,                  pen fillrule=CURRENTPEN, penarray *p, Intarray *edges,                  bool copy=true);
void gen_runpicture12(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  Intarray * edges=vm::pop<Intarray *>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 209 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray : nop;
  size_t n=checkArrays(p,edges);
  size_t m=checkArray(g);
  array *z=new array(n);
  Int k=0;
  Int in=(Int) n;
  for(size_t j=0; j < m; ++j) {
    path *P=read<path *>(g,j);
    assert(P);
    Int stop=Min(P->size(),in-k);
    mem::vector<solvedKnot>& nodes=P->Nodes();
    for(Int i=0; i < stop; ++i)
      (*z)[k++]=nodes[i].point;
  }
  checkArrays(p,z);
  
  f->append(new drawGouraudShade(*copyarray(g),stroke,fillrule,*copyarray(p),
                                 *z,*copyarray(edges)));
}

#line 230 "runpicture.in"
// void tensorshade(picture *f, patharray *g, bool stroke=false,                 pen fillrule=CURRENTPEN, penarray2 *p, patharray *b=NULL,                 pairarray2 *z=emptyarray, bool copy=true);
void gen_runpicture13(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pairarray2 * z=vm::pop<pairarray2 *>(Stack,emptyarray);
  patharray * b=vm::pop<patharray *>(Stack,NULL);
  penarray2 * p=vm::pop<penarray2 *>(Stack);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 233 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray : nop;
  array *(*copyarray2)(array *a)=copy ? copyArray2 : nop;
  if(b == NULL) b=g;
  size_t n=checkArrays(p,b);
  size_t nz=checkArray(z);
  if(nz != 0)
    checkEqual(nz,n);
  f->append(new drawTensorShade(*copyarray(g),stroke,fillrule,*copyarray2(p),
                                *copyarray(b),*copyarray2(z)));
}

#line 245 "runpicture.in"
// void functionshade(picture *f, patharray *g, bool stroke=false,                   pen fillrule=CURRENTPEN, string shader=emptystring,                   bool copy=true);
void gen_runpicture14(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  string shader=vm::pop<string>(Stack,emptystring);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 248 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray : nop;
  f->append(new drawFunctionShade(*copyarray(g),stroke,fillrule,shader));
}

// Clip a picture to a superpath using the given fill rule.
// Subsequent additions to the picture will not be affected by the clipping.
#line 255 "runpicture.in"
// void clip(picture *f, patharray *g, bool stroke=false,          pen fillrule=CURRENTPEN, bool copy=true);
void gen_runpicture15(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 257 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray : nop;
  drawClipBegin *begin=new drawClipBegin(*copyarray(g),stroke,fillrule,true);
  f->enclose(begin,new drawClipEnd(true,begin));
}

#line 263 "runpicture.in"
// void beginclip(picture *f, patharray *g, bool stroke=false,               pen fillrule=CURRENTPEN, bool copy=true);
void gen_runpicture16(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 265 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray : nop;
  f->append(new drawClipBegin(*copyarray(g),stroke,fillrule,false));
}

#line 270 "runpicture.in"
// void endclip(picture *f);
void gen_runpicture17(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 271 "runpicture.in"
  f->append(new drawClipEnd(false));
}

#line 275 "runpicture.in"
// void gsave(picture *f);
void gen_runpicture18(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 276 "runpicture.in"
  f->append(new drawGsave());
}

#line 280 "runpicture.in"
// void grestore(picture *f);
void gen_runpicture19(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 281 "runpicture.in"
  f->append(new drawGrestore());
}

#line 285 "runpicture.in"
// void begingroup(picture *f);
void gen_runpicture20(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 286 "runpicture.in"
  f->append(new drawBegin());
}

#line 290 "runpicture.in"
// void endgroup(picture *f);
void gen_runpicture21(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 291 "runpicture.in"
  f->append(new drawEnd());
}

#line 295 "runpicture.in"
// void _begingroup3(picture *f, string name, real compression,                 real granularity, bool closed, bool tessellate,                 bool dobreak, bool nobreak, triple center, Int interaction);
void gen_runpicture22(stack *Stack)
{
  Int interaction=vm::pop<Int>(Stack);
  triple center=vm::pop<triple>(Stack);
  bool nobreak=vm::pop<bool>(Stack);
  bool dobreak=vm::pop<bool>(Stack);
  bool tessellate=vm::pop<bool>(Stack);
  bool closed=vm::pop<bool>(Stack);
  real granularity=vm::pop<real>(Stack);
  real compression=vm::pop<real>(Stack);
  string name=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 298 "runpicture.in"
  f->append(new drawBegin3(name,compression,granularity,
                           closed,tessellate,dobreak,nobreak,
                           center,(Interaction) intcast(interaction)));
}

#line 304 "runpicture.in"
// void endgroup3(picture *f);
void gen_runpicture23(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 305 "runpicture.in"
  f->append(new drawEnd3());
}

#line 309 "runpicture.in"
// void add(picture *dest, picture *src);
void gen_runpicture24(stack *Stack)
{
  picture * src=vm::pop<picture *>(Stack);
  picture * dest=vm::pop<picture *>(Stack);
#line 310 "runpicture.in"
  dest->add(*src);
}

#line 314 "runpicture.in"
// void prepend(picture *dest, picture *src);
void gen_runpicture25(stack *Stack)
{
  picture * src=vm::pop<picture *>(Stack);
  picture * dest=vm::pop<picture *>(Stack);
#line 315 "runpicture.in"
  dest->prepend(*src);
}

#line 319 "runpicture.in"
// void postscript(picture *f, string s);
void gen_runpicture26(stack *Stack)
{
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 320 "runpicture.in"
  f->append(new drawVerbatim(PostScript,s));
}

#line 324 "runpicture.in"
// void tex(picture *f, string s);
void gen_runpicture27(stack *Stack)
{
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 325 "runpicture.in"
  f->append(new drawVerbatim(TeX,s));
}

#line 329 "runpicture.in"
// void postscript(picture *f, string s, pair min, pair max);
void gen_runpicture28(stack *Stack)
{
  pair max=vm::pop<pair>(Stack);
  pair min=vm::pop<pair>(Stack);
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 330 "runpicture.in"
  f->append(new drawVerbatim(PostScript,s,min,max));
}

#line 334 "runpicture.in"
// void tex(picture *f, string s, pair min, pair max);
void gen_runpicture29(stack *Stack)
{
  pair max=vm::pop<pair>(Stack);
  pair min=vm::pop<pair>(Stack);
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 335 "runpicture.in"
  f->append(new drawVerbatim(TeX,s,min,max));
}

#line 339 "runpicture.in"
// void texpreamble(string s);
void gen_runpicture30(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 340 "runpicture.in"
  string t=s+"\n";
  processDataStruct &pd=processData();
  pd.TeXpipepreamble.push_back(t);
  pd.TeXpreamble.push_back(t);
}

#line 347 "runpicture.in"
// void deletepreamble();
void gen_runpicture31(stack *)
{
#line 348 "runpicture.in"
  if(getSetting<bool>("inlinetex")) {
    unlink(buildname(outname(),"pre").c_str());
  }
}

#line 354 "runpicture.in"
// void _labelpath(picture *f, string s, string size, path g, string justify,                pair offset, pen p);
void gen_runpicture32(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  pair offset=vm::pop<pair>(Stack);
  string justify=vm::pop<string>(Stack);
  path g=vm::pop<path>(Stack);
  string size=vm::pop<string>(Stack);
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 356 "runpicture.in"
  f->append(new drawLabelPath(s,size,g,justify,offset,p));
}

#line 360 "runpicture.in"
// void texreset();
void gen_runpicture33(stack *)
{
#line 361 "runpicture.in"
  processDataStruct &pd=processData();
  pd.TeXpipepreamble.clear();
  pd.TeXpreamble.clear();
  pd.tex.pipeclose();
}

#line 368 "runpicture.in"
// void layer(picture *f);
void gen_runpicture34(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 369 "runpicture.in"
  f->append(new drawLayer());
}

#line 373 "runpicture.in"
// void newpage(picture *f);
void gen_runpicture35(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 374 "runpicture.in"
  f->append(new drawNewPage());
}

#line 378 "runpicture.in"
// void _image(picture *f, realarray2 *data, pair initial, pair final,            penarray *palette=NULL, transform t=identity, bool copy=true,            bool antialias=false);
void gen_runpicture36(stack *Stack)
{
  bool antialias=vm::pop<bool>(Stack,false);
  bool copy=vm::pop<bool>(Stack,true);
  transform t=vm::pop<transform>(Stack,identity);
  penarray * palette=vm::pop<penarray *>(Stack,NULL);
  pair final=vm::pop<pair>(Stack);
  pair initial=vm::pop<pair>(Stack);
  realarray2 * data=vm::pop<realarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 381 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray : nop;
  array *(*copyarray2)(array *a)=copy ? copyArray2 : nop;
  f->append(new drawPaletteImage(*copyarray2(data),*copyarray(palette),
                            t*matrix(initial,final),antialias));
}

#line 388 "runpicture.in"
// void _image(picture *f, penarray2 *data, pair initial, pair final,            transform t=identity, bool copy=true, bool antialias=false);
void gen_runpicture37(stack *Stack)
{
  bool antialias=vm::pop<bool>(Stack,false);
  bool copy=vm::pop<bool>(Stack,true);
  transform t=vm::pop<transform>(Stack,identity);
  pair final=vm::pop<pair>(Stack);
  pair initial=vm::pop<pair>(Stack);
  penarray2 * data=vm::pop<penarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 390 "runpicture.in"
  array *(*copyarray2)(array *a)=copy ? copyArray2 : nop;
  f->append(new drawNoPaletteImage(*copyarray2(data),t*matrix(initial,final),
                                   antialias));
}

#line 396 "runpicture.in"
// void _image(picture *f, callablePen *F, Int width, Int height,            pair initial, pair final, transform t=identity, bool antialias=false);
void gen_runpicture38(stack *Stack)
{
  bool antialias=vm::pop<bool>(Stack,false);
  transform t=vm::pop<transform>(Stack,identity);
  pair final=vm::pop<pair>(Stack);
  pair initial=vm::pop<pair>(Stack);
  Int height=vm::pop<Int>(Stack);
  Int width=vm::pop<Int>(Stack);
  callablePen * F=vm::pop<callablePen *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 398 "runpicture.in"
  f->append(new drawFunctionImage(Stack,F,width,height,
                                  t*matrix(initial,final),antialias));
}

#line 403 "runpicture.in"
// string nativeformat();
void gen_runpicture39(stack *Stack)
{
#line 404 "runpicture.in"
  {Stack->push<string>(nativeformat()); return;}
}

#line 408 "runpicture.in"
// bool latex();
void gen_runpicture40(stack *Stack)
{
#line 409 "runpicture.in"
  {Stack->push<bool>(latex(getSetting<string>("tex"))); return;}
}

#line 413 "runpicture.in"
// bool pdf();
void gen_runpicture41(stack *Stack)
{
#line 414 "runpicture.in"
  {Stack->push<bool>(pdf(getSetting<string>("tex"))); return;}
}

#line 418 "runpicture.in"
// void _shipout(string prefix=emptystring, picture *f, picture *preamble=NULL,              string format=emptystring, bool wait=false, bool view=true,              transform T=identity);
void gen_runpicture42(stack *Stack)
{
  transform T=vm::pop<transform>(Stack,identity);
  bool view=vm::pop<bool>(Stack,true);
  bool wait=vm::pop<bool>(Stack,false);
  string format=vm::pop<string>(Stack,emptystring);
  picture * preamble=vm::pop<picture *>(Stack,NULL);
  picture * f=vm::pop<picture *>(Stack);
  string prefix=vm::pop<string>(Stack,emptystring);
#line 421 "runpicture.in"
  if(prefix.empty()) prefix=outname();

  picture *result=new picture;
  unsigned level=0;
  picture::nodelist::iterator p;
  
  xmap_t xmap=processData().xmap;
  transform Tinv=inverse(T);

  for(p = f->nodes.begin(); p != f->nodes.end(); ++p) {
    transform t=getTransform(xmap,p);
    bool Delete=(t == ZeroTransform);
    if(!Delete && !t.isIdentity()) t=T*t*Tinv;
    picture *group=new picture;
    assert(*p);
    if((*p)->endgroup()) error(nobegin);
    if((*p)->begingroup()) {
      ++level;
      while(p != f->nodes.end() && level) {
        if(!Delete) {
          drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
          group->append(e);
        }
        ++p;
        if(p == f->nodes.end()) break;
        assert(*p);
        if((*p)->begingroup()) ++level;
        if((*p)->endgroup()) {
          if(level) --level;
          else error(nobegin);
        }
      }
    }
    if(p == f->nodes.end()) break;
    assert(*p);
    if(!Delete) {
      drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
      group->append(e);
      result->add(*group);
    }
  }
    
  result->shipout(preamble,prefix,format,wait,view);
}

#line 467 "runpicture.in"
// void shipout3(string prefix, picture *f, string format=emptystring,              real width, real height, real angle, real zoom,              triple m, triple M, pair shift, pair margin, realarray2 *t,              realarray *background, triplearray *lights, realarray2 *diffuse,              realarray2 *specular, bool view=true);
void gen_runpicture43(stack *Stack)
{
  bool view=vm::pop<bool>(Stack,true);
  realarray2 * specular=vm::pop<realarray2 *>(Stack);
  realarray2 * diffuse=vm::pop<realarray2 *>(Stack);
  triplearray * lights=vm::pop<triplearray *>(Stack);
  realarray * background=vm::pop<realarray *>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  pair margin=vm::pop<pair>(Stack);
  pair shift=vm::pop<pair>(Stack);
  triple M=vm::pop<triple>(Stack);
  triple m=vm::pop<triple>(Stack);
  real zoom=vm::pop<real>(Stack);
  real angle=vm::pop<real>(Stack);
  real height=vm::pop<real>(Stack);
  real width=vm::pop<real>(Stack);
  string format=vm::pop<string>(Stack,emptystring);
  picture * f=vm::pop<picture *>(Stack);
  string prefix=vm::pop<string>(Stack);
#line 472 "runpicture.in"
  size_t n=checkArrays(lights,diffuse);
  checkEqual(n,checkArray(specular));
  
  real *T,*Background,*Diffuse,*Specular;
  triple *Lights;

  copyArray2C(T,t,true,4);
  copyArrayC(Background,background);
  copyArrayC(Lights,lights);
  copyArray2C(Diffuse,diffuse,false,4,UseGC);
  copyArray2C(Specular,specular,false,4,UseGC);
    
  f->shipout3(prefix,format,width,height,angle,zoom,m,M,shift,margin,T,
              Background,n,Lights,Diffuse,Specular,view);
  
  delete[] Background;
  delete[] T;
}

#line 492 "runpicture.in"
// void shipout3(string prefix, picture *f, string format=defaultformat3);
void gen_runpicture44(stack *Stack)
{
  string format=vm::pop<string>(Stack,defaultformat3);
  picture * f=vm::pop<picture *>(Stack);
  string prefix=vm::pop<string>(Stack);
#line 493 "runpicture.in"
  f->shipout3(prefix,format);
}

#line 497 "runpicture.in"
// void xmap(string key, transform t=identity);
void gen_runpicture45(stack *Stack)
{
  transform t=vm::pop<transform>(Stack,identity);
  string key=vm::pop<string>(Stack);
#line 498 "runpicture.in"
  xmap_t &xmap=processData().xmap;
  xmap_t::iterator p=xmap.find(key);
  if(p != xmap.end())
    p->second.push_back(t); 
  else {
    xtransform_t *v=new xtransform_t();
    v->push_back(t);
    xmap[key]=*v;
  }
}

#line 510 "runpicture.in"
// void deconstruct(picture *f, picture *preamble=NULL, transform T=identity);
void gen_runpicture46(stack *Stack)
{
  transform T=vm::pop<transform>(Stack,identity);
  picture * preamble=vm::pop<picture *>(Stack,NULL);
  picture * f=vm::pop<picture *>(Stack);
#line 511 "runpicture.in"
  unsigned level=0;

  string prefix=outname();
  const string xformat="svg";

  openpipeout();

  const string Done="Done";
  const string Error="Error";
  
  unsigned arg=0;
  xmap_t xmap=processData().xmap;
  transform Tinv=inverse(T);
    
  for(picture::nodelist::iterator p=f->nodes.begin();;) {
    if(p == f->nodes.end()) break;
       
    picture *group=new picture;
    transform t=getTransform(xmap,p);
    bool Delete=(t == ZeroTransform);
    if(!Delete && !t.isIdentity()) t=T*t*Tinv;

    assert(*p);
    if((*p)->endgroup()) {
      fprintf(pipeout,"%s\n",Error.c_str());
      fflush(pipeout);
      error(nobegin);
    }
    bool clip=false;
    if((*p)->begingroup()) {
      ++level;
      while(p != f->nodes.end() && level) {
        if(!Delete) {
          drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
          group->append(e);
          if((*p)->endclip()) clip=true;
        }
        ++p;
        if(p == f->nodes.end()) break;
        assert(*p);
        if((*p)->begingroup()) ++level;
        if((*p)->endgroup()) {
          if(level) --level;
          else {
            fprintf(pipeout,"%s\n",Error.c_str());
            fflush(pipeout);
            error(nobegin);
          }
        }
      }
    }
    if(p != f->nodes.end()) {
      if(!Delete) {
        drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
        group->append(e);
        if((*p)->endclip()) clip=true;
        ostringstream buf;
        buf << prefix << "_" << arg;
        string outname=buildname(buf.str(),xformat);
        group->shipout(preamble,outname,xformat,false,false);
        bbox b=group->bounds();
        if(!b.empty) {
          fprintf(pipeout,"KEY=%s%d\n",e->KEY.c_str(),clip);
      
          const char *oldlocale=setlocale(LC_NUMERIC,NULL);
          bool override=oldlocale && strcmp(oldlocale,"C") != 0;
          if(override) {
            oldlocale=StrdupNoGC(oldlocale);
            setlocale(LC_NUMERIC,"C");
          }
        
          fprintf(pipeout,"%g %g %g %g\n",b.left,b.bottom,b.right,b.top);
        
          if(override) {
            setlocale(LC_NUMERIC,oldlocale);
            delete[] oldlocale;
          }
        
          fflush(pipeout);
          ++arg;
        }
      }
      ++p;
    }
  }
      
  fprintf(pipeout,"%s\n",Done.c_str());
  fflush(pipeout);
}


// Three-dimensional picture and surface operations

// Bezier curve
#line 606 "runpicture.in"
// void _draw(picture *f, path3 g, triple center=Zero, penarray *p,          real opacity, real shininess, real metallic, real fresnel0,          Int interaction=0);
void gen_runpicture47(stack *Stack)
{
  Int interaction=vm::pop<Int>(Stack,0);
  real fresnel0=vm::pop<real>(Stack);
  real metallic=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  triple center=vm::pop<triple>(Stack,Zero);
  path3 g=vm::pop<path3>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 609 "runpicture.in"
  if(g.size() > 0)
    f->append(new drawPath3(g,center,*p,opacity,shininess,metallic,fresnel0,
                            (Interaction) intcast(interaction)));
}

// Bezier patch
#line 616 "runpicture.in"
// void draw(picture *f, triplearray2 *P, triple center, bool straight,          penarray *p, real opacity, real shininess, real metallic,          real fresnel0, penarray *colors, Int interaction,          bool primitive=false);
void gen_runpicture48(stack *Stack)
{
  bool primitive=vm::pop<bool>(Stack,false);
  Int interaction=vm::pop<Int>(Stack);
  penarray * colors=vm::pop<penarray *>(Stack);
  real fresnel0=vm::pop<real>(Stack);
  real metallic=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  bool straight=vm::pop<bool>(Stack);
  triple center=vm::pop<triple>(Stack);
  triplearray2 * P=vm::pop<triplearray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 620 "runpicture.in"
  f->append(new drawBezierPatch(*P,center,straight,*p,opacity,shininess,
                                metallic,fresnel0,*colors,
                                (Interaction) intcast(interaction),primitive));
}

// Bezier triangle
#line 627 "runpicture.in"
// void drawbeziertriangle(picture *f, triplearray2 *P, triple center,                        bool straight, penarray *p, real opacity,                        real shininess, real metallic, real fresnel0,                        penarray *colors, Int interaction,                        bool primitive=false);
void gen_runpicture49(stack *Stack)
{
  bool primitive=vm::pop<bool>(Stack,false);
  Int interaction=vm::pop<Int>(Stack);
  penarray * colors=vm::pop<penarray *>(Stack);
  real fresnel0=vm::pop<real>(Stack);
  real metallic=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  bool straight=vm::pop<bool>(Stack);
  triple center=vm::pop<triple>(Stack);
  triplearray2 * P=vm::pop<triplearray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 632 "runpicture.in"
  f->append(new drawBezierTriangle(*P,center,straight,*p,opacity,shininess,
                                   metallic,fresnel0,*colors,
                                   (Interaction) intcast(interaction),
                                   primitive));
}

// General NURBS curve
#line 640 "runpicture.in"
// void draw(picture *f, triplearray *P, realarray *knot,          realarray *weights=emptyarray, pen p);
void gen_runpicture50(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  realarray * weights=vm::pop<realarray *>(Stack,emptyarray);
  realarray * knot=vm::pop<realarray *>(Stack);
  triplearray * P=vm::pop<triplearray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 642 "runpicture.in"
  f->append(new drawNurbsPath3(*P,knot,weights,p));
}

// General NURBS surface
#line 647 "runpicture.in"
// void draw(picture *f, triplearray2 *P, realarray *uknot, realarray *vknot,          realarray2 *weights=emptyarray, penarray *p, real opacity,          real shininess,real metallic, real fresnel0, penarray *colors);
void gen_runpicture51(stack *Stack)
{
  penarray * colors=vm::pop<penarray *>(Stack);
  real fresnel0=vm::pop<real>(Stack);
  real metallic=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  realarray2 * weights=vm::pop<realarray2 *>(Stack,emptyarray);
  realarray * vknot=vm::pop<realarray *>(Stack);
  realarray * uknot=vm::pop<realarray *>(Stack);
  triplearray2 * P=vm::pop<triplearray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 650 "runpicture.in"
  f->append(new drawNurbs(*P,uknot,vknot,weights,*p,opacity,shininess,
                          metallic,fresnel0,*colors));
}

// Sphere primitive
#line 656 "runpicture.in"
// void drawSphere(picture *f, realarray2 *t, bool half=false, penarray *p,                real opacity, real shininess, real metallic, real fresnel0,                Int type);
void gen_runpicture52(stack *Stack)
{
  Int type=vm::pop<Int>(Stack);
  real fresnel0=vm::pop<real>(Stack);
  real metallic=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  bool half=vm::pop<bool>(Stack,false);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 659 "runpicture.in"
  f->append(new drawSphere(*t,half,*p,opacity,shininess,metallic,fresnel0,
                           intcast(type)));
}

// Cylinder primitive
#line 665 "runpicture.in"
// void drawCylinder(picture *f, realarray2 *t, penarray *p, real opacity,                  real shininess, real metallic, real fresnel0,                  bool core=false);
void gen_runpicture53(stack *Stack)
{
  bool core=vm::pop<bool>(Stack,false);
  real fresnel0=vm::pop<real>(Stack);
  real metallic=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 668 "runpicture.in"
  f->append(new drawCylinder(*t,*p,opacity,shininess,metallic,fresnel0,core));
}

// Disk primitive
#line 673 "runpicture.in"
// void drawDisk(picture *f, realarray2 *t, penarray *p, real opacity,              real shininess, real metallic, real fresnel0);
void gen_runpicture54(stack *Stack)
{
  real fresnel0=vm::pop<real>(Stack);
  real metallic=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 675 "runpicture.in"
  f->append(new drawDisk(*t,*p,opacity,shininess,metallic,fresnel0));
}

// Tube primitive
#line 680 "runpicture.in"
// void drawTube(picture *f, triplearray *g, real width, penarray *p,              real opacity, real shininess, real metallic, real fresnel0,              triple min, triple max, bool core=false);
void gen_runpicture55(stack *Stack)
{
  bool core=vm::pop<bool>(Stack,false);
  triple max=vm::pop<triple>(Stack);
  triple min=vm::pop<triple>(Stack);
  real fresnel0=vm::pop<real>(Stack);
  real metallic=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  real width=vm::pop<real>(Stack);
  triplearray * g=vm::pop<triplearray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 683 "runpicture.in"
  f->append(new drawTube(*g,width,*p,opacity,shininess,metallic,fresnel0,
                         min,max,core));
}

// Draw pixel
#line 689 "runpicture.in"
// void drawpixel(picture *f, triple v, pen p, real width=1.0);
void gen_runpicture56(stack *Stack)
{
  real width=vm::pop<real>(Stack,1.0);
  pen p=vm::pop<pen>(Stack);
  triple v=vm::pop<triple>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 690 "runpicture.in"
  f->append(new drawPixel(v,p,width));
}

// Draw triangles
#line 695 "runpicture.in"
// void draw(picture *f, triplearray *v, Intarray2 *vi,          triplearray *n, Intarray2 *ni,          penarray *p, real opacity, real shininess,           real metallic, real fresnel0,          penarray *c=emptyarray, Intarray2 *ci=emptyarray);
void gen_runpicture57(stack *Stack)
{
  Intarray2 * ci=vm::pop<Intarray2 *>(Stack,emptyarray);
  penarray * c=vm::pop<penarray *>(Stack,emptyarray);
  real fresnel0=vm::pop<real>(Stack);
  real metallic=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  Intarray2 * ni=vm::pop<Intarray2 *>(Stack);
  triplearray * n=vm::pop<triplearray *>(Stack);
  Intarray2 * vi=vm::pop<Intarray2 *>(Stack);
  triplearray * v=vm::pop<triplearray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 700 "runpicture.in"
  f->append(new drawTriangles(*v,*vi,*n,*ni,*p,opacity,shininess,metallic,
                              fresnel0,*c,*ci));
}

#line 705 "runpicture.in"
// triple min3(picture *f);
void gen_runpicture58(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 706 "runpicture.in"
  {Stack->push<triple>(f->bounds3().Min()); return;}
}

#line 710 "runpicture.in"
// triple max3(picture *f);
void gen_runpicture59(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 711 "runpicture.in"
  {Stack->push<triple>(f->bounds3().Max()); return;}
}

#line 715 "runpicture.in"
// triple size3(picture *f);
void gen_runpicture60(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 716 "runpicture.in"
  bbox3 b=f->bounds3();
  {Stack->push<triple>(b.Max()-b.Min()); return;}
}

#line 721 "runpicture.in"
// pair minratio(picture *f);
void gen_runpicture61(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 722 "runpicture.in"
  {Stack->push<pair>(f->ratio(::min)); return;}
}

#line 726 "runpicture.in"
// pair maxratio(picture *f);
void gen_runpicture62(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 727 "runpicture.in"
  {Stack->push<pair>(f->ratio(::max)); return;}
}

#line 731 "runpicture.in"
// bool is3D(picture *f);
void gen_runpicture63(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 732 "runpicture.in"
  {Stack->push<bool>(f->have3D()); return;}
}

} // namespace run

namespace trans {

void gen_runpicture_venv(venv &ve)
{
#line 126 "runpicture.in"
  REGISTER_BLTIN(run::newPicture,"newPicture");
#line 131 "runpicture.in"
  addFunc(ve, run::gen_runpicture1, primBoolean(), SYM(empty), formal(primPicture(), SYM(f), false, false));
#line 136 "runpicture.in"
  addFunc(ve, run::gen_runpicture2, primVoid(), SYM(erase), formal(primPicture(), SYM(f), false, false));
#line 141 "runpicture.in"
  addFunc(ve, run::gen_runpicture3, primPair(), SYM(min), formal(primPicture(), SYM(f), false, false));
#line 146 "runpicture.in"
  addFunc(ve, run::gen_runpicture4, primPair(), SYM(max), formal(primPicture(), SYM(f), false, false));
#line 151 "runpicture.in"
  addFunc(ve, run::gen_runpicture5, primPair(), SYM(size), formal(primPicture(), SYM(f), false, false));
#line 157 "runpicture.in"
  addFunc(ve, run::gen_runpicture6, primVoid(), SYM(_draw), formal(primPicture(), SYM(f), false, false), formal(primPath(), SYM(g), false, false), formal(primPen(), SYM(p), false, false));
#line 162 "runpicture.in"
  addFunc(ve, run::gen_runpicture7, primVoid(), SYM(fill), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primPen(), SYM(p), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 168 "runpicture.in"
  addFunc(ve, run::gen_runpicture8, primVoid(), SYM(latticeshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(penArray2()  , SYM(p), false, false), formal(primTransform(), SYM(t), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 177 "runpicture.in"
  addFunc(ve, run::gen_runpicture9, primVoid(), SYM(axialshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(pena), false, false), formal(primPair(), SYM(a), false, false), formal(primBoolean(), SYM(extenda), true, false), formal(primPen(), SYM(penb), false, false), formal(primPair(), SYM(b), false, false), formal(primBoolean(), SYM(extendb), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 186 "runpicture.in"
  addFunc(ve, run::gen_runpicture10, primVoid(), SYM(radialshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(pena), false, false), formal(primPair(), SYM(a), false, false), formal(primReal(), SYM(ra), false, false), formal(primBoolean(), SYM(extenda), true, false), formal(primPen(), SYM(penb), false, false), formal(primPair(), SYM(b), false, false), formal(primReal(), SYM(rb), false, false), formal(primBoolean(), SYM(extendb), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 195 "runpicture.in"
  addFunc(ve, run::gen_runpicture11, primVoid(), SYM(gouraudshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(penArray()  , SYM(p), false, false), formal(pairArray(), SYM(z), false, false), formal(IntArray(), SYM(edges), false, false), formal(primBoolean(), SYM(copy), true, false));
#line 206 "runpicture.in"
  addFunc(ve, run::gen_runpicture12, primVoid(), SYM(gouraudshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(penArray()  , SYM(p), false, false), formal(IntArray(), SYM(edges), false, false), formal(primBoolean(), SYM(copy), true, false));
#line 230 "runpicture.in"
  addFunc(ve, run::gen_runpicture13, primVoid(), SYM(tensorshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(penArray2()  , SYM(p), false, false), formal(pathArray()  , SYM(b), true, false), formal(pairArray2(), SYM(z), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 245 "runpicture.in"
  addFunc(ve, run::gen_runpicture14, primVoid(), SYM(functionshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(primString() , SYM(shader), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 253 "runpicture.in"
  addFunc(ve, run::gen_runpicture15, primVoid(), SYM(clip), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 263 "runpicture.in"
  addFunc(ve, run::gen_runpicture16, primVoid(), SYM(beginclip), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 270 "runpicture.in"
  addFunc(ve, run::gen_runpicture17, primVoid(), SYM(endclip), formal(primPicture(), SYM(f), false, false));
#line 275 "runpicture.in"
  addFunc(ve, run::gen_runpicture18, primVoid(), SYM(gsave), formal(primPicture(), SYM(f), false, false));
#line 280 "runpicture.in"
  addFunc(ve, run::gen_runpicture19, primVoid(), SYM(grestore), formal(primPicture(), SYM(f), false, false));
#line 285 "runpicture.in"
  addFunc(ve, run::gen_runpicture20, primVoid(), SYM(begingroup), formal(primPicture(), SYM(f), false, false));
#line 290 "runpicture.in"
  addFunc(ve, run::gen_runpicture21, primVoid(), SYM(endgroup), formal(primPicture(), SYM(f), false, false));
#line 295 "runpicture.in"
  addFunc(ve, run::gen_runpicture22, primVoid(), SYM(_begingroup3), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(name), false, false), formal(primReal(), SYM(compression), false, false), formal(primReal(), SYM(granularity), false, false), formal(primBoolean(), SYM(closed), false, false), formal(primBoolean(), SYM(tessellate), false, false), formal(primBoolean(), SYM(dobreak), false, false), formal(primBoolean(), SYM(nobreak), false, false), formal(primTriple(), SYM(center), false, false), formal(primInt(), SYM(interaction), false, false));
#line 304 "runpicture.in"
  addFunc(ve, run::gen_runpicture23, primVoid(), SYM(endgroup3), formal(primPicture(), SYM(f), false, false));
#line 309 "runpicture.in"
  addFunc(ve, run::gen_runpicture24, primVoid(), SYM(add), formal(primPicture(), SYM(dest), false, false), formal(primPicture(), SYM(src), false, false));
#line 314 "runpicture.in"
  addFunc(ve, run::gen_runpicture25, primVoid(), SYM(prepend), formal(primPicture(), SYM(dest), false, false), formal(primPicture(), SYM(src), false, false));
#line 319 "runpicture.in"
  addFunc(ve, run::gen_runpicture26, primVoid(), SYM(postscript), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(s), false, false));
#line 324 "runpicture.in"
  addFunc(ve, run::gen_runpicture27, primVoid(), SYM(tex), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(s), false, false));
#line 329 "runpicture.in"
  addFunc(ve, run::gen_runpicture28, primVoid(), SYM(postscript), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(s), false, false), formal(primPair(), SYM(min), false, false), formal(primPair(), SYM(max), false, false));
#line 334 "runpicture.in"
  addFunc(ve, run::gen_runpicture29, primVoid(), SYM(tex), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(s), false, false), formal(primPair(), SYM(min), false, false), formal(primPair(), SYM(max), false, false));
#line 339 "runpicture.in"
  addFunc(ve, run::gen_runpicture30, primVoid(), SYM(texpreamble), formal(primString() , SYM(s), false, false));
#line 347 "runpicture.in"
  addFunc(ve, run::gen_runpicture31, primVoid(), SYM(deletepreamble));
#line 354 "runpicture.in"
  addFunc(ve, run::gen_runpicture32, primVoid(), SYM(_labelpath), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(s), false, false), formal(primString() , SYM(size), false, false), formal(primPath(), SYM(g), false, false), formal(primString() , SYM(justify), false, false), formal(primPair(), SYM(offset), false, false), formal(primPen(), SYM(p), false, false));
#line 360 "runpicture.in"
  addFunc(ve, run::gen_runpicture33, primVoid(), SYM(texreset));
#line 368 "runpicture.in"
  addFunc(ve, run::gen_runpicture34, primVoid(), SYM(layer), formal(primPicture(), SYM(f), false, false));
#line 373 "runpicture.in"
  addFunc(ve, run::gen_runpicture35, primVoid(), SYM(newpage), formal(primPicture(), SYM(f), false, false));
#line 378 "runpicture.in"
  addFunc(ve, run::gen_runpicture36, primVoid(), SYM(_image), formal(primPicture(), SYM(f), false, false), formal(realArray2(), SYM(data), false, false), formal(primPair(), SYM(initial), false, false), formal(primPair(), SYM(final), false, false), formal(penArray()  , SYM(palette), true, false), formal(primTransform(), SYM(t), true, false), formal(primBoolean(), SYM(copy), true, false), formal(primBoolean(), SYM(antialias), true, false));
#line 388 "runpicture.in"
  addFunc(ve, run::gen_runpicture37, primVoid(), SYM(_image), formal(primPicture(), SYM(f), false, false), formal(penArray2()  , SYM(data), false, false), formal(primPair(), SYM(initial), false, false), formal(primPair(), SYM(final), false, false), formal(primTransform(), SYM(t), true, false), formal(primBoolean(), SYM(copy), true, false), formal(primBoolean(), SYM(antialias), true, false));
#line 396 "runpicture.in"
  addFunc(ve, run::gen_runpicture38, primVoid(), SYM(_image), formal(primPicture(), SYM(f), false, false), formal(penFunction(), SYM(f), false, false), formal(primInt(), SYM(width), false, false), formal(primInt(), SYM(height), false, false), formal(primPair(), SYM(initial), false, false), formal(primPair(), SYM(final), false, false), formal(primTransform(), SYM(t), true, false), formal(primBoolean(), SYM(antialias), true, false));
#line 403 "runpicture.in"
  addFunc(ve, run::gen_runpicture39, primString() , SYM(nativeformat));
#line 408 "runpicture.in"
  addFunc(ve, run::gen_runpicture40, primBoolean(), SYM(latex));
#line 413 "runpicture.in"
  addFunc(ve, run::gen_runpicture41, primBoolean(), SYM(pdf));
#line 418 "runpicture.in"
  addFunc(ve, run::gen_runpicture42, primVoid(), SYM(_shipout), formal(primString() , SYM(prefix), true, false), formal(primPicture(), SYM(f), false, false), formal(primPicture(), SYM(preamble), true, false), formal(primString() , SYM(format), true, false), formal(primBoolean(), SYM(wait), true, false), formal(primBoolean(), SYM(view), true, false), formal(primTransform(), SYM(t), true, false));
#line 467 "runpicture.in"
  addFunc(ve, run::gen_runpicture43, primVoid(), SYM(shipout3), formal(primString() , SYM(prefix), false, false), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(format), true, false), formal(primReal(), SYM(width), false, false), formal(primReal(), SYM(height), false, false), formal(primReal(), SYM(angle), false, false), formal(primReal(), SYM(zoom), false, false), formal(primTriple(), SYM(m), false, false), formal(primTriple(), SYM(m), false, false), formal(primPair(), SYM(shift), false, false), formal(primPair(), SYM(margin), false, false), formal(realArray2(), SYM(t), false, false), formal(realArray(), SYM(background), false, false), formal(tripleArray(), SYM(lights), false, false), formal(realArray2(), SYM(diffuse), false, false), formal(realArray2(), SYM(specular), false, false), formal(primBoolean(), SYM(view), true, false));
#line 492 "runpicture.in"
  addFunc(ve, run::gen_runpicture44, primVoid(), SYM(shipout3), formal(primString() , SYM(prefix), false, false), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(format), true, false));
#line 497 "runpicture.in"
  addFunc(ve, run::gen_runpicture45, primVoid(), SYM(xmap), formal(primString() , SYM(key), false, false), formal(primTransform(), SYM(t), true, false));
#line 510 "runpicture.in"
  addFunc(ve, run::gen_runpicture46, primVoid(), SYM(deconstruct), formal(primPicture(), SYM(f), false, false), formal(primPicture(), SYM(preamble), true, false), formal(primTransform(), SYM(t), true, false));
#line 602 "runpicture.in"
  addFunc(ve, run::gen_runpicture47, primVoid(), SYM(_draw), formal(primPicture(), SYM(f), false, false), formal(primPath3(), SYM(g), false, false), formal(primTriple(), SYM(center), true, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primReal(), SYM(metallic), false, false), formal(primReal(), SYM(fresnel0), false, false), formal(primInt(), SYM(interaction), true, false));
#line 615 "runpicture.in"
  addFunc(ve, run::gen_runpicture48, primVoid(), SYM(draw), formal(primPicture(), SYM(f), false, false), formal(tripleArray2(), SYM(p), false, false), formal(primTriple(), SYM(center), false, false), formal(primBoolean(), SYM(straight), false, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primReal(), SYM(metallic), false, false), formal(primReal(), SYM(fresnel0), false, false), formal(penArray()  , SYM(colors), false, false), formal(primInt(), SYM(interaction), false, false), formal(primBoolean(), SYM(primitive), true, false));
#line 626 "runpicture.in"
  addFunc(ve, run::gen_runpicture49, primVoid(), SYM(drawbeziertriangle), formal(primPicture(), SYM(f), false, false), formal(tripleArray2(), SYM(p), false, false), formal(primTriple(), SYM(center), false, false), formal(primBoolean(), SYM(straight), false, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primReal(), SYM(metallic), false, false), formal(primReal(), SYM(fresnel0), false, false), formal(penArray()  , SYM(colors), false, false), formal(primInt(), SYM(interaction), false, false), formal(primBoolean(), SYM(primitive), true, false));
#line 639 "runpicture.in"
  addFunc(ve, run::gen_runpicture50, primVoid(), SYM(draw), formal(primPicture(), SYM(f), false, false), formal(tripleArray(), SYM(p), false, false), formal(realArray(), SYM(knot), false, false), formal(realArray(), SYM(weights), true, false), formal(primPen(), SYM(p), false, false));
#line 646 "runpicture.in"
  addFunc(ve, run::gen_runpicture51, primVoid(), SYM(draw), formal(primPicture(), SYM(f), false, false), formal(tripleArray2(), SYM(p), false, false), formal(realArray(), SYM(uknot), false, false), formal(realArray(), SYM(vknot), false, false), formal(realArray2(), SYM(weights), true, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primReal(), SYM(metallic), false, false), formal(primReal(), SYM(fresnel0), false, false), formal(penArray()  , SYM(colors), false, false));
#line 655 "runpicture.in"
  addFunc(ve, run::gen_runpicture52, primVoid(), SYM(drawSphere), formal(primPicture(), SYM(f), false, false), formal(realArray2(), SYM(t), false, false), formal(primBoolean(), SYM(half), true, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primReal(), SYM(metallic), false, false), formal(primReal(), SYM(fresnel0), false, false), formal(primInt(), SYM(type), false, false));
#line 664 "runpicture.in"
  addFunc(ve, run::gen_runpicture53, primVoid(), SYM(drawCylinder), formal(primPicture(), SYM(f), false, false), formal(realArray2(), SYM(t), false, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primReal(), SYM(metallic), false, false), formal(primReal(), SYM(fresnel0), false, false), formal(primBoolean(), SYM(core), true, false));
#line 672 "runpicture.in"
  addFunc(ve, run::gen_runpicture54, primVoid(), SYM(drawDisk), formal(primPicture(), SYM(f), false, false), formal(realArray2(), SYM(t), false, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primReal(), SYM(metallic), false, false), formal(primReal(), SYM(fresnel0), false, false));
#line 679 "runpicture.in"
  addFunc(ve, run::gen_runpicture55, primVoid(), SYM(drawTube), formal(primPicture(), SYM(f), false, false), formal(tripleArray(), SYM(g), false, false), formal(primReal(), SYM(width), false, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primReal(), SYM(metallic), false, false), formal(primReal(), SYM(fresnel0), false, false), formal(primTriple(), SYM(min), false, false), formal(primTriple(), SYM(max), false, false), formal(primBoolean(), SYM(core), true, false));
#line 688 "runpicture.in"
  addFunc(ve, run::gen_runpicture56, primVoid(), SYM(drawpixel), formal(primPicture(), SYM(f), false, false), formal(primTriple(), SYM(v), false, false), formal(primPen(), SYM(p), false, false), formal(primReal(), SYM(width), true, false));
#line 694 "runpicture.in"
  addFunc(ve, run::gen_runpicture57, primVoid(), SYM(draw), formal(primPicture(), SYM(f), false, false), formal(tripleArray(), SYM(v), false, false), formal(IntArray2(), SYM(vi), false, false), formal(tripleArray(), SYM(n), false, false), formal(IntArray2(), SYM(ni), false, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primReal(), SYM(metallic), false, false), formal(primReal(), SYM(fresnel0), false, false), formal(penArray()  , SYM(c), true, false), formal(IntArray2(), SYM(ci), true, false));
#line 705 "runpicture.in"
  addFunc(ve, run::gen_runpicture58, primTriple(), SYM(min3), formal(primPicture(), SYM(f), false, false));
#line 710 "runpicture.in"
  addFunc(ve, run::gen_runpicture59, primTriple(), SYM(max3), formal(primPicture(), SYM(f), false, false));
#line 715 "runpicture.in"
  addFunc(ve, run::gen_runpicture60, primTriple(), SYM(size3), formal(primPicture(), SYM(f), false, false));
#line 721 "runpicture.in"
  addFunc(ve, run::gen_runpicture61, primPair(), SYM(minratio), formal(primPicture(), SYM(f), false, false));
#line 726 "runpicture.in"
  addFunc(ve, run::gen_runpicture62, primPair(), SYM(maxratio), formal(primPicture(), SYM(f), false, false));
#line 731 "runpicture.in"
  addFunc(ve, run::gen_runpicture63, primBoolean(), SYM(is3D), formal(primPicture(), SYM(f), false, false));
}

} // namespace trans
