% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaCrossover.R
\name{xegaGaUPCrossGene}
\alias{xegaGaUPCrossGene}
\title{Parameterized uniform crossover of 2 genes.}
\usage{
xegaGaUPCrossGene(gg1, gg2, lF)
}
\arguments{
\item{gg1}{A binary gene.}

\item{gg2}{A binary gene.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A list of one binary gene.
}
\description{
\code{xegaGaUPCrossGene()} swaps alleles of both genes
             with a probability of \code{lF$UCrossSwap()}. 
             It generates a random 
             mask which is used to build the new gene.
}
\examples{
gene1<-xegaGaInitGene(lFxegaGaGene)
gene2<-xegaGaInitGene(lFxegaGaGene)
xegaGaDecodeGene(gene1, lFxegaGaGene)
xegaGaDecodeGene(gene2, lFxegaGaGene)
gene3<-xegaGaUPCrossGene(gene1, gene2, lFxegaGaGene)
xegaGaDecodeGene(gene3[[1]], lFxegaGaGene)
}
\references{
Spears William and De Jong, Kenneth (1991):
  On the Virtues of Parametrized Uniform Crossover. 
  In: Belew, Richar K. and Booker, Lashon B. (Ed.)
  Proceedings of the Fourth International Conference on Genetic Algorithms,
  Morgan Kaufmann Publishers, Los Altos, California, pp. 230-236.
  (ISBN:1-55860-208-9)
}
\seealso{
Other Crossover (Returns 1 Kid): 
\code{\link{xegaGaCrossGene}()},
\code{\link{xegaGaUCrossGene}()}
}
\concept{Crossover (Returns 1 Kid)}
