% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_named_list}
\alias{assert_named_list}
\title{Assert an object is a list with named elements}
\usage{
assert_named_list(x)
}
\arguments{
\item{x}{[list] List to check}
}
\value{
[none] stop if assertion fails
}
\description{
Stops if:
\itemize{
 \item{x is not a list}
 \item{x is a data.frame}
 \item{x has no names}
 \item{x has any NA names}
 \item{x has any zero-length names}
 \item{x has any whitespace-only names}
}
}
\seealso{
Other assertions: 
\code{\link{assert_dir_exists}()},
\code{\link{assert_scalar}()},
\code{\link{assert_scalar_not_empty}()},
\code{\link{assert_type}()}
}
\concept{assertions}
