% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_tables.R
\name{summary_infection_risk}
\alias{summary_infection_risk}
\title{Generate an Outbreak Risk Simulation Table}
\usage{
summary_infection_risk(
  yr,
  disease = "Measles",
  kindergarten_size = 200,
  VE = NULL,
  r0_custom = NULL
)
}
\arguments{
\item{yr}{The year for the analysis (e.g., 2024).}

\item{disease}{The disease to model. Choose from "Measles", "Pertussis",
"Chickenpox", or "Custom". Default is "Measles".}

\item{kindergarten_size}{The size of the school cohort. Default is 200.}

\item{VE}{Vaccine effectiveness. If NULL (the default), a sensible default is
used for the chosen disease (e.g., 0.97 for Measles). A user-provided
value (0 to 1) will override the default.}

\item{r0_custom}{The basic reproduction number (R0) for a custom disease.
This parameter is required and must be a positive number if `disease` is set to "Custom".}
}
\value{
A data frame containing the formatted risk analysis table.
}
\description{
Creates a summary table of outbreak risk for a given year. The analysis
includes scenarios for the statewide average coverage rate as well as for
counties at the minimum, maximum, and quartile coverage rates. This function
can model pre-set diseases or a custom disease with a user-specified R0.
}
\examples{
# Example 1: Standard analysis for Measles in 2024 (uses default VE of 0.97)
summary_infection_risk(yr = 2024, disease = "Measles")

# Example 2: Analysis for Pertussis, overriding the default VE
summary_infection_risk(yr = 2024, disease = "Pertussis", VE = 0.91)

# Example 3: Analysis for a custom disease (e.g., Mumps-like)
summary_infection_risk(yr = 2024, disease = "Custom", VE = 0.88, r0_custom = 11)
}
