% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlged.R
\name{mlged}
\alias{mlged}
\title{Generalized Error distribution maximum likelihood estimation}
\usage{
mlged(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{currently affects nothing.}
}
\value{
\code{mlged} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for the
parameters \code{mean}, \code{sd}, \code{nu} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
Joint maximum likelihood estimation as implemented by \link[fGarch:dist-gedFit]{fGarch::gedFit}.
}
\details{
For the density function of the Student t-distribution see
\link[fGarch:dist-ged]{ged}.
}
\examples{
mlged(precip)
}
\references{
Nelson D.B. (1991); Conditional Heteroscedasticity in Asset
Returns: A New Approach, Econometrica, 59, 347<U+2013>370.

Fernandez C., Steel M.F.J. (2000); On Bayesian Modelling of Fat Tails and
Skewness, Preprint.
}
\seealso{
\link[fGarch:dist-ged]{ged} for the Student t-density.
}
