% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_tteICE.R
\name{print.tteICE}
\alias{print.tteICE}
\title{Print a short summary of the estimated treatment effect}
\usage{
\method{print}{tteICE}(x, digits = 3, ...)
}
\arguments{
\item{x}{A fitted object returned by the function \code{surv.tteICE} or \code{scr.tteICE}.}

\item{digits}{The digits of the results}

\item{...}{Other augments in function \code{\link{print.default}}}
}
\value{
Print the summary of a tteICE object
}
\description{
This function summarize the results
}
\examples{
## load data
data(bmt)
bmt = transform(bmt, d4=d2+d3)
A = as.numeric(bmt$group>1)
## print the results
for (st in c('composite','natural','removed','whileon','principal')){
 fit = surv.tteICE(A, bmt$t2, bmt$d4, st)
 print(fit)
}
for (st in c('composite','natural','removed','whileon','principal')){
 fit = scr.tteICE(A, bmt$t1, bmt$d1, bmt$t2, bmt$d2, st)
 print(fit, digits=2)
}

}
\seealso{
\code{\link[tteICE]{surv.tteICE}},
\code{\link[tteICE]{scr.tteICE}}
}
