% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{estimate.cgarch.spec}
\alias{estimate.cgarch.spec}
\alias{estimate}
\alias{estimate.dcc.spec}
\alias{estimate.gogarch.spec}
\title{Estimates a model given a specification.}
\usage{
\method{estimate}{cgarch.spec}(
  object,
  solver = "solnp",
  control = list(trace = 0),
  return_hessian = TRUE,
  ...
)

\method{estimate}{dcc.spec}(
  object,
  solver = "solnp",
  control = list(trace = 0),
  return_hessian = TRUE,
  ...
)

\method{estimate}{gogarch.spec}(object, trace = FALSE, ...)
}
\arguments{
\item{object}{an object of class \dQuote{cgarch.spec}, \dQuote{dcc.spec} or
\dQuote{gogarch.spec}.}

\item{solver}{the solver to use for the second stage estimation of the multivariate
dynamics. Valid choices are \code{\link[Rsolnp]{solnp}}, \code{\link[nloptr]{nloptr}}
and \code{\link[stats]{optim}}, with the latter using the \dQuote{L-BFGS-B} method.
This option is inactive for the GOGARCH model which uses the default solver in
package \dQuote{tsgarch} for the estimation of the independent factors.}

\item{control}{solver control parameters.}

\item{return_hessian}{whether to calculate and return the partitioned hessian
of the model (see details). Not applicable in the case of the GOGARCH model.}

\item{...}{for the GOGARCH model, additional options passed to the \code{\link{radical}}
function.}

\item{trace}{whether to print tracing information for the GOGARCH model estimation.}
}
\value{
An estimated object of one of either \dQuote{cgarch.estimate},
\dQuote{dcc.estimate} or \dQuote{gogarch.estimate}.
}
\description{
Method for estimating one of the models in the package given a specification object.
}
\details{
\subsection{DCC and Copula Models}{

Estimation assumes a 2-stage approach whereby the pre-estimated
GARCH models (first stage) are used to estimate the Copula or DCC dynamics. In
the case of the constant correlation Gaussian model, there are no parameters to estimate.
Whilst this 2-stage approach results in a very fast estimation, the calculation
of the standard errors based on the partitioned hessian is quite expensive. The
user can create a futures \code{\link[future]{plan}} to take advantage of parallel
functionality which for large dimensional problems leads to a large speedup.
Additionally, the option of not calculating the hessian (\dQuote{return_hessian})
is available. In that case, the scores are still calculated and the resulting
standard errors will be based on the outer product of gradients.
}

\subsection{GOGARCH Model}{

The independent factors are calculated by first pre-whitening the data (PCA),
selecting the number of factors, and then solving for the rotation matrix. A
GARCH model is then estimated on each factor. A minimal amount of information
is retained in the estimation object and most of the heavy lifting related to
co-moment matrices, weighted moments etc is done through dedicated methods.
The estimation method makes use of parallel processing for the independent
factor GARCH models which can be setup using \code{\link[future]{plan}}.
Additionally, the RADICAL algorithm benefits from part parallelization which
can be controlled using \code{\link[RcppParallel]{setThreadOptions}}.
}
}
\author{
Alexios Galanos
}
