#'QME objective function
#'
#'
#'@param bet parameter values. Column matrix with p rows.
#'@param x model matrix
#'@param y response variable, column matrix
#'@param cv threshold value (see \code{\link{qme}}, argument \code{cval}, for more information).
#'
#'@return
#'Returns the value of the objective function for given parameter values
#'
#'@export
#'@author Anita Lindmark and Maria Karlsson
#'@seealso \code{\link{qme}}

funcval.QME <- function(bet,x,y,cv)
{
  max.xtb.cval <- pmax(x%*%bet, cv)
  ind <- ifelse(abs(y-max.xtb.cval)<cv,((y-max.xtb.cval)^2-cv^2),0)
  funcvalue <- sum(ind)
  return(funcvalue)
}
