% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockcv2rsample.R
\name{blockcv2rsample}
\alias{blockcv2rsample}
\title{Convert an object created with \code{blockCV} to an \code{rsample} object}
\usage{
blockcv2rsample(x, data)
}
\arguments{
\item{x}{a object created with a \code{blockCV} function}

\item{data}{the \code{sf} object used to create \code{x}}
}
\value{
an \code{rsample} object
}
\description{
This function converts objects created with \code{blockCV} to \code{rsample} objects
that can be used by \code{tidysdm}. BlockCV provides more sophisticated sampling
options than the \code{spatialsample} library. For example, it is possible to
stratify the sampling to ensure that presences and absences are evenly
distributed among the folds (see the example below).
}
\details{
Note that currently only objects of type \code{cv_spatial} and \code{cv_cluster} are
supported.
}
\examples{
\dontshow{if (rlang::is_installed("blockCV")) withAutoprint(\{ # examplesIf}
library(blockCV)
points <- read.csv(system.file("extdata/", "species.csv",
  package = "blockCV"
))
pa_data <- sf::st_as_sf(points, coords = c("x", "y"), crs = 7845)
sb1 <- cv_spatial(
  x = pa_data,
  column = "occ", # the response column to balance the folds
  k = 5, # number of folds
  size = 350000, # size of the blocks in metres
  selection = "random", # random blocks-to-fold
  iteration = 10
) # find evenly dispersed folds
sb1_rsample <- blockcv2rsample(sb1, pa_data)
class(sb1_rsample)
autoplot(sb1_rsample)
\dontshow{\}) # examplesIf}
}
