% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot_simple_ensemble.R
\name{autoplot.simple_ensemble}
\alias{autoplot.simple_ensemble}
\title{Plot the results of a simple ensemble}
\usage{
\method{autoplot}{simple_ensemble}(
  object,
  rank_metric = NULL,
  metric = NULL,
  std_errs = stats::qnorm(0.95),
  ...
)
}
\arguments{
\item{object}{A \code{\link{simple_ensemble}} whose elements have results.}

\item{rank_metric}{A character string for which metric should be used to rank
the results. If none is given, the first metric in the metric set is used
(after filtering by the \code{metric} option).}

\item{metric}{A character vector for which metrics (apart from \code{rank_metric})
to be included in the visualization. If NULL (the default), all available
metrics will be plotted}

\item{std_errs}{The number of standard errors to plot (if the standard error
exists).}

\item{...}{Other options to pass to \code{autoplot()}. Currently unused.}
}
\value{
A ggplot object.
}
\description{
This \code{autoplot()} method plots performance metrics that have been
ranked using a metric.
}
\details{
This function is intended to produce a default plot to visualize helpful
information across all possible applications of a \code{\link{simple_ensemble}}. More
sophisticated plots can be produced using standard \code{ggplot2} code for
plotting.

The x-axis is the workflow rank in the set (a value of one being the best)
versus the performance metric(s) on the y-axis. With multiple metrics, there
will be facets for each metric, with the \code{rank_metric} first (if any was
provided; otherwise the metric used to create the \code{\link{simple_ensemble}} will
be used).

If multiple resamples are used, confidence bounds are shown for each result
(95\% confidence, by default).
}
\examples{
\dontshow{if (rlang::is_installed("earth")) withAutoprint(\{ # examplesIf}
# we use the two_class_example from `workflowsets`
two_class_ens <- simple_ensemble() \%>\%
  add_member(two_class_res, metric = "roc_auc")
autoplot(two_class_ens)
\dontshow{\}) # examplesIf}
}
\keyword{ensemble}
