% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin-estimates.R
\name{fit_plugin_Y}
\alias{fit_plugin_Y}
\title{Fits a T-learner using the appropriate settings}
\usage{
fit_plugin_Y(full_data, weight_col, y_col, a_col, ..., .Model_cfg)
}
\arguments{
\item{full_data}{The full dataset of interest for the modelling problem.}

\item{weight_col}{The unquoted weighting variable name to use in model fitting.}

\item{y_col}{The unquoted column name of the outcome.}

\item{a_col}{The unquoted column name of the treatment.}

\item{...}{The unquoted names of covariates to use in the model.}

\item{.Model_cfg}{A \code{Model_cfg} object configuring the appropriate model type to use.}
}
\value{
A list with two elements, \code{mu1} and \code{mu0} corresponding to the models fit to
the treatment and control potential outcomes, respectively. Each is a new \code{Predictor}
object of the appropriate subclass corresponding to the the \code{Model_cfg} fit to the data.
}
\description{
This function prepares data, fits the appropriate model and returns the
resulting estimates in a standardized format.
}
\keyword{internal}
