% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public_api.R
\name{attach_config}
\alias{attach_config}
\title{Attach an \code{HTE_cfg} to a dataframe}
\usage{
attach_config(data, .HTE_cfg)
}
\arguments{
\item{data}{dataframe}

\item{.HTE_cfg}{\code{HTE_cfg} object representing the full configuration of the HTE analysis.}
}
\description{
This adds a configuration attribute to a dataframe for HTE estimation.
This configuration details the full analysis of HTE that should be performed.
}
\details{
For information about how to set up an \code{HTE_cfg} object, see the Recipe API
documentation \code{\link[=basic_config]{basic_config()}}.

To see an example analysis, read \code{vignette("experimental_analysis")} in the context
of an experiment, \code{vignette("experimental_analysis")} for an observational study, or
\code{vignette("methodological_details")} for a deeper dive under the hood.
}
\examples{
library("dplyr")
if(require("palmerpenguins")) {
data(package = 'palmerpenguins')
penguins$unitid = seq_len(nrow(penguins))
penguins$propensity = rep(0.5, nrow(penguins))
penguins$treatment = rbinom(nrow(penguins), 1, penguins$propensity)
cfg <- basic_config() \%>\% 
add_known_propensity_score("propensity") \%>\%
add_outcome_model("SL.glm.interaction") \%>\%
remove_vimp()
attach_config(penguins, cfg) \%>\%
make_splits(unitid, .num_splits = 4) \%>\%
produce_plugin_estimates(outcome = body_mass_g, treatment = treatment, species, sex) \%>\%
construct_pseudo_outcomes(body_mass_g, treatment) \%>\%
estimate_QoI(species, sex)
}
}
\seealso{
\code{\link[=basic_config]{basic_config()}}, \code{\link[=make_splits]{make_splits()}}, \code{\link[=produce_plugin_estimates]{produce_plugin_estimates()}},
\code{\link[=construct_pseudo_outcomes]{construct_pseudo_outcomes()}}, \code{\link[=estimate_QoI]{estimate_QoI()}}
}
