% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe-api.R
\name{add_vimp}
\alias{add_vimp}
\title{Adds variable importance information}
\usage{
add_vimp(hte_cfg, sample_splitting = TRUE, linear_only = FALSE)
}
\arguments{
\item{hte_cfg}{\code{HTE_cfg} object to update.}

\item{sample_splitting}{Logical indicating whether to use sample splitting or not.
Choosing not to use sample splitting means that inference will only be valid for
moderators with non-null importance.}

\item{linear_only}{Logical indicating whether the variable importance should use only a single
linear-only model. Variable importance measure will only be consistent for the population
quantity if the true model of pseudo-outcomes is linear.}
}
\value{
Updated \code{HTE_cfg} object
}
\description{
This adds a variable importance quantity of interest to the outputs.
}
\examples{
library("dplyr")
basic_config() \%>\%
   add_vimp(sample_splitting = FALSE) -> hte_cfg
}
\references{
\itemize{
\item Williamson, B. D., Gilbert, P. B., Carone, M., & Simon, N. (2021).
Nonparametric variable importance assessment using machine learning techniques.
Biometrics, 77(1), 9-22.
\item Williamson, B. D., Gilbert, P. B., Simon, N. R., & Carone, M. (2021).
A general framework for inference on algorithm-agnostic variable importance.
Journal of the American Statistical Association, 1-14.
}
}
