% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe-api.R
\name{add_propensity_diagnostic}
\alias{add_propensity_diagnostic}
\title{Add an additional diagnostic to the propensity score}
\usage{
add_propensity_diagnostic(hte_cfg, diag)
}
\arguments{
\item{hte_cfg}{\code{HTE_cfg} object to update.}

\item{diag}{Character indicating the name of the diagnostic
to include. Possible values are \code{"MSE"}, \code{"AUC"} and, for
\code{SuperLearner} ensembles, \code{"SL_risk"} and \code{"SL_coefs"}.}
}
\value{
Updated \code{HTE_cfg} object
}
\description{
This adds a diagnostic to the propensity score.
}
\examples{
library("dplyr")
basic_config() \%>\%
   add_propensity_diagnostic(c("AUC", "MSE")) -> hte_cfg
}
