% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_cfg.R
\name{Known_cfg}
\alias{Known_cfg}
\title{Configuration of Known Model}
\description{
\code{Known_cfg} is a configuration class for when a particular model is known
a-priori. The prototypical usage of this class is when heterogeneous
treatment effects are estimated in the context of a randomized control
trial with known propensity scores.
}
\examples{

## ------------------------------------------------
## Method `Known_cfg$new`
## ------------------------------------------------

Known_cfg$new("propensity_score")
}
\section{Super class}{
\code{\link[tidyhte:Model_cfg]{tidyhte::Model_cfg}} -> \code{Known_cfg}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{covariate_name}}{The name of the column in the dataset
which corresponds to the known model score.}

\item{\code{model_class}}{The class of the model, required for all classes
which inherit from \code{Model_cfg}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Known_cfg-new}{\code{Known_cfg$new()}}
\item \href{#method-Known_cfg-clone}{\code{Known_cfg$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Known_cfg-new"></a>}}
\if{latex}{\out{\hypertarget{method-Known_cfg-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Known_cfg} object with specified covariate column.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Known_cfg$new(covariate_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{covariate_name}}{The name of the column, a string, in the dataset
corresponding to the known model score (i.e. the true conditional expectation).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Known_cfg} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Known_cfg$new("propensity_score")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Known_cfg-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Known_cfg-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Known_cfg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
