% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling_core.R
\name{predict.lda_topic_model}
\alias{predict.lda_topic_model}
\title{Get predictions from a Latent Dirichlet Allocation model}
\usage{
\method{predict}{lda_topic_model}(
  object,
  newdata,
  method = c("gibbs", "dot"),
  iterations = NULL,
  burnin = -1,
  ...
)
}
\arguments{
\item{object}{a fitted object of class \code{lda_topic_model}}

\item{newdata}{a DTM or TCM of class \code{dgCMatrix} or a numeric vector}

\item{method}{one of either "gibbs" or "dot". If "gibbs" Gibbs sampling is used
and \code{iterations} must be specified.}

\item{iterations}{If \code{method = "gibbs"}, an integer number of iterations 
for the Gibbs sampler to run. A future version may include automatic stopping criteria.}

\item{burnin}{If \code{method = "gibbs"}, an integer number of burnin iterations. 
If \code{burnin} is greater than -1, the entries of the resulting "theta" matrix 
are an average over all iterations greater than \code{burnin}.}

\item{...}{Other arguments to be passed to \code{\link[textmineR]{TmParallelApply}}}
}
\value{
a "theta" matrix with one row per document and one column per topic
}
\description{
Obtains predictions of topics for new documents from a fitted LDA model
}
\examples{
\dontrun{
# load some data
data(nih_sample_dtm)

# fit a model 
set.seed(12345)

m <- FitLdaModel(dtm = nih_sample_dtm[1:20,], k = 5,
                 iterations = 200, burnin = 175)

str(m)

# predict on held-out documents using gibbs sampling "fold in"
p1 <- predict(m, nih_sample_dtm[21:100,], method = "gibbs",
              iterations = 200, burnin = 175)

# predict on held-out documents using the dot product method
p2 <- predict(m, nih_sample_dtm[21:100,], method = "dot")

# compare the methods
barplot(rbind(p1[1,],p2[1,]), beside = TRUE, col = c("red", "blue")) 
}
}
