% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.tailor}
\alias{tidy.tailor}
\title{Tidy a tailor object}
\usage{
\method{tidy}{tailor}(x, number = NA, ...)
}
\arguments{
\item{x}{A \code{\link[=tailor]{tailor()}} object.}

\item{number}{Optional. A single integer between 1 and the number of
adjustments.}

\item{...}{Currently unused; must be empty.}
}
\value{
A tibble containing information about the tailor's adjustments including
their ordering, whether they've been trained, and whether they require
training with a separate calibration set.
}
\description{
Describe a tailor's adjustments in a tibble with one row per adjustment.
}
\examples{
\dontshow{if (rlang::is_installed("probably")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tailor() |>
  adjust_numeric_range(lower_limit = 1) |>
  tidy()
\dontshow{\}) # examplesIf}
}
