% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust-predictions-custom.R
\name{adjust_predictions_custom}
\alias{adjust_predictions_custom}
\title{Change or add variables}
\usage{
adjust_predictions_custom(x, ..., .pkgs = character(0))
}
\arguments{
\item{x}{A \code{\link[=tailor]{tailor()}}.}

\item{...}{Name-value pairs of expressions. See \code{\link[dplyr:mutate]{dplyr::mutate()}}.}

\item{.pkgs}{A character string of extra packages that are needed to execute
the commands.}
}
\value{
An updated \code{\link[=tailor]{tailor()}} containing the new operation.
}
\description{
This adjustment functions allows for arbitrary transformations of model
predictions using \code{\link[dplyr:mutate]{dplyr::mutate()}} statements.
}
\section{Data-dependent transformations}{

Note that custom adjustments should not carry out estimation. If they do,
the estimation steps will be carried out independently at \code{fit()}
and \code{predict()} time. For example, if your transformation includes a mean
shift, the postprocessor will take the mean of the column supplied in the
training data at \code{fit()} and, rather than reusing that mean at \code{predict()}
will take the mean again of the dataset supplied at \code{predict()} time.
}

\section{Data Usage}{

This adjustment doesn't require estimation and, as such, the same data that's
used to train it with \code{fit()} can be predicted on with \code{predict()}; fitting
this adjustment just collects metadata on the supplied column names and does
not risk data leakage.
}

\examples{
\dontshow{if (rlang::is_installed(c("probably", "modeldata"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(modeldata)

head(two_class_example)

tlr <-
  tailor() |>
  adjust_equivocal_zone() |>
  adjust_predictions_custom(linear_predictor = binomial()$linkfun(Class2))

tlr_fit <- fit(
  tlr,
  two_class_example,
  outcome = c(truth),
  estimate = c(predicted),
  probabilities = c(Class1, Class2)
)

predict(tlr_fit, two_class_example) |> head()
\dontshow{\}) # examplesIf}
}
