% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlg_save.tcltkGUI.R
\name{dlg_save.tcltkGUI}
\alias{dlg_save.tcltkGUI}
\title{A Tcl/Tk version of the \{svDialogs\} file save dialog box}
\usage{
\method{dlg_save}{tcltkGUI}(
  default = "untitled",
  title = "Save file as",
  filters = dlg_filters["All", ],
  ...,
  gui = .GUI
)
}
\arguments{
\item{default}{The default file to start with (use \verb{/dir/*} or \verb{/dir/*.*} to
start in a given directory, but without predefined name).}

\item{title}{A title to display on top of the dialog box.}

\item{filters}{A specification of file filters as a \code{nx2} matrix, or a
character string with even number of items. First items is the label, second
one is the filter. See \code{dlg_filters} for examples. This is currently ignored
on MacOS, since such kind of filter is defined differently there.}

\item{...}{Not used yet.}

\item{gui}{The 'gui' object concerned by this dialog box.}
}
\value{
The path to the file to save to.
}
\description{
A Tcl/Tk version of the \{svDialogs\} file save dialog box
}
\examples{
library(svDialogstcltk) # Tcl/Tk dialog boxes are now used by default
\dontrun{
# Choose one R filename to save some R script into it
dlg_save(title = "Save R script to", filters = dlg_filters[c("R", "All"), ])$res
}
}
\seealso{
\code{\link[svDialogs:dlg_save]{svDialogs::dlg_save()}}
}
\concept{Modal dialog box}
\keyword{misc}
