\name{combine2}
\alias{combine2}
\title{Merging two dataset for the analysis by "netmeta"}
\usage{
combine2(data1, data2)
}
\arguments{
\item{data1}{Dataset 1.}
\item{data2}{Dataset 2.}
}
\value{
\itemize{
\item \code{studlab}: ID variable of studies.
\item \code{treat1}: The treatment of arm 1.
\item \code{treat2}: The treatment of arm 2.
\item \code{TE}: The effect measure estimate.
\item \code{seTE}: Standard error estimate for the effect measure estimator.
}
}
\description{
Merging two dataset for the analysis by \code{netmeta} package (e.g., an output object by \code{pairwiseHR} for dichotomized outcome dataset and the survival outcome dataset). The output object can be straightforwardly applied to the \code{netmeta} function.
}

\references{
Noma, H. and Maruo, K. (2025). Network meta-analysis combining survival and count outcome data: A simple frequentist approach. medRxiv: 10.1101/2025.01.23.25321051.
}

\examples{
data(woods1)
data(woods2)

woods3 <- pairwiseHR(treat, studlab=study, event=d, n, data=woods2)
combine2(woods1, woods3)
}
