% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_check.R
\name{type_check}
\alias{type_check}
\title{List Type Checking}
\usage{
type_check(
  template,
  target,
  with_cast = FALSE,
  log_items = c("casts", "missing", "excess", "debug")[c(1, 3)]
)
}
\arguments{
\item{template}{\itemize{
\item A named list to use as a template.
}}

\item{target}{\itemize{
\item A named list to use as the output.
}}

\item{with_cast}{\itemize{
\item If true, edits the target instead of just checking types.
}}

\item{log_items}{\itemize{
\item Which debug info to print. Takes a character vector. By default, logs casts and excess fields (target fields not in template). We expect some missing for the moment.
}}
}
\value{
The target object, with its types appropriately cast.
}
\description{
Given two named objects, go through both and make the types of the second
match the types of the first.
}
\examples{
type_check(
  list("a" = character(0), "b" = integer(0)),
  data.frame("a" = c(1,2), "b" = c(3,4)),
  TRUE, NULL
)
}
