% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multistorr.R
\name{storr_multistorr}
\alias{storr_multistorr}
\title{Storr with multiple storage drivers}
\usage{
storr_multistorr(keys, data, default_namespace = "objects")
}
\arguments{
\item{keys}{Driver for the keys}

\item{data}{Driver for the data}

\item{default_namespace}{Default namespace (see \link{storr})}
}
\description{
Create a special storr that uses separate storage drivers for the
keys (which tend to be numerous and small in size) and the data
(which tends to be somewhat less numerous and much larger in
size).  This might be useful to use storage models with different
characteristics (in memory/on disk, etc).
}
\details{
This is an experimental feature and somewhat subject to change.
In particular, the driver may develop the ability to store small
data in the same storr as the keys (say, up to 1kb) based on some
tunable parameter.

You can attach another storr to either the data or the key storage
(see the example), but it will not be able to see keys or data
(respectively).  If you garbage collect the data half, all the
data will be lost!
}
\examples{
# Create a storr that is stores keys in an environment and data in
# an rds
path <- tempfile()
st <- storr::storr_multistorr(driver_environment(),
                              driver_rds(path))
st$set("a", runif(10))
st$get("a")

# The data can be also seen by connecting to the rds store
rds <- storr::storr_rds(path)
rds$list() # empty
rds$list_hashes() # here's the data
rds$get_value(rds$list_hashes())

st$destroy()
}
