% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.utilities.R
\name{message_print}
\alias{message_print}
\title{\code{\link{print}} objects to the \code{\link{message}} output.}
\usage{
message_print(..., messageArgs = NULL)
}
\arguments{
\item{...}{arguments to \code{\link{print}}.}

\item{messageArgs}{a list of arguments to be passed directly to \code{\link{message}}.}
}
\description{
A thin wrapper around \code{\link{print}} that captures its output and prints
it as a \code{\link{message}}, usually to STDERR.
}
\examples{
cat(1:5)

print(1:5)
message_print(1:5) # Looks the same (though may be in a different color on some frontends).

suppressMessages(print(1:5)) # Still prints
suppressMessages(message_print(1:5)) # Silenced
}
