% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.utils.R
\name{arr_from_coo}
\alias{arr_from_coo}
\alias{arr_to_coo}
\title{Conveniently covert between coordinate-value and array representations}
\usage{
arr_from_coo(x, coord, dim = lengths(dimnames), x0 = NA, dimnames = NULL)

arr_to_coo(X, x0, na.rm = FALSE)
}
\arguments{
\item{x}{values of elements differing from the default.}

\item{coord}{an integer matrix of their indices.}

\item{dim}{dimension vector; recycled to \code{ncol(coord)}; if not
given, inferred from \code{dimnames}.}

\item{x0}{the default value.}

\item{dimnames}{dimension name list.}

\item{X}{an array.}

\item{na.rm}{whether the \code{NA} elements of the array should be
omitted from the list.}
}
\value{
\code{coo_to_arr()} returns a matrix or an array.

\code{arr_to_coo()} returns a list with the following elements:

\item{\code{x}}{the values distinct from \code{x0}}

\item{\code{coord}}{a matrix with a column for each dimension containing
indexes of values distinct from \code{x0}}

\item{\code{dim}}{the dimension vector of the matrix}

\item{\code{dimnames}}{the dimension name list of the matrix}
}
\description{
These function similarly to \CRANpkg{Matrix}'s utilities but is
simpler and allows arbitrary baseline and handling of missing
values. (It is also almost certainly much slower.) Also, since it
is likely that operations will be performed on the elements of the
array, their argument is first for easier piping.
}
\details{
If \code{x0} is \code{NA}, non-\code{NA} elements are returned; if \code{x0} is \code{NULL},
all elements are.
}
\examples{
m <- matrix(rpois(25, 1), 5, 5)
arr_to_coo(m, 0L)
stopifnot(identical(do.call(arr_from_coo, arr_to_coo(m, 0L)), m))

stopifnot(length(arr_to_coo(m, NULL)$x) == 25) # No baseline

m[sample.int(25L, 2L)] <- NA
m
arr_to_coo(m, 0L) # Return NAs

arr_to_coo(m, 0L, na.rm = TRUE) # Drop NAs
}
