% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{coef.starnet}
\alias{coef.starnet}
\title{Extract Coefficients}
\usage{
\method{coef}{starnet}(object, nzero = NULL, ...)
}
\arguments{
\item{object}{\link[starnet]{starnet} object}

\item{nzero}{maximum number of non-zero coefficients\strong{:}
positive integer, or \code{NULL}}

\item{...}{further arguments (not applicable)}
}
\value{
List of scalar \code{alpha} and vector \code{beta},
containing the pooled intercept and the pooled slopes,
respectively.
}
\description{
Extracts pooled coefficients.
(The meta learners weights the coefficients from the base learners.)
}
\examples{
\dontshow{
if(!grepl('SunOS',Sys.info()['sysname'])){
set.seed(1)
n <- 50; p <- 100
y <- rnorm(n=n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
object <- starnet(y=y,X=X)
coef <- coef(object)}}
\donttest{
set.seed(1)
n <- 50; p <- 100
y <- rnorm(n=n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
object <- starnet(y=y,X=X)
coef <- coef(object)}

}
