% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_power_equivalence_normal.R
\name{sim_power_equivalence_normal}
\alias{sim_power_equivalence_normal}
\title{Empirical Power for Equivalence (Normal Outcomes)}
\usage{
sim_power_equivalence_normal(
  ngroups,
  npergroup,
  sd,
  llimit,
  ulimit,
  nsim,
  t_level = 0.95,
  conf.level = 0.95
)
}
\arguments{
\item{ngroups}{Integer. Number of groups to compare}

\item{npergroup}{Integer. Number of observations per group.}

\item{sd}{Numeric. Standard deviation of the outcome distribution (common across groups).}

\item{llimit}{Numeric. Lower equivalence limit.}

\item{ulimit}{Numeric. Upper equivalence limit.}

\item{nsim}{Integer. Number of simulations to perform.}

\item{t_level}{Numeric. Confidence level used for the t-tests (e.g., 0.95 for 95\% CI).}

\item{conf.level}{Numeric. Confidence level for the empirical power estimate}
}
\value{
An S3 object of class \code{empirical_power_result}, which contains
the estimated empirical power and its confidence interval. The object can
be printed, formatted, or further processed using associated S3 methods.
See also \code{\link{empirical_power_result}}.
}
\description{
Estimates the empirical power to detect equivalence among multiple groups assuming
no true difference in normally distributed outcomes. Pairwise two-sample t-tests are
used, and equivalence is declared if all confidence intervals for differences between
group means lie entirely within the interval defined by \code{llimit} and \code{ulimit}.
}
\details{
This function simulates data under the null hypothesis of no difference between groups
and calculates the proportion of simulations in which all pairwise comparisons fall within
the specified equivalence limits.
}
\examples{
#Equivalence testing for three groups with log-scale outcome
sim_power_equivalence_normal(
  ngroups = 3,
  npergroup = 172,
  sd = 0.403,
  llimit = log10(2/3),
  ulimit = log10(3/2),
  nsim = 1000,
  t_level = 0.95
)
}
\seealso{
\code{\link{empirical_power_result}}
}
