% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{beta_inc}
\alias{beta_inc}
\alias{beta_inc_inv}
\title{The incomplete beta function and its inverse}
\usage{
beta_inc(x, a, b, lower_tail = TRUE, log = FALSE)

beta_inc_inv(u, a, b, lower_tail = TRUE, log = FALSE)
}
\arguments{
\item{x}{a vector of size \code{nx} or a matrix of size \code{c(nx, 1)}.}

\item{a, b}{scalars giving the parameters of the beta function.}

\item{lower_tail}{accumulate the probability from the lower tail? If
\code{FALSE}, the probability is accumulated from the \emph{upper} tail.
Defaults to \code{FALSE}.}

\item{log}{use log-scale? If \code{TRUE}, returns the logarithm of the
incomplete beta function and uses log-scale for \code{u} in \code{beta_inc}.
Defaults to \code{FALSE}.}

\item{u}{a vector of probabilities of size \code{nu} or a matrix of size
\code{c(nu, 1)}.}
}
\value{
\itemize{
  \item \code{beta_inc}: a matrix of size \code{c(nx, 1)} with the
  evaluation of the incomplete beta function at \code{x}.
  \item \code{beta_inc_inv}: a matrix of size \code{c(nu, 1)} with the
  evaluation of the inverse incomplete beta function at \code{u}.
}
}
\description{
Computes the incomplete beta function
\deqn{I_x(a,b):=\int_0^x u^{a-1}(1-u)^{b-1}\,d\mathrm{u},\quad a,b>0}{
I_x(a,b):=\int_0^x u^{a-1}(1-u)^{b-1}du, a,b>0}
and its inverse function.
}
\details{
The functions are mere wrappers to R's internal \code{pbeta} and
\code{qbeta} functions.
}
\keyword{internal}
