% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_kbdm.R
\name{raw_kbdm}
\alias{raw_kbdm}
\title{Kolmogorov complexity of a matrix}
\usage{
raw_kbdm(mat, subsize)
}
\arguments{
\item{mat}{A logical matrix (with TRUE/FALSE values)}

\item{subsize}{A submatrix size to carry out the Block Decomposition Method
(must be between 1 and 3)}
}
\value{
The KBDM numeric value as a named vector
}
\description{
Compute the Kolmogorov complexity of a matrix using the 
  Block Decomposition Method (requires the \code{acss} package).
}
\details{
The Kolmogorov complexity cannot be computed directly for large strings 
    (i.e. matrices). However, the complexity of smaller submatrices can be 
    estimated, then combined to obtain an approximation of the complexity 
    of the whole matrix. This method, the Block Decomposition Method is 
    implemented in this function. See also \code{\link{kbdm_sews}} 
    for more details.
}
\examples{

\donttest{ 
raw_kbdm(forestgap[[1]], subsize = 3)
}

}
\seealso{
\code{\link{kbdm_sews}}, \code{\link[acss]{acss}}
}
