% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{patchsizes}
\alias{patchsizes}
\title{Get patch sizes.}
\usage{
patchsizes(mat, merge = FALSE, nbmask = "von_neumann", wrap = FALSE)
}
\arguments{
\item{mat}{A logical matrix or a list of such matrices.}

\item{merge}{Controls whether the obtained patch size distributions are to 
be pooled together if \code{mat} is a list of matrices.}

\item{nbmask}{Either "moore" for 8-way neighborhood, "von_neumann" for four-way 
neighborhood (default), or a 3x3 matrix describing which neighbors to 
consider around a cell. See \code{\link{patchsizes}} for details on how to specify 
such neighborhoods.}

\item{wrap}{Whether to wrap around lattice boundaries (`TRUE`/`FALSE`), 
effectively using periodic boundaries.}
}
\value{
If mat is a logical matrix, then the function returns a vector of 
  patch sizes. If mat is a list of logical matrices, then it returns 
  a list of vectors of patch sizes: this list is flattened if merge is TRUE.
}
\description{
Get the distribution of patch sizes from a logical matrix
}
\examples{

data(forestgap)
patchsizes(forestgap[[5]]) # Use a single matrix

# Compute the average patch size of each matrix
list_patches <- patchsizes(forestgap) # get the patch size for each matrix
print( sapply(list_patches, mean)) # print the average patch size 

# Example with 8-way neighborhood
patchsizes(forestgap[[5]], nbmask = "moore")

# Same neighborhood as above, but specified in matrix form 
moore_nb <- matrix(c(1, 1, 1, 
                     1, 0, 1, 
                     1, 1, 1), 
                   nrow = 3, ncol = 3, byrow = TRUE)
patchsizes(forestgap[[5]], nbmask = moore_nb) 

}
\seealso{
\code{\link{label}}
}
