% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{weedseed}
\alias{weedseed}
\title{Weed seed abundance}
\format{
A data frame with 5 variables: \code{Sample}, \code{Site}, \code{HLength}, \code{Spikelets}, \code{TotalSeed}.
\describe{
  \item{Sample}{Factor. Unique identifier for each sample point.}
  \item{Site}{Factor. Study site where the sample was collected (levels: "C", "L", "P", "W").}
  \item{HLength}{Numeric. Average head length of rye-grass plants at the sampling point (in millimeters, mm).}
  \item{Spikelets}{Numeric. Average number of spikelets per head at the sampling point.}
  \item{TotalSeed}{Integer. Total number of seeds per square meter at the sampling point.}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
weedseed
}
\description{
An observational study was conducted to explore the relationship between seed production and plant characteristics in rye-grass. Between 17 and 24 samples were collected at each of four study sites (Site: C, L, P, and W). For each sample point, the total number of seeds per square meter (TotalSeed), the average head length in millimeters (HLength), and the average number of spikelets per head (Spikelets) were measured. This dataset facilitates analysis of how head length and spikelet count may influence seed yield across multiple field sites.
}
\examples{
anova(lm(log10(TotalSeed) ~ Site * (HLength + Spikelets) , data = weedseed))

}
\keyword{datasets}
