% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{heights}
\alias{heights}
\title{Plant heights in glasshouse}
\format{
A data frame with 5 variables: \code{Pot}, \code{Row}, \code{Column}, \code{Dose}, \code{Height}.
\describe{
  \item{Pot}{Factor. Unique identifier for each pot (experimental unit).}
  \item{Row}{Factor. Row position of the pot in the grid layout on the bench.}
  \item{Column}{Factor. Column position of the pot in the grid layout on the bench.}
  \item{Dose}{Factor. Applied dose of the growth regulator.}
  \item{Height}{Numeric. Plant height (in centimeters) measured six weeks after treatment.}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
heights
}
\description{
A glasshouse experiment was conducted to examine how different doses of a growth regulator affect plant height under controlled conditions. Six increasing doses (Dose) were each applied to four replicate plants, with each plant grown in a separate pot. The pots were arranged in a completely randomized design on a bench grid comprising four rows (Row) and six columns (Column). After six weeks, the height of each plant (in cm; Height) was measured. This setup enables analysis of the effect of growth regulator dose on plant height, while accounting for any potential spatial variation across the grid layout.
}
\examples{
anova(lm(Height ~ Column + Dose, data = heights))

}
\keyword{datasets}
