% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{forest2}
\alias{forest2}
\title{Stand density of mixed nothofagus forest plots alternative representation}
\format{
A data frame with 7 variables: \code{DPlot}, \code{Type}, \code{SD}, \code{QD}, \code{d1}, \code{d2}, \code{d3}.
\describe{
  \item{DPlot}{Factor. Unique identifier for each forest plot.}
  \item{Type}{Factor. Forest stand type classified by the dominant Nothofagus species: "Coigue", "Rauli", or "Roble".}
  \item{SD}{Integer. Stand density, as the number of trees per hectare in each plot.}
  \item{QD}{Numeric. Mean quadratic diameter (in centimeters) of trees in the plot.}
  \item{d1}{Integer. Dummy variable for stand type Coigue (1 if Type is "Coigue", 0 otherwise).}
  \item{d2}{Integer. Dummy variable for stand type Rauli (1 if Type is "Rauli", 0 otherwise).}
  \item{d3}{Integer. Dummy variable for stand type Roble (1 if Type is "Roble", 0 otherwise).}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
forest2
}
\description{
A survey of 41 plots in natural stands of pure or mixed Nothofagus forest at the foot of the Andes was conducted to investigate variation in stand structure. Each plot was classified by the dominant tree species into one of three stand types: Coigue (13 plots), Rauli (9 plots), or Roble (19 plots). For each plot, stand density (number of trees per hectare, SD) and mean quadratic diameter (in cm, QD) were recorded. To facilitate analysis, three dummy variables (d1, d2, d3) were created to represent the stand type factor. The main aim of the study was to model stand density as a function of quadratic diameter and to compare this relationship among the three types of Nothofagus stands.
}
\examples{
anova(lm(log(SD) ~ log(QD) * (d2 + d3), data = forest2))

}
\keyword{datasets}
