% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lngca.R
\name{lngca}
\alias{lngca}
\title{Decompose the original data through LNGCA method.}
\usage{
lngca(
  xData,
  n.comp = NULL,
  Ux.list = NULL,
  whiten = c("sqrtprec", "eigenvec", "none"),
  maxit = 1000,
  eps = 1e-06,
  verbose = FALSE,
  restarts.pbyd = 0,
  restarts.dbyd = 0,
  distribution = c("JB", "tiltedgaussian", "logistic"),
  density = FALSE,
  out.all = FALSE,
  orth.method = c("svd", "givens"),
  df = 0,
  stand = FALSE,
  ...
)
}
\arguments{
\item{xData}{the original dataset for decomposition, matrix of n x px.}

\item{n.comp}{the number of components to be estimated.}

\item{Ux.list}{list of user specified initial values for Ux. If null, will generate random orthogonal matrices. See restarts.pbyd and restarts.dbyd}

\item{whiten}{whitening method. Defaults to "svd" which uses the n left eigenvectors divided by sqrt(px-1) by 'eigenvec'. Optionally uses the square root of the n x n "precision" matrix by 'sqrtprec'.}

\item{maxit}{max iteration, defalut = 1000}

\item{eps}{default = 1e-06}

\item{verbose}{default = FALSE}

\item{restarts.pbyd}{default = 0. Generates p x d random orthogonal matrices. Use a large number for large datasets. Note: it is recommended that you run lngca twice with different seeds and compare the results, which should be similar when a sufficient number of restarts is used. In practice, stability with large datasets and a large number of components can be challenging.}

\item{restarts.dbyd}{default = 0. These are d x d initial matrices padded with zeros, which results in initializations from the principal subspace. Can speed up convergence but may miss low variance non-Gaussian components.}

\item{distribution}{distribution methods with default to tilted Gaussian. "logistic" is similar to infomax ICA, JB is capable of capture super and sub Gaussian distribution while being faster than tilted Gaussian. (tilted Gaussian tends to be most accurate, but computationally much slower.)}

\item{density}{return the estimated tilted Gaussian density? default = FALSE}

\item{out.all}{default = FALSE}

\item{orth.method}{default = 'svd'. Method to generate random initial matrices. See [gen.inits()]}

\item{df}{default = 0, df of the spline used in fitting the non-parametric density. use df=8 or so for tilted gaussian. set df=0 for JB and logistic.}

\item{stand}{whether to standardize the data to have row and column means equal to 0 and the row standard deviation equal to 1 (i.e., all variables on same scale). Often used when combined with singR for data integration.}

\item{...}{other arguments to tiltedgaussian estimation}
}
\value{
Function outputs a list including the following:
\describe{
      \item{\code{U}}{matrix rx x n, part of the expression that Ax = Ux x Lx and Ax x Xc = Sx, where Lx is the whitener matrix.}
      \item{\code{loglik}}{the value of log-likelihood in the lngca method.}
      \item{\code{S}}{the variable loading matrix r x px, each row is a component, which can be used to measure nongaussianity}
      \item{\code{df}}{egree of freedom.}
      \item{\code{distribution}}{the method used for data decomposition.}
      \item{\code{whitener}}{A symmetric whitening matrix n x n from dX, the same with  whitenerXA = est.sigmaXA \%^\% -0.5}
      \item{\code{M}}{Mx Mtrix with n x rx.}
      \item{\code{nongaussianity}}{the nongaussianity score for each component saved in S matrix.}
}
}
\description{
Implements the methods of linear non-Gaussian component analysis (LNGCA) and likelihood component analysis (when using a density, e.g., tilted Gaussian) from the \href{https://www.tandfonline.com/doi/full/10.1080/01621459.2017.1407772}{LNGCA paper}
}
\examples{
\donttest{
#get simulation data
data(exampledata)
data=exampledata

# To get n.comp value, we can use NG_number function.

# use JB statistic as the measure of nongaussianity to run lngca with df=0
estX_JB = lngca(xData = data$dX, n.comp = 4,
 whiten = 'sqrtprec', restarts.pbyd = 20, distribution='JB',df=0)

# use the tiltedgaussian distribution to run lngca with df=8. This takes a long time:
estX_tilt = lngca(xData = data$dX, n.comp = 4,
 whiten = 'sqrtprec', restarts.pbyd = 20, distribution='tiltedgaussian',df=8)

# true non-gaussian component of Sx, include individual and joint components
trueSx = rbind(data$sjX,data$siX)

# use pmse to compare the difference of the two methods
pmse(S1 = t(trueSx),S2=t(estX_JB$S),standardize = TRUE)
pmse(S1 = t(trueSx),S2=t(estX_tilt$S),standardize = TRUE)

# the lngca using tiltedgaussian tends to be more accurate
# with smaller pmse value, but takes longer to run.
}

}
