% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censor_linelist.R
\name{censor_linelist}
\alias{censor_linelist}
\title{Censor dates in line list}
\usage{
censor_linelist(
  linelist,
  interval,
  reporting_artefact = c("none", "weekend_effects"),
  offset = min(linelist$date_onset, na.rm = TRUE)
)
}
\arguments{
\item{linelist}{Line list \verb{<data.frame>} output from \code{\link[=sim_linelist]{sim_linelist()}}.}

\item{interval}{An \code{integer} or \code{character} string for the size of the time
interval for censoring. Valid \code{character} options are:
\itemize{
\item \verb{"daily}
\item \code{"weekly"}
\item \code{"epiweek"}
\item \code{"montly"}
\item \code{"yearly"}
}

See details for information of the date/period objects that are returned for
each interval type.}

\item{reporting_artefact}{A \code{character} string, either \code{"none"} (default) or
\code{"weekend_effect"}. By default none of the dates are altered in other ways
during censoring, however if \code{reporting_artefact = "weekend_effect"} then
all the dates in the \verb{$date_reporting} column that fall on a weekend are
shifted to the following Monday. This artefact is commonly referred to as the
"weekend effect" (see \doi{10.1186/s13104-025-07145-y}).}

\item{offset}{An \code{integer} or \verb{<Date>} for the value to start counting the
period from (0 is the start of the Unix epoch). Only applicable if
\code{interval} is specified as an \code{integer}.

Default date used to start counting from for the \verb{<grates_period>} is the
earliest symptom onset date (\verb{$date_onset}). See \code{\link[grates:period_class]{grates::as_period()}} for
more information.

If setting \code{reporting_artefact = "weekend_effects"} the period may start or
end on a weekend.}
}
\value{
A line list \verb{<data.frame>}.
}
\description{
Censor \verb{<Date>} columns in line list output from \code{\link[=sim_linelist]{sim_linelist()}} to a
specified time interval.

This function is similar to \code{\link[incidence2:incidence]{incidence2::incidence()}} but does not aggregate
events into an \verb{<incidence2>} object, instead it returns the same line list
\verb{<data.frame>} as input but with modified event dates.
}
\details{
The line list columns that contain \verb{<Date>} objects are stored at double
point precision by default. In other words, they are not \code{integer} values,
so can be part way through a day. The exact numeric value of the \verb{<Date>}
can be seen if you \code{\link[=unclass]{unclass()}} it.

Censoring line list dates reduces the time precision (window) of the event.
Often dates of events, such as symptom onset or hospital admission are only
known to the nearest day, not hour or minute. Other events may be more
coarsely censored, for example to the nearest week or month.
\code{censor_linelist()} converts the exact double point precision event
\verb{<Date>} to the time \code{interval} specified.

Depending on the \code{interval} specified, the date columns will be returned
as different objects. Here is a list of the valid input \code{interval} and the
resulting class of the date column.
\itemize{
\item \code{integer} -> \verb{<grates_period>} (see \code{\link[grates:period_class]{grates::as_period()}})
\item \code{"daily"} -> \verb{<Date>} (see \link{Date})
\item \code{"weekly"} -> \verb{<grates_isoweek>} (see \code{\link[grates:isoweek_class]{grates::as_isoweek()}})
\item \code{"epiweek"} -> \verb{<grates_epiweek>} (see \code{\link[grates:epiweek_class]{grates::as_epiweek()}})
\item \code{"monthly"} -> \verb{<grates_yearmonth>} (see \code{\link[grates:yearmonth_class]{grates::as_yearmonth()}})
\item \code{"yearly"} -> \verb{<grates_year>} (see \code{\link[grates:year_class]{grates::as_year()}})
}
}
\examples{
set.seed(1)
linelist <- sim_linelist()
linelist_cens <- censor_linelist(linelist, interval = "daily")

# censor to a 3-day period
linelist_cens <- censor_linelist(linelist, interval = 3)

# no reporting of events on weekends
linelist_cens <- censor_linelist(
  linelist,
  interval = "daily",
  reporting_artefact = "weekend_effects"
)
}
