% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAvgRad.R
\name{plotAvgRad}
\alias{plotAvgRad}
\title{Plot hourly average radiation}
\usage{
plotAvgRad(
  mydata,
  date = "date",
  rad = "radg",
  ylabel = NULL,
  title = "",
  locale = NULL
)
}
\arguments{
\item{mydata}{A data frame containing data to plot.}

\item{date}{The name of the column representing date and time. Data must be of
class \code{POSIXlt} or \code{POSIXct} (default = "date"). If the timezone is unspecified,
it is set to GMT.}

\item{rad}{Name of the column representing radiation (default = "radg").}

\item{ylabel}{The label along the y axis. If missing a default label is plotted.}

\item{title}{Optional plot title}

\item{locale}{Locale to use for legend. Default is English, the only other
one currently supported is Italian.}
}
\value{
A \code{ggplot2} plot.
}
\description{
Plot a histogram with hourly average of solar radiation, together with
hourly maxima for June and December.
}
\examples{
data(stMeteo)
plotAvgRad(stMeteo, date = "date", rad = "radg")

}
\seealso{
\code{\link[=plotStabilityClass]{plotStabilityClass()}}, \code{\link[=plotAvgTemp]{plotAvgTemp()}}
}
